// Automatically generated rust module for 'fulfillment_manager.proto' file

#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
#![allow(unknown_lints)]
#![allow(clippy::all)]
#![cfg_attr(rustfmt, rustfmt_skip)]


use quick_protobuf::{MessageRead, MessageWrite, BytesReader, Writer, WriterBackend, Result};
use quick_protobuf::sizeofs::*;
use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct FulfillmentEntry {
    pub node_pubkey: Option<Vec<u8>>,
    pub lease_count: Option<i32>,
    pub slot_expiration: Option<i32>,
}

impl<'a> MessageRead<'a> for FulfillmentEntry {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.node_pubkey = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(16) => msg.lease_count = Some(r.read_int32(bytes)?),
                Ok(24) => msg.slot_expiration = Some(r.read_int32(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for FulfillmentEntry {
    fn get_size(&self) -> usize {
        0
        + self.node_pubkey.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.lease_count.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.slot_expiration.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.node_pubkey { w.write_with_tag(10, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.lease_count { w.write_with_tag(16, |w| w.write_int32(*s))?; }
        if let Some(ref s) = self.slot_expiration { w.write_with_tag(24, |w| w.write_int32(*s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct FulfillmentManagerAuth {
    pub nominee_pubkey: Option<Vec<u8>>,
    pub fulfillment_manager_pubkey: Option<Vec<u8>>,
    pub authorize_heartbeat: Option<bool>,
    pub authorize_usage: Option<bool>,
}

impl<'a> MessageRead<'a> for FulfillmentManagerAuth {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.nominee_pubkey = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(18) => msg.fulfillment_manager_pubkey = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(24) => msg.authorize_heartbeat = Some(r.read_bool(bytes)?),
                Ok(32) => msg.authorize_usage = Some(r.read_bool(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for FulfillmentManagerAuth {
    fn get_size(&self) -> usize {
        0
        + self.nominee_pubkey.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.fulfillment_manager_pubkey.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.authorize_heartbeat.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.authorize_usage.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.nominee_pubkey { w.write_with_tag(10, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.fulfillment_manager_pubkey { w.write_with_tag(18, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.authorize_heartbeat { w.write_with_tag(24, |w| w.write_bool(*s))?; }
        if let Some(ref s) = self.authorize_usage { w.write_with_tag(32, |w| w.write_bool(*s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct FulfillmentManagerState {
    pub version: Option<i32>,
    pub configs: Option<mod_FulfillmentManagerState::Configs>,
    pub entries: Vec<FulfillmentEntry>,
}

impl<'a> MessageRead<'a> for FulfillmentManagerState {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.version = Some(r.read_int32(bytes)?),
                Ok(18) => msg.configs = Some(r.read_message::<mod_FulfillmentManagerState::Configs>(bytes)?),
                Ok(26) => msg.entries.push(r.read_message::<FulfillmentEntry>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for FulfillmentManagerState {
    fn get_size(&self) -> usize {
        0
        + self.version.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.configs.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
        + self.entries.iter().map(|s| 1 + sizeof_len((s).get_size())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.version { w.write_with_tag(8, |w| w.write_int32(*s))?; }
        if let Some(ref s) = self.configs { w.write_with_tag(18, |w| w.write_message(s))?; }
        for s in &self.entries { w.write_with_tag(26, |w| w.write_message(s))?; }
        Ok(())
    }
}

pub mod mod_FulfillmentManagerState {

use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct Configs {
    pub heartbeat_auth_required: Option<bool>,
    pub usage_auth_required: Option<bool>,
    pub locked: Option<bool>,
}

impl<'a> MessageRead<'a> for Configs {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.heartbeat_auth_required = Some(r.read_bool(bytes)?),
                Ok(16) => msg.usage_auth_required = Some(r.read_bool(bytes)?),
                Ok(24) => msg.locked = Some(r.read_bool(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for Configs {
    fn get_size(&self) -> usize {
        0
        + self.heartbeat_auth_required.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.usage_auth_required.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.locked.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.heartbeat_auth_required { w.write_with_tag(8, |w| w.write_bool(*s))?; }
        if let Some(ref s) = self.usage_auth_required { w.write_with_tag(16, |w| w.write_bool(*s))?; }
        if let Some(ref s) = self.locked { w.write_with_tag(24, |w| w.write_bool(*s))?; }
        Ok(())
    }
}

}

