// Automatically generated rust module for 'fulfillment_manager.proto' file

#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
#![allow(unknown_lints)]
#![allow(clippy::all)]
#![cfg_attr(rustfmt, rustfmt_skip)]


use quick_protobuf::{MessageRead, MessageWrite, BytesReader, Writer, WriterBackend, Result};
use quick_protobuf::sizeofs::*;
use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct FulfillmentEntry {
    pub node_pubkey: Vec<u8>,
    pub lease_count: i32,
    pub slot_expiration: i32,
}

impl<'a> MessageRead<'a> for FulfillmentEntry {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.node_pubkey = r.read_bytes(bytes)?.to_owned(),
                Ok(16) => msg.lease_count = r.read_int32(bytes)?,
                Ok(24) => msg.slot_expiration = r.read_int32(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for FulfillmentEntry {
    fn get_size(&self) -> usize {
        0
        + if self.node_pubkey.is_empty() { 0 } else { 1 + sizeof_len((&self.node_pubkey).len()) }
        + if self.lease_count == 0i32 { 0 } else { 1 + sizeof_varint(*(&self.lease_count) as u64) }
        + if self.slot_expiration == 0i32 { 0 } else { 1 + sizeof_varint(*(&self.slot_expiration) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if !self.node_pubkey.is_empty() { w.write_with_tag(10, |w| w.write_bytes(&**&self.node_pubkey))?; }
        if self.lease_count != 0i32 { w.write_with_tag(16, |w| w.write_int32(*&self.lease_count))?; }
        if self.slot_expiration != 0i32 { w.write_with_tag(24, |w| w.write_int32(*&self.slot_expiration))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct FulfillmentManagerAuth {
    pub nominee_pubkey: Vec<u8>,
    pub fulfillment_manager_pubkey: Vec<u8>,
    pub authorize_heartbeat: bool,
    pub authorize_usage: bool,
}

impl<'a> MessageRead<'a> for FulfillmentManagerAuth {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.nominee_pubkey = r.read_bytes(bytes)?.to_owned(),
                Ok(18) => msg.fulfillment_manager_pubkey = r.read_bytes(bytes)?.to_owned(),
                Ok(24) => msg.authorize_heartbeat = r.read_bool(bytes)?,
                Ok(32) => msg.authorize_usage = r.read_bool(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for FulfillmentManagerAuth {
    fn get_size(&self) -> usize {
        0
        + if self.nominee_pubkey.is_empty() { 0 } else { 1 + sizeof_len((&self.nominee_pubkey).len()) }
        + if self.fulfillment_manager_pubkey.is_empty() { 0 } else { 1 + sizeof_len((&self.fulfillment_manager_pubkey).len()) }
        + if self.authorize_heartbeat == false { 0 } else { 1 + sizeof_varint(*(&self.authorize_heartbeat) as u64) }
        + if self.authorize_usage == false { 0 } else { 1 + sizeof_varint(*(&self.authorize_usage) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if !self.nominee_pubkey.is_empty() { w.write_with_tag(10, |w| w.write_bytes(&**&self.nominee_pubkey))?; }
        if !self.fulfillment_manager_pubkey.is_empty() { w.write_with_tag(18, |w| w.write_bytes(&**&self.fulfillment_manager_pubkey))?; }
        if self.authorize_heartbeat != false { w.write_with_tag(24, |w| w.write_bool(*&self.authorize_heartbeat))?; }
        if self.authorize_usage != false { w.write_with_tag(32, |w| w.write_bool(*&self.authorize_usage))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct FulfillmentManagerState {
    pub version: i32,
    pub configs: Option<mod_FulfillmentManagerState::Configs>,
    pub entries: Vec<FulfillmentEntry>,
}

impl<'a> MessageRead<'a> for FulfillmentManagerState {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.version = r.read_int32(bytes)?,
                Ok(18) => msg.configs = Some(r.read_message::<mod_FulfillmentManagerState::Configs>(bytes)?),
                Ok(26) => msg.entries.push(r.read_message::<FulfillmentEntry>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for FulfillmentManagerState {
    fn get_size(&self) -> usize {
        0
        + if self.version == 0i32 { 0 } else { 1 + sizeof_varint(*(&self.version) as u64) }
        + self.configs.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
        + self.entries.iter().map(|s| 1 + sizeof_len((s).get_size())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.version != 0i32 { w.write_with_tag(8, |w| w.write_int32(*&self.version))?; }
        if let Some(ref s) = self.configs { w.write_with_tag(18, |w| w.write_message(s))?; }
        for s in &self.entries { w.write_with_tag(26, |w| w.write_message(s))?; }
        Ok(())
    }
}

pub mod mod_FulfillmentManagerState {

use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct Configs {
    pub heartbeat_auth_required: bool,
    pub usage_auth_required: bool,
    pub locked: bool,
}

impl<'a> MessageRead<'a> for Configs {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.heartbeat_auth_required = r.read_bool(bytes)?,
                Ok(16) => msg.usage_auth_required = r.read_bool(bytes)?,
                Ok(24) => msg.locked = r.read_bool(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for Configs {
    fn get_size(&self) -> usize {
        0
        + if self.heartbeat_auth_required == false { 0 } else { 1 + sizeof_varint(*(&self.heartbeat_auth_required) as u64) }
        + if self.usage_auth_required == false { 0 } else { 1 + sizeof_varint(*(&self.usage_auth_required) as u64) }
        + if self.locked == false { 0 } else { 1 + sizeof_varint(*(&self.locked) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.heartbeat_auth_required != false { w.write_with_tag(8, |w| w.write_bool(*&self.heartbeat_auth_required))?; }
        if self.usage_auth_required != false { w.write_with_tag(16, |w| w.write_bool(*&self.usage_auth_required))?; }
        if self.locked != false { w.write_with_tag(24, |w| w.write_bool(*&self.locked))?; }
        Ok(())
    }
}

}

