// Automatically generated rust module for 'instruction.proto' file

#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
#![allow(unknown_lints)]
#![allow(clippy::all)]
#![cfg_attr(rustfmt, rustfmt_skip)]


use quick_protobuf::{MessageRead, MessageWrite, BytesReader, Writer, WriterBackend, Result};
use core::convert::TryFrom;
use core::ops::Deref;
use core::ops::DerefMut;
use quick_protobuf::sizeofs::*;
use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct SwitchboardInstruction {
    pub instruction: mod_SwitchboardInstruction::OneOfinstruction,
}

impl<'a> MessageRead<'a> for SwitchboardInstruction {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.instruction = mod_SwitchboardInstruction::OneOfinstruction::init_instruction(r.read_message::<mod_SwitchboardInstruction::InitInstruction>(bytes)?),
                Ok(18) => msg.instruction = mod_SwitchboardInstruction::OneOfinstruction::register_job_instruction(r.read_message::<mod_SwitchboardInstruction::RegisterJobInstruction>(bytes)?),
                Ok(26) => msg.instruction = mod_SwitchboardInstruction::OneOfinstruction::unregister_job_instruction(r.read_message::<mod_SwitchboardInstruction::UnregisterJobInstruction>(bytes)?),
                Ok(34) => msg.instruction = mod_SwitchboardInstruction::OneOfinstruction::update_aggregate_instruction(r.read_message::<mod_SwitchboardInstruction::UpdateAggregateInstruction>(bytes)?),
                Ok(42) => msg.instruction = mod_SwitchboardInstruction::OneOfinstruction::get_aggregate_instruction(r.read_message::<mod_SwitchboardInstruction::GetAggregateInstruction>(bytes)?),
                Ok(50) => msg.instruction = mod_SwitchboardInstruction::OneOfinstruction::save_result_instruction(r.read_message::<mod_SwitchboardInstruction::SaveResultInstruction>(bytes)?),
                Ok(58) => msg.instruction = mod_SwitchboardInstruction::OneOfinstruction::set_aggregator_configs_instruction(r.read_message::<mod_SwitchboardInstruction::SetAggregatorConfigsInstruction>(bytes)?),
                Ok(66) => msg.instruction = mod_SwitchboardInstruction::OneOfinstruction::set_fulfillment_manager_configs_instruction(r.read_message::<mod_SwitchboardInstruction::SetFulfillmentManagerConfigsInstruction>(bytes)?),
                Ok(74) => msg.instruction = mod_SwitchboardInstruction::OneOfinstruction::heartbeat_instruction(r.read_message::<mod_SwitchboardInstruction::HeartbeatInstruction>(bytes)?),
                Ok(82) => msg.instruction = mod_SwitchboardInstruction::OneOfinstruction::register_auth_instruction(r.read_message::<mod_SwitchboardInstruction::RegisterAuthInstruction>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for SwitchboardInstruction {
    fn get_size(&self) -> usize {
        0
        + match self.instruction {
            mod_SwitchboardInstruction::OneOfinstruction::init_instruction(ref m) => 1 + sizeof_len((m).get_size()),
            mod_SwitchboardInstruction::OneOfinstruction::register_job_instruction(ref m) => 1 + sizeof_len((m).get_size()),
            mod_SwitchboardInstruction::OneOfinstruction::unregister_job_instruction(ref m) => 1 + sizeof_len((m).get_size()),
            mod_SwitchboardInstruction::OneOfinstruction::update_aggregate_instruction(ref m) => 1 + sizeof_len((m).get_size()),
            mod_SwitchboardInstruction::OneOfinstruction::get_aggregate_instruction(ref m) => 1 + sizeof_len((m).get_size()),
            mod_SwitchboardInstruction::OneOfinstruction::save_result_instruction(ref m) => 1 + sizeof_len((m).get_size()),
            mod_SwitchboardInstruction::OneOfinstruction::set_aggregator_configs_instruction(ref m) => 1 + sizeof_len((m).get_size()),
            mod_SwitchboardInstruction::OneOfinstruction::set_fulfillment_manager_configs_instruction(ref m) => 1 + sizeof_len((m).get_size()),
            mod_SwitchboardInstruction::OneOfinstruction::heartbeat_instruction(ref m) => 1 + sizeof_len((m).get_size()),
            mod_SwitchboardInstruction::OneOfinstruction::register_auth_instruction(ref m) => 1 + sizeof_len((m).get_size()),
            mod_SwitchboardInstruction::OneOfinstruction::None => 0,
    }    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        match self.instruction {            mod_SwitchboardInstruction::OneOfinstruction::init_instruction(ref m) => { w.write_with_tag(10, |w| w.write_message(m))? },
            mod_SwitchboardInstruction::OneOfinstruction::register_job_instruction(ref m) => { w.write_with_tag(18, |w| w.write_message(m))? },
            mod_SwitchboardInstruction::OneOfinstruction::unregister_job_instruction(ref m) => { w.write_with_tag(26, |w| w.write_message(m))? },
            mod_SwitchboardInstruction::OneOfinstruction::update_aggregate_instruction(ref m) => { w.write_with_tag(34, |w| w.write_message(m))? },
            mod_SwitchboardInstruction::OneOfinstruction::get_aggregate_instruction(ref m) => { w.write_with_tag(42, |w| w.write_message(m))? },
            mod_SwitchboardInstruction::OneOfinstruction::save_result_instruction(ref m) => { w.write_with_tag(50, |w| w.write_message(m))? },
            mod_SwitchboardInstruction::OneOfinstruction::set_aggregator_configs_instruction(ref m) => { w.write_with_tag(58, |w| w.write_message(m))? },
            mod_SwitchboardInstruction::OneOfinstruction::set_fulfillment_manager_configs_instruction(ref m) => { w.write_with_tag(66, |w| w.write_message(m))? },
            mod_SwitchboardInstruction::OneOfinstruction::heartbeat_instruction(ref m) => { w.write_with_tag(74, |w| w.write_message(m))? },
            mod_SwitchboardInstruction::OneOfinstruction::register_auth_instruction(ref m) => { w.write_with_tag(82, |w| w.write_message(m))? },
            mod_SwitchboardInstruction::OneOfinstruction::None => {},
    }        Ok(())
    }
}

pub mod mod_SwitchboardInstruction {

use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct InitInstruction {
    pub type_pb: switchboard_account_types::SwitchboardAccountType,
}

impl<'a> MessageRead<'a> for InitInstruction {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.type_pb = r.read_enum(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for InitInstruction {
    fn get_size(&self) -> usize {
        0
        + if self.type_pb == switchboard_account_types::SwitchboardAccountType::TYPE_UNINITIALIZED { 0 } else { 1 + sizeof_varint(*(&self.type_pb) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.type_pb != switchboard_account_types::SwitchboardAccountType::TYPE_UNINITIALIZED { w.write_with_tag(8, |w| w.write_enum(*&self.type_pb as i32))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct RegisterJobInstruction {
    pub job: Option<job_schemas::OracleJob>,
}

impl<'a> MessageRead<'a> for RegisterJobInstruction {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.job = Some(r.read_message::<job_schemas::OracleJob>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for RegisterJobInstruction {
    fn get_size(&self) -> usize {
        0
        + self.job.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.job { w.write_with_tag(10, |w| w.write_message(s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct UnregisterJobInstruction {
    pub job_pubkey: Vec<u8>,
}

impl<'a> MessageRead<'a> for UnregisterJobInstruction {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.job_pubkey = r.read_bytes(bytes)?.to_owned(),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for UnregisterJobInstruction {
    fn get_size(&self) -> usize {
        0
        + if self.job_pubkey.is_empty() { 0 } else { 1 + sizeof_len((&self.job_pubkey).len()) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if !self.job_pubkey.is_empty() { w.write_with_tag(10, |w| w.write_bytes(&**&self.job_pubkey))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct UpdateAggregateInstruction { }

impl<'a> MessageRead<'a> for UpdateAggregateInstruction {
    fn from_reader(r: &mut BytesReader, _: &[u8]) -> Result<Self> {
        r.read_to_end();
        Ok(Self::default())
    }
}

impl MessageWrite for UpdateAggregateInstruction { }

#[derive(Debug, Default, PartialEq, Clone)]
pub struct GetAggregateInstruction { }

impl<'a> MessageRead<'a> for GetAggregateInstruction {
    fn from_reader(r: &mut BytesReader, _: &[u8]) -> Result<Self> {
        r.read_to_end();
        Ok(Self::default())
    }
}

impl MessageWrite for GetAggregateInstruction { }

#[derive(Debug, Default, PartialEq, Clone)]
pub struct SetAggregatorConfigsInstruction {
    pub min_confirmations: i32,
    pub min_update_delay_seconds: i64,
    pub fulfillment_manager_pubkey: Vec<u8>,
    pub lock: bool,
}

impl<'a> MessageRead<'a> for SetAggregatorConfigsInstruction {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.min_confirmations = r.read_int32(bytes)?,
                Ok(16) => msg.min_update_delay_seconds = r.read_int64(bytes)?,
                Ok(26) => msg.fulfillment_manager_pubkey = r.read_bytes(bytes)?.to_owned(),
                Ok(40) => msg.lock = r.read_bool(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for SetAggregatorConfigsInstruction {
    fn get_size(&self) -> usize {
        0
        + if self.min_confirmations == 0i32 { 0 } else { 1 + sizeof_varint(*(&self.min_confirmations) as u64) }
        + if self.min_update_delay_seconds == 0i64 { 0 } else { 1 + sizeof_varint(*(&self.min_update_delay_seconds) as u64) }
        + if self.fulfillment_manager_pubkey.is_empty() { 0 } else { 1 + sizeof_len((&self.fulfillment_manager_pubkey).len()) }
        + if self.lock == false { 0 } else { 1 + sizeof_varint(*(&self.lock) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.min_confirmations != 0i32 { w.write_with_tag(8, |w| w.write_int32(*&self.min_confirmations))?; }
        if self.min_update_delay_seconds != 0i64 { w.write_with_tag(16, |w| w.write_int64(*&self.min_update_delay_seconds))?; }
        if !self.fulfillment_manager_pubkey.is_empty() { w.write_with_tag(26, |w| w.write_bytes(&**&self.fulfillment_manager_pubkey))?; }
        if self.lock != false { w.write_with_tag(40, |w| w.write_bool(*&self.lock))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct SetFulfillmentManagerConfigsInstruction {
    pub heartbeat_auth_required: bool,
    pub usage_auth_required: bool,
    pub lock: bool,
}

impl<'a> MessageRead<'a> for SetFulfillmentManagerConfigsInstruction {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.heartbeat_auth_required = r.read_bool(bytes)?,
                Ok(16) => msg.usage_auth_required = r.read_bool(bytes)?,
                Ok(24) => msg.lock = r.read_bool(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for SetFulfillmentManagerConfigsInstruction {
    fn get_size(&self) -> usize {
        0
        + if self.heartbeat_auth_required == false { 0 } else { 1 + sizeof_varint(*(&self.heartbeat_auth_required) as u64) }
        + if self.usage_auth_required == false { 0 } else { 1 + sizeof_varint(*(&self.usage_auth_required) as u64) }
        + if self.lock == false { 0 } else { 1 + sizeof_varint(*(&self.lock) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.heartbeat_auth_required != false { w.write_with_tag(8, |w| w.write_bool(*&self.heartbeat_auth_required))?; }
        if self.usage_auth_required != false { w.write_with_tag(16, |w| w.write_bool(*&self.usage_auth_required))?; }
        if self.lock != false { w.write_with_tag(24, |w| w.write_bool(*&self.lock))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct SaveResultInstruction {
    pub job_idx: u32,
    pub node_idx: u32,
    pub job_pubkey: Vec<u8>,
    pub result: f64,
    pub error: bool,
}

impl<'a> MessageRead<'a> for SaveResultInstruction {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.job_idx = r.read_uint32(bytes)?,
                Ok(16) => msg.node_idx = r.read_uint32(bytes)?,
                Ok(26) => msg.job_pubkey = r.read_bytes(bytes)?.to_owned(),
                Ok(33) => msg.result = r.read_double(bytes)?,
                Ok(40) => msg.error = r.read_bool(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for SaveResultInstruction {
    fn get_size(&self) -> usize {
        0
        + if self.job_idx == 0u32 { 0 } else { 1 + sizeof_varint(*(&self.job_idx) as u64) }
        + if self.node_idx == 0u32 { 0 } else { 1 + sizeof_varint(*(&self.node_idx) as u64) }
        + if self.job_pubkey.is_empty() { 0 } else { 1 + sizeof_len((&self.job_pubkey).len()) }
        + if self.result == 0f64 { 0 } else { 1 + 8 }
        + if self.error == false { 0 } else { 1 + sizeof_varint(*(&self.error) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.job_idx != 0u32 { w.write_with_tag(8, |w| w.write_uint32(*&self.job_idx))?; }
        if self.node_idx != 0u32 { w.write_with_tag(16, |w| w.write_uint32(*&self.node_idx))?; }
        if !self.job_pubkey.is_empty() { w.write_with_tag(26, |w| w.write_bytes(&**&self.job_pubkey))?; }
        if self.result != 0f64 { w.write_with_tag(33, |w| w.write_double(*&self.result))?; }
        if self.error != false { w.write_with_tag(40, |w| w.write_bool(*&self.error))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct HeartbeatInstruction {
    pub lease_count: i64,
    pub slot_expiration: i64,
}

impl<'a> MessageRead<'a> for HeartbeatInstruction {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.lease_count = r.read_int64(bytes)?,
                Ok(16) => msg.slot_expiration = r.read_int64(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for HeartbeatInstruction {
    fn get_size(&self) -> usize {
        0
        + if self.lease_count == 0i64 { 0 } else { 1 + sizeof_varint(*(&self.lease_count) as u64) }
        + if self.slot_expiration == 0i64 { 0 } else { 1 + sizeof_varint(*(&self.slot_expiration) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.lease_count != 0i64 { w.write_with_tag(8, |w| w.write_int64(*&self.lease_count))?; }
        if self.slot_expiration != 0i64 { w.write_with_tag(16, |w| w.write_int64(*&self.slot_expiration))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct RegisterAuthInstruction {
    pub authorize_heartbeat: bool,
    pub authorize_usage: bool,
}

impl<'a> MessageRead<'a> for RegisterAuthInstruction {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.authorize_heartbeat = r.read_bool(bytes)?,
                Ok(16) => msg.authorize_usage = r.read_bool(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for RegisterAuthInstruction {
    fn get_size(&self) -> usize {
        0
        + if self.authorize_heartbeat == false { 0 } else { 1 + sizeof_varint(*(&self.authorize_heartbeat) as u64) }
        + if self.authorize_usage == false { 0 } else { 1 + sizeof_varint(*(&self.authorize_usage) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.authorize_heartbeat != false { w.write_with_tag(8, |w| w.write_bool(*&self.authorize_heartbeat))?; }
        if self.authorize_usage != false { w.write_with_tag(16, |w| w.write_bool(*&self.authorize_usage))?; }
        Ok(())
    }
}

#[derive(Debug, PartialEq, Clone)]
pub enum OneOfinstruction {
    init_instruction(mod_SwitchboardInstruction::InitInstruction),
    register_job_instruction(mod_SwitchboardInstruction::RegisterJobInstruction),
    unregister_job_instruction(mod_SwitchboardInstruction::UnregisterJobInstruction),
    update_aggregate_instruction(mod_SwitchboardInstruction::UpdateAggregateInstruction),
    get_aggregate_instruction(mod_SwitchboardInstruction::GetAggregateInstruction),
    save_result_instruction(mod_SwitchboardInstruction::SaveResultInstruction),
    set_aggregator_configs_instruction(mod_SwitchboardInstruction::SetAggregatorConfigsInstruction),
    set_fulfillment_manager_configs_instruction(mod_SwitchboardInstruction::SetFulfillmentManagerConfigsInstruction),
    heartbeat_instruction(mod_SwitchboardInstruction::HeartbeatInstruction),
    register_auth_instruction(mod_SwitchboardInstruction::RegisterAuthInstruction),
    None,
}

impl Default for OneOfinstruction {
    fn default() -> Self {
        OneOfinstruction::None
    }
}

}

