// Automatically generated rust module for 'aggregator_state.proto' file

#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
#![allow(unknown_lints)]
#![allow(clippy::all)]
#![cfg_attr(rustfmt, rustfmt_skip)]


use quick_protobuf::{MessageRead, MessageWrite, BytesReader, Writer, WriterBackend, Result};
use core::convert::TryFrom;
use core::ops::Deref;
use core::ops::DerefMut;
use quick_protobuf::sizeofs::*;
use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct FulfillmentAgreement {
    pub node_pubkeys: Vec<Vec<u8>>,
    pub completed: Vec<u8>,
}

impl<'a> MessageRead<'a> for FulfillmentAgreement {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.node_pubkeys.push(r.read_bytes(bytes)?.to_owned()),
                Ok(18) => msg.completed = r.read_bytes(bytes)?.to_owned(),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for FulfillmentAgreement {
    fn get_size(&self) -> usize {
        0
        + self.node_pubkeys.iter().map(|s| 1 + sizeof_len((s).len())).sum::<usize>()
        + if self.completed.is_empty() { 0 } else { 1 + sizeof_len((&self.completed).len()) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        for s in &self.node_pubkeys { w.write_with_tag(10, |w| w.write_bytes(&**s))?; }
        if !self.completed.is_empty() { w.write_with_tag(18, |w| w.write_bytes(&**&self.completed))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct RoundResult {
    pub num_success: i32,
    pub num_error: i32,
    pub mean: f64,
    pub round_open_slot: u64,
    pub round_open_timestamp: i64,
    pub min_response: f64,
    pub max_response: f64,
}

impl<'a> MessageRead<'a> for RoundResult {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.num_success = r.read_int32(bytes)?,
                Ok(16) => msg.num_error = r.read_int32(bytes)?,
                Ok(25) => msg.mean = r.read_double(bytes)?,
                Ok(32) => msg.round_open_slot = r.read_uint64(bytes)?,
                Ok(40) => msg.round_open_timestamp = r.read_int64(bytes)?,
                Ok(49) => msg.min_response = r.read_double(bytes)?,
                Ok(57) => msg.max_response = r.read_double(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for RoundResult {
    fn get_size(&self) -> usize {
        0
        + if self.num_success == 0i32 { 0 } else { 1 + sizeof_varint(*(&self.num_success) as u64) }
        + if self.num_error == 0i32 { 0 } else { 1 + sizeof_varint(*(&self.num_error) as u64) }
        + if self.mean == 0f64 { 0 } else { 1 + 8 }
        + if self.round_open_slot == 0u64 { 0 } else { 1 + sizeof_varint(*(&self.round_open_slot) as u64) }
        + if self.round_open_timestamp == 0i64 { 0 } else { 1 + sizeof_varint(*(&self.round_open_timestamp) as u64) }
        + if self.min_response == 0f64 { 0 } else { 1 + 8 }
        + if self.max_response == 0f64 { 0 } else { 1 + 8 }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.num_success != 0i32 { w.write_with_tag(8, |w| w.write_int32(*&self.num_success))?; }
        if self.num_error != 0i32 { w.write_with_tag(16, |w| w.write_int32(*&self.num_error))?; }
        if self.mean != 0f64 { w.write_with_tag(25, |w| w.write_double(*&self.mean))?; }
        if self.round_open_slot != 0u64 { w.write_with_tag(32, |w| w.write_uint64(*&self.round_open_slot))?; }
        if self.round_open_timestamp != 0i64 { w.write_with_tag(40, |w| w.write_int64(*&self.round_open_timestamp))?; }
        if self.min_response != 0f64 { w.write_with_tag(49, |w| w.write_double(*&self.min_response))?; }
        if self.max_response != 0f64 { w.write_with_tag(57, |w| w.write_double(*&self.max_response))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct AggregatorState {
    pub version: u32,
    pub configs: Option<mod_AggregatorState::Configs>,
    pub fulfillment_manager_pubkey: Vec<u8>,
    pub job_definition_pubkeys: Vec<Vec<u8>>,
    pub agreement: Option<FulfillmentAgreement>,
    pub current_round_result: Option<RoundResult>,
    pub last_round_result: Option<RoundResult>,
}

impl<'a> MessageRead<'a> for AggregatorState {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.version = r.read_uint32(bytes)?,
                Ok(18) => msg.configs = Some(r.read_message::<mod_AggregatorState::Configs>(bytes)?),
                Ok(26) => msg.fulfillment_manager_pubkey = r.read_bytes(bytes)?.to_owned(),
                Ok(34) => msg.job_definition_pubkeys.push(r.read_bytes(bytes)?.to_owned()),
                Ok(42) => msg.agreement = Some(r.read_message::<FulfillmentAgreement>(bytes)?),
                Ok(50) => msg.current_round_result = Some(r.read_message::<RoundResult>(bytes)?),
                Ok(58) => msg.last_round_result = Some(r.read_message::<RoundResult>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for AggregatorState {
    fn get_size(&self) -> usize {
        0
        + if self.version == 0u32 { 0 } else { 1 + sizeof_varint(*(&self.version) as u64) }
        + self.configs.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
        + if self.fulfillment_manager_pubkey.is_empty() { 0 } else { 1 + sizeof_len((&self.fulfillment_manager_pubkey).len()) }
        + self.job_definition_pubkeys.iter().map(|s| 1 + sizeof_len((s).len())).sum::<usize>()
        + self.agreement.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
        + self.current_round_result.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
        + self.last_round_result.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.version != 0u32 { w.write_with_tag(8, |w| w.write_uint32(*&self.version))?; }
        if let Some(ref s) = self.configs { w.write_with_tag(18, |w| w.write_message(s))?; }
        if !self.fulfillment_manager_pubkey.is_empty() { w.write_with_tag(26, |w| w.write_bytes(&**&self.fulfillment_manager_pubkey))?; }
        for s in &self.job_definition_pubkeys { w.write_with_tag(34, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.agreement { w.write_with_tag(42, |w| w.write_message(s))?; }
        if let Some(ref s) = self.current_round_result { w.write_with_tag(50, |w| w.write_message(s))?; }
        if let Some(ref s) = self.last_round_result { w.write_with_tag(58, |w| w.write_message(s))?; }
        Ok(())
    }
}

pub mod mod_AggregatorState {

use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct Configs {
    pub locked: bool,
    pub min_confirmations: i32,
    pub min_update_delay_seconds: i64,
    pub min_round_agreement_percentage: i32,
}

impl<'a> MessageRead<'a> for Configs {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.locked = r.read_bool(bytes)?,
                Ok(16) => msg.min_confirmations = r.read_int32(bytes)?,
                Ok(24) => msg.min_update_delay_seconds = r.read_int64(bytes)?,
                Ok(32) => msg.min_round_agreement_percentage = r.read_int32(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for Configs {
    fn get_size(&self) -> usize {
        0
        + if self.locked == false { 0 } else { 1 + sizeof_varint(*(&self.locked) as u64) }
        + if self.min_confirmations == 0i32 { 0 } else { 1 + sizeof_varint(*(&self.min_confirmations) as u64) }
        + if self.min_update_delay_seconds == 0i64 { 0 } else { 1 + sizeof_varint(*(&self.min_update_delay_seconds) as u64) }
        + if self.min_round_agreement_percentage == 0i32 { 0 } else { 1 + sizeof_varint(*(&self.min_round_agreement_percentage) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.locked != false { w.write_with_tag(8, |w| w.write_bool(*&self.locked))?; }
        if self.min_confirmations != 0i32 { w.write_with_tag(16, |w| w.write_int32(*&self.min_confirmations))?; }
        if self.min_update_delay_seconds != 0i64 { w.write_with_tag(24, |w| w.write_int64(*&self.min_update_delay_seconds))?; }
        if self.min_round_agreement_percentage != 0i32 { w.write_with_tag(32, |w| w.write_int32(*&self.min_round_agreement_percentage))?; }
        Ok(())
    }
}

}

