use quick_protobuf::deserialize_from_slice;
use solana_program::account_info::AccountInfo;
use solana_program::program_error::ProgramError;
use switchboard_protos::protos::aggregator_state::AggregatorState;

pub use switchboard_protos::protos::aggregator_state::RoundResult;

pub fn get_feed<'a>(switchboard_feed: &'a AccountInfo<'a>) -> Result<RoundResult, ProgramError> {
    let state_buffer = switchboard_feed.try_borrow_data()?;
    let aggregator_state: AggregatorState =
        deserialize_from_slice(&state_buffer[1..]).map_err(|_| ProgramError::InvalidAccountData)?;
    let mut maybe_round = aggregator_state.current_round_result.clone();
    if (maybe_round.is_none()
        || maybe_round.clone().unwrap().num_success < aggregator_state.configs.ok_or(ProgramError::InvalidAccountData)?.min_confirmations)
        && aggregator_state.last_round_result.is_some()
    {
        maybe_round = aggregator_state.last_round_result.clone();
    }
    maybe_round.ok_or(ProgramError::InvalidAccountData)
}
