// This file is part of linux-support. It is subject to the license terms in the COPYRIGHT file found in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT. No part of linux-support, including this file, may be copied, modified, propagated, or distributed except according to the terms contained in the COPYRIGHT file.
// Copyright © 2020 The developers of linux-support. See the COPYRIGHT file in the top-level directory of this distribution and at https://raw.githubusercontent.com/lemonrock/linux-support/master/COPYRIGHT.


/// Use upper case (eg `A` to `F`) or lower case (eg `a` to `f`) for digits above 9.
#[derive(Debug, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[repr(u8)]
pub enum NonNumericDigitCase
{
	/// Upper.
	Upper = b'A',

	/// Lower.
	Lower = b'a',
}

impl NonNumericDigitCase
{
	#[inline(always)]
	fn contains(self, byte: u8, radix: Radix) -> Option<u8>
	{
		let lowest_alphabetic_digit = self as u8;
		if byte >= lowest_alphabetic_digit && byte < (lowest_alphabetic_digit + (radix as u8))
		{
			Some(byte - lowest_alphabetic_digit)
		}
		else
		{
			None
		}
	}
}
