# SVGrep (Separated Values Grep)

[![builds.sr.ht status](https://builds.sr.ht/~tsdh/svgrep.svg)](https://builds.sr.ht/~tsdh/svgrep?)
[![latest release](https://img.shields.io/crates/v/svgrep.svg)](https://crates.io/crates/svgrep)
[![License GPL 3 or later](https://img.shields.io/crates/l/svgrep.svg)](https://www.gnu.org/licenses/gpl-3.0.en.html)


`svgrep` is a small utility for filtering and searching in separated values
files (CSV, TSV, whatever).

Here is its synopsis:

```
USAGE:
    svgrep [FLAGS] [OPTIONS] [--] [FILE]

FLAGS:
    -h, --help       Prints help information
    -t, --trim       Trim the cell contents when printing.
    -V, --version    Prints version information

OPTIONS:
    -@, --cell-select-char <char>  Separates the <col>=<regex> pairs in --match expressions from
                                   the column display selection (default: @).
    -&, --conj-char <char>         Separates multiple <col>=<regex> pairs in --match expressions
                                   to form a conjunction (default: &).
    -m, --match <match>...         Sets the match-and-select expression.
                                     
                                   Syntax:
                                   <col>=<regex>(&<col>=<regex>)+@<disp_cols>
                                   <col> is a natural number or * meaning any column.
                                   <regex> is a regex matched against the cells at column <col>.
                                   <disp_cols> is a comma-separated list of columns to display (defaul: all).
                                     
                                   --match '1=foo&2=bar' acts as logical AND wheras multiple expressions like
                                   --match '1=foo' '2=bar' act as a logical OR.
    -=, --matches-char <char>      Separates a <col> from the <regex> in --match expressions.
                                   (default: =).
    -s, --separator <char>         Sets the separator to be used (default: ';')

ARGS:
    <FILE>    The separated values file. If none is given, reads from stdin.
```

## Questions & Patches

For asking questions, sending feedback, or patches, refer to [my public inbox
(mailinglist)](https://lists.sr.ht/~tsdh/public-inbox).  Please mention the
project you are referring to in the subject.

## Bugs

If you've found a bug, please report it at
[~tsdh/svgrep](https://todo.sr.ht/~tsdh/svgrep).

## Build status

[![builds.sr.ht status](https://builds.sr.ht/~tsdh/svgrep.svg)](https://builds.sr.ht/~tsdh/svgrep?)

## License

[GPLv3 or later](https://www.gnu.org/licenses/gpl-3.0.en.html)
