/* Copyright (C) 2019 Open Information Security Foundation
*
* You can copy, redistribute or modify this Program under the terms of
* the GNU General Public License version 2 as published by the Free
* Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* version 2 along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301, USA.
*/

#ifndef __RUST_BINDINGS_GEN_H_
#define __RUST_BINDINGS_GEN_H_

/* Generated with cbindgen:0.20.0 */

/* DO NOT EDIT This file is autogenerated by cbindgen. Don't modify this manually. */

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

enum HTTP2TransactionState {
    HTTP2StateIdle = 0,
    HTTP2StateOpen = 1,
    HTTP2StateReserved = 2,
    HTTP2StateDataClient = 3,
    HTTP2StateHalfClosedClient = 4,
    HTTP2StateDataServer = 5,
    HTTP2StateHalfClosedServer = 6,
    HTTP2StateClosed = 7,
    HTTP2StateGlobal = 8,
};
typedef uint8_t HTTP2TransactionState;

enum MQTTFlagState {
    MQTT_DONT_CARE = 0,
    MQTT_MUST_BE_SET = 1,
    MQTT_CANT_BE_SET = 2,
};
typedef uint8_t MQTTFlagState;

enum SSHConnectionState {
    SshStateInProgress = 0,
    SshStateBannerWaitEol = 1,
    SshStateBannerDone = 2,
    SshStateFinished = 3,
};
typedef uint8_t SSHConnectionState;

/**
 * Container for parsed Asn1 objects
 */
typedef struct Asn1 Asn1;

typedef struct DCEIfaceData DCEIfaceData;

typedef struct DCEOpnumData DCEOpnumData;

typedef struct DCERPCState DCERPCState;

typedef struct DCERPCTransaction DCERPCTransaction;

typedef struct DCERPCUDPState DCERPCUDPState;

typedef struct RSDNSTransaction RSDNSTransaction;

/**
 * Struct to hold parsed asn1 keyword options
 */
typedef struct DetectAsn1Data DetectAsn1Data;

typedef struct DetectDnsOpcode DetectDnsOpcode;

typedef struct DetectModbusRust DetectModbusRust;

typedef struct HTTP2State HTTP2State;

typedef struct HTTP2Transaction HTTP2Transaction;

typedef struct JsonBuilder JsonBuilder;

typedef struct MQTTState MQTTState;

typedef struct MQTTTransaction MQTTTransaction;

typedef struct ModbusState ModbusState;

typedef struct ModbusTransaction ModbusTransaction;

typedef struct NFSState NFSState;

typedef struct NFSTransaction NFSTransaction;

typedef struct RFBState RFBState;

typedef struct RFBTransaction RFBTransaction;

typedef struct RdpState RdpState;

typedef struct RdpTransaction RdpTransaction;

typedef struct SCMd5 SCMd5;

typedef struct SCSha1 SCSha1;

typedef struct SCSha256 SCSha256;

typedef struct SIPState SIPState;

typedef struct SIPTransaction SIPTransaction;

typedef struct SMBState SMBState;

typedef struct SMBTransaction SMBTransaction;

typedef struct X509 X509;

/**
 * A "mark" or saved state for a JsonBuilder object.
 *
 * The name is full, and the types are u64 as this object is used
 * directly in C as well.
 */
typedef struct JsonBuilderMark {
    uint64_t position;
    uint64_t state_index;
    uint64_t state;
} JsonBuilderMark;

typedef struct AppLayerResult {
    int32_t status;
    uint32_t consumed;
    uint32_t needed;
} AppLayerResult;

typedef struct AppLayerTxConfig {
    /**
     * config: log flags
     */
    uint8_t log_flags;
} AppLayerTxConfig;

/**
 * LoggerFlags tracks which loggers have already been executed.
 */
typedef struct LoggerFlags {
    uint32_t flags;
} LoggerFlags;

typedef struct AppLayerTxData {
    /**
     * config: log flags
     */
    struct AppLayerTxConfig config;
    /**
     * logger flags for tx logging api
     */
    struct LoggerFlags logged;
    /**
     * track file open/logs so we can know how long to keep the tx
     */
    uint32_t files_opened;
    uint32_t files_logged;
    uint32_t files_stored;
    /**
     * detection engine flags for use by detection engine
     */
    uint64_t detect_flags_ts;
    uint64_t detect_flags_tc;
} AppLayerTxData;

typedef struct AppLayerGetTxIterTuple {
    void *tx_ptr;
    uint64_t tx_id;
    bool has_next;
} AppLayerGetTxIterTuple;

typedef struct ModbusMessage {
    const void *_0;
} ModbusMessage;

void rs_log_set_level(int32_t level);

void rs_init(SuricataContext *context);

/**
 * Free a CString allocated by Rust (for ex. using `rust_string_to_c`)
 *
 * # Safety
 *
 * s must be allocated by rust, using `CString::new`
 */
void rs_cstring_free(char *s);

struct JsonBuilder *jb_new_object(void);

struct JsonBuilder *jb_new_array(void);

struct JsonBuilder *jb_clone(struct JsonBuilder *js);

void jb_free(struct JsonBuilder *js);

uintptr_t jb_capacity(struct JsonBuilder *jb);

void jb_reset(struct JsonBuilder *jb);

bool jb_open_object(struct JsonBuilder *js, const char *key);

bool jb_start_object(struct JsonBuilder *js);

bool jb_open_array(struct JsonBuilder *js, const char *key);

bool jb_set_string(struct JsonBuilder *js, const char *key, const char *val);

bool jb_set_string_from_bytes(struct JsonBuilder *js,
                              const char *key,
                              const uint8_t *bytes,
                              uint32_t len);

bool jb_set_formatted(struct JsonBuilder *js, const char *formatted);

bool jb_append_object(struct JsonBuilder *jb, const struct JsonBuilder *obj);

bool jb_set_object(struct JsonBuilder *js,
                   const char *key,
                   struct JsonBuilder *val);

bool jb_append_string(struct JsonBuilder *js, const char *val);

bool jb_append_string_from_bytes(struct JsonBuilder *js,
                                 const uint8_t *bytes,
                                 uint32_t len);

bool jb_append_uint(struct JsonBuilder *js, uint64_t val);

bool jb_append_float(struct JsonBuilder *js, double val);

bool jb_set_uint(struct JsonBuilder *js, const char *key, uint64_t val);

bool jb_set_float(struct JsonBuilder *js, const char *key, double val);

bool jb_set_bool(struct JsonBuilder *js, const char *key, bool val);

bool jb_close(struct JsonBuilder *js);

uintptr_t jb_len(const struct JsonBuilder *js);

const uint8_t *jb_ptr(struct JsonBuilder *js);

void jb_get_mark(struct JsonBuilder *js, struct JsonBuilderMark *mark);

bool jb_restore_mark(struct JsonBuilder *js, struct JsonBuilderMark *mark);

/**
 * Returns *mut DNSState
 */
void *rs_dns_state_new(void *_orig_state, AppProto _orig_proto);

/**
 * Returns *mut DNSState
 */
void *rs_dns_state_tcp_new(void);

/**
 * Params:
 * - state: *mut DNSState as void pointer
 */
void rs_dns_state_free(void *state);

void rs_dns_state_tx_free(void *state, uint64_t tx_id);

/**
 * C binding parse a DNS request. Returns 1 on success, -1 on failure.
 */
struct AppLayerResult rs_dns_parse_request(const Flow *_flow,
                                           void *state,
                                           void *_pstate,
                                           const uint8_t *input,
                                           uint32_t input_len,
                                           const void *_data,
                                           uint8_t _flags);

struct AppLayerResult rs_dns_parse_response(const Flow *_flow,
                                            void *state,
                                            void *_pstate,
                                            const uint8_t *input,
                                            uint32_t input_len,
                                            const void *_data,
                                            uint8_t _flags);

/**
 * C binding parse a DNS request. Returns 1 on success, -1 on failure.
 */
struct AppLayerResult rs_dns_parse_request_tcp(const Flow *_flow,
                                               void *state,
                                               void *_pstate,
                                               const uint8_t *input,
                                               uint32_t input_len,
                                               const void *_data,
                                               uint8_t _flags);

struct AppLayerResult rs_dns_parse_response_tcp(const Flow *_flow,
                                                void *state,
                                                void *_pstate,
                                                const uint8_t *input,
                                                uint32_t input_len,
                                                const void *_data,
                                                uint8_t _flags);

int rs_dns_tx_get_alstate_progress(void *_tx, uint8_t _direction);

uint64_t rs_dns_state_get_tx_count(void *state);

void *rs_dns_state_get_tx(void *state, uint64_t tx_id);

bool rs_dns_tx_is_request(struct RSDNSTransaction *tx);

bool rs_dns_tx_is_response(struct RSDNSTransaction *tx);

int rs_dns_state_set_tx_detect_state(void *tx, DetectEngineState *de_state);

DetectEngineState *rs_dns_state_get_tx_detect_state(void *tx);

AppLayerDecoderEvents *rs_dns_state_get_events(void *tx);

struct AppLayerTxData *rs_dns_state_get_tx_data(void *tx);

uint8_t rs_dns_tx_get_query_name(struct RSDNSTransaction *tx,
                                 uint32_t i,
                                 const uint8_t **buf,
                                 uint32_t *len);

/**
 * Get the DNS transaction ID of a transaction.
 * extern uint16_t rs_dns_tx_get_tx_id(RSDNSTransaction *);
 */
uint16_t rs_dns_tx_get_tx_id(struct RSDNSTransaction *tx);

/**
 * Get the DNS response flags for a transaction.
 *
 * extern uint16_t rs_dns_tx_get_response_flags(RSDNSTransaction *);
 */
uint16_t rs_dns_tx_get_response_flags(struct RSDNSTransaction *tx);

uint8_t rs_dns_tx_get_query_rrtype(struct RSDNSTransaction *tx,
                                   uint16_t i,
                                   uint16_t *rrtype);

AppProto rs_dns_probe(const Flow *_flow,
                      uint8_t _dir,
                      const uint8_t *input,
                      uint32_t len,
                      uint8_t *rdir);

AppProto rs_dns_probe_tcp(const Flow *_flow,
                          uint8_t direction,
                          const uint8_t *input,
                          uint32_t len,
                          uint8_t *rdir);

void rs_dns_apply_tx_config(void *_state,
                            void *_tx,
                            int _mode,
                            struct AppLayerTxConfig config);

void rs_dns_udp_register_parser(void);

void rs_dns_tcp_register_parser(void);

bool rs_dns_log_json_query(struct RSDNSTransaction *tx,
                           uint16_t i,
                           uint64_t flags,
                           struct JsonBuilder *jb);

bool rs_dns_log_json_answer(struct RSDNSTransaction *tx,
                            uint64_t flags,
                            struct JsonBuilder *js);

bool rs_dns_do_log_answer(struct RSDNSTransaction *tx, uint64_t flags);

struct JsonBuilder *rs_dns_log_json_answer_v1(struct RSDNSTransaction *tx,
                                              uint16_t i,
                                              uint64_t flags);

struct JsonBuilder *rs_dns_log_json_authority_v1(struct RSDNSTransaction *tx,
                                                 uint16_t i,
                                                 uint64_t flags);

/**
 * Perform the DNS opcode match.
 *
 * 1 will be returned on match, otherwise 0 will be returned.
 */
uint8_t rs_dns_opcode_match(struct RSDNSTransaction *tx,
                            struct DetectDnsOpcode *detect,
                            uint8_t flags);

void *rs_detect_dns_opcode_parse(const char *carg);

void rs_dns_detect_opcode_free(void *ptr);

void rs_dns_lua_get_tx_id(lua_State *clua, struct RSDNSTransaction *tx);

int rs_dns_lua_get_rrname(lua_State *clua, struct RSDNSTransaction *tx);

int rs_dns_lua_get_rcode(lua_State *clua, struct RSDNSTransaction *tx);

int rs_dns_lua_get_query_table(lua_State *clua, struct RSDNSTransaction *tx);

int rs_dns_lua_get_answer_table(lua_State *clua, struct RSDNSTransaction *tx);

int rs_dns_lua_get_authority_table(lua_State *clua,
                                   struct RSDNSTransaction *tx);

/**
 * Returns *mut NFSState
 */
void *rs_nfs_state_new(void *_orig_state, AppProto _orig_proto);

/**
 * Params:
 * - state: *mut NFSState as void pointer
 */
void rs_nfs_state_free(void *state);

/**
 * C binding parse a NFS TCP request. Returns 1 on success, -1 on failure.
 */
struct AppLayerResult rs_nfs_parse_request(const Flow *flow,
                                           void *state,
                                           void *_pstate,
                                           const uint8_t *input,
                                           uint32_t input_len,
                                           const void *_data,
                                           uint8_t _flags);

struct AppLayerResult rs_nfs_parse_request_tcp_gap(struct NFSState *state,
                                                   uint32_t input_len);

struct AppLayerResult rs_nfs_parse_response(const Flow *flow,
                                            void *state,
                                            void *_pstate,
                                            const uint8_t *input,
                                            uint32_t input_len,
                                            const void *_data,
                                            uint8_t _flags);

struct AppLayerResult rs_nfs_parse_response_tcp_gap(struct NFSState *state,
                                                    uint32_t input_len);

/**
 * C binding to parse an NFS/UDP request. Returns 1 on success, -1 on failure.
 */
struct AppLayerResult rs_nfs_parse_request_udp(const Flow *f,
                                               void *state,
                                               void *_pstate,
                                               const uint8_t *input,
                                               uint32_t input_len,
                                               const void *_data,
                                               uint8_t _flags);

struct AppLayerResult rs_nfs_parse_response_udp(const Flow *f,
                                                void *state,
                                                void *_pstate,
                                                const uint8_t *input,
                                                uint32_t input_len,
                                                const void *_data,
                                                uint8_t _flags);

uint64_t rs_nfs_state_get_tx_count(void *state);

void *rs_nfs_state_get_tx(void *state, uint64_t tx_id);

struct AppLayerGetTxIterTuple rs_nfs_state_get_tx_iterator(uint8_t _ipproto,
                                                           AppProto _alproto,
                                                           void *state,
                                                           uint64_t min_tx_id,
                                                           uint64_t _max_tx_id,
                                                           uint64_t *istate);

void rs_nfs_state_tx_free(void *state, uint64_t tx_id);

int rs_nfs_tx_get_alstate_progress(void *tx, uint8_t direction);

struct AppLayerTxData *rs_nfs_get_tx_data(void *tx);

int32_t rs_nfs_state_set_tx_detect_state(void *tx, DetectEngineState *de_state);

DetectEngineState *rs_nfs_state_get_tx_detect_state(void *tx);

AppLayerDecoderEvents *rs_nfs_state_get_events(void *tx);

int8_t rs_nfs_state_get_event_info_by_id(int event_id,
                                         const char **event_name,
                                         AppLayerEventType *event_type);

int rs_nfs_state_get_event_info(const char *event_name,
                                int *event_id,
                                AppLayerEventType *event_type);

/**
 * return procedure(s) in the tx. At 0 return the main proc,
 * otherwise get procs from the 'file_additional_procs'.
 * Keep calling until 0 is returned.
 */
uint8_t rs_nfs_tx_get_procedures(struct NFSTransaction *tx,
                                 uint16_t i,
                                 uint32_t *procedure);

void rs_nfs_tx_get_version(struct NFSTransaction *tx, uint32_t *version);

void rs_nfs_init(SuricataFileContext *context);

/**
 * MIDSTREAM
 */
AppProto rs_nfs_probe_ms(const Flow *_flow,
                         uint8_t direction,
                         const uint8_t *input,
                         uint32_t len,
                         uint8_t *rdir);

AppProto rs_nfs_probe(const Flow *_f,
                      uint8_t direction,
                      const uint8_t *input,
                      uint32_t len,
                      uint8_t *_rdir);

/**
 * TOSERVER probe function
 */
AppProto rs_nfs_probe_udp_ts(const Flow *_f,
                             uint8_t _direction,
                             const uint8_t *input,
                             uint32_t len,
                             uint8_t *_rdir);

/**
 * TOCLIENT probe function
 */
AppProto rs_nfs_probe_udp_tc(const Flow *_f,
                             uint8_t _direction,
                             const uint8_t *input,
                             uint32_t len,
                             uint8_t *_rdir);

FileContainer *rs_nfs_getfiles(void *ptr, uint8_t direction);

void rs_nfs_setfileflags(uint8_t direction,
                         struct NFSState *ptr,
                         uint16_t flags);

void rs_nfs_register_parser(void);

void rs_nfs_udp_register_parser(void);

uint8_t rs_nfs_tx_logging_is_filtered(struct NFSState *state,
                                      struct NFSTransaction *tx);

bool rs_nfs_log_json_request(struct NFSState *state,
                             struct NFSTransaction *tx,
                             struct JsonBuilder *js);

bool rs_nfs_log_json_response(struct NFSState *state,
                              struct NFSTransaction *tx,
                              struct JsonBuilder *js);

bool rs_rpc_log_json_response(struct NFSTransaction *tx,
                              struct JsonBuilder *js);

uint16_t rs_ftp_active_port(const uint8_t *input, uint32_t len);

uint16_t rs_ftp_pasv_response(const uint8_t *input, uint32_t len);

uint16_t rs_ftp_active_eprt(const uint8_t *input, uint32_t len);

uint16_t rs_ftp_epsv_response(const uint8_t *input, uint32_t len);

void rs_smb_init(SuricataFileContext *context);

/**
 * Returns *mut SMBState
 */
void *rs_smb_state_new(void *_orig_state, AppProto _orig_proto);

/**
 * Params:
 * - state: *mut SMBState as void pointer
 */
void rs_smb_state_free(void *state);

/**
 * C binding parse a SMB request. Returns 1 on success, -1 on failure.
 */
struct AppLayerResult rs_smb_parse_request_tcp(const Flow *flow,
                                               void *state,
                                               void *_pstate,
                                               const uint8_t *input,
                                               uint32_t input_len,
                                               const void *_data,
                                               uint8_t flags);

struct AppLayerResult rs_smb_parse_request_tcp_gap(struct SMBState *state,
                                                   uint32_t input_len);

struct AppLayerResult rs_smb_parse_response_tcp(const Flow *flow,
                                                void *state,
                                                void *_pstate,
                                                const uint8_t *input,
                                                uint32_t input_len,
                                                const void *_data,
                                                uint8_t flags);

struct AppLayerResult rs_smb_parse_response_tcp_gap(struct SMBState *state,
                                                    uint32_t input_len);

AppProto rs_smb_probe_tcp(const Flow *_f,
                          uint8_t flags,
                          const uint8_t *input,
                          uint32_t len,
                          uint8_t *rdir);

uint64_t rs_smb_state_get_tx_count(void *state);

void *rs_smb_state_get_tx(void *state, uint64_t tx_id);

struct AppLayerGetTxIterTuple rs_smb_state_get_tx_iterator(uint8_t _ipproto,
                                                           AppProto _alproto,
                                                           void *state,
                                                           uint64_t min_tx_id,
                                                           uint64_t _max_tx_id,
                                                           uint64_t *istate);

void rs_smb_state_tx_free(void *state, uint64_t tx_id);

int32_t rs_smb_tx_get_alstate_progress(void *tx, uint8_t direction);

struct AppLayerTxData *rs_smb_get_tx_data(void *tx);

DetectEngineState *rs_smb_state_get_tx_detect_state(void *tx);

int rs_smb_state_set_tx_detect_state(void *tx, DetectEngineState *de_state);

void rs_smb_state_truncate(void *state, uint8_t direction);

AppLayerDecoderEvents *rs_smb_state_get_events(void *tx);

int8_t rs_smb_state_get_event_info_by_id(int event_id,
                                         const char **event_name,
                                         AppLayerEventType *event_type);

int rs_smb_state_get_event_info(const char *event_name,
                                int *event_id,
                                AppLayerEventType *event_type);

void rs_smb_register_parser(void);

bool rs_smb_log_json_request(struct JsonBuilder *jsb,
                             struct SMBState *state,
                             struct SMBTransaction *tx);

bool rs_smb_log_json_response(struct JsonBuilder *jsb,
                              struct SMBState *state,
                              struct SMBTransaction *tx);

uint8_t rs_smb_tx_get_share(struct SMBTransaction *tx,
                            const uint8_t **buffer,
                            uint32_t *buffer_len);

uint8_t rs_smb_tx_get_named_pipe(struct SMBTransaction *tx,
                                 const uint8_t **buffer,
                                 uint32_t *buffer_len);

uint8_t rs_smb_tx_get_stub_data(struct SMBTransaction *tx,
                                uint8_t direction,
                                const uint8_t **buffer,
                                uint32_t *buffer_len);

uint8_t rs_smb_tx_match_dce_opnum(struct SMBTransaction *tx,
                                  struct DCEOpnumData *dce_data);

uint8_t rs_smb_tx_get_dce_iface(struct SMBState *state,
                                struct SMBTransaction *tx,
                                struct DCEIfaceData *dce_data);

FileContainer *rs_smb_getfiles(void *ptr, uint8_t direction);

void rs_smb_setfileflags(uint8_t direction,
                         struct SMBState *ptr,
                         uint16_t flags);

/**
 * Returns *mut KRB5State
 */
void *rs_krb5_state_new(void *_orig_state, AppProto _orig_proto);

/**
 * Params:
 * - state: *mut KRB5State as void pointer
 */
void rs_krb5_state_free(void *state);

void *rs_krb5_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_krb5_state_get_tx_count(void *state);

void rs_krb5_state_tx_free(void *state, uint64_t tx_id);

int rs_krb5_tx_get_alstate_progress(void *_tx, uint8_t _direction);

int rs_krb5_state_set_tx_detect_state(void *tx, DetectEngineState *de_state);

DetectEngineState *rs_krb5_state_get_tx_detect_state(void *tx);

AppLayerDecoderEvents *rs_krb5_state_get_events(void *tx);

AppProto rs_krb5_probing_parser(const Flow *_flow,
                                uint8_t _direction,
                                const uint8_t *input,
                                uint32_t input_len,
                                uint8_t *_rdir);

AppProto rs_krb5_probing_parser_tcp(const Flow *_flow,
                                    uint8_t direction,
                                    const uint8_t *input,
                                    uint32_t input_len,
                                    uint8_t *rdir);

struct AppLayerResult rs_krb5_parse_request(const Flow *_flow,
                                            void *state,
                                            void *_pstate,
                                            const uint8_t *input,
                                            uint32_t input_len,
                                            const void *_data,
                                            uint8_t _flags);

struct AppLayerResult rs_krb5_parse_response(const Flow *_flow,
                                             void *state,
                                             void *_pstate,
                                             const uint8_t *input,
                                             uint32_t input_len,
                                             const void *_data,
                                             uint8_t _flags);

struct AppLayerResult rs_krb5_parse_request_tcp(const Flow *_flow,
                                                void *state,
                                                void *_pstate,
                                                const uint8_t *input,
                                                uint32_t input_len,
                                                const void *_data,
                                                uint8_t _flags);

struct AppLayerResult rs_krb5_parse_response_tcp(const Flow *_flow,
                                                 void *state,
                                                 void *_pstate,
                                                 const uint8_t *input,
                                                 uint32_t input_len,
                                                 const void *_data,
                                                 uint8_t _flags);

void rs_register_krb5_parser(void);

void rs_krb5_tx_get_msgtype(KRB5Transaction *tx, uint32_t *ptr);

/**
 * Get error code, if present in transaction
 * Return 0 if error code was filled, else 1
 */
uint32_t rs_krb5_tx_get_errcode(KRB5Transaction *tx, int32_t *ptr);

uint8_t rs_krb5_tx_get_cname(KRB5Transaction *tx,
                             uint32_t i,
                             const uint8_t **buffer,
                             uint32_t *buffer_len);

uint8_t rs_krb5_tx_get_sname(KRB5Transaction *tx,
                             uint32_t i,
                             const uint8_t **buffer,
                             uint32_t *buffer_len);

bool rs_krb5_log_json_response(struct JsonBuilder *jsb,
                               KRB5State *_state,
                               KRB5Transaction *tx);

struct AppLayerResult rs_parse_dcerpc_request_gap(struct DCERPCState *state,
                                                  uint32_t _input_len);

struct AppLayerResult rs_parse_dcerpc_response_gap(struct DCERPCState *state,
                                                   uint32_t _input_len);

struct AppLayerResult rs_dcerpc_parse_request(const Flow *flow,
                                              void *state,
                                              void *_pstate,
                                              const uint8_t *input,
                                              uint32_t input_len,
                                              const void *_data,
                                              uint8_t flags);

struct AppLayerResult rs_dcerpc_parse_response(const Flow *flow,
                                               void *state,
                                               void *_pstate,
                                               const uint8_t *input,
                                               uint32_t input_len,
                                               const void *_data,
                                               uint8_t flags);

void *rs_dcerpc_state_new(void *_orig_state, AppProto _orig_proto);

void rs_dcerpc_state_free(void *state);

void rs_dcerpc_state_transaction_free(void *state, uint64_t tx_id);

void rs_dcerpc_state_trunc(void *state, uint8_t direction);

DetectEngineState *rs_dcerpc_get_tx_detect_state(void *vtx);

int rs_dcerpc_set_tx_detect_state(void *vtx, DetectEngineState *de_state);

void *rs_dcerpc_get_tx(void *vtx, uint64_t tx_id);

uint64_t rs_dcerpc_get_tx_cnt(void *vtx);

int rs_dcerpc_get_alstate_progress(void *tx, uint8_t direction);

struct AppLayerTxData *rs_dcerpc_get_tx_data(void *tx);

void rs_dcerpc_get_stub_data(struct DCERPCTransaction *tx,
                             const uint8_t **buf,
                             uint32_t *len,
                             uint8_t *endianness,
                             uint8_t dir);

void rs_dcerpc_register_parser(void);

struct AppLayerResult rs_dcerpc_udp_parse(const Flow *_flow,
                                          void *state,
                                          void *_pstate,
                                          const uint8_t *input,
                                          uint32_t input_len,
                                          const void *_data,
                                          uint8_t _flags);

void rs_dcerpc_udp_state_free(void *state);

void *rs_dcerpc_udp_state_new(void *_orig_state, AppProto _orig_proto);

void rs_dcerpc_udp_state_transaction_free(void *state, uint64_t tx_id);

DetectEngineState *rs_dcerpc_udp_get_tx_detect_state(void *vtx);

int rs_dcerpc_udp_set_tx_detect_state(void *vtx, DetectEngineState *de_state);

struct AppLayerTxData *rs_dcerpc_udp_get_tx_data(void *tx);

void *rs_dcerpc_udp_get_tx(void *state, uint64_t tx_id);

uint64_t rs_dcerpc_udp_get_tx_cnt(void *vtx);

void rs_dcerpc_udp_register_parser(void);

uint8_t rs_dcerpc_iface_match(struct DCERPCTransaction *tx,
                              struct DCERPCState *state,
                              struct DCEIfaceData *if_data);

void *rs_dcerpc_iface_parse(const char *carg);

void rs_dcerpc_iface_free(void *ptr);

uint8_t rs_dcerpc_opnum_match(struct DCERPCTransaction *tx,
                              struct DCEOpnumData *opnum_data);

void *rs_dcerpc_opnum_parse(const char *carg);

void rs_dcerpc_opnum_free(void *ptr);

bool rs_dcerpc_log_json_record_tcp(const struct DCERPCState *state,
                                   const struct DCERPCTransaction *tx,
                                   struct JsonBuilder *jsb);

bool rs_dcerpc_log_json_record_udp(const struct DCERPCUDPState *state,
                                   const struct DCERPCTransaction *tx,
                                   struct JsonBuilder *jsb);

/**
 * Intermediary function between the C code and the parsing functions.
 */
void *rs_modbus_parse(const char *c_arg);

void rs_modbus_free(void *ptr);

/**
 * Compares a transaction to a signature to determine whether the transaction
 * matches the signature. If it does, 1 is returned; otherwise 0 is returned.
 */
uint8_t rs_modbus_inspect(const struct ModbusTransaction *tx,
                          const struct DetectModbusRust *modbus);

bool rs_modbus_to_json(struct ModbusTransaction *tx, struct JsonBuilder *js);

/**
 * Probe input to see if it looks like Modbus.
 */
AppProto rs_modbus_probe(const Flow *_flow,
                         uint8_t _direction,
                         const uint8_t *input,
                         uint32_t len,
                         uint8_t *_rdir);

void *rs_modbus_state_new(void *_orig_state, AppProto _orig_proto);

void rs_modbus_state_free(void *state);

void rs_modbus_state_tx_free(void *state, uint64_t tx_id);

struct AppLayerResult rs_modbus_parse_request(const Flow *_flow,
                                              void *state,
                                              void *pstate,
                                              const uint8_t *input,
                                              uint32_t input_len,
                                              const void *_data,
                                              uint8_t _flags);

struct AppLayerResult rs_modbus_parse_response(const Flow *_flow,
                                               void *state,
                                               void *pstate,
                                               const uint8_t *input,
                                               uint32_t input_len,
                                               const void *_data,
                                               uint8_t _flags);

uint64_t rs_modbus_state_get_tx_count(void *state);

void *rs_modbus_state_get_tx(void *state, uint64_t tx_id);

int rs_modbus_tx_get_alstate_progress(void *tx, uint8_t _direction);

AppLayerDecoderEvents *rs_modbus_state_get_events(void *tx);

DetectEngineState *rs_modbus_state_get_tx_detect_state(void *tx);

int rs_modbus_state_set_tx_detect_state(void *tx, DetectEngineState *de_state);

struct AppLayerTxData *rs_modbus_state_get_tx_data(void *tx);

void rs_modbus_register_parser(void);

uint8_t rs_modbus_message_get_function(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_subfunction(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_read_request_address(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_read_request_quantity(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_rw_multreq_read_address(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_rw_multreq_read_quantity(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_rw_multreq_write_address(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_rw_multreq_write_quantity(const struct ModbusMessage *msg);

const uint8_t *rs_modbus_message_get_rw_multreq_write_data(const struct ModbusMessage *msg,
                                                           uintptr_t *data_len);

uint16_t rs_modbus_message_get_write_multreq_address(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_write_multreq_quantity(const struct ModbusMessage *msg);

const uint8_t *rs_modbus_message_get_write_multreq_data(const struct ModbusMessage *msg,
                                                        uintptr_t *data_len);

uint16_t rs_modbus_message_get_and_mask(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_or_mask(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_write_address(const struct ModbusMessage *msg);

uint16_t rs_modbus_message_get_write_data(const struct ModbusMessage *msg);

const uint8_t *rs_modbus_message_get_bytevec_data(const struct ModbusMessage *msg,
                                                  uintptr_t *data_len);

struct ModbusMessage rs_modbus_state_get_tx_request(void *state,
                                                    uint64_t tx_id);

struct ModbusMessage rs_modbus_state_get_tx_response(void *state,
                                                     uint64_t tx_id);

uint8_t rs_ike_state_get_exch_type(IKETransaction *tx, uint8_t *exch_type);

uint8_t rs_ike_state_get_spi_initiator(IKETransaction *tx,
                                       const uint8_t **buffer,
                                       uint32_t *buffer_len);

uint8_t rs_ike_state_get_spi_responder(IKETransaction *tx,
                                       const uint8_t **buffer,
                                       uint32_t *buffer_len);

uint8_t rs_ike_state_get_nonce(IKETransaction *tx,
                               const uint8_t **buffer,
                               uint32_t *buffer_len);

uint8_t rs_ike_state_get_key_exchange(IKETransaction *tx,
                                      const uint8_t **buffer,
                                      uint32_t *buffer_len);

uint8_t rs_ike_tx_get_vendor(const IKETransaction *tx,
                             uint32_t i,
                             const uint8_t **buf,
                             uint32_t *len);

uint8_t rs_ike_state_get_sa_attribute(IKETransaction *tx,
                                      const char *sa_type,
                                      uint32_t *value);

uint8_t rs_ike_state_get_key_exchange_payload_length(IKETransaction *tx,
                                                     uint32_t *value);

uint8_t rs_ike_state_get_nonce_payload_length(IKETransaction *tx,
                                              uint32_t *value);

/**
 * C entry point for a probing parser.
 */
AppProto rs_ike_probing_parser(const Flow *_flow,
                               uint8_t direction,
                               const uint8_t *input,
                               uint32_t input_len,
                               uint8_t *rdir);

void *rs_ike_state_new(void *_orig_state, AppProto _orig_proto);

void rs_ike_state_free(void *state);

void rs_ike_state_tx_free(void *state, uint64_t tx_id);

struct AppLayerResult rs_ike_parse_request(const Flow *_flow,
                                           void *state,
                                           void *_pstate,
                                           const uint8_t *input,
                                           uint32_t input_len,
                                           const void *_data,
                                           uint8_t _flags);

struct AppLayerResult rs_ike_parse_response(const Flow *_flow,
                                            void *state,
                                            void *_pstate,
                                            const uint8_t *input,
                                            uint32_t input_len,
                                            const void *_data,
                                            uint8_t _flags);

void *rs_ike_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_ike_state_get_tx_count(void *state);

int rs_ike_state_progress_completion_status(uint8_t _direction);

int rs_ike_tx_get_alstate_progress(void *_tx, uint8_t _direction);

uint32_t rs_ike_tx_get_logged(void *_state, void *tx);

void rs_ike_tx_set_logged(void *_state, void *tx, uint32_t logged);

AppLayerDecoderEvents *rs_ike_state_get_events(void *tx);

struct AppLayerGetTxIterTuple rs_ike_state_get_tx_iterator(uint8_t _ipproto,
                                                           AppProto _alproto,
                                                           void *state,
                                                           uint64_t min_tx_id,
                                                           uint64_t _max_tx_id,
                                                           uint64_t *istate);

void rs_ike_register_parser(void);

bool rs_ike_logger_log(IKEState *state,
                       void *tx,
                       uint32_t flags,
                       struct JsonBuilder *js);

/**
 * Returns *mut SNMPState
 */
void *rs_snmp_state_new(void *_orig_state, AppProto _orig_proto);

/**
 * Params:
 * - state: *mut SNMPState as void pointer
 */
void rs_snmp_state_free(void *state);

struct AppLayerResult rs_snmp_parse_request(const Flow *_flow,
                                            void *state,
                                            void *_pstate,
                                            const uint8_t *input,
                                            uint32_t input_len,
                                            const void *_data,
                                            uint8_t _flags);

struct AppLayerResult rs_snmp_parse_response(const Flow *_flow,
                                             void *state,
                                             void *_pstate,
                                             const uint8_t *input,
                                             uint32_t input_len,
                                             const void *_data,
                                             uint8_t _flags);

void *rs_snmp_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_snmp_state_get_tx_count(void *state);

void rs_snmp_state_tx_free(void *state, uint64_t tx_id);

int rs_snmp_tx_get_alstate_progress(void *_tx, uint8_t _direction);

int rs_snmp_state_set_tx_detect_state(void *tx, DetectEngineState *de_state);

DetectEngineState *rs_snmp_state_get_tx_detect_state(void *tx);

AppLayerDecoderEvents *rs_snmp_state_get_events(void *tx);

struct AppLayerGetTxIterTuple rs_snmp_state_get_tx_iterator(SNMPState *state,
                                                            uint64_t min_tx_id,
                                                            uint64_t *istate);

struct AppLayerGetTxIterTuple rs_snmp_get_tx_iterator(uint8_t _ipproto,
                                                      AppProto _alproto,
                                                      void *alstate,
                                                      uint64_t min_tx_id,
                                                      uint64_t _max_tx_id,
                                                      uint64_t *istate);

AppProto rs_snmp_probing_parser(const Flow *_flow,
                                uint8_t _direction,
                                const uint8_t *input,
                                uint32_t input_len,
                                uint8_t *_rdir);

void rs_register_snmp_parser(void);

bool rs_snmp_log_json_response(struct JsonBuilder *jsb,
                               SNMPState *state,
                               SNMPTransaction *tx);

void rs_snmp_tx_get_version(SNMPTransaction *tx, uint32_t *version);

void rs_snmp_tx_get_community(SNMPTransaction *tx,
                              const uint8_t **buf,
                              uint32_t *len);

void rs_snmp_tx_get_pdu_type(SNMPTransaction *tx, uint32_t *pdu_type);

/**
 * Returns *mut NTPState
 */
void *rs_ntp_state_new(void *_orig_state, AppProto _orig_proto);

/**
 * Params:
 * - state: *mut NTPState as void pointer
 */
void rs_ntp_state_free(void *state);

struct AppLayerResult rs_ntp_parse_request(const Flow *_flow,
                                           void *state,
                                           void *_pstate,
                                           const uint8_t *input,
                                           uint32_t input_len,
                                           const void *_data,
                                           uint8_t _flags);

struct AppLayerResult rs_ntp_parse_response(const Flow *_flow,
                                            void *state,
                                            void *_pstate,
                                            const uint8_t *input,
                                            uint32_t input_len,
                                            const void *_data,
                                            uint8_t _flags);

void *rs_ntp_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_ntp_state_get_tx_count(void *state);

void rs_ntp_state_tx_free(void *state, uint64_t tx_id);

int rs_ntp_tx_get_alstate_progress(void *_tx, uint8_t _direction);

int rs_ntp_state_set_tx_detect_state(void *tx, DetectEngineState *de_state);

DetectEngineState *rs_ntp_state_get_tx_detect_state(void *tx);

AppLayerDecoderEvents *rs_ntp_state_get_events(void *tx);

AppProto ntp_probing_parser(const Flow *_flow,
                            uint8_t _direction,
                            const uint8_t *input,
                            uint32_t input_len,
                            uint8_t *_rdir);

void rs_register_ntp_parser(void);

void *rs_tftp_state_alloc(void);

void rs_tftp_state_free(void *state);

void rs_tftp_state_tx_free(TFTPState *state, uint64_t tx_id);

void *rs_tftp_get_tx(TFTPState *state, uint64_t tx_id);

uint64_t rs_tftp_get_tx_cnt(TFTPState *state);

int64_t rs_tftp_request(TFTPState *state, const uint8_t *input, uint32_t len);

struct AppLayerTxData *rs_tftp_get_tx_data(void *tx);

bool rs_tftp_log_json_request(TFTPTransaction *tx, struct JsonBuilder *jb);

AppProto rs_dhcp_probing_parser(const Flow *_flow,
                                uint8_t _direction,
                                const uint8_t *input,
                                uint32_t input_len,
                                uint8_t *_rdir);

int rs_dhcp_tx_get_alstate_progress(void *_tx, uint8_t _direction);

void *rs_dhcp_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_dhcp_state_get_tx_count(void *state);

struct AppLayerResult rs_dhcp_parse(const Flow *_flow,
                                    void *state,
                                    void *_pstate,
                                    const uint8_t *input,
                                    uint32_t input_len,
                                    const void *_data,
                                    uint8_t _flags);

void rs_dhcp_state_tx_free(void *state, uint64_t tx_id);

void *rs_dhcp_state_new(void *_orig_state, AppProto _orig_proto);

void rs_dhcp_state_free(void *state);

AppLayerDecoderEvents *rs_dhcp_state_get_events(void *tx);

struct AppLayerGetTxIterTuple rs_dhcp_state_get_tx_iterator(uint8_t _ipproto,
                                                            AppProto _alproto,
                                                            void *state,
                                                            uint64_t min_tx_id,
                                                            uint64_t _max_tx_id,
                                                            uint64_t *istate);

void rs_dhcp_register_parser(void);

void *rs_dhcp_logger_new(const void *conf);

void rs_dhcp_logger_free(void *logger);

bool rs_dhcp_logger_log(void *logger, void *tx, struct JsonBuilder *js);

bool rs_dhcp_logger_do_log(void *logger, void *tx);

uint8_t rs_sip_tx_get_method(struct SIPTransaction *tx,
                             const uint8_t **buffer,
                             uint32_t *buffer_len);

uint8_t rs_sip_tx_get_uri(struct SIPTransaction *tx,
                          const uint8_t **buffer,
                          uint32_t *buffer_len);

uint8_t rs_sip_tx_get_protocol(struct SIPTransaction *tx,
                               const uint8_t **buffer,
                               uint32_t *buffer_len,
                               uint8_t direction);

uint8_t rs_sip_tx_get_stat_code(struct SIPTransaction *tx,
                                const uint8_t **buffer,
                                uint32_t *buffer_len);

uint8_t rs_sip_tx_get_stat_msg(struct SIPTransaction *tx,
                               const uint8_t **buffer,
                               uint32_t *buffer_len);

uint8_t rs_sip_tx_get_request_line(struct SIPTransaction *tx,
                                   const uint8_t **buffer,
                                   uint32_t *buffer_len);

uint8_t rs_sip_tx_get_response_line(struct SIPTransaction *tx,
                                    const uint8_t **buffer,
                                    uint32_t *buffer_len);

bool rs_sip_log_json(struct SIPTransaction *tx, struct JsonBuilder *js);

void *rs_sip_state_new(void *_orig_state, AppProto _orig_proto);

void rs_sip_state_free(void *state);

void *rs_sip_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_sip_state_get_tx_count(void *state);

void rs_sip_state_tx_free(void *state, uint64_t tx_id);

int rs_sip_tx_get_alstate_progress(void *_tx, uint8_t _direction);

int rs_sip_state_set_tx_detect_state(void *tx, DetectEngineState *de_state);

DetectEngineState *rs_sip_state_get_tx_detect_state(void *tx);

AppLayerDecoderEvents *rs_sip_state_get_events(void *tx);

AppProto rs_sip_probing_parser_ts(const Flow *_flow,
                                  uint8_t _direction,
                                  const uint8_t *input,
                                  uint32_t input_len,
                                  uint8_t *_rdir);

AppProto rs_sip_probing_parser_tc(const Flow *_flow,
                                  uint8_t _direction,
                                  const uint8_t *input,
                                  uint32_t input_len,
                                  uint8_t *_rdir);

struct AppLayerResult rs_sip_parse_request(const Flow *_flow,
                                           void *state,
                                           void *_pstate,
                                           const uint8_t *input,
                                           uint32_t input_len,
                                           const void *_data,
                                           uint8_t _flags);

struct AppLayerResult rs_sip_parse_response(const Flow *_flow,
                                            void *state,
                                            void *_pstate,
                                            const uint8_t *input,
                                            uint32_t input_len,
                                            const void *_data,
                                            uint8_t _flags);

void rs_sip_register_parser(void);

uint8_t rs_rfb_tx_get_name(struct RFBTransaction *tx,
                           const uint8_t **buffer,
                           uint32_t *buffer_len);

uint8_t rs_rfb_tx_get_sectype(struct RFBTransaction *tx, uint32_t *sectype);

uint8_t rs_rfb_tx_get_secresult(struct RFBTransaction *tx, uint32_t *secresult);

bool rs_rfb_logger_log(struct RFBState *_state,
                       void *tx,
                       struct JsonBuilder *js);

void *rs_rfb_state_new(void *_orig_state, AppProto _orig_proto);

void rs_rfb_state_free(void *state);

void rs_rfb_state_tx_free(void *state, uint64_t tx_id);

struct AppLayerResult rs_rfb_parse_request(const Flow *_flow,
                                           void *state,
                                           void *_pstate,
                                           const uint8_t *input,
                                           uint32_t input_len,
                                           const void *_data,
                                           uint8_t _flags);

struct AppLayerResult rs_rfb_parse_response(const Flow *_flow,
                                            void *state,
                                            void *_pstate,
                                            const uint8_t *input,
                                            uint32_t input_len,
                                            const void *_data,
                                            uint8_t _flags);

void *rs_rfb_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_rfb_state_get_tx_count(void *state);

int rs_rfb_tx_get_alstate_progress(void *tx, uint8_t _direction);

AppLayerDecoderEvents *rs_rfb_state_get_events(void *tx);

struct AppLayerGetTxIterTuple rs_rfb_state_get_tx_iterator(uint8_t _ipproto,
                                                           AppProto _alproto,
                                                           void *state,
                                                           uint64_t min_tx_id,
                                                           uint64_t _max_tx_id,
                                                           uint64_t *istate);

void rs_rfb_register_parser(void);

uint8_t rs_mqtt_tx_has_type(const struct MQTTTransaction *tx, uint8_t mtype);

int rs_mqtt_cstr_message_code(const char *str);

uint8_t rs_mqtt_tx_has_flags(const struct MQTTTransaction *tx,
                             MQTTFlagState qretain,
                             MQTTFlagState qdup);

uint8_t rs_mqtt_tx_has_qos(const struct MQTTTransaction *tx, uint8_t qos);

uint8_t rs_mqtt_tx_get_protocol_version(const struct MQTTState *state);

uint8_t rs_mqtt_tx_has_connect_flags(const struct MQTTTransaction *tx,
                                     MQTTFlagState username,
                                     MQTTFlagState password,
                                     MQTTFlagState will,
                                     MQTTFlagState will_retain,
                                     MQTTFlagState clean_session);

uint8_t rs_mqtt_tx_get_connect_clientid(const struct MQTTTransaction *tx,
                                        const uint8_t **buffer,
                                        uint32_t *buffer_len);

uint8_t rs_mqtt_tx_get_connect_username(const struct MQTTTransaction *tx,
                                        const uint8_t **buffer,
                                        uint32_t *buffer_len);

uint8_t rs_mqtt_tx_get_connect_password(const struct MQTTTransaction *tx,
                                        const uint8_t **buffer,
                                        uint32_t *buffer_len);

uint8_t rs_mqtt_tx_get_connect_willtopic(const struct MQTTTransaction *tx,
                                         const uint8_t **buffer,
                                         uint32_t *buffer_len);

uint8_t rs_mqtt_tx_get_connect_willmessage(const struct MQTTTransaction *tx,
                                           const uint8_t **buffer,
                                           uint32_t *buffer_len);

uint8_t rs_mqtt_tx_get_connack_sessionpresent(const struct MQTTTransaction *tx,
                                              bool *session_present);

uint8_t rs_mqtt_tx_get_publish_topic(const struct MQTTTransaction *tx,
                                     const uint8_t **buffer,
                                     uint32_t *buffer_len);

uint8_t rs_mqtt_tx_get_publish_message(const struct MQTTTransaction *tx,
                                       const uint8_t **buffer,
                                       uint32_t *buffer_len);

uint8_t rs_mqtt_tx_get_subscribe_topic(const struct MQTTTransaction *tx,
                                       uint32_t i,
                                       const uint8_t **buf,
                                       uint32_t *len);

uint8_t rs_mqtt_tx_get_unsubscribe_topic(const struct MQTTTransaction *tx,
                                         uint32_t i,
                                         const uint8_t **buf,
                                         uint32_t *len);

uint8_t rs_mqtt_tx_get_reason_code(const struct MQTTTransaction *tx,
                                   uint8_t *result);

uint8_t rs_mqtt_tx_unsuback_has_reason_code(const struct MQTTTransaction *tx,
                                            uint8_t code);

bool rs_mqtt_logger_log(struct MQTTState *_state,
                        void *tx,
                        uint32_t flags,
                        struct JsonBuilder *js);

AppProto rs_mqtt_probing_parser(const Flow *_flow,
                                uint8_t _direction,
                                const uint8_t *input,
                                uint32_t input_len,
                                uint8_t *_rdir);

void *rs_mqtt_state_new(void *_orig_state, AppProto _orig_proto);

void rs_mqtt_state_free(void *state);

void rs_mqtt_state_tx_free(void *state, uint64_t tx_id);

struct AppLayerResult rs_mqtt_parse_request(const Flow *_flow,
                                            void *state,
                                            void *_pstate,
                                            const uint8_t *input,
                                            uint32_t input_len,
                                            const void *_data,
                                            uint8_t _flags);

struct AppLayerResult rs_mqtt_parse_response(const Flow *_flow,
                                             void *state,
                                             void *_pstate,
                                             const uint8_t *input,
                                             uint32_t input_len,
                                             const void *_data,
                                             uint8_t _flags);

void *rs_mqtt_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_mqtt_state_get_tx_count(void *state);

int rs_mqtt_tx_is_toclient(const void *tx);

int rs_mqtt_tx_get_alstate_progress(void *tx, uint8_t direction);

uint32_t rs_mqtt_tx_get_logged(void *_state, void *tx);

void rs_mqtt_tx_set_logged(void *_state, void *tx, uint32_t logged);

AppLayerDecoderEvents *rs_mqtt_state_get_events(void *tx);

struct AppLayerGetTxIterTuple rs_mqtt_state_get_tx_iterator(uint8_t _ipproto,
                                                            AppProto _alproto,
                                                            void *state,
                                                            uint64_t min_tx_id,
                                                            uint64_t _max_tx_id,
                                                            uint64_t *istate);

void rs_mqtt_register_parser(uint32_t cfg_max_msg_len);

/**
 * C entry point for a probing parser.
 */
AppProto rs_template_probing_parser(const Flow *_flow,
                                    uint8_t _direction,
                                    const uint8_t *input,
                                    uint32_t input_len,
                                    uint8_t *_rdir);

void *rs_template_state_new(void *_orig_state, AppProto _orig_proto);

void rs_template_state_free(void *state);

void rs_template_state_tx_free(void *state, uint64_t tx_id);

struct AppLayerResult rs_template_parse_request(const Flow *_flow,
                                                void *state,
                                                void *pstate,
                                                const uint8_t *input,
                                                uint32_t input_len,
                                                const void *_data,
                                                uint8_t _flags);

struct AppLayerResult rs_template_parse_response(const Flow *_flow,
                                                 void *state,
                                                 void *pstate,
                                                 const uint8_t *input,
                                                 uint32_t input_len,
                                                 const void *_data,
                                                 uint8_t _flags);

void *rs_template_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_template_state_get_tx_count(void *state);

int rs_template_tx_get_alstate_progress(void *tx, uint8_t _direction);

AppLayerDecoderEvents *rs_template_state_get_events(void *tx);

struct AppLayerGetTxIterTuple rs_template_state_get_tx_iterator(uint8_t _ipproto,
                                                                AppProto _alproto,
                                                                void *state,
                                                                uint64_t min_tx_id,
                                                                uint64_t _max_tx_id,
                                                                uint64_t *istate);

/**
 * Get the request buffer for a transaction from C.
 *
 * No required for parsing, but an example function for retrieving a
 * pointer to the request buffer from C for detection.
 */
uint8_t rs_template_get_request_buffer(void *tx,
                                       const uint8_t **buf,
                                       uint32_t *len);

/**
 * Get the response buffer for a transaction from C.
 */
uint8_t rs_template_get_response_buffer(void *tx,
                                        const uint8_t **buf,
                                        uint32_t *len);

void rs_template_register_parser(void);

bool rs_template_logger_log(void *tx, struct JsonBuilder *js);

bool rs_rdp_to_json(struct RdpTransaction *tx, struct JsonBuilder *js);

void *rs_rdp_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_rdp_state_get_tx_count(void *state);

int rs_rdp_tx_get_progress(void *_tx, uint8_t _direction);

void *rs_rdp_state_new(void *_orig_state, AppProto _orig_proto);

void rs_rdp_state_free(void *state);

void rs_rdp_state_tx_free(void *state, uint64_t tx_id);

/**
 * probe for T.123 message, whether to client or to server
 */
AppProto rs_rdp_probe_ts_tc(const Flow *_flow,
                            uint8_t _direction,
                            const uint8_t *input,
                            uint32_t input_len,
                            uint8_t *_rdir);

struct AppLayerResult rs_rdp_parse_ts(const Flow *_flow,
                                      void *state,
                                      void *_pstate,
                                      const uint8_t *input,
                                      uint32_t input_len,
                                      const void *_data,
                                      uint8_t _flags);

struct AppLayerResult rs_rdp_parse_tc(const Flow *_flow,
                                      void *state,
                                      void *_pstate,
                                      const uint8_t *input,
                                      uint32_t input_len,
                                      const void *_data,
                                      uint8_t _flags);

void rs_rdp_register_parser(void);

/**
 * Attempt to parse a X.509 from input, and return a pointer to the parsed object if successful.
 *
 * # Safety
 *
 * input must be a valid buffer of at least input_len bytes
 */
struct X509 *rs_x509_decode(const uint8_t *input,
                            uint32_t input_len,
                            uint32_t *err_code);

char *rs_x509_get_subject(const struct X509 *ptr);

char *rs_x509_get_issuer(const struct X509 *ptr);

char *rs_x509_get_serial(const struct X509 *ptr);

/**
 * Extract validity from input X.509 object
 *
 * # Safety
 *
 * ptr must be a valid object obtained using `rs_x509_decode`
 */
int32_t rs_x509_get_validity(const struct X509 *ptr,
                             int64_t *not_before,
                             int64_t *not_after);

/**
 * Free a X.509 object allocated by Rust
 *
 * # Safety
 *
 * ptr must be a valid object obtained using `rs_x509_decode`
 */
void rs_x509_free(struct X509 *ptr);

/**
 * Attempt to parse a Asn1 object from input, and return a pointer
 * to the parsed object if successful, null on failure
 *
 * # Safety
 *
 * input must be a valid buffer of at least input_len bytes
 * pointer must be freed using `rs_asn1_free`
 */
struct Asn1 *rs_asn1_decode(const uint8_t *input,
                            uint16_t input_len,
                            uint32_t buffer_offset,
                            const struct DetectAsn1Data *ad_ptr);

/**
 * Free a Asn1 object allocated by Rust
 *
 * # Safety
 *
 * ptr must be a valid object obtained using `rs_asn1_decode`
 */
void rs_asn1_free(struct Asn1 *ptr);

/**
 * This function implements the detection of the following options:
 *   - oversize_length
 *   - bitstring_overflow
 *   - double_overflow
 *
 * # Safety
 *
 * ptr must be a valid object obtained using `rs_asn1_decode`
 * ad_ptr must be a valid object obtained using `rs_detect_asn1_parse`
 *
 * Returns 1 if any of the options match, 0 if not
 */
uint8_t rs_asn1_checks(const struct Asn1 *ptr,
                       const struct DetectAsn1Data *ad_ptr);

/**
 * Parse the asn1 keyword and return a pointer to a `DetectAsn1Data`
 * containing the parsed options, returns null on failure
 *
 * # Safety
 *
 * pointer must be free'd using `rs_detect_asn1_free`
 */
struct DetectAsn1Data *rs_detect_asn1_parse(const char *input);

/**
 * Free a `DetectAsn1Data` object allocated by Rust
 *
 * # Safety
 *
 * ptr must be a valid object obtained using `rs_detect_asn1_parse`
 */
void rs_detect_asn1_free(struct DetectAsn1Data *ptr);

uint8_t rs_ssh_tx_get_protocol(void *tx,
                               const uint8_t **buffer,
                               uint32_t *buffer_len,
                               uint8_t direction);

uint8_t rs_ssh_tx_get_software(void *tx,
                               const uint8_t **buffer,
                               uint32_t *buffer_len,
                               uint8_t direction);

uint8_t rs_ssh_tx_get_hassh(void *tx,
                            const uint8_t **buffer,
                            uint32_t *buffer_len,
                            uint8_t direction);

uint8_t rs_ssh_tx_get_hassh_string(void *tx,
                                   const uint8_t **buffer,
                                   uint32_t *buffer_len,
                                   uint8_t direction);

bool rs_ssh_log_json(void *tx, struct JsonBuilder *js);

AppLayerDecoderEvents *rs_ssh_state_get_events(void *tx);

void *rs_ssh_state_new(void *_orig_state, AppProto _orig_proto);

void rs_ssh_state_free(void *state);

void rs_ssh_state_tx_free(void *_state, uint64_t _tx_id);

struct AppLayerResult rs_ssh_parse_request(const Flow *_flow,
                                           void *state,
                                           void *pstate,
                                           const uint8_t *input,
                                           uint32_t input_len,
                                           const void *_data,
                                           uint8_t _flags);

struct AppLayerResult rs_ssh_parse_response(const Flow *_flow,
                                            void *state,
                                            void *pstate,
                                            const uint8_t *input,
                                            uint32_t input_len,
                                            const void *_data,
                                            uint8_t _flags);

void *rs_ssh_state_get_tx(void *state, uint64_t _tx_id);

uint64_t rs_ssh_state_get_tx_count(void *_state);

SSHConnectionState rs_ssh_tx_get_flags(void *tx, uint8_t direction);

int rs_ssh_tx_get_alstate_progress(void *tx, uint8_t direction);

void rs_ssh_register_parser(void);

void rs_ssh_enable_hassh(void);

bool rs_ssh_hassh_is_enabled(void);

bool rs_ssh_tx_get_log_condition(void *tx);

int rs_http2_tx_has_frametype(void *tx, uint8_t direction, uint8_t value);

int rs_http2_parse_frametype(const char *str);

int rs_http2_tx_has_errorcode(void *tx, uint8_t direction, uint32_t code);

int rs_http2_parse_errorcode(const char *str);

int rs_http2_tx_get_next_priority(void *tx, uint8_t direction, uint32_t nb);

int rs_http2_tx_get_next_window(void *tx, uint8_t direction, uint32_t nb);

void *rs_http2_detect_settingsctx_parse(const char *str);

void rs_http2_detect_settingsctx_free(void *ctx);

int rs_http2_detect_settingsctx_match(const void *ctx,
                                      void *tx,
                                      uint8_t direction);

void *rs_detect_u64_parse(const char *str);

void rs_detect_u64_free(void *ctx);

int rs_http2_detect_sizeupdatectx_match(const void *ctx,
                                        void *tx,
                                        uint8_t direction);

uint8_t rs_http2_tx_get_header_name(struct HTTP2Transaction *tx,
                                    uint8_t direction,
                                    uint32_t nb,
                                    const uint8_t **buffer,
                                    uint32_t *buffer_len);

uint8_t rs_http2_tx_get_uri(struct HTTP2Transaction *tx,
                            const uint8_t **buffer,
                            uint32_t *buffer_len);

uint8_t rs_http2_tx_get_method(struct HTTP2Transaction *tx,
                               const uint8_t **buffer,
                               uint32_t *buffer_len);

uint8_t rs_http2_tx_get_host(struct HTTP2Transaction *tx,
                             const uint8_t **buffer,
                             uint32_t *buffer_len);

uint8_t rs_http2_tx_get_host_norm(struct HTTP2Transaction *tx,
                                  const uint8_t **buffer,
                                  uint32_t *buffer_len);

uint8_t rs_http2_tx_get_useragent(struct HTTP2Transaction *tx,
                                  const uint8_t **buffer,
                                  uint32_t *buffer_len);

uint8_t rs_http2_tx_get_status(struct HTTP2Transaction *tx,
                               const uint8_t **buffer,
                               uint32_t *buffer_len);

uint8_t rs_http2_tx_get_cookie(struct HTTP2Transaction *tx,
                               uint8_t direction,
                               const uint8_t **buffer,
                               uint32_t *buffer_len);

uint8_t rs_http2_tx_get_header_value(struct HTTP2Transaction *tx,
                                     uint8_t direction,
                                     const char *strname,
                                     const uint8_t **buffer,
                                     uint32_t *buffer_len);

uint8_t rs_http2_tx_get_header_names(struct HTTP2Transaction *tx,
                                     uint8_t direction,
                                     const uint8_t **buffer,
                                     uint32_t *buffer_len);

uint8_t rs_http2_tx_get_headers(struct HTTP2Transaction *tx,
                                uint8_t direction,
                                const uint8_t **buffer,
                                uint32_t *buffer_len);

uint8_t rs_http2_tx_get_headers_raw(struct HTTP2Transaction *tx,
                                    uint8_t direction,
                                    const uint8_t **buffer,
                                    uint32_t *buffer_len);

uint8_t rs_http2_tx_get_header(struct HTTP2Transaction *tx,
                               uint8_t direction,
                               uint32_t nb,
                               const uint8_t **buffer,
                               uint32_t *buffer_len);

void rs_http2_tx_set_method(struct HTTP2State *state,
                            const uint8_t *buffer,
                            uint32_t buffer_len);

void rs_http2_tx_set_uri(struct HTTP2State *state,
                         const uint8_t *buffer,
                         uint32_t buffer_len);

void rs_http2_tx_add_header(struct HTTP2State *state,
                            const uint8_t *name,
                            uint32_t name_len,
                            const uint8_t *value,
                            uint32_t value_len);

void rs_http2_init(SuricataFileContext *context);

/**
 * C entry point for a probing parser.
 */
AppProto rs_http2_probing_parser_tc(const Flow *_flow,
                                    uint8_t _direction,
                                    const uint8_t *input,
                                    uint32_t input_len,
                                    uint8_t *_rdir);

extern void HTTP2MimicHttp1Request(void *orig_state, void *new_state);

void *rs_http2_state_new(void *orig_state, AppProto _orig_proto);

void rs_http2_state_free(void *state);

void rs_http2_state_tx_free(void *state, uint64_t tx_id);

struct AppLayerResult rs_http2_parse_ts(const Flow *flow,
                                        void *state,
                                        void *_pstate,
                                        const uint8_t *input,
                                        uint32_t input_len,
                                        const void *_data,
                                        uint8_t _flags);

struct AppLayerResult rs_http2_parse_tc(const Flow *flow,
                                        void *state,
                                        void *_pstate,
                                        const uint8_t *input,
                                        uint32_t input_len,
                                        const void *_data,
                                        uint8_t _flags);

void *rs_http2_state_get_tx(void *state, uint64_t tx_id);

uint64_t rs_http2_state_get_tx_count(void *state);

HTTP2TransactionState rs_http2_tx_get_state(void *tx);

int rs_http2_tx_get_alstate_progress(void *tx, uint8_t _direction);

AppLayerDecoderEvents *rs_http2_state_get_events(void *tx);

struct AppLayerGetTxIterTuple rs_http2_state_get_tx_iterator(uint8_t _ipproto,
                                                             AppProto _alproto,
                                                             void *state,
                                                             uint64_t min_tx_id,
                                                             uint64_t _max_tx_id,
                                                             uint64_t *istate);

FileContainer *rs_http2_getfiles(void *state, uint8_t direction);

void rs_http2_register_parser(void);

bool rs_http2_log_json(void *tx, struct JsonBuilder *js);

bool rs_check_utf8(const char *val);

struct SCSha256 *SCSha256New(void);

void SCSha256Update(struct SCSha256 *hasher,
                    const uint8_t *bytes,
                    uint32_t len);

void SCSha256Finalize(struct SCSha256 *hasher, uint8_t *out, uint32_t len);

/**
 * C function to finalize the Sha256 hasher to a hex string.
 *
 * Notes:
 * - There is probably room for optimization here, by iterating the result and writing
 *   the output directly to the output buffer.
 *
 * But even given the notes, this appears to be faster than the equivalent that we
 * did in C using NSS.
 */
void SCSha256FinalizeToHex(struct SCSha256 *hasher,
                           char *out,
                           uint32_t len);

/**
 * Free an unfinalized Sha256 context.
 */
void SCSha256Free(struct SCSha256 *hasher);

bool SCSha256HashBuffer(const uint8_t *buf,
                        uint32_t buf_len,
                        uint8_t *out,
                        uint32_t len);

struct SCSha1 *SCSha1New(void);

void SCSha1Update(struct SCSha1 *hasher, const uint8_t *bytes, uint32_t len);

void SCSha1Finalize(struct SCSha1 *hasher, uint8_t *out, uint32_t len);

/**
 * Free an unfinalized Sha1 context.
 */
void SCSha1Free(struct SCSha1 *hasher);

bool SCSha1HashBuffer(const uint8_t *buf,
                      uint32_t buf_len,
                      uint8_t *out,
                      uint32_t len);

struct SCMd5 *SCMd5New(void);

void SCMd5Update(struct SCMd5 *hasher, const uint8_t *bytes, uint32_t len);

/**
 * Finalize the MD5 hash placing the digest in the provided out buffer.
 *
 * This function consumes the SCMd5 hash context.
 */
void SCMd5Finalize(struct SCMd5 *hasher, uint8_t *out, uint32_t len);

/**
 * Finalize MD5 context to a hex string.
 *
 * Consumes the hash context and cannot be re-used.
 */
void SCMd5FinalizeToHex(struct SCMd5 *hasher, char *out, uint32_t len);

/**
 * Free an unfinalized Sha1 context.
 */
void SCMd5Free(struct SCMd5 *hasher);

void SCMd5HashBuffer(const uint8_t *buf,
                     uint32_t buf_len,
                     uint8_t *out,
                     uint32_t len);

/**
 * C binding for a function to MD5 hash a single buffer to a hex string.
 */
void SCMd5HashBufferToHex(const uint8_t *buf,
                          uint32_t buf_len,
                          char *out,
                          uint32_t len);

#endif /* __RUST_BINDINGS_GEN_H_ */
