ix!();

use crate::{
    AdsrEnvelope,
    AdsrParam,
    AdsrState,
};

impl AdsrEnvelope {

    pub fn process_block_digital_release(&mut self) {

        self.phase -= self.tables.envelope_rate_linear(
            pvalf![self.params[AdsrParam::Release]]
        ) * tsyncratio![self,Release];

        self.output = self.phase;

        for _i in 0..pvali![self.params[AdsrParam::ReleaseShape]] {
            self.output *= self.phase;
        }

        if self.phase < 0.0
        {
            self.envstate = AdsrState::Idle;
            self.output = 0.0;
        }

        self.output *= self.scalestage;
    }
}
