# Variant structs

The most basic items generated by SuperStruct are the variant structs. For each
variant listed in the top-level `superstruct(variants(..)` list, a struct with
the name `{BaseName}{VariantName}` will be created. For example:

```rust,no_run,no_playground
#[superstruct(variants(Foo, Bar))]
struct MyStruct {
    name: String,
    #[superstruct(only(Foo))]
    location: u16,
}
```

Here the `BaseName` is `MyStruct` and there are two variants called `Foo` and `Bar`.

The generated variant structs are:

```rust,no_run,no_playground
struct MyStructFoo {
    name: String,
    location: u16,
}

struct MyStructBar {
    name: String,
}
```

Note how the `only` attribute controls the presence of fields in each variant.
For more information see [Struct attributes](../config/struct.md).

The variant structs are unified as part of the [top-level enum](./enum.md).
