# sun

A rust port of the JS library [suncalc](https://github.com/mourner/suncalc/), forked from the [sun](https://github.com/flosse/rust-sun) crate.

Features
  - [x] Get sun position at a given time and position
  - [x] Get sun phase times for a given location
  - [ ] Moon calculations

## Install

Add the following to your `Cargo.toml`

    [dependencies]
    suncalc = "0.3"

## Usage

```rust
pub fn main() {
  let unixtime = suncalc::Timestamp(1362441600000);
  let lat = 48.0;
  let lon = 9.0;
  let pos = suncalc::get_position(unixtime,lat,lon);
  let az  = pos.azimuth.to_degrees();
  let alt = pos.altitude.to_degrees();
  println!("The position of the sun is {}/{}", az, alt);
}
```
