# sunbeam [![Actions Status](https://github.com/afiasell/sunbeam/workflows/ci/badge.svg)](https://github.com/afiasell/sunbeam/actions) [![docs](https://docs.rs/sunbeam/badge.svg)](https://docs.rs/sunbeam)

> Sunbeam is a typo-safe CSS class library

Sunbeam is a typo-safe CSS class library.

With sunbeam you write your CSS using the `css!` macro.

Later, at build time, you run `sunbeam-build` to parse these `css!` calls and then generate a CSS file that contains only
the CSS that your application is using.

## Basic Usage

```sh
cargo new sunbeam-example
cd sunbeam-example
```

```rust
// src/main.rs

#[macro_use]
extern crate sunbeam;

fn main () {
  let classes = css!(mr10 px5 py10 min640:bg-col-red min980:bg-col-custom);
  assert_eq!(classes, "mr10 px5 py10 min640:bg-col-red min980:bg-col-custom");
}
```

```rust
// build.rs

use sunbeam_build;

fn main() {
    // In a real application you might programatically build your file list
    // using something like:
    // `swift_bridge_build::files_in_dir_ending_with("src", "-view.rs")`
    let files_with_css = vec!["src/main.rs"];

	for path in &files_with_css {
		println!("cargo:rerun-if-changed={}", path);
	}

    sunbeam_build::parse_css(files)
        .write_class_declarations("./app.css")
}
```

```sh
cargo check
cat app.css
```

## Custom CSS

Sunbeam's default styles should cover most use cases, but some applications might need to introduce
new classes for their own needs.

For certain kinds of CSS, sunbeam allows you to define additional classes that will also be type
checked at compile time.

```
# Sunbeam.toml

custom-spacing = [
  mb36,
  ml98,
  p85,
]

custom-breakpoint = [ min308, min999, ]

[custom-color]
brand-red = #ff0001
```

```
let classes = css!("mb36 ml98 p85 bg-col-brand-red mt5 mr10");
assert_eq!(classes, "mb36 ml98 p85 bg-col-brand-red mt5 mr10");
```

## Invalid CSS

If you try to use a class or selector that is not defined by sunbeam
or in your Sunbeam.toml, you will get a compile time error.

```
let _classes = css!(d-flex not-a-real-class);
```

```
# SHOW THE COMPILE TIME ERROR HERE
```

## To Test

To run the test suite.

```sh
# Clone the repository
git clone git@github.com:chinedufn/sunbeam.git
cd sunbeam

# Run tests
cargo test --all
```

## License

sunbeam is licensed under either of

- Apache License, Version 2.0 ([LICENSE-APACHE][apache] or http://apache.org/licenses/LICENSE-2.0)
- MIT license ([LICENSE-MIT][mit] or http://opensource.org/licenses/MIT)

[apache]: ./LICENSE-APACHE
[mit]: ./LICENSE-MIT
