//! Sunbeam's css! macro.

#![deny(missing_docs)]

use sunbeam_ir::Classes;
use syn::parse_macro_input;

/// Create a CSS class string
///
/// ```
/// # use sunbeam_macro::css;
/// let classes = css!("mt1 mb5 p10");
/// assert_eq!(classes, "mt1 mb5 p10")
/// ```
#[proc_macro]
pub fn css(input: proc_macro::TokenStream) -> proc_macro::TokenStream {
    let input_fork = input.clone();

    // Ensures that all of the classes are valid.
    let _classes = parse_macro_input!(input_fork as Classes);

    input
}

#[cfg(test)]
mod ui_tests {
    #[test]
    fn ui() {
        let t = trybuild::TestCases::new();
        t.compile_fail("tests/ui/*.rs");
    }
}
