use crate::color::{ColorName, CssColor};
use std::collections::{HashMap, HashSet};

/// Configuration for Sunbeam.
#[derive(serde::Serialize, serde::Deserialize)]
pub struct SunbeamConfig {
    /// Colors that can be used for text and backgrounds.
    pub colors: HashMap<ColorName, CssColor>,
    /// Pre-defined screen widths that can be used for media queries
    pub screen_widths: HashSet<u32>,
}

impl Default for SunbeamConfig {
    fn default() -> Self {
        SunbeamConfig {
            colors: HashMap::new(),
            screen_widths: HashSet::default(),
        }
    }
}

pub(crate) trait ConfigLookup {
    fn get_color(&self, color_name: &ColorName) -> Option<&CssColor>;
}

impl ConfigLookup for SunbeamConfig {
    fn get_color(&self, color_name: &ColorName) -> Option<&CssColor> {
        self.colors.get(color_name)
    }
}
