use super::*;

#[test]
fn padding() {
    ClassTest {
        tokens: quote!("p5"),
        config: SunbeamConfig::default(),
        expected_css_class_definition: r#"
.p5 {
    padding: 5px;
}"#,
    }
    .test();
}

#[test]
fn padding_top() {
    ClassTest {
        tokens: quote!("pt5"),
        config: SunbeamConfig::default(),
        expected_css_class_definition: r#"
.pt5 {
    padding-top: 5px;
}"#,
    }
    .test();
}

#[test]
fn padding_left() {
    ClassTest {
        tokens: quote!("pl5"),
        config: SunbeamConfig::default(),
        expected_css_class_definition: r#"
.pl5 {
    padding-left: 5px;
}"#,
    }
    .test();
}

#[test]
fn padding_right() {
    ClassTest {
        tokens: quote!("pr5"),
        config: SunbeamConfig::default(),
        expected_css_class_definition: r#"
.pr5 {
    padding-right: 5px;
}"#,
    }
    .test();
}

#[test]
fn padding_bottom() {
    ClassTest {
        tokens: quote!("pb5"),
        config: SunbeamConfig::default(),
        expected_css_class_definition: r#"
.pb5 {
    padding-bottom: 5px;
}"#,
    }
    .test();
}
