use super::*;

#[test]
fn gteq_screen_width() {
    let mut config = SunbeamConfig::default();
    config.screen_widths.insert(640);

    let mut expected_modifiers = Modifiers::default();
    expected_modifiers.set_min_width_gteq(640).unwrap();

    ClassTest {
        tokens: quote!("gteq640:max-w-10"),
        config,
        expected_css_class_definition: r#"
@media (min-width: 640px) {
    .gteq640\:max-w-10 {
        max-width: 10px;
    }
}
"#,
    }
    .test();
}
