use super::*;

#[test]
fn border_width() {
    ClassTest {
        tokens: quote!("border-width-5"),
        config: SunbeamConfig::default(),
        expected_css_class_definition: r#"
.border-width-5 {
    border-width: 5px;
}"#,
    }
    .test();
}

#[test]
fn border_top() {
    ClassTest {
        tokens: quote!("border-top-width-5"),
        config: SunbeamConfig::default(),
        expected_css_class_definition: r#"
.border-top-width-5 {
    border-top-width: 5px;
}"#,
    }
    .test();
}

#[test]
fn border_left() {
    ClassTest {
        tokens: quote!("border-left-width-5"),
        config: SunbeamConfig::default(),
        expected_css_class_definition: r#"
.border-left-width-5 {
    border-left-width: 5px;
}"#,
    }
    .test();
}

#[test]
fn border_bottom() {
    ClassTest {
        tokens: quote!("border-bottom-width-5"),
        config: SunbeamConfig::default(),
        expected_css_class_definition: r#"
.border-bottom-width-5 {
    border-bottom-width: 5px;
}"#,
    }
    .test();
}

#[test]
fn border_right() {
    ClassTest {
        tokens: quote!("border-right-width-5"),
        config: SunbeamConfig::default(),
        expected_css_class_definition: r#"
.border-right-width-5 {
    border-right-width: 5px;
}"#,
    }
    .test();
}
