use super::*;
use crate::color::{ColorName, CssColor};

#[test]
fn border_color() {
    let mut config = SunbeamConfig::default();
    config.colors.insert(
        ColorName::new("red-10".to_string()).unwrap(),
        CssColor::new("#ff1122".to_string()).unwrap(),
    );

    ClassTest {
        tokens: quote!("border-color-red-10"),
        config,
        expected_css_class_definition: r#"
.border-color-red-10 {
    border-color: #ff1122;
}"#,
    }
    .test();
}
