use super::*;
use crate::color::{ColorName, CssColor};

#[test]
fn background_color() {
    let mut config = SunbeamConfig::default();
    config.colors.insert(
        ColorName::new("red-10".to_string()).unwrap(),
        CssColor::new("#ff1122".to_string()).unwrap(),
    );

    ClassTest {
        tokens: quote!("bg-color-red-10"),
        config,
        expected_css_class_definition: r#"
.bg-color-red-10 {
    background-color: #ff1122;
}"#,
    }
    .test();
}
