//! Tests where we confirm that we properly parse css!(...) macro tokens and that we
//! generate the appropriate CSS string.

use crate::class_dictionary::ClassDictionary;
use crate::{Modifiers, SunbeamConfig};
use proc_macro2::TokenStream;
use quote::quote;
use syn::LitStr;

mod align_items_tests;
mod background_color_tests;
mod border_color;
mod border_style;
mod border_width;
mod box_sizing_tests;
mod cursor_tests;
mod display_tests;
mod flex_direction_tests;
mod flex_tests;
mod gteq_screen_width_tests;
mod height_tests;
mod hover_tests;
mod margin_tests;
mod max_width_tests;
mod overflow_tests;
mod padding_tests;
mod text_color_tests;
mod text_decoration_tests;
mod visited_tests;
mod width_tests;

struct ClassTest {
    tokens: TokenStream,
    config: SunbeamConfig,
    expected_css_class_definition: &'static str,
}

impl ClassTest {
    fn test(self) {
        let dictionary = ClassDictionary::new();

        let classes: LitStr = syn::parse2(self.tokens).unwrap();

        let classes = classes.value();
        assert!(!classes.contains(" "));
        let class = classes;

        let class_definition = dictionary
            .get_class_definition(&class, &self.config)
            .unwrap();

        assert_eq!(
            class_definition.css_class_definition,
            self.expected_css_class_definition.trim()
        );
    }
}
