//! An intermediate representation of a css!(...) invocation.
//!
//! `css!(...)` macro calls get parsed into this IR.
//!
//! This IR is then used when validating and generating CSS files.

#![deny(missing_docs)]

pub use self::{class::*, sunbeam_config::*};
use std::ops::Deref;

mod parse;
#[cfg(test)]
mod parser_and_generator_tests;

mod class;
mod class_dictionary;
mod color;
mod generate_css_file;
mod sunbeam_config;

/// The data structure that a `css!(...)` invocation gets parsed into.
#[derive(Debug)]
pub struct Classes {
    classes: Vec<RetrievedClassDefinition>,
}

impl Classes {
    /// Create a new Classes
    pub fn new() -> Self {
        Self {
            classes: Vec::new(),
        }
    }

    /// Add more parsed classes to this set of classes.
    pub fn extend(&mut self, other: Classes) {
        self.classes.extend(other.classes.into_iter())
    }
}

impl Deref for Classes {
    type Target = Vec<RetrievedClassDefinition>;

    fn deref(&self) -> &Self::Target {
        &self.classes
    }
}

#[cfg(test)]
mod intentionally_here {
    //! Keeping this here makes it easy to run all of the crate's tests from within the IDE.
    //! You can call run tests in your IDE from the lib.rs file
    //! (as long as your cursor is outside of this test module), which will then run all
    //! of the tests in the crate (since every module is a descendent of lib.rs.)

    #[test]
    fn intentionally_here() {}
}
