/// A CSS color, such as RGB, RGBA or HEX.
///
/// rgb(1, 2, 3);
/// rgba(1, 2, 3, 4);
/// #aabbcc;
#[derive(Debug, Clone, serde::Serialize, serde::Deserialize)]
pub struct CssColor(String);

/// An error with a CSS color.
#[derive(Debug, thiserror::Error)]
pub enum CssColorError {
    //
}

impl CssColor {
    /// Create a new CssColor.
    pub fn new(color: String) -> Result<CssColor, CssColorError> {
        Self::validate_color(&color)?;
        let color = CssColor(color);
        Ok(color)
    }

    /// Get the color.
    // TODO: We can remove the Result when we implement a custom deserialize for CsssColor.
    pub fn get(&self) -> Result<&str, CssColorError> {
        CssColor::validate_color(&self.0)?;

        Ok(&self.0)
    }

    fn validate_color(_color: &str) -> Result<(), CssColorError> {
        // TODO: Validation
        Ok(())
    }
}
