pub use self::modifiers::*;

mod modifiers;

/// A CSS class and modifiers.
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
pub struct RetrievedClassDefinition {
    /// bg-color-{color}
    pub class_name_template: String,
    /// .some-class { ... }
    pub css_class_definition: String,
    /// See [`Modifiers`]
    pub modifiers: Modifiers,
}

impl RetrievedClassDefinition {
    /// Create a new Modifiers
    pub fn new(
        class_name_template: String,
        css_class_definition: String,
        modifiers: Modifiers,
    ) -> Self {
        RetrievedClassDefinition {
            class_name_template,
            css_class_definition,
            modifiers,
        }
    }
}

/// Pixels, percentages, etc
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Copy, Clone)]
pub enum PixelsOrPercent {
    /// 123px
    Pixels(u32),
    /// 56%
    Percentage(Percent),
}

/// Percentage, etc
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Copy, Clone)]
pub struct Percent(u8);

impl Percent {
    pub(crate) fn new(percentage: u32) -> Option<Percent> {
        if percentage <= 100 {
            Some(Percent(percentage as u8))
        } else {
            None
        }
    }

    pub(crate) fn get(&self) -> u8 {
        self.0
    }
}
