Object.assign(window.search, {"doc_urls":["sudograph.html#sudograph","vision-and-motivation.html#vision-and-motivation","vision-and-motivation.html#vision","vision-and-motivation.html#motivation","examples.html#examples","quickest-of-quick-starts.html#quickest-of-quick-starts-new-project","quick-start.html#quick-start-new-project","quick-start.html#prerequisites","quick-start.html#sudograph-generate","quick-start.html#deployment","existing-project.html#existing-project","existing-project.html#edit-dfxjson-in-root-directory","existing-project.html#add-cargotoml-to-root-directory","existing-project.html#create-graphql-canister-crate","existing-project.html#create-graphql-schema","existing-project.html#import-and-call-the-graphql_database-procedural-macro","existing-project.html#create-candid-file","existing-project.html#deploy","local-deployment.html#local-deployment","local-deployment.html#playground-canister","local-deployment.html#frontend-canister","local-deployment.html#command-line","local-deployment.html#sudograph-client","local-deployment.html#rust-canister","local-deployment.html#motoko-canister","local-deployment.html#wasm-binary-optimization","ic-deployment.html#ic-deployment","ic-deployment.html#wasm-binary-optimization","wasm-binary-optimization.html#wasm-binary-optimization","wasm-binary-optimization.html#manual-optimization","wasm-binary-optimization.html#automatic-optimization","sudograph-client.html#sudograph-client","sudograph-client.html#installation","sudograph-client.html#use","sudograph-client.html#query","sudograph-client.html#mutation","sudograph-client.html#changing-query-and-mutation-canister-function-names","sudograph-client.html#authentication","agent-js.html#agent-js","agent-js.html#installation","agent-js.html#use","agent-js.html#query","agent-js.html#mutation","agent-js.html#authentication","schema.html#schema","schema-scalars.html#scalars","schema-scalars.html#blob","schema-scalars.html#boolean","schema-scalars.html#date","schema-scalars.html#float","schema-scalars.html#id","schema-scalars.html#int","schema-scalars.html#json","schema-scalars.html#string","schema-enums.html#enums","schema-objects.html#objects","schema-relations.html#relations","schema-relations.html#one-to-one-relations","schema-relations.html#one-sided","schema-relations.html#two-sided","schema-relations.html#one-to-many-relations","schema-relations.html#one-sided","schema-relations.html#two-sided","schema-relations.html#many-to-many-relations","schema-custom-scalars.html#custom-scalars","schema-custom-resolvers.html#custom-resolvers","schema-custom-resolvers.html#resolvers-within-the-graphql-canister","schema-custom-resolvers.html#resolvers-within-a-different-canister","schema-custom-resolvers.html#rust","schema-custom-resolvers.html#motoko","schema-custom-resolvers.html#other-languages","schema-custom-resolvers.html#type-conversions","schema-custom-resolvers.html#graphql---rust","schema-custom-resolvers.html#graphql---motoko","schema-custom-directives.html#custom-directives","schema-sudograph-directives.html#sudograph-directives","schema-sudograph-directives.html#relation","schema-sudograph-directives.html#canister","schema-sudograph-directives.html#possible-future-relations","schema-sudograph-settings.html#sudograph-settings","schema-sudograph-settings.html#exportgeneratedqueryfunction","schema-sudograph-settings.html#exportgeneratedmutationfunction","schema-sudograph-settings.html#exportgeneratedinitfunction","schema-sudograph-settings.html#exportgeneratedpostupgradefunction","generated-schema.html#generated-schema","generated-schema-query.html#query","generated-schema-query-read.html#read","generated-schema-mutation.html#mutation","generated-schema-mutation-create.html#create","generated-schema-mutation-update.html#update","generated-schema-mutation-delete.html#delete","generated-schema-mutation-init.html#init","generated-schema-subscription.html#subscription","generated-schema-search.html#search","generated-schema-search.html#scalar-search","generated-schema-search.html#blob","generated-schema-search.html#boolean","generated-schema-search.html#date","generated-schema-search.html#float","generated-schema-search.html#id","generated-schema-search.html#int","generated-schema-search.html#json","generated-schema-search.html#string","generated-schema-search.html#and","generated-schema-search.html#or","generated-schema-search.html#relation-search","generated-schema-limit.html#limit","generated-schema-offset.html#offset","generated-schema-order.html#order","authorization.html#authorization","authorization.html#canister-authorization","authorization.html#rust-authorization","authorization.html#motoko-authorization","migrations.html#migrations","migrations.html#simple-migrations","migrations.html#automatic-migrations","migrations.html#manual-migrations","transactions.html#transactions","transactions.html#single-canister-mutations","transactions.html#multi-canister-mutations","multi-canister-scaling.html#multi-canister-scaling","custom-database-operations.html#custom-database-operations","custom-database-operations.html#sudodb","custom-database-operations.html#objecttypestore","custom-async-graphql-integration.html#custom-async_graphql-integration","limitations.html#limitations"],"index":{"documentStore":{"docInfo":{"0":{"body":54,"breadcrumbs":2,"title":1},"1":{"body":0,"breadcrumbs":4,"title":2},"10":{"body":106,"breadcrumbs":4,"title":2},"100":{"body":45,"breadcrumbs":4,"title":1},"101":{"body":58,"breadcrumbs":4,"title":1},"102":{"body":53,"breadcrumbs":4,"title":1},"103":{"body":39,"breadcrumbs":3,"title":0},"104":{"body":27,"breadcrumbs":3,"title":0},"105":{"body":75,"breadcrumbs":5,"title":2},"106":{"body":152,"breadcrumbs":4,"title":1},"107":{"body":180,"breadcrumbs":4,"title":1},"108":{"body":93,"breadcrumbs":4,"title":1},"109":{"body":219,"breadcrumbs":2,"title":1},"11":{"body":64,"breadcrumbs":6,"title":4},"110":{"body":50,"breadcrumbs":3,"title":2},"111":{"body":31,"breadcrumbs":3,"title":2},"112":{"body":111,"breadcrumbs":3,"title":2},"113":{"body":24,"breadcrumbs":2,"title":1},"114":{"body":67,"breadcrumbs":3,"title":2},"115":{"body":58,"breadcrumbs":3,"title":2},"116":{"body":127,"breadcrumbs":3,"title":2},"117":{"body":9,"breadcrumbs":2,"title":1},"118":{"body":97,"breadcrumbs":4,"title":3},"119":{"body":44,"breadcrumbs":4,"title":3},"12":{"body":34,"breadcrumbs":6,"title":4},"120":{"body":143,"breadcrumbs":6,"title":3},"121":{"body":16,"breadcrumbs":6,"title":3},"122":{"body":96,"breadcrumbs":4,"title":1},"123":{"body":106,"breadcrumbs":4,"title":1},"124":{"body":110,"breadcrumbs":6,"title":3},"125":{"body":54,"breadcrumbs":2,"title":1},"13":{"body":55,"breadcrumbs":6,"title":4},"14":{"body":30,"breadcrumbs":5,"title":3},"15":{"body":28,"breadcrumbs":7,"title":5},"16":{"body":97,"breadcrumbs":5,"title":3},"17":{"body":9,"breadcrumbs":3,"title":1},"18":{"body":81,"breadcrumbs":4,"title":2},"19":{"body":17,"breadcrumbs":4,"title":2},"2":{"body":81,"breadcrumbs":3,"title":1},"20":{"body":17,"breadcrumbs":4,"title":2},"21":{"body":34,"breadcrumbs":4,"title":2},"22":{"body":43,"breadcrumbs":4,"title":2},"23":{"body":95,"breadcrumbs":4,"title":2},"24":{"body":42,"breadcrumbs":4,"title":2},"25":{"body":10,"breadcrumbs":5,"title":3},"26":{"body":38,"breadcrumbs":4,"title":2},"27":{"body":10,"breadcrumbs":5,"title":3},"28":{"body":47,"breadcrumbs":6,"title":3},"29":{"body":100,"breadcrumbs":5,"title":2},"3":{"body":146,"breadcrumbs":3,"title":1},"30":{"body":134,"breadcrumbs":5,"title":2},"31":{"body":24,"breadcrumbs":4,"title":2},"32":{"body":8,"breadcrumbs":3,"title":1},"33":{"body":91,"breadcrumbs":3,"title":1},"34":{"body":42,"breadcrumbs":3,"title":1},"35":{"body":30,"breadcrumbs":3,"title":1},"36":{"body":35,"breadcrumbs":8,"title":6},"37":{"body":45,"breadcrumbs":3,"title":1},"38":{"body":11,"breadcrumbs":4,"title":2},"39":{"body":8,"breadcrumbs":3,"title":1},"4":{"body":35,"breadcrumbs":2,"title":1},"40":{"body":88,"breadcrumbs":3,"title":1},"41":{"body":30,"breadcrumbs":3,"title":1},"42":{"body":34,"breadcrumbs":3,"title":1},"43":{"body":36,"breadcrumbs":3,"title":1},"44":{"body":107,"breadcrumbs":2,"title":1},"45":{"body":18,"breadcrumbs":3,"title":1},"46":{"body":170,"breadcrumbs":3,"title":1},"47":{"body":11,"breadcrumbs":3,"title":1},"48":{"body":64,"breadcrumbs":3,"title":1},"49":{"body":11,"breadcrumbs":3,"title":1},"5":{"body":87,"breadcrumbs":8,"title":5},"50":{"body":17,"breadcrumbs":3,"title":1},"51":{"body":11,"breadcrumbs":3,"title":1},"52":{"body":27,"breadcrumbs":3,"title":1},"53":{"body":11,"breadcrumbs":3,"title":1},"54":{"body":38,"breadcrumbs":3,"title":1},"55":{"body":139,"breadcrumbs":3,"title":1},"56":{"body":36,"breadcrumbs":3,"title":1},"57":{"body":9,"breadcrumbs":5,"title":3},"58":{"body":45,"breadcrumbs":4,"title":2},"59":{"body":35,"breadcrumbs":4,"title":2},"6":{"body":22,"breadcrumbs":6,"title":4},"60":{"body":9,"breadcrumbs":5,"title":3},"61":{"body":54,"breadcrumbs":4,"title":2},"62":{"body":41,"breadcrumbs":4,"title":2},"63":{"body":41,"breadcrumbs":5,"title":3},"64":{"body":17,"breadcrumbs":5,"title":2},"65":{"body":53,"breadcrumbs":5,"title":2},"66":{"body":164,"breadcrumbs":7,"title":4},"67":{"body":36,"breadcrumbs":7,"title":4},"68":{"body":215,"breadcrumbs":4,"title":1},"69":{"body":166,"breadcrumbs":4,"title":1},"7":{"body":86,"breadcrumbs":3,"title":1},"70":{"body":37,"breadcrumbs":4,"title":1},"71":{"body":0,"breadcrumbs":5,"title":2},"72":{"body":70,"breadcrumbs":5,"title":2},"73":{"body":24,"breadcrumbs":5,"title":2},"74":{"body":9,"breadcrumbs":5,"title":2},"75":{"body":18,"breadcrumbs":5,"title":2},"76":{"body":46,"breadcrumbs":4,"title":1},"77":{"body":51,"breadcrumbs":4,"title":1},"78":{"body":7,"breadcrumbs":6,"title":3},"79":{"body":28,"breadcrumbs":5,"title":2},"8":{"body":18,"breadcrumbs":4,"title":2},"80":{"body":90,"breadcrumbs":4,"title":1},"81":{"body":90,"breadcrumbs":4,"title":1},"82":{"body":64,"breadcrumbs":4,"title":1},"83":{"body":75,"breadcrumbs":4,"title":1},"84":{"body":193,"breadcrumbs":4,"title":2},"85":{"body":28,"breadcrumbs":4,"title":1},"86":{"body":133,"breadcrumbs":5,"title":1},"87":{"body":31,"breadcrumbs":4,"title":1},"88":{"body":110,"breadcrumbs":5,"title":1},"89":{"body":121,"breadcrumbs":5,"title":1},"9":{"body":9,"breadcrumbs":3,"title":1},"90":{"body":112,"breadcrumbs":5,"title":1},"91":{"body":72,"breadcrumbs":5,"title":1},"92":{"body":26,"breadcrumbs":4,"title":1},"93":{"body":18,"breadcrumbs":4,"title":1},"94":{"body":9,"breadcrumbs":5,"title":2},"95":{"body":44,"breadcrumbs":4,"title":1},"96":{"body":14,"breadcrumbs":4,"title":1},"97":{"body":60,"breadcrumbs":4,"title":1},"98":{"body":45,"breadcrumbs":4,"title":1},"99":{"body":61,"breadcrumbs":4,"title":1}},"docs":{"0":{"body":"Sudograph is a GraphQL database for the Internet Computer (IC). Its goal is to become the simplest way to develop applications for the IC. Developers start by defining a GraphQL schema using the GraphQL SDL . Once the schema is defined, it can be included within a canister and deployed to the IC. An entire relational database is generated from the schema, with GraphQL queries and mutations enabling a variety of CRUD operations, including advanced querying over relational data. Sudograph should be considered somewhere between alpha and beta software.","breadcrumbs":"Sudograph » Sudograph","id":"0","title":"Sudograph"},"1":{"body":"","breadcrumbs":"Vision and motivation » Vision and motivation","id":"1","title":"Vision and motivation"},"10":{"body":"The quickest of quick starts and quick start are both designed to get you started with an entire example project from scratch. If instead you wish to integrate Sudograph into an existing project, this section will help you to achieve that. Basically you need to add a new Rust canister to your project and import and call the graphql_database procedural macro. If you're new to developing for the Internet Computer, you might want to check the documentation to get familiar with canister development. The detailed steps are listed out below, but looking at examples might also help a lot. Make sure you at least have Rust, the wasm32-unknown-unknown Rust compilation target, and dfx 0.7.2 installed on your system. If you need help setting all of that up, look at the prerequisites section of the quick start . There are a few basic steps to integrate Sudograph into an existing project: Edit dfx.json in root directory Add Cargo.toml to root directory Create graphql canister crate Create GraphQL schema Import and call the graphql_database procedural macro Create candid file Deploy","breadcrumbs":"Existing project » Existing project","id":"10","title":"Existing project"},"100":{"body":"Generated input: input ReadIntInput { eq: Int gt: Int gte: Int lt: Int lte: Int\n} Examples: query { readUser(search: { age: { eq: 25 } }) { id }\n} query { readUser(search: { age: { gt: 20 } }) { id }\n} query { readUser(search: { age: { gte: 30 } }) { id }\n} query { readUser(search: { age: { lt: 45 } }) { id }\n} query { readUser(search: { age: { lte: 70 } }) { id }\n}","breadcrumbs":"Generated schema » Search » Int","id":"100","title":"Int"},"101":{"body":"Generated input: input ReadJSONInput { eq: String gt: String gte: String lt: String lte: String contains: String\n} Examples: query { readUser(search: { meta: { eq: \"{ \\\"zone\\\": 5 }\" } }) { id }\n} query { readUser(search: { meta: { gt: \"{ \\\"zone\\\": 5 }\" } }) { id }\n} query { readUser(search: { meta: { gte: \"{ \\\"zone\\\": 5 }\" } }) { id }\n} query { readUser(search: { meta: { lt: \"{ \\\"zone\\\": 5 }\" } }) { id }\n} query { readUser(search: { meta: { lte: \"{ \\\"zone\\\": 5 }\" } }) { id }\n} query { readUser(search: { meta: { contains: \"zone\" } }) { id }\n}","breadcrumbs":"Generated schema » Search » JSON","id":"101","title":"JSON"},"102":{"body":"Generated input: input ReadStringInput { eq: String gt: String gte: String lt: String lte: String contains: String\n} Examples: query { readUser(search: { username: { eq: \"lastmjs\" } }) { id }\n} query { readUser(search: { username: { gt: \"lastmjs\" } }) { id }\n} query { readUser(search: { username: { gte: \"lastmjs\" } }) { id }\n} query { readUser(search: { username: { lt: \"lastmjs\" } }) { id }\n} query { readUser(search: { username: { lte: \"lastmjs\" } }) { id }\n} query { readUser(search: { username: { contains: \"mjs\" } }) { id }\n}","breadcrumbs":"Generated schema » Search » String","id":"102","title":"String"},"103":{"body":"The search input for each object type, in addition to all scalar and relation fields, contains an and field. If you want to and together multiple searches of the same field, there are two ways to do so: query { readUser(search: { age: { gte: 5 lte: 10 } }) { id age }\n} This can also be achieved like so: query { readUser(search: { and: [ { age: { gte: 5 } }, { age: { lte: 10 } } ] }) { id age }\n}","breadcrumbs":"Generated schema » Search » and","id":"103","title":"and"},"104":{"body":"The search input for each object type, in addition to all scalar and relation fields, contains an or field. If you want to or together multiple searches of the same field, you can do so: query { readUser(search: { or: [ { age: { eq: 5 } }, { age: { eq: 6 } } ] }) { id age }\n}","breadcrumbs":"Generated schema » Search » or","id":"104","title":"or"},"105":{"body":"You can search by relation fields using the search inputs generated for each object type. Imagine the following schema: type User { id: ID! username: String! blogPosts: [BlogPost!]! @relation(name: \"User:blogPosts::BlogPost:author\")\n} type BlogPost { id: ID! publishedAt: Date title: String! author: User! @relation(name: \"User:blogPosts::BlogPost:author\")\n} The search inputs generated for each object type would be: input ReadUserInput { id: ReadIDInput username: ReadStringInput blogPosts: ReadBlogPostInput and: [ReadUserInput!] or: [ReadUserInput!]\n} input ReadBlogPostInput { id: ReadIDInput publishedAt: ReadDateInput title: ReadStringInput author: ReadUserInput and: [ReadBlogPostInput!] or: [ReadBlogPostInput!]\n} You can search across relations like so: query { readUser(search: { blogPosts: { title: { contains: \"The\" } } }) { id username blogPosts { id title } }\n}","breadcrumbs":"Generated schema » Search » Relation search","id":"105","title":"Relation search"},"106":{"body":"The limit input argument is an Int that allows you to specify how many records to return for a selection. For example, a limit of 0 would always return 0 records, and a limit of 10 would return no more than 10 records. If the limit specified is greater than the number of records available based on the query inputs, then the total number of records available will be returned. Combining limit with offset allows for flexible paging capabilities. A good example of paging can be found in the frontend of the files example . Assuming there are 10 User records in the database: query { readUser(limit: 10) { id }\n} # The readUser property in the selection set would be:\n# [{ id: 0 }, { id: 1 }, { id: 2 }, { id: 3 }, { id: 4 }, { id: 5 }, { id: 6 }, { id: 7 }, { id: 8 }, { id: 9 }] query { readUser(limit: 5) { id }\n} # The readUser property in the selection set would be:\n# [{ id: 0 }, { id: 1 }, { id: 2 }, { id: 3 }, { id: 4 }] query { readUser(limit: 0) { id }\n} # The readUser property in the selection set would be:\n# [] It's important to remember that within any selection sets you have the ability to limit on any many-relation: query { readUser { id blogPosts(limit: 5) { title } }\n} mutation { createUser(input: { username: \"lastmjs\" }) { id blogPosts(limit: 5) { title } }\n} mutation { updateUser(input: { id: \"0\" username: \"lastmjs\" }) { id blogPosts(limit: 5) { title } }\n} mutation { deleteUser(input: { id: \"0\" }) { id blogPosts(limit: 5) { title } }\n}","breadcrumbs":"Generated schema » Limit » Limit","id":"106","title":"Limit"},"107":{"body":"The offset input argument is an Int that allows you to specify the starting index in the selection of records. For example, imagine there are 10 User records in the database. An offset of 0 would return all 10 records starting at index 0 which is the first record (assuming they are ordered already in the database): query { readUser(offset: 0) { id }\n} # The readUser property in the selection set would be:\n# [{ id: 0 }, { id: 1 }, { id: 2 }, { id: 3 }, { id: 4 }, { id: 5 }, { id: 6 }, { id: 7 }, { id: 8 }, { id: 9 }] An offset of 1 would return 9 records starting at index 1 which is the second record: query { readUser(offset: 1) { id }\n} # The readUser property in the selection set would be:\n# [{ id: 1 }, { id: 2 }, { id: 3 }, { id: 4 }, { id: 5 }, { id: 6 }, { id: 7 }, { id: 8 }, { id: 9 }] If the offset specified is greater than or equal to the number of records available based on the query inputs, Sudograph will panic causing the call to trap. Essentially at this point the offset has gone beyond the end of the selection array. If you disagree with this choice let me know @lastmjs or open an issue in the repository . Combining offset with limit allows for flexible paging capabilities. A good example of paging can be found in the frontend of the files example . It's important to remember that within any selection sets you have the ability to offset on any many-relation: query { readUser { id blogPosts(offset: 5) { title } }\n} mutation { createUser(input: { username: \"lastmjs\" }) { id blogPosts(offset: 5) { title } }\n} mutation { updateUser(input: { id: \"0\" username: \"lastmjs\" }) { id blogPosts(offset: 5) { title } }\n} mutation { deleteUser(input: { id: \"0\" }) { id blogPosts(offset: 5) { title } }\n}","breadcrumbs":"Generated schema » Offset » Offset","id":"107","title":"Offset"},"108":{"body":"The order input allows you to order by any one scalar field of an object type. In the future it may be possible to order by multiple fields. There are two possible orderings, DESC and ASC. Here are some examples assuming the following schema: type User { id: ID! age: Int! username: String!\n} query { readUser(order: { id: DESC }) { id }\n} query { readUser(order: { age: ASC }) { id }\n} query { readUser(order: { username: DESC }) { id }\n} It's important to remember that within any selection sets you have the ability to order on any many-relation: query { readUser { id blogPosts(order: { title: DESC }) { title } }\n} mutation { createUser(input: { username: \"lastmjs\" }) { id blogPosts(order: { title: DESC }) { title } }\n} mutation { updateUser(input: { id: \"0\" username: \"lastmjs\" }) { id blogPosts(order: { title: DESC }) { title } }\n} mutation { deleteUser(input: { id: \"0\" }) { id blogPosts(order: { title: DESC }) { title } }\n}","breadcrumbs":"Generated schema » Order » Order","id":"108","title":"Order"},"109":{"body":"Authorization and authentication are two separate but related concerns. Authentication proves who (which identity) is performing a query or update, and authorization describes what that identity is allowed to do. Sudograph relies on the Internet Computer's native authentication of clients using public-key cryptography. There are some very nice helper libraries that allow you to easily create identities on the frontend that are able to sign query and update calls to canisters. See the agent-js documentation for more details. Authorization on the other hand must be handled by your canister in your own custom functions or resolvers. Before allowing a mutation to be executed, or before returning data in a custom resolver, you will want to get the principal of the caller and check that it is allowed to perform the operation. Here's a very simple example from the Ethereum Archival Canister . First the schema instructs Sudograph not to export the generated mutation function: type SudographSettings { exportGeneratedMutationFunction: false\n} This is important because we do not want any mutations taking place that aren't authorized. The Ethereum Archival Canister is designed to accept mutations only from one identity (the EC2 instance that mirrors blocks from a geth node). We perform the authorization like so: use sudograph::graphql_database; graphql_database!(\"canisters/graphql/src/schema.graphql\"); #[update]\nasync fn graphql_mutation_custom(mutation_string: String, variables_json_string: String) -> String { let ec2_principal = ic_cdk::export::Principal::from_text(\"y6lgw-chi3g-2ok7i-75s5h-k34kj-ybcke-oq4nb-u4i7z-vclk4-hcpxa-hqe\").expect(\"should be able to decode\"); if ic_cdk::caller() != ec2_principal { panic!(\"Not authorized\"); } return graphql_mutation(mutation_string, variables_json_string).await;\n} We have overridden the generated graphql mutation function, graphql_mutation, with our own custom graphql_mutation_custom. We then hard-code the EC2 instance's principal representing its identity. We panic if any other identity attempts to perform an update. This is a very simple example, but it illustrates how you can create custom functions designed for a specific purpose with authorization, using Sudograph to perform CRUD operations. The plan is to eventually introduce authorization configuration into the GraphQL schema, allowing you to use a directive like @auth to enforce authorization. Until you can configure authorization from within the schema itself, it will probably be necessary to control all access to queries and mutations from custom canister functions that enforce their own authorization. Custom resolvers won't really be useful if any data in the schema needs authorized access.","breadcrumbs":"Authorization » Authorization","id":"109","title":"Authorization"},"11":{"body":"Add a new canister to your dfx.json in the root directory of your project. You can name the canister whatever you'd like, but to keep things simple we'll call the canister graphql. If you have other canisters already defined, just add the graphql canister. The canister defined below assumes a directory structure where there is a directory called canisters to contain each canister. You can change up the directory structure if you'd like, just change all of the paths appropriately.: { \"canisters\": { \"graphql\": { \"type\": \"custom\", \"build\": \"cargo build --target wasm32-unknown-unknown --package graphql --release\", \"candid\": \"canisters/graphql/src/graphql.did\", \"wasm\": \"target/wasm32-unknown-unknown/release/graphql.wasm\" } }\n}","breadcrumbs":"Existing project » Edit dfx.json in root directory","id":"11","title":"Edit dfx.json in root directory"},"110":{"body":"If you are interested in using a Rust or Motoko canister as a client to your graphql canister, then take a look at the rust-client and motoko-client examples. The graphql canister can be configured to only authorize queries or updates from a specific canister. This will allow you to create authorized data-specific functions in your Rust or Motoko canisters, and those functions can then use GraphQL to call into the graphql canister. This is probably the best way to implement authorization in your applications until something like the @auth directive is implemented.","breadcrumbs":"Authorization » Canister authorization","id":"110","title":"Canister authorization"},"111":{"body":"use ic_cdk;\nuse ic_cdk_macros; #[ic_cdk_macros::import(canister = \"graphql\")]\nstruct GraphQLCanister; #[ic_cdk_macros::query]\nasync fn get_all_users() -> String { // TODO here you can implement your custom authorization for get_all_users let result = GraphQLCanister::graphql_query_custom( \" query { readUser { id } } \".to_string(), \"{}\".to_string() ).await; let result_string = result.0; return result_string;\n}","breadcrumbs":"Authorization » Rust authorization","id":"111","title":"Rust authorization"},"112":{"body":"import Text \"mo:base/Text\"; actor Motoko { let GraphQLCanister = actor \"rrkah-fqaaa-aaaaa-aaaaq-cai\": actor { graphql_query_custom: query (Text, Text) -> async (Text); graphql_mutation: (Text, Text) -> async (Text); }; public func get_all_users(): async (Text) { // TODO here you can implement your custom authorization for get_all_users let result = await GraphQLCanister.graphql_query_custom(\"query { readUser { id } }\", \"{}\"); return result; }\n} You can then authorize specific canisters in the graphql canister like this: use sudograph::graphql_database; graphql_database!(\"canisters/graphql/src/schema.graphql\"); #[sudograph::ic_cdk_macros::query]\nasync fn graphql_query_custom(query: String, variables: String) -> String { let motoko_canister_principal = sudograph::ic_cdk::export::Principal::from_text(\"ryjl3-tyaaa-aaaaa-aaaba-cai\").expect(\"should be able to decode\"); if sudograph::ic_cdk::caller() != motoko_canister_principal { panic!(\"Not authorized\"); } return graphql_query(query, variables).await;\n} graphql_query_custom will only accept calls from the ryjl3-tyaaa-aaaaa-aaaba-cai canister. Now all authorization logic can be implemented in the ryjl3-tyaaa-aaaaa-aaaba-cai canister. Again, the goal is to allow you to write custom authorization into your schema with something like an @auth directive, which should greatly simplify authorization and allow for GraphQL operations to be made directly from a frontend client.","breadcrumbs":"Authorization » Motoko authorization","id":"112","title":"Motoko authorization"},"113":{"body":"Whenever you wish to make changes to a canister without losing that canister's state, you must perform what is called an upgrade . An upgrade allows you to preserve your canister's state while changing its code. You can see a full example of an upgrade here .","breadcrumbs":"Migrations » Migrations","id":"113","title":"Migrations"},"114":{"body":"If you haven't changed your schema and you just want to preserve state across upgrades: use sudograph; sudograph::graphql_database!(\"canisters/graphql/src/schema.graphql\"); #[sudograph::ic_cdk_macros::pre_upgrade]\nfn pre_upgrade_custom() { let object_type_store = sudograph::ic_cdk::storage::get::<ObjectTypeStore>(); sudograph::ic_cdk::storage::stable_save((object_type_store,));\n} #[sudograph::ic_cdk_macros::post_upgrade]\nfn post_upgrade_custom() { let (stable_object_type_store,): (ObjectTypeStore,) = sudograph::ic_cdk::storage::stable_restore().expect(\"ObjectTypeStore should be in stable memory\"); let object_type_store = sudograph::ic_cdk::storage::get_mut::<ObjectTypeStore>(); for (key, value) in stable_object_type_store.into_iter() { object_type_store.insert(key, value); }\n} The upgrade shown above assumes no changes to your GraphQL schema. If you were to change your GraphQL schema and then perform the upgrade, you would run into a number of issues. This is because the underlying data structures that make up your database would be out of sync with your schema. In this case your code would cease to function as intended. You must perform automatic or manual migrations on your code if you change your schema.","breadcrumbs":"Migrations » Simple migrations","id":"114","title":"Simple migrations"},"115":{"body":"Automatic migrations are not currently supported. For now you'll need to manually change the ObjectTypeStore in your post_upgrade function to reflect the changes in your schema, or accept that you will lose all of your state on every deploy (this may be acceptable if you plan on only deploying once). The plan is to eventually automate migrations as much as possible. With automatic migrations, if you change your schema and wish to update it on a live canister, Sudograph will generate migrations written in Rust to accomplish the migration for you. If a migration cannot be performed automatically, Sudograph will allow you to easily define your own migration code in Rust. That's the rough plan for now.","breadcrumbs":"Migrations » Automatic migrations","id":"115","title":"Automatic migrations"},"116":{"body":"Even with automatic migrations, you will run into scenarios that cannot be handled automatically. You may be required to manually update the ObjectTypeStore in the post_upgrade function to fully migrate data after schema changes. Studying the documentation available for the ObjectTypeStore will help you determine what needs to be changed within it when you change your schema. Let's look at the migrations required when we add a field to an object type in our schema. Here's the original schema: type User { id: ID!\n} Imagine that we have deployed the original schema. Now we will change the schema: type User { id: ID! username: String\n} We need to change the ObjectTypeStore so that it is aware of the change. In our post_upgrade function: #[sudograph::ic_cdk_macros::post_upgrade]\nfn post_upgrade_custom() { let (stable_object_type_store,): (ObjectTypeStore,) = sudograph::ic_cdk::storage::stable_restore().expect(\"ObjectTypeStore should be in stable memory\"); let object_type_store = sudograph::ic_cdk::storage::get_mut::<ObjectTypeStore>(); for (key, value) in stable_object_type_store.into_iter() { object_type_store.insert(key, value); } // First grab the object type for User let user_object_type = object_type_store.get_mut(\"User\").expect(\"User object type should exist\"); // Then add the type information for the username field user_object_type.field_types_store.insert( \"username\".to_string(), sudograph::sudodb::FieldType::String ); // Finally add the initial values for the username field for field_value_store in user_object_type.field_values_store.values_mut() { field_value_store.insert( \"username\".to_string(), sudograph::sudodb::FieldValue::Scalar(None) ); }\n} After the next deploy we will have successfully migrated our database! Make sure to remove the code on subsequent deploys. Automatic migrations will make this process simpler and more standardized.","breadcrumbs":"Migrations » Manual migrations","id":"116","title":"Manual migrations"},"117":{"body":"Sudograph does not have a strong guarantee of atomicity (transactions) at this time. Read on for more information.","breadcrumbs":"Transactions » Transactions","id":"117","title":"Transactions"},"118":{"body":"Within a single update call, transactions are automatically handled by the Internet Computer itself! If there are any errors (technically Wasm traps) all state changes are undone and thus not persisted. This is a very nice feature of single canister development, and it's important to know that the schema that Sudograph generates for you is limited to a single canister by default. Unfortunately, Sudograph does not currently guarantee that all errors will lead to traps, and thus there is no guarantee that all state changes within a single update call will be undone. Once an automated testing framework is in place, adding this functionality to Sudograph should not be too difficult. Once Sudograph ensures all errors will lead to traps, you will be able to execute transactions and ensure atomicity by executing many mutations within a single update call like this: mutation { createUser1: createUser(input: { username: \"user1\" }) { id } createUser2: createUser(input: { username: \"user2\" }) { id } createUser3: createUser(input: { username: \"user3\" }) { id }\n} The mutations above will either all succeed or all fail.","breadcrumbs":"Transactions » Single canister mutations","id":"118","title":"Single canister mutations"},"119":{"body":"Even if you batch many mutations into one update call, if any of your mutations are custom and call into other canisters, the atomic guarantees are gone. Providing atomic operations in these situations will be more difficult for Sudograph to implement because the Internet Computer does not provide atomicity when doing multi-canister updates. If you need transactions across multiple canisters, you will need to write custom code that can undo state changes across all canisters in a chain of mutations.","breadcrumbs":"Transactions » Multi-canister mutations","id":"119","title":"Multi-canister mutations"},"12":{"body":"In the root directory of your project create a Cargo.toml file with the following contents: [workspace]\nmembers = [ \"canisters/graphql\",\n] [profile.release]\nlto = true\nopt-level = 'z' Again this assumes your project has a canisters directory where the graphql canister will be defined. You can change the directory structure if you wish, just make sure to update this Cargo.toml file.","breadcrumbs":"Existing project » Add Cargo.toml to root directory","id":"12","title":"Add Cargo.toml to root directory"},"120":{"body":"Sudograph will not scale a single schema across multiple canisters automatically. The goal is to eventually provide this functionality, but the timeline and feasibility of this goal are unknown. You can deploy as many Sudograph canisters with a single schema as you'd like, but the generated queries and mutations will only be able to operate on data that has been created within the same canister (unless you write your own glue code to enable cross-canister queries and mutations). Currently each schema that you deploy into a canister is limited to ~4 GB of data. This should be sufficient for prototyping and small amounts of storage and usage. There are also multiple scaling techniques that could be used to scale out, for example by storing large files (video, audio, images, documents) in a separate set of canisters that has automatic scaling built-in, and storing references to that data in your Sudograph canister. One of the main problems Sudograph will have scaling across multiple canisters is ensuring efficient and flexible querying. Complex indexing and searching will need to work on relational data across multiple canisters. Sudograph is focused first on providing an amazing single canister development experience. This should be sufficient for many new developers and young projects. There are multiple promising technologies or solutions that could lift the ~4 GB limit, including memory64 , multiple memories , and possibly infinite/unbounded virtual memory in canisters. I am hopeful that individual canisters will be able to scale into the 10s or 100s or perhaps 1000s of GBs in the near future.","breadcrumbs":"Multi-canister scaling » Multi-canister scaling","id":"120","title":"Multi-canister scaling"},"121":{"body":"Sudograph is designed to generate much of the CRUD functionality you might need, but it can't handle every situation. You might find the need to have access to the underlying data structures.","breadcrumbs":"Custom database operations » Custom database operations","id":"121","title":"Custom database operations"},"122":{"body":"One layer below Sudograph is Sudodb. Sudodb is a very simple relational database that uses the Internet Computer's orthogonal persistence directly. It exposes a few basic functions like create, read, update, and delete. You can use those functions directly in custom resolvers or your own functions. You can dig through the documentation and source code below: Repository Crates.io Docs.rs Here's an example of how you would use Sudodb directly: use sudograph::graphql_database; graphql_database!(\"canisters/graphql/src/schema.graphql\"); #[sudograph::ic_cdk_macros::query]\nasync fn read_all_users() -> Vec<User> { let object_type_store = sudograph::ic_cdk::storage::get::<ObjectTypeStore>(); let mut selection_set_map = HashMap::new(); selection_set_map.insert( String::from(\"id\"), sudograph::sudodb::SelectionSetInfo { selection_set: sudograph::sudodb::SelectionSet(None), search_inputs: vec![], limit_option: None, offset_option: None, order_inputs: vec![] } ); let selection_set = sudograph::sudodb::SelectionSet(Some(selection_set_map)); let read_result = sudograph::sudodb::read( object_type_store, \"User\", &vec![], None, None, &vec![], &selection_set ); match read_result { Ok(strings) => { let deserialized_strings: Vec<User> = strings.iter().map(|string| { return sudograph::serde_json::from_str(string).unwrap(); }).collect(); return deserialized_strings; }, Err(_) => { return vec![]; } };\n}","breadcrumbs":"Custom database operations » Sudodb","id":"122","title":"Sudodb"},"123":{"body":"One layer below Sudodb is the ObjectTypeStore. The ObjectTypeStore is the main data structure that makes up the GraphQL database. You can directly read from or update the ObjectTypeStore in custom resolvers or your own functions. You can dig into its structure in the documentation and source code below: Repository Docs.rs Here's an example of how you would use the ObjectTypeStore directly: #[sudograph::ic_cdk_macros::query]\nasync fn read_all_users() -> Vec<User> { let object_type_store = sudograph::ic_cdk::storage::get::<ObjectTypeStore>(); let object_type = object_type_store.get(\"User\").expect(\"should exist\"); let users = object_type.field_values_store.iter().map(|(_, field_value_store)| { let id = match field_value_store.get(\"id\").expect(\"should exist\") { FieldValue::Scalar(field_value_scalar_option) => match field_value_scalar_option.as_ref().expect(\"should exist\") { FieldValueScalar::String(id) => ID(id.to_string()), _ => panic!(\"should not happen\") }, _ => panic!(\"should not happen\") }; let username = match field_value_store.get(\"username\").expect(\"should exist\") { FieldValue::Scalar(field_value_scalar_option) => match field_value_scalar_option.as_ref().expect(\"should exist\") { FieldValueScalar::String(username) => username.to_string(), _ => panic!(\"should not happen\") }, _ => panic!(\"should not happen\") }; // This example does not show you how to resolve relations // You would need to go and get the blog posts by using information in the blogPosts FieldValue // and retrieving the records from the BlogPost object type let blog_posts = vec![]; return User { id, username, blogPosts: blog_posts }; }).collect(); return users;\n}","breadcrumbs":"Custom database operations » ObjectTypeStore","id":"123","title":"ObjectTypeStore"},"124":{"body":"Sudograph is built on the bedrock of async_graphql . async_graphql is the library providing most of the fundamental GraphQL functionality, includes resolving queries and mutations. Sudograph is mostly tasked with transforming your provided schema into the Rust data structures that async_graphql expects. Though Sudograph is designed to provide a lot of functionality for you automatically, you may find the need to dig deeper and integrate with async_graphql more directly. The automatically generated graphql_query and graphql_mutation functions create an async_graphql schema data structure. These functions also accept queries and mutations and execute them against that schema. You can always generate your own functions (see Sudograph Settings ) and use async_graphql directly if you wish. You can see how Sudograph creates an async_graphql schema here (look for the graphql_query and graphql_mutation functions). You can write your own async_graphql types as well. Basically, if you understand how Sudograph is simply generating async_graphql Rust data structures, including queries and mutations, you will be able to figure out how to augment the schema yourself. This could be very useful if you are waiting on Sudograph to implement a feature for you, as you might be able to implement it yourself right away with minimal effort.","breadcrumbs":"Custom async_graphql integration » Custom async_graphql integration","id":"124","title":"Custom async_graphql integration"},"125":{"body":"No custom scalars, only Blob, Boolean, Date, Float, ID, Int, JSON, and String are available No custom input objects, only custom input scalars allowed in custom resolvers Each schema is limited to a single canister with ~4 GB of storage Very inneficient querying No automatic migrations, once you deploy the schema is final unless you implement your own migrations No authorization at the schema level, deal with it through your own custom authorization at the canister function level No automated tests No subscriptions No transactions","breadcrumbs":"Limitations » Limitations","id":"125","title":"Limitations"},"13":{"body":"Create a new directory within canisters called graphql, and add a Cargo.toml file. It should look like the following: [package]\nname = \"graphql\"\nversion = \"0.0.0\"\nedition = \"2018\" [lib]\npath = \"src/graphql.rs\"\ncrate-type = [\"cdylib\"] [dependencies]\nsudograph = \"0.3.0\"\nic-cdk = \"0.3.0\" # TODO this will go away once https://github.com/dfinity/candid/pull/249 is released Within the canisters/graphql directory, now create a src directory. The canisters/graphql/src directory will contain your GraphQL schema, the Rust entrypoint to your graphql canister, and your candid file.","breadcrumbs":"Existing project » Create graphql canister crate","id":"13","title":"Create graphql canister crate"},"14":{"body":"Within the canisters/graphql/src directory, create your schema.graphql file. The following is just an example: type User { id: ID! username: String! blogPosts: [BlogPost!]! @relation(name: \"User:blogPosts::BlogPost:author\")\n} type BlogPost { id: ID! publishedAt: Date title: String! author: User! @relation(name: \"User:blogPosts::BlogPost:author\")\n}","breadcrumbs":"Existing project » Create GraphQL schema","id":"14","title":"Create GraphQL schema"},"15":{"body":"Within the canisters/graphql/src directory, create your graphql.rs file. The file should look like this: use sudograph::graphql_database; graphql_database!(\"canisters/graphql/src/schema.graphql\"); This simply imports the graphql_database procedural macro from sudograph and then invokes it with the path to your schema.graphql file. This is where the magic happens and the database with CRUD queries and mutations are all generated.","breadcrumbs":"Existing project » Import and call the graphql_database procedural macro","id":"15","title":"Import and call the graphql_database procedural macro"},"16":{"body":"Within the canisters/graphql/src directory, create your graphql.did file. The file should look like this: service : { \"graphql_query\": (text, text) -> (text) query; \"graphql_mutation\": (text, text) -> (text);\n} The generated canister code will have created the two functions defined in graphql.did, but for now you'll need to create the candid file manually. Hopefully in the future it can be generated for you or abstracted away somehow. graphql_query and graphql_mutation both take two parameters. The first parameter is the query or mutation string. The second parameter is a JSON string containing any variables for the query or mutation. Currently the second parameter is required, so just send an empty JSON object string \"{}\" if no variables are required for the query or mutation. graphql_query and graphql_mutation both return the result of the query or mutation as a JSON string. Whatever client is consuming the query or mutation will then need to parse the JSON string to turn it into a language-level object. The Sudograph Client will do this for you in a JavaScript frontend.","breadcrumbs":"Existing project » Create candid file","id":"16","title":"Create candid file"},"17":{"body":"Use the following links for more information about local deployment and IC deployment .","breadcrumbs":"Existing project » Deploy","id":"17","title":"Deploy"},"18":{"body":"Start up an IC replica and deploy: # Open a terminal and run the following command to start a local IC replica\ndfx start # Alternatively to the above command, you can run the replica in the background\ndfx start --background # If you are running the replica in the background, you can run this command within the same terminal as the dfx start --background command\n# If you are not running the replica in the background, then open another terminal and run this command from the root directory of your project\ndfx deploy Make sure to run dfx deploy for your first deploy. For quicker deployments after the first, you can run dfx deploy graphql if you've only changed your schema or the Rust code within the graphql canister. dfx deploy graphql will only deploy the graphql canister, which contains the generated database.","breadcrumbs":"Local deployment » Local deployment","id":"18","title":"Local deployment"},"19":{"body":"Start executing GraphQL queries and mutations against your database by going to the following URL in a Chromium browser: http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 .","breadcrumbs":"Local deployment » playground canister","id":"19","title":"playground canister"},"2":{"body":"My goal for Sudograph is for it to become the simplest, most flexible, and in the end most powerful way to develop internet applications. That's the grand vision. To scope the vision down a bit, more realistically I want Sudograph to become the simplest, most flexible, and in the end most powerful way to develop Internet Computer applications. Sudograph will achieve this vision by reading your GraphQL schema and generating an amazingly flexible, super simple, infinitely scalable, and extremely secure backend. That's a lot of hyperbole! But that's also the future I want to build with Sudograph. Achieving this vision begins with enabling CRUD operations within a single canister, then quickly moves into migrations , authorization , and multi-canister scaling . Sudograph is currently transitioning from alpha into beta, and there's a long journey ahead.","breadcrumbs":"Vision and motivation » Vision","id":"2","title":"Vision"},"20":{"body":"View a simple frontend application that communicates with the graphql canister by going to the following URL in a Chromium browser: http://rrkah-fqaaa-aaaaa-aaaaq-cai.localhost:8000 .","breadcrumbs":"Local deployment » frontend canister","id":"20","title":"frontend canister"},"21":{"body":"You can execute queries against the graphql canister from the command line if you wish: # send a query to the graphql canister\ndfx canister call graphql graphql_query '(\"query { readUser { id } }\", \"{}\")' # send a mutation to the graphql canister\ndfx canister call graphql graphql_mutation '(\"mutation { createUser(input: { username: \\\"lastmjs\\\" }) { id } }\", \"{}\")'","breadcrumbs":"Local deployment » command line","id":"21","title":"command line"},"22":{"body":"See the Sudograph Client documentation for more information. Here's a simple example of using Sudograph Client from a JavaScript frontend: import { gql, sudograph\n} from 'sudograph'; const { query, mutation\n} = sudograph({ canisterId: 'ryjl3-tyaaa-aaaaa-aaaba-cai'\n}); async function getUserIds() { const result = await query(gql` query { readUser { id } } `); const users = result.data.readUser; return users;\n}","breadcrumbs":"Local deployment » Sudograph Client","id":"22","title":"Sudograph Client"},"23":{"body":"If you want to call into the graphql canister from another Rust canister, first you update the dfx.json and then implement your rust canister. Make sure to include the graphql canister as a dependency to your rust canister in dfx.json: { \"canisters\": { \"graphql\": { \"type\": \"custom\", \"build\": \"cargo build --target wasm32-unknown-unknown --package graphql --release\", \"candid\": \"canisters/graphql/src/graphql.did\", \"wasm\": \"target/wasm32-unknown-unknown/release/graphql.wasm\" }, \"playground\": { \"type\": \"assets\", \"source\": [\"canisters/playground/build\"] }, \"rust\": { \"type\": \"custom\", \"build\": \"cargo build --target wasm32-unknown-unknown --package rust --release\", \"candid\": \"canisters/rust/src/rust.did\", \"wasm\": \"target/wasm32-unknown-unknown/release/rust.wasm\", \"dependencies\": [ \"graphql\" ] } }\n} And then in your rust canister: use ic_cdk;\nuse ic_cdk_macros; #[ic_cdk_macros::import(canister = \"graphql\")]\nstruct GraphQLCanister; #[ic_cdk_macros::query]\nasync fn get_all_users() -> String { let result = GraphQLCanister::graphql_query( \" query { readUser { id } } \".to_string(), \"{}\".to_string() ).await; let result_string = result.0; return result_string;\n}","breadcrumbs":"Local deployment » Rust canister","id":"23","title":"Rust canister"},"24":{"body":"If you want to call into the graphql canister from a Motoko canister: import Text \"mo:base/Text\"; actor Motoko { let GraphQLCanister = actor \"rrkah-fqaaa-aaaaa-aaaaq-cai\": actor { graphql_query: query (Text, Text) -> async (Text); graphql_mutation: (Text, Text) -> async (Text); }; public func get_all_users(): async (Text) { let result = await GraphQLCanister.graphql_query(\"query { readUser { id } }\", \"{}\"); return result; }\n}","breadcrumbs":"Local deployment » Motoko canister","id":"24","title":"Motoko canister"},"25":{"body":"If the replica rejects deployment of your canister because the payload is too large, you may need to optimize your Wasm binary .","breadcrumbs":"Local deployment » Wasm binary optimization","id":"25","title":"Wasm binary optimization"},"26":{"body":"Before deploying to the Internet Computer you should understand that Sudograph is alpha/beta software. There are missing features and potential bugs. There is also no way to easily migrate data (if you change your schema, you'll need to either delete your state and start over or manually make changes to the Sudograph data structures). But if you must deploy to the IC, here is the command: dfx deploy --network ic","breadcrumbs":"IC deployment » IC deployment","id":"26","title":"IC deployment"},"27":{"body":"If the replica rejects deployment of your canister because the payload is too large, you may need to optimize your Wasm binary .","breadcrumbs":"IC deployment » Wasm binary optimization","id":"27","title":"Wasm binary optimization"},"28":{"body":"At some point your compiled Rust Wasm binary will grow too large and will be rejected by the canister on deploy. This could happen because the Rust source code that you've written has grown too large, or because your schema has grown too large. A large schema will lead to a large amount of generated Rust code. To temporarily overcome this issue (only so much can be done during optimization, eventually the binary will be too big and the Internet Computer will need to address that), you can optimize your Rust Wasm binary.","breadcrumbs":"Wasm binary optimization » Wasm binary optimization","id":"28","title":"Wasm binary optimization"},"29":{"body":"To do this manually, in the root of your directory run the following command once to install the optimizer: cargo install ic-cdk-optimizer --root target You should also change your dfx.json file from: { \"canisters\": { \"graphql\": { \"type\": \"custom\", \"build\": \"cargo build --target wasm32-unknown-unknown --package graphql --release\", \"candid\": \"canisters/graphql/src/graphql.did\", \"wasm\": \"target/wasm32-unknown-unknown/release/graphql.wasm\" } }\n} to: { \"canisters\": { \"graphql\": { \"type\": \"custom\", \"build\": \"cargo build --target wasm32-unknown-unknown --package graphql --release\", \"candid\": \"canisters/graphql/src/graphql.did\", \"wasm\": \"target/wasm32-unknown-unknown/release/graphql-optimized.wasm\" } }\n} The only thing that changed was the wasm property of the graphql canister object, and it changed from \"wasm\": \"target/wasm32-unknown-unknown/release/graphql.wasm\" to \"wasm\": \"target/wasm32-unknown-unknown/release/graphql-optimized.wasm\". Each time you run dfx deploy or dfx deploy graphql, you will need to run the following command after: ./target/bin/ic-cdk-optimizer ./target/wasm32-unknown-unknown/release/graphql.wasm -o ./target/wasm32-unknown-unknown/release/graphql-optimized.wasm","breadcrumbs":"Wasm binary optimization » Manual optimization","id":"29","title":"Manual optimization"},"3":{"body":"I have been developing with GraphQL since somewhere around 2016. It immediately struck me as a powerful way to deal with the complexities of managing the reading and writing of data for non-trivial internet applications. It has proven to me since that it is extremely versatile, and I have used it for a number of projects with a number of different underlying data sources. Though GraphQL simplifies development, implementing it is not always simple. It still requires you to write a lot of code to bring your schema to life, in large part because GraphQL does not solve the problem of how data is read and written. There are a number of libraries that have been developed in the recent past to address this problem. You can think of these as GraphQL generators. They attempt in one way or another to take a GraphQL schema and generate the code required to read and write data. During my journey to find the perfect GraphQL generator, I went from Graphcool to Prisma to Graphback to finally writing a GraphQL generator from scratch . And there are other similar projects out there, like Hasura and PostGraphile . No project has gotten it right yet, and each library has trade-offs and falls short of the vision of generating an amazingly flexible, super simple, infinitely scalable, and extremely secure backend from a GraphQL schema. It's a very difficult problem. The Internet Computer may provide a very interesting solution. The Internet Computer promises flexibility, simplicity, scalability, and security like no other platform before it. Combining the powers of GraphQL with the Internet Computer may be the best chance we have yet to achieve this vision.","breadcrumbs":"Vision and motivation » Motivation","id":"3","title":"Motivation"},"30":{"body":"It can be tedious to have to run the above command manually after each dfx deploy. If you wish to figure out how to use cargo scripts of some kind you can do that. You could also use make or bash or some other build process or scripting system. Another way is to adopt npm scripts. Your package.json could look something like this: { \"scripts\": { \"build\": \"cd canisters/playground && npm install && npm run build && cd ../frontend && npm install && npm run build\", \"dfx-deploy\": \"npm run dfx-build-graphql && npm run dfx-optimize-graphql && dfx deploy\", \"dfx-deploy-graphql\": \"npm run dfx-build-graphql && npm run dfx-optimize-graphql && dfx deploy graphql\", \"dfx-build-graphql\": \"cargo build --target wasm32-unknown-unknown --package graphql --release\", \"dfx-optimize-graphql\": \"./target/bin/ic-cdk-optimizer ./target/wasm32-unknown-unknown/release/graphql.wasm -o ./target/wasm32-unknown-unknown/release/graphql-optimized.wasm\" }\n} Then instead of running dfx deploy or dfx deploy graphql you would run npm run dfx-deploy or npm run dfx-deploy-graphql. In the future it would be nice for the dfx.json to allow for some sort of build scripts, which would make this process less messy. There is an open forum post about this here .","breadcrumbs":"Wasm binary optimization » Automatic optimization","id":"30","title":"Automatic optimization"},"31":{"body":"The Sudograph Client is a frontend JavaScript/TypeScript library that provides a convenient API for interacting with your deployed graphql canister. It is an alternative to using agent-js directly, and currently works only for the frontend (Node.js support will come later).","breadcrumbs":"Sudograph Client » Sudograph Client","id":"31","title":"Sudograph Client"},"32":{"body":"Install Sudograph Client into your frontend project with npm install sudograph.","breadcrumbs":"Sudograph Client » Installation","id":"32","title":"Installation"},"33":{"body":"In addition to the code on this page, many of the examples have frontend projects that show Sudograph Client in use. For our example, let's imagine we have some sort of frontend UI component defined in a JavaScript file called component.js. You could import and prepare Sudograph Client for use as follows: // component.js import { gql, sudograph\n} from 'sudograph'; const { query, mutation\n} = sudograph({ canisterId: 'ryjl3-tyaaa-aaaaa-aaaba-cai'\n}); Above we import the gql tag and the sudograph function. The gql tag will be used for queries later on. To prepare for query or mutation execution, we call the sudograph function and pass in an options object. In this case, we simply put in the canister id of our graphql canister. The options object looks like this in TypeScript: import { Identity } from '@dfinity/agent'; export type Options = Readonly<{ canisterId: string; identity?: Identity; queryFunctionName?: string; mutationFunctionName?: string;\n}>;","breadcrumbs":"Sudograph Client » Use","id":"33","title":"Use"},"34":{"body":"If we want to execute a query, we would do so as follows. Imagine defining a function to return all user ids: // component.js async function getUserIds() { const result = await query(gql` query { readUser { id } } `); const users = result.data.readUser; return users;\n} By the way, the gql tag is just a nice way to integrate with existing editor tools, such as syntax highlighting and type checking. You can remove it if you'd like.","breadcrumbs":"Sudograph Client » query","id":"34","title":"query"},"35":{"body":"If we want to execute a mutation, we would do so as follows. Imagine defining a function to create a user: // component.js async function createUser(username) { const result = await mutation(gql` mutation ($username: String!) { createUser(input: { username: $username }) { id } } `, { username }); const user = result.data.createUser; return user;\n}","breadcrumbs":"Sudograph Client » mutation","id":"35","title":"mutation"},"36":{"body":"The queryFunctionName and mutationFunctionName properties of the options object that we pass into the sudograph function allow us to specify the names of the canister functions that are exposed by our graphql canister. By default the generated query and mutation function names are graphql_query and graphql_mutation. Sudograph Client will assume those names should be used unless queryFunctionName and mutationFunctionName are supplied by the developer.","breadcrumbs":"Sudograph Client » Changing query and mutation canister function names","id":"36","title":"Changing query and mutation canister function names"},"37":{"body":"The identity property of the options object that we pass into the sudograph function helps us out with authentication, and its type is defined by @dfinity/agent . If we pass in an identity object, it will be passed into the constructor of the @dfinity/agent HttpAgent that Sudograph Client is creating for you under the hood. This identity will be used to sign query and mutation requests, allowing you to implement authorization inside of your graphql canister. The files example shows how to use Internet Identity with a graphql canister.","breadcrumbs":"Sudograph Client » Authentication","id":"37","title":"Authentication"},"38":{"body":"If you don't wish to use Sudograph Client , you can reach for the lower-level agent-js library.","breadcrumbs":"agent-js » agent-js","id":"38","title":"agent-js"},"39":{"body":"Install agent-js into your frontend project with npm install @dfinity/agent.","breadcrumbs":"agent-js » Installation","id":"39","title":"Installation"},"4":{"body":"Multiple examples are located in the examples directory in the Sudograph repository . Here's a list of possibly useful examples: basic Ethereum Archival Canister files 1 files 2 intermediate miscellaneous motoko-client motoko-custom-resolvers rust-client rust-custom-resolvers sudograph-vue webi_api","breadcrumbs":"Examples » Examples","id":"4","title":"Examples"},"40":{"body":"In addition to the code on this page, the Sudograph Client implementation is a very good example of how to use agent-js directly to interact with a graphql canister. For our example, let's imagine we have some sort of frontend UI component defined in a JavaScript file called component.js. You could import and prepare agent-js for use as follows: // component.js import { Actor, HttpAgent\n} from '@dfinity/agent'; const idlFactory = ({ IDL }) => { return IDL.Service({ graphql_query: IDL.Func([IDL.Text, IDL.Text], [IDL.Text], ['query']), graphql_mutation: IDL.Func([IDL.Text, IDL.Text], [IDL.Text], []) });\n}; const agent = new HttpAgent(); const actor = Actor.createActor(idlFactory, { agent, canisterId: 'ryjl3-tyaaa-aaaaa-aaaba-cai'\n}); Above we manually construct an IDL Factory describing the graphql_query and graphql_mutation functions exported from our canister. We then create an agent and use that agent with the canister id of our graphql canister to create an actor.","breadcrumbs":"agent-js » Use","id":"40","title":"Use"},"41":{"body":"If we want to execute a query, we would do so as follows. Imagine defining a function to return all user ids: // component.js async function getUserIds() { const result = await actor.graphql_query(` query { readUser { id } } `, JSON.stringify({})); const resultJSON = JSON.parse(result); const users = resultJSON.data.readUser; return users;\n}","breadcrumbs":"agent-js » query","id":"41","title":"query"},"42":{"body":"If we want to execute a mutation, we would do so as follows. Imagine defining a function to create a user: // component.js async function createUser(username) { const result = await actor.graphql_mutation(` mutation ($username: String!) { createUser(input: { username: $username }) { id } } `, JSON.stringify({ username })); const resultJSON = JSON.parse(result); const user = resultJSON.data.createUser; return user;\n}","breadcrumbs":"agent-js » mutation","id":"42","title":"mutation"},"43":{"body":"The HttpAgent from @dfinity/agent takes an object as a parameter to its contructor. That object has a property called identity of type Identity which can be found in @dfinity/agent. This identity will be used to sign requests made by the actor object that we create, allowing you to implement authorization inside of your graphql canister. The files example shows how to use Internet Identity with a graphql canister.","breadcrumbs":"agent-js » Authentication","id":"43","title":"Authentication"},"44":{"body":"The schema is where you define all of the data types of your application, including relations between types. It is also where you will eventually define many other settings, possibly including authentication, authorization, subnet, and Sudograph-specific settings. An example schema might look like this: type User { id: ID! username: String! blogPosts: [BlogPost!]! @relation(name: \"User:blogPosts::BlogPost:author\")\n} type BlogPost { id: ID! publishedAt: Date title: String! author: User! @relation(name: \"User:blogPosts::BlogPost:author\")\n} We have told Sudograph that we have two object types, User and BlogPost. We've described the fields of each type, using some included scalar types such as ID, Date, and String. We have also described one relation between our two types, a one-to-many relationship from User to BlogPost on the fields User:blogPosts and BlogPost:author. The schema is an incredibly powerful yet simple tool for defining the complex data types of your application. Get to know the possibilities of your schema: Scalars Enums Objects Relations Custom scalars Custom resolvers Custom directives Sudograph directives Sudograph settings","breadcrumbs":"Schema » Schema","id":"44","title":"Schema"},"45":{"body":"Scalar types are not divisible, they have no fields of their own. The scalar types automatically available to you in a Sudograph schema are: Blob Boolean Date Float ID Int JSON String","breadcrumbs":"Schema » Scalars » Scalars","id":"45","title":"Scalars"},"46":{"body":"A Blob value maps to a Rust Vec<u8>. type File { id: ID! contents: Blob!\n} Query or mutation inputs of type Blob should be strings or arrays of numbers that can be converted into Rust u8 numbers. Blob types in selection sets are always returned as JSON arrays of numbers. An example in JavaScript of inputting a string for a Blob: async function createSmallFile() { const result = await mutation(gql` mutation ($contents: Blob!) { createFile(input: { contents: $contents }) { contents } } `, { contents: 'hello' }); const file = result.data.createFile; console.log(file);\n} The logged contents of the file would be this: [104, 101, 108, 108, 111]. You can convert the array of numbers back to a string like so: [104, 101, 108, 108, 111].map(x => String.fromCharCode(x)).join('') An example in JavaScript of inputting an array of numbers for a Blob: async function createSmallFile() { const result = await mutation(gql` mutation ($contents: Blob!) { createFile(input: { contents: $contents }) { contents } } `, { contents: 'hello'.split('').map(x => x.charCodeAt()) }); const file = result.data.createFile; console.log(file);\n} The logged contents of the file would be this: [104, 101, 108, 108, 111]. You can convert the array of numbers back to a string like so: [104, 101, 108, 108, 111].map(x => String.fromCharCode(x)).join('') Blob types in selection sets can use offset and limit to grab specific bytes: async function createSmallFile() { const result = await mutation(gql` mutation ($contents: Blob!) { createFile(input: { contents: $contents }) { contents(offset: 1, limit: 3) } } `, { contents: 'hello' }); const file = result.data.createFile; console.log(file);\n} The logged contents of the file would be this: [101, 108, 108]. You can convert the array of numbers back to a string like so: [101, 108, 108].map(x => String.fromCharCode(x)).join('')","breadcrumbs":"Schema » Scalars » Blob","id":"46","title":"Blob"},"47":{"body":"A Boolean value maps to a Rust bool. type User { id: ID! verified: Boolean!\n}","breadcrumbs":"Schema » Scalars » Boolean","id":"47","title":"Boolean"},"48":{"body":"A Date value maps to a Rust String for storage and a chrono::DateTime for filtering. type User { id: ID! dateOfBirth: Date!\n} Query or mutation inputs of type Date should be strings that can be parsed by chrono::DateTime . For example, in JavaScript new Date().toISOString() would be an acceptable format. An example in JavaScript: async function getUsersInInterval() { const result = await query(gql` query ($startDate: Date!, $endDate: Date!) { readUser(search: { dateOfBirth: { gte: $startDate lt: $endDate } }) { id } } `, { startDate: new Date('2021-07-01').toISOString(), endDate: new Date('2021-07-02').toISOString() }); const users = result.data.readUser; return users;\n}","breadcrumbs":"Schema » Scalars » Date","id":"48","title":"Date"},"49":{"body":"A Float value maps to a Rust f32. type User { id: ID! height: Float!\n}","breadcrumbs":"Schema » Scalars » Float","id":"49","title":"Float"},"5":{"body":"This section is designed to get you going completely from scratch. It assumes you want to have a frontend, a GraphQL playground, and the graphql canister. If you instead wish to integrate Sudograph into an existing project, see the Existing project section . If you've already got Node.js, npm, Rust, the wasm32-unknown-unknown Rust compilation target, and dfx 0.7.2 installed then just run the following commands: mkdir my-new-project\ncd my-new-project\nnpx sudograph\ndfx start --background\ndfx deploy Once deployed, you can visit the following canisters from a Chromium browser: playground: http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 frontend: http://rrkah-fqaaa-aaaaa-aaaaq-cai.localhost:8000 If the above did not work, try the full installation steps in the actual quick start . More information is available for local deployment and IC deployment .","breadcrumbs":"Quickest of quick starts » Quickest of quick starts (new project)","id":"5","title":"Quickest of quick starts (new project)"},"50":{"body":"An ID value maps to a Rust String. All Sudograph object types must have a field called id of type ID. type User { id: ID!\n}","breadcrumbs":"Schema » Scalars » ID","id":"50","title":"ID"},"51":{"body":"An Int value maps to a Rust i32. type User { id: ID! age: Int!\n}","breadcrumbs":"Schema » Scalars » Int","id":"51","title":"Int"},"52":{"body":"A JSON value maps to a Rust String. type User { id: ID! meta: JSON!\n} Query or mutation inputs of type JSON should be any valid JSON value. JSON types in selection sets are always returned as JSON values.","breadcrumbs":"Schema » Scalars » JSON","id":"52","title":"JSON"},"53":{"body":"A String value maps to a Rust String. type User { id: ID! username: String!\n}","breadcrumbs":"Schema » Scalars » String","id":"53","title":"String"},"54":{"body":"Enums are essentially a scalar type that can be one value out of a predetermined set of values that are defined statically in a schema. Enums are represented as strings in the database and selection sets. Here's a simple example of a Color enum: type User { id: ID! favoriteColor: Color!\n} enum Color { WHITE BLUE GOLD SILVER YELLOW PURPLE\n}","breadcrumbs":"Schema » Enums » Enums","id":"54","title":"Enums"},"55":{"body":"Object types have fields that may be types such as other object types or scalars or enums. Object types allow you to define the truly custom data types and relations that make up your application. You could model a user with blog posts like so: type User { id: ID! username: String! blogPosts: [BlogPost!]! @relation(name: \"User:blogPosts::BlogPost:author\")\n} type BlogPost { id: ID! publishedAt: Date title: String! author: User! @relation(name: \"User:blogPosts::BlogPost:author\")\n} You could model a family tree like so: # TODO this example will not work yet\n# TODO the self-referencing has some issues and multiple @relation directives per field is not yet supported\ntype Person { id: ID! firstName: String! lastName: String! father: Person @relation(name: \"Person:father::Person:children\") mother: Person @relation(name: \"Person:mother::Person:children\") children: [Person!]! @relation(name: \"Person:father::Person:children\") @relation(name: \"Person:mother::Person:children\")\n} You could model Ethereum block data like so: type Block { id: ID! number: Int! hash: String! parent: Block transactionsRoot: String! transactionCount: Int! stateRoot: String! gasLimit: String! gasUsed: String! timestamp: Date! transactions: [Transaction!]! @relation(name: \"Block:transactions::Transaction:block\")\n} type Transaction { id: ID! hash: String! index: Int! from: String! to: String! value: String! gasPrice: String! gas: String! inputData: String! block: Block! @relation(name: \"Block:transactions::Transaction:block\") gasUsed: String!\n}","breadcrumbs":"Schema » Objects » Objects","id":"55","title":"Objects"},"56":{"body":"Relations allow you to describe the relationships between object types and their fields. Sudograph has a variety of relation capabilities. Please note that the name argument of the @relation directive is just an arbitrary string, there is no DSL required. The only requirement is that the name argument be the same on both sides of the relation. Also note that you can only have one @relation directive per field for now.","breadcrumbs":"Schema » Relations » Relations","id":"56","title":"Relations"},"57":{"body":"One-to-one relations allow you to connect one object with another object.","breadcrumbs":"Schema » Relations » One-to-one relations","id":"57","title":"One-to-one relations"},"58":{"body":"If you only care about retrieving relation information from one side of the relation, you don't need a @relation directive: type Foot { id: ID! shoe: Shoe\n} type Shoe { id: ID!\n} In the above example, you will be able to select the shoe of a foot, like so: query { readFoot(search: { id: { eq: \"7c3nrr-6jhf3-2gozt-hh37a-d6nvf-lsdwv-d7bhp-uk5nt-r42y\" } }) { id shoe { id } }\n} You will not be able to select the foot of a shoe.","breadcrumbs":"Schema » Relations » One-sided","id":"58","title":"One-sided"},"59":{"body":"If you care about retrieving relation information from both sides of the relation, add a @relation directive. The name argument of the @relation directive can be arbitrary, but it must be the same on both sides of the relation. type Foot { id: ID! shoe: Shoe @relation(name: \"Foot:shoe::Shoe:foot\")\n} type Shoe { id: ID! foot: Foot @relation(name: \"Foot:shoe::Shoe:foot\")\n}","breadcrumbs":"Schema » Relations » Two-sided","id":"59","title":"Two-sided"},"6":{"body":"This section is designed to get you going completely from scratch. It assumes you want to have a frontend, a GraphQL playground, and the graphql canister. If you instead wish to integrate Sudograph into an existing project, see the Existing project section .","breadcrumbs":"Quick start » Quick start (new project)","id":"6","title":"Quick start (new project)"},"60":{"body":"One-to-many relations allow you to connect one object with multiple other objects.","breadcrumbs":"Schema » Relations » One-to-many relations","id":"60","title":"One-to-many relations"},"61":{"body":"If you only care about retrieving relation information from one side of the relation, you don't need a @relation directive: type Monkey { id: ID! name: String! bananas: [Banana!]!\n} type Banana { id: ID! color: String! size: Int!\n} In the above example, you will be able to select the bananas of a monkey, like so: query { readMonkey(search: { id: { eq: \"7c3nrr-6jhf3-2gozt-hh37a-d6nvf-lsdwv-d7bhp-uk5nt-r42y\" } }) { id name bananas { id color size } }\n} You will not be able to select the monkey of a banana.","breadcrumbs":"Schema » Relations » One-sided","id":"61","title":"One-sided"},"62":{"body":"If you care about retrieving relation information from both sides of the relation, add a @relation directive. The name argument of the @relation directive can be arbitrary, but it must be the same on both sides of the relation. type Monkey { id: ID! name: String! bananas: [Banana!]! @relation(name: \"Monkey:bananas::Banana:monkey\")\n} type Banana { id: ID! color: String! size: Int! monkey: Monkey @relation(name: \"Monkey:bananas::Banana:monkey\")\n}","breadcrumbs":"Schema » Relations » Two-sided","id":"62","title":"Two-sided"},"63":{"body":"Many-to-many relations allow you to connect multiple objects with multiple other objects. Many-to-many relations must have a @relation directive. The name argument of the @relation directive can be arbitrary, but it must be the same on both sides of the relation. type Author { id: ID! documents: [Document!]! @relation(name: \"Author:documents::Document:authors\")\n} type Document { id: ID! text: String! authors: [Author!]! @relation(name: \"Author:documents::Document:authors\")\n}","breadcrumbs":"Schema » Relations » Many-to-many relations","id":"63","title":"Many-to-many relations"},"64":{"body":"Custom scalars (scalars that you define) are not yet supported. You'll have to work with the included scalars: Blob Boolean Date Float ID Int JSON String","breadcrumbs":"Schema » Custom scalars » Custom scalars","id":"64","title":"Custom scalars"},"65":{"body":"DISCLAIMER: Custom resolvers have only been minimally tested. Information presented here may not be entirely accurate. If you find issues please get in contact with @lastmjs or open issues on the repository . Though Sudograph generates many powerful CRUD operations for you, it will not be able to cover every conceivable requirement of your applications. Custom resolvers provide a way for you to create your own functionality that is accessible through the same GraphQL API as Sudograph's generated functionality. There are two main locations a resolver can be written, within the graphql canister or in a separate canister.","breadcrumbs":"Schema » Custom resolvers » Custom resolvers","id":"65","title":"Custom resolvers"},"66":{"body":"You can see a full example of Rust custom resolvers here . To write resolvers within your graphql canister, start by augmenting your schema, for example in canisters/graphql/src/schema.graphql: type Query { custom_get(id: ID!): Message\n} type Mutation { custom_set(id: ID!, text: String): Boolean!\n} type Message { id: ID! text: String!\n} We've added one custom query and one custom mutation to the schema. Next we need to implement the resolvers in code. To implement a resolver, we add an asynchronous function to the Rust file that contains our graphql_database macro invocation. The function should have the same name as the query or mutation in the schema, and should use parameter and return types that match the types in the schema. The return type should be a Result with the Ok variant matching the return type in the schema, and you should use sudograph::async_graphql::Error as the Err variant. Object types generated from your schema are automatically in scope in Rust, because they are generated by the graphql_database macro. Type conversions between GraphQL and Rust can be found here . Now we'll implement the custom resolvers for the query and mutation in canisters/graphql/src/graphql.rs: use sudograph::graphql_database; graphql_database!(\"canisters/graphql/src/schema.graphql\"); type PrimaryKey = String;\ntype MessageStore = HashMap<PrimaryKey, Option<Message>>; async fn custom_get(id: ID) -> Result<Option<Message>, sudograph::async_graphql::Error> { let message_store = sudograph::ic_cdk::storage::get::<MessageStore>(); let message_option = message_store.get(&id.to_string()); match message_option { Some(message) => { return Ok(message.clone()); }, None => { return Ok(None); } };\n} async fn custom_set(id: ID, text: Option<String>) -> Result<bool, sudograph::async_graphql::Error> { let message_store = sudograph::ic_cdk::storage::get_mut::<MessageStore>(); let message = match text { Some(text_value) => Some(Message { id: id.clone(), text: text_value }), None => None }; message_store.insert(id.to_string(), message); return Ok(true);\n}","breadcrumbs":"Schema » Custom resolvers » Resolvers within the graphql canister","id":"66","title":"Resolvers within the graphql canister"},"67":{"body":"You can also write resolvers that are deployed to other canisters, using any language supported by the Internet Computer. For now you'll most likely be using Rust or Motoko, so examples are included below. The process is similar to what you've just seen above, but in your GraphQL schema the custom queries and mutations have the addition of a @canister directive with the canister id of the canister that implements your resolver function.","breadcrumbs":"Schema » Custom resolvers » Resolvers within a different canister","id":"67","title":"Resolvers within a different canister"},"68":{"body":"In a Rust canister, start by augmenting your schema, for example in canisters/graphql/src/schema.graphql: type Query { custom_get(id: ID!): Message @canister(id: \"ryjl3-tyaaa-aaaaa-aaaba-cai\")\n} type Mutation { custom_set(id: ID!, text: String): Boolean! @canister(id: \"ryjl3-tyaaa-aaaaa-aaaba-cai\")\n} type Message { id: ID! text: String!\n} Notice we've added @canister(id: \"ryjl3-tyaaa-aaaaa-aaaba-cai\") to the custom query and mutation. Now we need to implement the Rust canister. Let's imagine we've created another Rust canister in canisters/another-rust-canister. We might have a file called canisters/another-rust-canister/src/lib.rs, and it would look like this: use sudograph; // TODO This hasn't been tested, might need some derive macros\nstruct ID(String); impl ID { fn to_string(&self) -> String { return String::from(&self.0); }\n} // TODO This hasn't been tested, might need some derive macros\nstruct Message { id: String, text: String\n}; type PrimaryKey = String;\ntype MessageStore = HashMap<PrimaryKey, Option<Message>>; #[sudograph::ic_cdk_macros::query]\nasync fn custom_get(id: ID) -> Option<Message> { let message_store = sudograph::ic_cdk::storage::get::<MessageStore>(); let message_option = message_store.get(&id.to_string()); match message_option { Some(message) => { return message.clone(); }, None => { return None; } };\n} #[sudograph::ic_cdk_macros::update]\nasync fn custom_set(id: ID, text: Option<String>) -> bool { let message_store = sudograph::ic_cdk::storage::get_mut::<MessageStore>(); let message = match text { Some(text_value) => Some(Message { id: id.clone(), text: text_value }), None => None }; message_store.insert(id.to_string(), message); return true;\n} Notice that these functions do not return a Result, they directly return the Rust types that correspond to the GraphQL types . This may change in the future as returning a Result may end up being more appropriate. Also notice that we had to implement the ID and Message types ourselves. We do not have all of the generated types available because we are not using the graphql_database macro in this canister. In the future Sudograph may provide a simple way to generate these types for you without generating the entire database, but for now you'll have to implement them yourself or figure out an appropriate way to induce proper serialization and deserialization. For example, Candid might serialize and deserialize ID to and from strings for us...you'll just have to figure this out on your own for now.","breadcrumbs":"Schema » Custom resolvers » Rust","id":"68","title":"Rust"},"69":{"body":"You can see a full example of Motoko custom resolvers here . In a Motoko canister, start by augmenting your schema, for example in canisters/graphql/src/schema.graphql: type Query { customGet(id: ID!): Message @canister(id: \"ryjl3-tyaaa-aaaaa-aaaba-cai\")\n} type Mutation { customSet(id: ID!, text: String): Boolean! @canister(id: \"ryjl3-tyaaa-aaaaa-aaaba-cai\")\n} type Message { id: ID! text: String!\n} Notice we've added @canister(id: \"ryjl3-tyaaa-aaaaa-aaaba-cai\") to the custom query and mutation. Now we need to implement the Motoko canister. Let's imagine we've created a Motoko canister in canisters/motoko. We might have a file called canisters/motoko/main.mo, and it would look like this: import Text \"mo:base/Text\";\nimport Map \"mo:base/HashMap\";\nimport Option \"mo:base/Option\"; actor Motoko { let message_store = Map.HashMap<Text, ?Message>(10, Text.equal, Text.hash); type Message = { id: Text; text: Text; }; public query func customGet(id: Text): async ?Message { return Option.flatten(message_store.get(id)); }; public func customSet(id: Text, text: ?Text): async Bool { let message: ?Message = switch (text) { case null null; case (?text_value) Option.make({ id; text = text_value; }); }; message_store.put(id, message); return true; };\n} Implementing the Motoko resolvers is very similar to implementing the Rust resolvers, the biggest difference besides the lanuage itself being the type conversions . We've implemented the Message type, and we've excluded the ID type and just used the native Motoko Text type. Again, you might have to experiment with the serialization and deserialization of values between canisters, a lot of it has to do with Candid.","breadcrumbs":"Schema » Custom resolvers » Motoko","id":"69","title":"Motoko"},"7":{"body":"You should have the following installed on your system: Node.js npm Rust wasm32-unknown-unknown Rust compilation target dfx 0.7.2 If you already have the above installed, you can skip to Sudograph generate . Run the following commands to install Node.js and npm. nvm is highly recommended and its use is shown below: curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.38.0/install.sh | bash # restart your terminal nvm install 14 Run the following command to install Rust and the wasm32-unknown-unknown target: curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh rustup target add wasm32-unknown-unknown Run the following command to install dfx 0.7.2: # Sudograph has been tested against version 0.7.2, so it is safest to install that specific version for now\nDFX_VERSION=0.7.2 sh -ci \"$(curl -fsSL https://sdk.dfinity.org/install.sh)\"","breadcrumbs":"Quick start » Prerequisites","id":"7","title":"Prerequisites"},"70":{"body":"Other languages are somewhat possible to use now (C, C++, AssemblyScript), and many more will come in the future as WebAssembly matures. Writing resolvers in each of these languages will be similar to writing them in Rust or Motoko. Once your schema is setup and correctly pointing to a canister, you simply implement the resolver in the language of choice and ensure that the types align correctly.","breadcrumbs":"Schema » Custom resolvers » Other languages","id":"70","title":"Other languages"},"71":{"body":"","breadcrumbs":"Schema » Custom resolvers » Type conversions","id":"71","title":"Type conversions"},"72":{"body":"Object, ID, and Date types must be created in Rust canisters if the graphql_database macro is not invoked. ID and Date types might work as String in Rust. Blob -> Vec<u8> Boolean -> bool Date -> Date Float -> f32 ID -> ID Int -> i32 JSON -> serde_json::Value String -> String Creating a custom ID type: // TODO This hasn't been tested, might need some derive macros\nstruct ID(String); impl ID { fn to_string(&self) -> String { return String::from(&self.0); }\n} Creating a custom Date type: // TODO This hasn't been tested, might need some derive macros\nstruct Date(String); impl Date { fn to_string(&self) -> String { return String::from(&self.0); }\n}","breadcrumbs":"Schema » Custom resolvers » GraphQL -> Rust","id":"72","title":"GraphQL -> Rust"},"73":{"body":"Object types must be manually created in Motoko. Blob -> Blob Boolean -> Bool Date -> Text Float -> Float ID -> Text Int -> Int32 JSON -> Text (it's unclear if this will work) String -> Text","breadcrumbs":"Schema » Custom resolvers » GraphQL -> Motoko","id":"73","title":"GraphQL -> Motoko"},"74":{"body":"Custom directives (directives that you define) are not yet supported. You'll have to work with the Sudograph directives .","breadcrumbs":"Schema » Custom directives » Custom directives","id":"74","title":"Custom directives"},"75":{"body":"Sudograph provides a number of directives for use within your GraphQL schema. Directives can be applied to object types or fields within your schema. The following are available for use:","breadcrumbs":"Schema » Sudograph directives » Sudograph directives","id":"75","title":"Sudograph directives"},"76":{"body":"name: relation arguments: name application: field description: Indicates a two-sided relationship, where both sides of the relationship need to be updated during relation mutations. The name argument is an arbitrary string, but must be the same on both fields representing each side of the relationship. type Foot { id: ID! shoe: Shoe @relation(name: \"Foot:shoe::Shoe:foot\")\n} type Shoe { id: ID! foot: Foot @relation(name: \"Foot:shoe::Shoe:foot\")\n}","breadcrumbs":"Schema » Sudograph directives » @relation","id":"76","title":"@relation"},"77":{"body":"name: canister arguments: id application: field description: Indicates the canister with the implementation of the resolver function. The id argument is used to do a cross-canister function call under-the-hood. type Query { customGet(id: ID!): Message @canister(id: \"ryjl3-tyaaa-aaaaa-aaaba-cai\")\n} type Mutation { customSet(id: ID!, text: String): Boolean! @canister(id: \"ryjl3-tyaaa-aaaaa-aaaba-cai\")\n} type Message { id: ID! text: String!\n}","breadcrumbs":"Schema » Sudograph directives » @canister","id":"77","title":"@canister"},"78":{"body":"Just let your imagination run wild with what some of these could do: @ignore @auth @token @subnet","breadcrumbs":"Schema » Sudograph directives » Possible future relations","id":"78","title":"Possible future relations"},"79":{"body":"There will be many settings that Sudograph will allow the developer to customize. Sudograph settings are set in your GraphQL schema using the SudographSettings object type. The following are supported now: type SudographSettings { exportGeneratedQueryFunction: true exportGeneratedMutationFunction: true exportGeneratedInitFunction: true exportGeneratedPostUpgradeFunction: true\n}","breadcrumbs":"Schema » Sudograph settings » Sudograph settings","id":"79","title":"Sudograph settings"},"8":{"body":"Start by making a new directory for your project. You then simply run the sudograph generate command: mkdir my-new-project cd my-new-project npx sudograph","breadcrumbs":"Quick start » Sudograph generate","id":"8","title":"Sudograph generate"},"80":{"body":"Defaults to true. If set to false, the graphql_query function generated by Sudograph will not be exported as a publicly available canister function. This would allow you to implement your own logic before executing a query, for example as part of an authorization flow. Here's an example of overriding the generated graphql_query function with some basic authorization. You would create the following GraphQL schema in canisters/graphql/src/schema.graphql: type SudographSettings { exportGeneratedQueryFunction: false\n} type User { id: ID!\n} You would write the following in canisters/graphql/src/graphql.rs: use sudograph::graphql_database; graphql_database!(\"canisters/graphql/src/schema.graphql\"); #[sudograph::ic_cdk_macros::query]\nasync fn graphql_query_custom(query_string: String, variables_json_string: String) -> String { let authorized_principal = sudograph::ic_cdk::export::Principal::from_text(\"y6lgw-chi3g-2ok7i-75s5h-k34kj-ybcke-oq4nb-u4i7z-vclk4-hcpxa-hqe\").expect(\"should be able to decode\"); if sudograph::ic_cdk::caller() != authorized_principal { panic!(\"Not authorized\"); } return graphql_query(query_string, variables_json_string).await;\n} You would update canisters/graphql/src/graphql.did: service : { \"graphql_query_custom\": (text, text) -> (text) query; \"graphql_mutation\": (text, text) -> (text);\n}","breadcrumbs":"Schema » Sudograph settings » exportGeneratedQueryFunction","id":"80","title":"exportGeneratedQueryFunction"},"81":{"body":"Defaults to true. If set to false, the graphql_mutation function generated by Sudograph will not be exported as a publicly available canister function. This would allow you to implement your own logic before executing a mutation, for example as part of an authorization flow. Here's an example of overriding the generated graphql_mutation function with some basic authorization. You would create the following GraphQL schema in canisters/graphql/src/schema.graphql: type SudographSettings { exportGeneratedMutationFunction: false\n} type User { id: ID!\n} You would write the following in canisters/graphql/src/graphql.rs: use sudograph::graphql_database; graphql_database!(\"canisters/graphql/src/schema.graphql\"); #[sudograph::ic_cdk_macros::update]\nasync fn graphql_mutation_custom(mutation_string: String, variables_json_string: String) -> String { let authorized_principal = sudograph::ic_cdk::export::Principal::from_text(\"y6lgw-chi3g-2ok7i-75s5h-k34kj-ybcke-oq4nb-u4i7z-vclk4-hcpxa-hqe\").expect(\"should be able to decode\"); if sudograph::ic_cdk::caller() != authorized_principal { panic!(\"Not authorized\"); } return graphql_mutation(mutation_string, variables_json_string).await;\n} You would update canisters/graphql/src/graphql.did: service : { \"graphql_query\": (text, text) -> (text) query; \"graphql_mutation_custom\": (text, text) -> (text);\n}","breadcrumbs":"Schema » Sudograph settings » exportGeneratedMutationFunction","id":"81","title":"exportGeneratedMutationFunction"},"82":{"body":"Defaults to true. If set to false, the init function generated by Sudograph will not be exported as a publicly available canister function. This would allow you to implement your own logic during canister initialization. You'll want to make sure to call the generated init function after your functionality is complete, as it executes all of the init mutations that initialize the database. Here's an example of overriding the generated init function. You would create the following GraphQL schema in canisters/graphql/src/schema.graphql: type SudographSettings { exportGeneratedInitFunction: false\n} type User { id: ID!\n} You would write the following in canisters/graphql/src/graphql.rs: use sudograph::graphql_database; graphql_database!(\"canisters/graphql/src/schema.graphql\"); #[sudograph::ic_cdk_macros::init]\nasync fn init_custom() { init.await;\n}","breadcrumbs":"Schema » Sudograph settings » exportGeneratedInitFunction","id":"82","title":"exportGeneratedInitFunction"},"83":{"body":"Defaults to true. If set to false, the post_upgrade function generated by Sudograph will not be exported as a publicly available canister function. This would allow you to implement your own logic during canister post upgrade. You'll want to make sure to call the generated post_upgrade function after your functionality is complete, as it executes all of the init mutations that initialize the database (unless you are keeping your state through stable memory, then you would not want to initialize the database again). Here's an example of overriding the generated post_upgrade function. You would create the following GraphQL schema in canisters/graphql/src/schema.graphql: type SudographSettings { exportGeneratedPostUpgradeFunction: false\n} type User { id: ID!\n} You would write the following in canisters/graphql/src/graphql.rs: use sudograph::graphql_database; graphql_database!(\"canisters/graphql/src/schema.graphql\"); #[sudograph::ic_cdk_macros::post_upgrade]\nasync fn post_upgrade_custom() { post_upgrade.await;\n}","breadcrumbs":"Schema » Sudograph settings » exportGeneratedPostUpgradeFunction","id":"83","title":"exportGeneratedPostUpgradeFunction"},"84":{"body":"Sudograph takes your schema and generates a much more powerful schema along with the resolvers for that schema. In addition to this documentation, assuming you've generated an example project with npx sudograph and deployed your canisters, then navigate to the playground at http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 in a Chromium browser and click the Docs button in the top right corner. That documentation explains everything that you can do with your newly generated schema. Query read Mutation create update delete Subscription Search Limit Offset Order As an example, given the following simple schema: type User { id: ID!\n} type BlogPost { id: ID!\n} Sudograph will generate the following schema along with its resolvers: type Query { readUser( search: ReadUserInput, limit: Int, offset: Int, order: OrderUserInput ): [User!]! readBlogPost( search: ReadBlogPostInput, limit: Int, offset: Int, order: OrderBlogPostInput ): [BlogPost!]!\n} input DeleteUserInput { id: ID ids: [ID!]\n} input UpdateBlogPostInput { id: ID!\n} input DeleteBlogPostInput { id: ID ids: [ID!]\n} input ReadUserInput { id: ReadIDInput and: [ReadUserInput!] or: [ReadUserInput!]\n} input ReadIDInput { eq: ID gt: ID gte: ID lt: ID lte: ID contains: ID\n} input OrderUserInput { id: OrderDirection\n} enum OrderDirection { ASC DESC\n} type User { id: ID!\n} input ReadBlogPostInput { id: ReadIDInput and: [ReadBlogPostInput!] or: [ReadBlogPostInput!]\n} input OrderBlogPostInput { id: OrderDirection\n} type BlogPost { id: ID!\n} type Mutation { createUser(input: CreateUserInput): [User!]! createBlogPost(input: CreateBlogPostInput): [BlogPost!]! updateUser(input: UpdateUserInput!): [User!]! updateBlogPost(input: UpdateBlogPostInput!): [BlogPost!]! deleteUser(input: DeleteUserInput!): [User!]! deleteBlogPost(input: DeleteBlogPostInput!): [BlogPost!]! initUser: Boolean! initBlogPost: Boolean!\n} input UpdateUserInput { id: ID!\n} input CreateBlogPostInput { id: ID\n} input CreateUserInput { id: ID\n}","breadcrumbs":"Generated schema » Generated Schema","id":"84","title":"Generated Schema"},"85":{"body":"Sudograph will generate the equivalent of the Query object type based on your GraphQL schema. If you have specified your own Query object type, the two object types will be combined into the final Query object type. The fields in the Query object type generated by Sudograph are: read","breadcrumbs":"Generated schema » Query » Query","id":"85","title":"Query"},"86":{"body":"The read query is the main way to read data from your GraphQL database. Per object type defined in your GraphQL schema, Sudograph generates one read field on the Query object type. We'll focus in on what happens with one object type defined. Imagine your schema looks like this: type User { id: ID!\n} Sudograph will generate the following (we're focusing on just one part of the generated schema): type Query { readUser( search: ReadUserInput, limit: Int offset: Int order: OrderUserInput ): [User!]!\n} input ReadUserInput { id: ReadIDInput and: [ReadUserInput!] or: [ReadUserInput!]\n} input OrderUserInput { id: OrderDirection\n} enum OrderDirection { ASC DESC\n} Each read query has the ability to search , limit , offset , and order . Each read query returns an array of its corresponding object types. It's important to remember that within read selection sets you also have the ability to search , limit , offset , and order on any many-relation. For example if you had this schema: type User { id: ID! blogPosts: [BlogPost!]!\n} type BlogPost { id: ID! title: String!\n} You could write a query like this: query { readUser { id blogPosts( search: { title: { contains: \"The\" } } offset: 0 limit: 10 order: { title: ASC } ) { id title } }\n}","breadcrumbs":"Generated schema » Query » read » read","id":"86","title":"read"},"87":{"body":"Sudograph will generate the equivalent of the Mutation object type based on your GraphQL schema. If you have specified your own Mutation object type, the two object types will be combined into the final Mutation object type. The fields in the Mutation object type generated by Sudograph are: create update delete init","breadcrumbs":"Generated schema » Mutation » Mutation","id":"87","title":"Mutation"},"88":{"body":"The create mutation is the main way to create data in your GraphQL database. Per object type defined in your GraphQL schema, Sudograph generates one create field on the Mutation object type. We'll focus in on what happens with one object type defined. Imagine your schema looks like this: type User { id: ID!\n} Sudograph will generate the following (we're focusing on just one part of the generated schema): type Mutation { createUser(input: CreateUserInput): [User!]!\n} input CreateUserInput { id: ID\n} It's important to remember that within create selection sets you also have the ability to search , limit , offset , and order on any many-relation. For example if you had this schema: type User { id: ID! blogPosts: [BlogPost!]!\n} type BlogPost { id: ID! title: String!\n} You could write a query like this: mutation { createUser(blogPosts: { connect: [\"7c3nrr-6jhf3-2gozt-hh37a-d6nvf-lsdwv-d7bhp-uk5nt-r42y\"] }) { id blogPosts( search: { title: { contains: \"The\" } } offset: 0 limit: 10 order: { title: ASC } ) { id title } }\n}","breadcrumbs":"Generated schema » Mutation » create » create","id":"88","title":"create"},"89":{"body":"The update mutation is the main way to update data in your GraphQL database. Per object type defined in your GraphQL schema, Sudograph generates one update field on the Mutation object type. We'll focus in on what happens with one object type defined. Imagine your schema looks like this: type User { id: ID!\n} Sudograph will generate the following (we're focusing on just one part of the generated schema): type Mutation { updateUser(input: UpdateUserInput!): [User!]!\n} input UpdateUserInput { id: ID!\n} It's important to remember that within update selection sets you also have the ability to search , limit , offset , and order on any many-relation. For example if you had this schema: type User { id: ID! blogPosts: [BlogPost!]!\n} type BlogPost { id: ID! title: String!\n} You could write a query like this: mutation { updateUser( id: \"7c3nrr-6jhf3-2gozt-hh37a-d6nvf-lsdwv-d7bhp-uk5nt-r42y\" blogPosts: { connect: [\"2c3nrr-4jhf3-2gozt-hj37a-d6nvf-lsdwv-d7bhp-uk5nt-r42y\"] } ) { id blogPosts( search: { title: { contains: \"The\" } } offset: 0 limit: 10 order: { title: ASC } ) { id title } }\n}","breadcrumbs":"Generated schema » Mutation » update » update","id":"89","title":"update"},"9":{"body":"Use the following links for more information about local deployment and IC deployment .","breadcrumbs":"Quick start » Deployment","id":"9","title":"Deployment"},"90":{"body":"The delete mutation is the main way to delete data in your GraphQL database. Per object type defined in your GraphQL schema, Sudograph generates one delete field on the Mutation object type. We'll focus in on what happens with one object type defined. Imagine your schema looks like this: type User { id: ID!\n} Sudograph will generate the following (we're focusing on just one part of the generated schema): type Mutation { deleteUser(input: DeleteUserInput!): [User!]!\n} input DeleteUserInput { id: ID ids: [ID!]\n} It's important to remember that within delete selection sets you also have the ability to search , limit , offset , and order on any many-relation. For example if you had this schema: type User { id: ID! blogPosts: [BlogPost!]!\n} type BlogPost { id: ID! title: String!\n} You could write a query like this: mutation { deleteUser(input: { id: \"7c3nrr-6jhf3-2gozt-hh37a-d6nvf-lsdwv-d7bhp-uk5nt-r42y\" }) { id blogPosts( search: { title: { contains: \"The\" } } offset: 0 limit: 10 order: { title: ASC } ) { id title } }\n}","breadcrumbs":"Generated schema » Mutation » delete » delete","id":"90","title":"delete"},"91":{"body":"The init mutation initializes the underlying Rust data structures in your GraphQL database. This mutation must be run before other queries or mutations can be executed for an object type. Sudograph will automatically run all init mutations for all of your object types in the graphql canister's init and post_upgrade functions, unless you override them. Per object type defined in your GraphQL schema, Sudograph generates one init field on the Mutation object type. We'll focus in on what happens with one object type defined. Imagine your schema looks like this: type User { id: ID!\n} Sudograph will generate the following (we're focusing on just one part of the generated schema): type Mutation { initUser: Boolean!\n}","breadcrumbs":"Generated schema » Mutation » init » init","id":"91","title":"init"},"92":{"body":"Subscriptions are not currently supported by Sudograph. Because the Internet Computer itself does not have any push mechanisms exposed, it will be difficult to provide subscription capabilities in the normal ways e.g. web sockets. For now you will have to implement your own polling solutions to know when data has been updated.","breadcrumbs":"Generated schema » Subscription » Subscription","id":"92","title":"Subscription"},"93":{"body":"The search input allows for flexible querying of records. You can query by scalars and relations to arbitrary depths (assuming performance allows). You can also use arbitrary combinations of and and or in your searches.","breadcrumbs":"Generated schema » Search » Search","id":"93","title":"Search"},"94":{"body":"You can search by scalar fields using the inputs generated for each scalar type.","breadcrumbs":"Generated schema » Search » Scalar search","id":"94","title":"Scalar search"},"95":{"body":"Generated input: input ReadBlobInput { eq: Blob contains: Blob startsWith: Blob endsWith: Blob\n} Examples: query { readFile(search: { contents: { eq: [101, 108, 108] } }) { id contents }\n} query { readFile(search: { contents: { contains: [108, 108] } }) { id contents }\n} query { readFile(search: { contents: { startsWith: [101] } }) { id contents }\n} query { readFile(search: { contents: { endsWith: [108] } }) { id contents }\n}","breadcrumbs":"Generated schema » Search » Blob","id":"95","title":"Blob"},"96":{"body":"Generated input: input ReadBooleanInput { eq: Boolean\n} Examples: query { readUser(search: { living: { eq: true } }) { id living }\n}","breadcrumbs":"Generated schema » Search » Boolean","id":"96","title":"Boolean"},"97":{"body":"Generated input: input ReadDateInput { eq: Date gt: Date gte: Date lt: Date lte: Date\n} Examples: query { readBlogPost(search: { createdAt: { eq: \"2021-07-02T22:45:44.001Z\" } }) { id title }\n} query { readBlogPost(search: { createdAt: { gt: \"2021-07-02T22:45:44.001Z\" } }) { id title }\n} query { readBlogPost(search: { createdAt: { gte: \"2021-07-02T22:45:44.001Z\" } }) { id title }\n} query { readBlogPost(search: { createdAt: { lt: \"2021-07-02T22:45:44.001Z\" } }) { id title }\n} query { readBlogPost(search: { createdAt: { lte: \"2021-07-02T22:45:44.001Z\" } }) { id title }\n}","breadcrumbs":"Generated schema » Search » Date","id":"97","title":"Date"},"98":{"body":"Generated input: input ReadFloatInput { eq: Float gt: Float gte: Float lt: Float lte: Float\n} Examples: query { readUser(search: { height: { eq: 5.8 } }) { id }\n} query { readUser(search: { height: { gt: 5.8 } }) { id }\n} query { readUser(search: { height: { gte: 5.8 } }) { id }\n} query { readUser(search: { height: { lt: 5.8 } }) { id }\n} query { readUser(search: { height: { lte: 5.8 } }) { id }\n}","breadcrumbs":"Generated schema » Search » Float","id":"98","title":"Float"},"99":{"body":"Generated input: input ReadIDInput { eq: ID gt: ID gte: ID lt: ID lte: ID contains: ID\n} Examples: query { readUser(search: { id: { eq: \"7c3nrr-6jhf3-2gozt-hh37a-d6nvf-lsdwv-d7bhp-uk5nt-r42y\" } }) { id }\n} query { readUser(search: { id: { gt: \"1\" } }) { id }\n} query { readUser(search: { id: { gte: \"1\" } }) { id }\n} query { readUser(search: { id: { lt: \"100\" } }) { id }\n} query { readUser(search: { id: { lte: \"100\" } }) { id }\n} query { readUser(search: { id: { contains: \"7c3nrr\" } }) { id }\n}","breadcrumbs":"Generated schema » Search » ID","id":"99","title":"ID"}},"length":126,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"0":{".":{"0":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"0":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"2":{"df":3,"docs":{"10":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"'":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"'":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"2":{"2":{":":{"4":{"5":{":":{"4":{"4":{".":{"0":{"0":{"1":{"df":0,"docs":{},"z":{"df":1,"docs":{"97":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"7":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"97":{"tf":2.23606797749979}}},"df":7,"docs":{"106":{"tf":2.6457513110645907},"107":{"tf":2.449489742783178},"108":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"1":{"0":{"0":{"0":{"df":1,"docs":{"120":{"tf":1.0}}},"df":2,"docs":{"120":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"1":{"df":2,"docs":{"46":{"tf":2.449489742783178},"95":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"46":{"tf":2.0}}},"8":{"]":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"46":{"tf":3.3166247903554},"95":{"tf":2.23606797749979}}},"df":8,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":2.0},"107":{"tf":1.4142135623730951},"120":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"1":{"1":{"]":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"4":{"df":1,"docs":{"7":{"tf":1.0}}},"df":5,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":2.23606797749979},"4":{"tf":1.0},"46":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"2":{"0":{"1":{"6":{"df":1,"docs":{"3":{"tf":1.0}}},"8":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":1,"docs":{"97":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":1,"docs":{"100":{"tf":1.0}}},"5":{"df":1,"docs":{"100":{"tf":1.0}}},"c":{"3":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"4":{"tf":1.0}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"z":{"df":0,"docs":{},"t":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"7":{"df":0,"docs":{},"i":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"3":{"0":{"df":1,"docs":{"100":{"tf":1.0}}},"df":3,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"46":{"tf":1.0}}},"4":{"5":{"df":1,"docs":{"100":{"tf":1.0}}},"df":4,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"125":{"tf":1.0}},"j":{"df":0,"docs":{},"h":{"df":0,"docs":{},"f":{"3":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}}}}},"5":{".":{"8":{"df":1,"docs":{"98":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":5,"docs":{"101":{"tf":2.23606797749979},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"106":{"tf":2.449489742783178},"107":{"tf":2.449489742783178}}},"6":{"a":{"a":{"a":{"a":{"df":3,"docs":{"19":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.4142135623730951}},"j":{"df":0,"docs":{},"h":{"df":0,"docs":{},"f":{"3":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}}},"7":{"0":{"df":1,"docs":{"100":{"tf":1.0}}},"5":{"df":0,"docs":{},"s":{"5":{"df":0,"docs":{},"h":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"3":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"106":{"tf":1.0},"107":{"tf":1.4142135623730951}}},"8":{"df":2,"docs":{"106":{"tf":1.0},"107":{"tf":1.4142135623730951}}},"9":{"df":2,"docs":{"106":{"tf":1.0},"107":{"tf":1.7320508075688772}}},"_":{"df":1,"docs":{"123":{"tf":2.0}}},"a":{"a":{"a":{"a":{"a":{"df":12,"docs":{"112":{"tf":2.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{},"q":{"df":4,"docs":{"112":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"5":{"tf":1.0}}}},"b":{"a":{"df":7,"docs":{"112":{"tf":1.7320508075688772},"22":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{},"q":{"df":3,"docs":{"19":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":11,"docs":{"114":{"tf":1.0},"118":{"tf":1.0},"18":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.4142135623730951},"124":{"tf":1.0},"48":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"109":{"tf":1.4142135623730951},"121":{"tf":1.0},"65":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":5,"docs":{"112":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"43":{"tf":1.0},"69":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"3":{"tf":1.0}}}}}}},"df":4,"docs":{"118":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"112":{"tf":1.0},"12":{"tf":1.0},"69":{"tf":1.0},"83":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"124":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":5,"docs":{"100":{"tf":2.23606797749979},"103":{"tf":2.23606797749979},"104":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"109":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":2.449489742783178}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":24,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":2.23606797749979},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":1.0},"125":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"h":{"a":{"/":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"107":{"tf":1.0},"11":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"31":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"106":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"120":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"28":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"18":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"31":{"tf":1.0},"65":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":10,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.4142135623730951},"55":{"tf":1.0},"65":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}},"df":1,"docs":{"75":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"56":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"109":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"107":{"tf":1.0},"46":{"tf":2.449489742783178},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"c":{"df":6,"docs":{"108":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":11,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"124":{"tf":3.1622776601683795}}}}}}},"df":0,"docs":{}}}},"df":21,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":2.0},"122":{"tf":1.0},"123":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"124":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"78":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"109":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{":":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":15,"docs":{"105":{"tf":1.4142135623730951},"109":{"tf":3.605551275463989},"110":{"tf":2.0},"111":{"tf":1.4142135623730951},"112":{"tf":2.6457513110645907},"125":{"tf":1.4142135623730951},"14":{"tf":1.0},"2":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"55":{"tf":1.0},"63":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"114":{"tf":1.0},"115":{"tf":2.0},"116":{"tf":1.7320508075688772},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"30":{"tf":1.0},"45":{"tf":1.0},"66":{"tf":1.0},"91":{"tf":1.0}}}},"df":3,"docs":{"115":{"tf":1.0},"118":{"tf":1.0},"125":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":12,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"116":{"tf":1.0},"125":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":11,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0}}}},"r":{"df":1,"docs":{"116":{"tf":1.0}}},"y":{"df":3,"docs":{"124":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"46":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"18":{"tf":2.23606797749979},"5":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{"df":2,"docs":{"61":{"tf":2.449489742783178},"62":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}},"h":{"df":2,"docs":{"30":{"tf":1.0},"7":{"tf":1.0}}},"i":{"c":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"122":{"tf":1.0},"124":{"tf":1.0},"4":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"124":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"109":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"91":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"122":{"tf":1.4142135623730951},"123":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"110":{"tf":1.0},"3":{"tf":1.0}}}},"t":{"a":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"0":{"tf":1.0},"44":{"tf":1.4142135623730951},"56":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":2.0}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":7,"docs":{"125":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":3.3166247903554},"64":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"95":{"tf":2.23606797749979}}},"c":{"df":0,"docs":{},"k":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":2,"docs":{"109":{"tf":1.0},"55":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"123":{"tf":1.0},"55":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":10,"docs":{"105":{"tf":2.449489742783178},"123":{"tf":1.7320508075688772},"14":{"tf":1.7320508075688772},"44":{"tf":2.23606797749979},"55":{"tf":1.7320508075688772},"84":{"tf":2.449489742783178},"86":{"tf":2.0},"88":{"tf":2.0},"89":{"tf":2.23606797749979},"90":{"tf":2.0}},"s":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":2.0}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"107":{"tf":2.0}}}}}}},"r":{"d":{"df":1,"docs":{"108":{"tf":2.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"54":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"47":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":13,"docs":{"125":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.7320508075688772},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.4142135623730951},"91":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"76":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"2":{"tf":1.0},"23":{"tf":2.0},"29":{"tf":2.0},"30":{"tf":3.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"124":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"i":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"8":{"0":{"0":{"0":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":8,"docs":{"112":{"tf":1.7320508075688772},"22":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"l":{"df":23,"docs":{"10":{"tf":1.4142135623730951},"107":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":48,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"109":{"tf":2.23606797749979},"11":{"tf":3.0},"110":{"tf":2.6457513110645907},"112":{"tf":2.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":2.23606797749979},"12":{"tf":1.4142135623730951},"120":{"tf":3.605551275463989},"125":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"23":{"tf":2.8284271247461903},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":2.0},"43":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"68":{"tf":2.23606797749979},"69":{"tf":2.0},"70":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"(":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"40":{"tf":1.0}}},"df":0,"docs":{}},"s":{"/":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"d":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":5,"docs":{"66":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":7,"docs":{"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":4,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"69":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"/":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"56":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0}}}}}}},"df":4,"docs":{"11":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"114":{"tf":1.0},"33":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"107":{"tf":1.0}}}}},"d":{"df":3,"docs":{"30":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0}},"k":{"df":3,"docs":{"13":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"70":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"119":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":13,"docs":{"11":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"114":{"tf":2.0},"115":{"tf":1.7320508075688772},"116":{"tf":2.449489742783178},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"36":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"10":{"tf":1.0},"109":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"3":{"df":0,"docs":{},"g":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"107":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"o":{":":{":":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"df":1,"docs":{"7":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"109":{"tf":1.0},"110":{"tf":1.7320508075688772},"112":{"tf":1.0},"16":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":16,"docs":{"109":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"33":{"tf":1.0},"40":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"122":{"tf":1.0},"123":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"54":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"3":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"31":{"tf":1.0},"70":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"18":{"tf":2.23606797749979},"21":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"28":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"x":{"df":3,"docs":{"120":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"40":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"j":{"df":6,"docs":{"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"67":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"109":{"tf":1.0},"122":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"65":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"109":{"tf":1.4142135623730951},"110":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"57":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"df":9,"docs":{"22":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"46":{"tf":2.449489742783178},"48":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":17,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"66":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"46":{"tf":4.242640687119285},"95":{"tf":2.8284271247461903}},"s":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"109":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"66":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0}}},"t":{"df":1,"docs":{"46":{"tf":2.0}}}}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"68":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"122":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":28,"docs":{"10":{"tf":1.7320508075688772},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":2.0},"35":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.7320508075688772},"73":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":2.23606797749979}},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"118":{"tf":1.7320508075688772},"21":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"35":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"1":{"df":1,"docs":{"118":{"tf":1.0}}},"2":{"df":1,"docs":{"118":{"tf":1.0}}},"3":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}}}}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"120":{"tf":1.0},"77":{"tf":1.0}}}}},"u":{"d":{"df":6,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"121":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"115":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.0},"92":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":24,"docs":{"109":{"tf":2.449489742783178},"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":2.23606797749979},"23":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"55":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"66":{"tf":2.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"79":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"d":{"6":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"f":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}}}},"7":{"b":{"df":0,"docs":{},"h":{"df":0,"docs":{},"p":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":20,"docs":{"0":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"114":{"tf":1.0},"116":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}},"df":19,"docs":{"0":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":2.0},"121":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"3":{"tf":2.0},"44":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{},"e":{"(":{"'":{"2":{"0":{"2":{"1":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":11,"docs":{"105":{"tf":1.0},"125":{"tf":1.0},"14":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"48":{"tf":2.449489742783178},"55":{"tf":1.4142135623730951},"64":{"tf":1.0},"72":{"tf":2.449489742783178},"73":{"tf":1.0},"97":{"tf":2.449489742783178}},"o":{"df":0,"docs":{},"f":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"125":{"tf":1.0},"3":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":6,"docs":{"118":{"tf":1.0},"36":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":22,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"115":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.0},"64":{"tf":1.0},"74":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"122":{"tf":1.0},"26":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":2.23606797749979}},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"13":{"tf":1.0},"23":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":19,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"125":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":3.0},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":3.0},"31":{"tf":1.0},"5":{"tf":2.0},"67":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}}},"s":{"c":{"df":3,"docs":{"108":{"tf":2.6457513110645907},"84":{"tf":1.0},"86":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"b":{"df":4,"docs":{"109":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":6,"docs":{"10":{"tf":1.0},"109":{"tf":1.4142135623730951},"121":{"tf":1.0},"124":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"109":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"36":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"/":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"33":{"tf":1.0},"37":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"x":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"0":{".":{"7":{".":{"2":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":8,"docs":{"10":{"tf":1.0},"18":{"tf":2.6457513110645907},"21":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":3.872983346207417},"5":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"3":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"118":{"tf":1.0},"119":{"tf":1.0},"3":{"tf":1.0},"92":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"g":{"df":3,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":14,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"44":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"67":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"112":{"tf":1.0},"122":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"31":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.23606797749979},"12":{"tf":2.0},"13":{"tf":2.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"107":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"o":{"c":{"df":1,"docs":{"84":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"122":{"tf":1.0},"123":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"22":{"tf":1.0},"63":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"119":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"28":{"tf":1.0},"3":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"92":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":14,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"11":{"tf":1.0},"120":{"tf":1.0},"125":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"44":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"109":{"tf":1.0},"115":{"tf":1.0},"26":{"tf":1.0}}}}}}},"c":{"2":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"109":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"120":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":3,"docs":{"107":{"tf":1.0},"2":{"tf":1.4142135623730951},"68":{"tf":1.0}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"70":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"44":{"tf":1.0},"54":{"tf":2.23606797749979},"55":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}}}},"q":{"df":12,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"84":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"107":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"85":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"(":{"_":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"66":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"107":{"tf":1.0},"54":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"109":{"tf":1.4142135623730951},"4":{"tf":1.0},"55":{"tf":1.0}}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"116":{"tf":1.0},"119":{"tf":1.0}},"t":{"df":0,"docs":{},"u":{"df":5,"docs":{"109":{"tf":1.0},"115":{"tf":1.0},"120":{"tf":1.0},"28":{"tf":1.0},"44":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":45,"docs":{"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.7320508075688772},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"113":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"14":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"4":{"tf":2.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":15,"docs":{"109":{"tf":1.0},"118":{"tf":1.4142135623730951},"124":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.7320508075688772},"116":{"tf":1.0},"123":{"tf":2.23606797749979},"34":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"120":{"tf":1.0},"69":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"109":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"79":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"79":{"tf":1.0},"80":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"s":{"df":3,"docs":{"122":{"tf":1.0},"36":{"tf":1.0},"92":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.4142135623730951}}}}}}}},"f":{"3":{"2":{"df":2,"docs":{"49":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}},"s":{"df":5,"docs":{"109":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":1,"docs":{"55":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"118":{"tf":1.0},"124":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{},"w":{"df":2,"docs":{"10":{"tf":1.0},"122":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"123":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.0},"123":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"i":{"d":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":21,"docs":{"103":{"tf":1.7320508075688772},"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"108":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"123":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"124":{"tf":1.0},"30":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"e":{"df":19,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"12":{"tf":1.4142135623730951},"120":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":2.0},"29":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":2.6457513110645907},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"116":{"tf":1.0},"125":{"tf":1.0},"3":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}}},"d":{"df":4,"docs":{"121":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"23":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"120":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"125":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.7320508075688772},"64":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"98":{"tf":2.449489742783178}}}},"df":0,"docs":{},"w":{"df":2,"docs":{"80":{"tf":1.0},"81":{"tf":1.0}}}}},"n":{"df":15,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.4142135623730951},"116":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"23":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"u":{"df":5,"docs":{"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}},"s":{"df":6,"docs":{"120":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":31,"docs":{"105":{"tf":1.0},"108":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":2.0},"75":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":3,"docs":{"58":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}}}},"q":{"a":{"a":{"a":{"df":4,"docs":{"112":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":15,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"113":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}},"n":{"c":{"df":3,"docs":{"112":{"tf":1.0},"24":{"tf":1.0},"69":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":34,"docs":{"109":{"tf":2.23606797749979},"110":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.7320508075688772},"123":{"tf":1.0},"124":{"tf":2.449489742783178},"125":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772},"82":{"tf":2.23606797749979},"83":{"tf":2.23606797749979},"91":{"tf":1.0}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"108":{"tf":1.0},"120":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.0}}}}}}},"g":{"a":{"df":1,"docs":{"55":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}},"b":{"df":2,"docs":{"120":{"tf":1.7320508075688772},"125":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":41,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":2.23606797749979},"36":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":2.23606797749979},"85":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"91":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"t":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":4,"docs":{"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"22":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}}}}}}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"120":{"tf":1.0}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"120":{"tf":1.4142135623730951},"2":{"tf":1.0}}}},"df":6,"docs":{"123":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}},"l":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"107":{"tf":1.0},"119":{"tf":1.0}}}},"o":{"d":{"df":3,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"q":{"df":0,"docs":{},"l":{"df":3,"docs":{"22":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0}}}},"r":{"a":{"b":{"df":2,"docs":{"116":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"h":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":1.0}},"e":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":9,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"122":{"tf":1.0},"15":{"tf":1.0},"66":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"109":{"tf":1.0},"81":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"109":{"tf":1.0},"81":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"109":{"tf":1.0},"81":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":10,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"124":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"21":{"tf":1.0},"24":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.4142135623730951}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"124":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"21":{"tf":1.0},"24":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.0}}},"y":{"(":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"112":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"(":{"\"":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"23":{"tf":1.0}}},"y":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"111":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":50,"docs":{"0":{"tf":2.0},"10":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"11":{"tf":2.0},"110":{"tf":2.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"12":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.23606797749979},"23":{"tf":2.449489742783178},"24":{"tf":1.0},"29":{"tf":2.449489742783178},"3":{"tf":3.0},"30":{"tf":3.3166247903554},"31":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"107":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"28":{"tf":1.0}},"n":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}},"t":{"df":7,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"84":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"df":9,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"48":{"tf":1.0},"84":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.0}},"l":{"df":4,"docs":{"109":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"123":{"tf":2.0},"15":{"tf":1.0},"28":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"55":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"x":{"a":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"98":{"tf":2.23606797749979}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"'":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"'":{"'":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"p":{"df":3,"docs":{"10":{"tf":1.7320508075688772},"116":{"tf":1.0},"37":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":11,"docs":{"109":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0},"54":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"df":10,"docs":{"108":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"124":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}},"h":{"3":{"7":{"a":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}}},"j":{"3":{"7":{"a":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"37":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"120":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}}},"q":{"df":0,"docs":{},"e":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"r":{"7":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":3,"docs":{"19":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"h":{"df":2,"docs":{"20":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0}}}}}}},"df":1,"docs":{"7":{"tf":1.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"/":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"2":{"4":{"9":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"d":{"df":0,"docs":{},"k":{".":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"i":{"3":{"2":{"df":2,"docs":{"51":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}},"c":{"_":{"c":{"d":{"df":0,"docs":{},"k":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"y":{"6":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"111":{"tf":1.0},"23":{"tf":1.0}},"s":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"111":{"tf":1.0},"23":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"111":{"tf":1.0},"23":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"111":{"tf":1.0},"23":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"0":{"tf":1.7320508075688772},"13":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"29":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}},"d":{"(":{"df":0,"docs":{},"i":{"d":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":1.0}}}}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":67,"docs":{"100":{"tf":2.23606797749979},"101":{"tf":2.449489742783178},"102":{"tf":2.449489742783178},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":2.8284271247461903},"106":{"tf":4.898979485566356},"107":{"tf":5.196152422706632},"108":{"tf":3.4641016151377544},"111":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":2.0},"118":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"14":{"tf":2.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":2.449489742783178},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":3.1622776601683795},"58":{"tf":2.6457513110645907},"59":{"tf":2.0},"61":{"tf":2.6457513110645907},"62":{"tf":2.0},"63":{"tf":2.0},"64":{"tf":1.0},"66":{"tf":2.6457513110645907},"67":{"tf":1.0},"68":{"tf":3.3166247903554},"69":{"tf":2.6457513110645907},"72":{"tf":2.449489742783178},"73":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":2.449489742783178},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":5.830951894845301},"86":{"tf":3.1622776601683795},"88":{"tf":3.1622776601683795},"89":{"tf":3.3166247903554},"90":{"tf":3.605551275463989},"91":{"tf":1.4142135623730951},"95":{"tf":2.0},"96":{"tf":1.0},"97":{"tf":2.23606797749979},"98":{"tf":2.23606797749979},"99":{"tf":4.358898943540674}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"109":{"tf":2.449489742783178},"33":{"tf":1.7320508075688772},"37":{"tf":2.0},"43":{"tf":2.0}}}}},"l":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"(":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":2.0}}}}}}},"df":1,"docs":{"40":{"tf":1.4142135623730951}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"120":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":17,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"116":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":22,"docs":{"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"119":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":2.0},"70":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"92":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":17,"docs":{"10":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"15":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":2.0},"40":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"120":{"tf":1.0},"124":{"tf":1.4142135623730951},"23":{"tf":1.0},"44":{"tf":1.7320508075688772},"64":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":3,"docs":{"107":{"tf":1.7320508075688772},"120":{"tf":1.0},"55":{"tf":1.0}}}},"i":{"c":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":12,"docs":{"116":{"tf":1.0},"117":{"tf":1.0},"123":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"9":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}}}},"df":4,"docs":{"82":{"tf":2.0},"83":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":2.23606797749979}},"i":{"df":4,"docs":{"116":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"84":{"tf":1.0},"91":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"125":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":25,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"125":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"52":{"tf":1.0},"84":{"tf":3.3166247903554},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"10":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"7":{"tf":2.6457513110645907}}},"n":{"c":{"df":1,"docs":{"109":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":4,"docs":{"10":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"3":{"2":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":15,"docs":{"100":{"tf":2.449489742783178},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"125":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":1.7320508075688772},"55":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"84":{"tf":2.0},"86":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"34":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"3":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":14,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"109":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"2":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":2.0},"37":{"tf":1.0},"43":{"tf":1.0},"67":{"tf":1.0},"92":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":2,"docs":{"15":{"tf":1.0},"72":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":5,"docs":{"107":{"tf":1.0},"114":{"tf":1.0},"28":{"tf":1.0},"55":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}},"t":{"'":{"df":10,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"118":{"tf":1.0},"3":{"tf":1.0},"73":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"109":{"tf":1.0},"118":{"tf":1.0},"69":{"tf":1.0},"92":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":6,"docs":{"16":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"s":{"df":5,"docs":{"109":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}}}}}}}}}}},"df":9,"docs":{"101":{"tf":1.0},"125":{"tf":1.0},"16":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":2.6457513110645907},"64":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}}},"k":{"3":{"4":{"df":0,"docs":{},"k":{"df":0,"docs":{},"j":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"11":{"tf":1.0},"83":{"tf":1.0}}}},"y":{"df":3,"docs":{"109":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"107":{"tf":1.0},"118":{"tf":1.0},"44":{"tf":1.0},"92":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"16":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":2.0}}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":5,"docs":{"120":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.23606797749979},"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"j":{"df":6,"docs":{"102":{"tf":2.23606797749979},"106":{"tf":1.4142135623730951},"107":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"21":{"tf":1.0},"65":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"33":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"122":{"tf":1.0},"123":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"118":{"tf":1.4142135623730951},"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}},"t":{"'":{"df":5,"docs":{"116":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"125":{"tf":1.4142135623730951},"16":{"tf":1.0},"38":{"tf":1.0}}}}}},"i":{"b":{"df":1,"docs":{"13":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"109":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"38":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}},"t":{"df":1,"docs":{"120":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"df":11,"docs":{"106":{"tf":2.6457513110645907},"107":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"86":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"k":{"df":2,"docs":{"17":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"115":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"5":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":2,"docs":{"4":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":1,"docs":{"46":{"tf":1.7320508075688772}},"i":{"c":{"df":5,"docs":{"112":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":17,"docs":{"10":{"tf":1.4142135623730951},"110":{"tf":1.0},"116":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"113":{"tf":1.0},"115":{"tf":1.0}}}},"t":{"df":5,"docs":{"10":{"tf":1.0},"124":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"69":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"s":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"v":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":8,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"48":{"tf":1.0},"84":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"df":8,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"84":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}},"o":{"df":1,"docs":{"12":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"112":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"120":{"tf":1.0},"123":{"tf":1.0},"65":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":14,"docs":{"10":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.4142135623730951},"12":{"tf":1.0},"123":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.4142135623730951},"55":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":17,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"33":{"tf":1.0},"44":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"65":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":9,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"16":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"40":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{".":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":9,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0}}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"122":{"tf":1.0},"123":{"tf":2.0},"66":{"tf":2.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"y":{"6":{"4":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"66":{"tf":2.0},"68":{"tf":2.449489742783178},"69":{"tf":2.8284271247461903},"77":{"tf":1.4142135623730951}},"e":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}},">":{"(":{"1":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"i":{"d":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"t":{"a":{"df":2,"docs":{"101":{"tf":2.449489742783178},"52":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":2.8284271247461903},"116":{"tf":2.449489742783178},"125":{"tf":1.4142135623730951},"2":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"124":{"tf":1.0},"65":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"j":{"df":1,"docs":{"102":{"tf":1.0}}},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{":":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"112":{"tf":1.0},"24":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{":":{"b":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"s":{":":{":":{"b":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"61":{"tf":1.7320508075688772},"62":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"e":{"df":14,"docs":{"106":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"124":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"1":{"tf":1.0},"3":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"_":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"110":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":2.8284271247461903},"70":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"115":{"tf":1.0},"121":{"tf":1.0},"28":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"2":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":2.449489742783178},"4":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.4142135623730951}}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":37,"docs":{"0":{"tf":1.0},"106":{"tf":1.7320508075688772},"107":{"tf":1.7320508075688772},"108":{"tf":1.7320508075688772},"109":{"tf":2.449489742783178},"118":{"tf":2.0},"119":{"tf":2.0},"120":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"42":{"tf":1.7320508075688772},"46":{"tf":2.0},"48":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":2.23606797749979},"88":{"tf":2.0},"89":{"tf":2.0},"90":{"tf":2.0},"91":{"tf":2.449489742783178}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":2,"docs":{"35":{"tf":1.0},"46":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"33":{"tf":1.0},"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"122":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"36":{"tf":2.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"109":{"tf":1.0},"69":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":22,"docs":{"10":{"tf":1.4142135623730951},"109":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"124":{"tf":1.0},"16":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"72":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"w":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"6":{"tf":1.0},"8":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.0},"66":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"109":{"tf":1.0},"118":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"j":{"df":3,"docs":{"31":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}},"e":{"df":3,"docs":{"122":{"tf":2.0},"66":{"tf":1.7320508075688772},"68":{"tf":2.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"i":{"c":{"df":2,"docs":{"68":{"tf":1.7320508075688772},"69":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":14,"docs":{"112":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"92":{"tf":1.0}}}},"p":{"df":0,"docs":{},"m":{"df":5,"docs":{"30":{"tf":3.3166247903554},"32":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"x":{"df":3,"docs":{"5":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"114":{"tf":1.0},"3":{"tf":1.7320508075688772},"46":{"tf":2.6457513110645907},"55":{"tf":1.0},"75":{"tf":1.0}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"123":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"(":{"_":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"114":{"tf":1.4142135623730951},"116":{"tf":1.0},"122":{"tf":1.4142135623730951},"123":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":32,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":1.0},"116":{"tf":1.7320508075688772},"123":{"tf":1.0},"125":{"tf":1.0},"16":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"50":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":2.23606797749979},"86":{"tf":2.0},"87":{"tf":2.23606797749979},"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"91":{"tf":2.23606797749979}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":2.0},"123":{"tf":2.23606797749979}}}}}}}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"df":8,"docs":{"106":{"tf":1.0},"107":{"tf":2.8284271247461903},"46":{"tf":1.0},"84":{"tf":1.7320508075688772},"86":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}}}}}}},"k":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"122":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":1,"docs":{"66":{"tf":1.0}}},"n":{"c":{"df":8,"docs":{"0":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"125":{"tf":1.0},"13":{"tf":1.0},"29":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0}}},"df":20,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"91":{"tf":1.7320508075688772}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"107":{"tf":1.0},"18":{"tf":1.4142135623730951},"30":{"tf":1.0},"65":{"tf":1.0}}},"r":{"df":8,"docs":{"0":{"tf":1.0},"109":{"tf":1.4142135623730951},"112":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"2":{"tf":1.0},"65":{"tf":1.0}}}},"t":{"df":1,"docs":{"12":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"25":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":2.0},"30":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.7320508075688772},"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}},"df":4,"docs":{"33":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"69":{"tf":1.0}}}}}}},"q":{"4":{"df":0,"docs":{},"n":{"b":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":7,"docs":{"107":{"tf":1.0},"108":{"tf":2.449489742783178},"84":{"tf":1.7320508075688772},"86":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}}}}}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"t":{"df":9,"docs":{"10":{"tf":1.0},"114":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":2,"docs":{"0":{"tf":1.0},"26":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":5,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":4,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"33":{"tf":1.0},"40":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"123":{"tf":2.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"107":{"tf":1.0},"109":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":2.0},"43":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"s":{"df":2,"docs":{"16":{"tf":1.0},"48":{"tf":1.0}}},"t":{"df":8,"docs":{"3":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"33":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"25":{"tf":1.0},"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"55":{"tf":1.0},"56":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":5,"docs":{"109":{"tf":2.23606797749979},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"93":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"122":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"55":{"tf":2.0}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"109":{"tf":1.0},"118":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"109":{"tf":1.0},"115":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"56":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"107":{"tf":1.0},"28":{"tf":1.0},"70":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"92":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"108":{"tf":1.4142135623730951},"115":{"tf":1.0},"120":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":4,"docs":{"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"91":{"tf":1.0}},"e":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":4,"docs":{"123":{"tf":1.0},"30":{"tf":1.0},"55":{"tf":1.0},"83":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"2":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"44":{"tf":1.0},"65":{"tf":1.0},"84":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"40":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"113":{"tf":1.0},"114":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"109":{"tf":1.0},"110":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"120":{"tf":1.0},"3":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"116":{"tf":1.0},"30":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":13,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"120":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":2.23606797749979},"6":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"120":{"tf":1.0},"3":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":6,"docs":{"106":{"tf":1.7320508075688772},"107":{"tf":1.4142135623730951},"29":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"120":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"109":{"tf":1.0}},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"i":{"d":{"df":9,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"3":{"tf":1.0},"31":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"24":{"tf":1.0},"69":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"14":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.0}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"92":{"tf":1.0}}}},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":55,"docs":{"0":{"tf":1.4142135623730951},"100":{"tf":2.23606797749979},"101":{"tf":2.449489742783178},"102":{"tf":2.449489742783178},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":2.23606797749979},"107":{"tf":2.0},"108":{"tf":2.0},"109":{"tf":1.7320508075688772},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"120":{"tf":1.7320508075688772},"124":{"tf":1.7320508075688772},"125":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":2.449489742783178},"19":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"77":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":2.23606797749979},"86":{"tf":2.6457513110645907},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":2.0},"96":{"tf":1.0},"97":{"tf":2.23606797749979},"98":{"tf":2.23606797749979},"99":{"tf":2.449489742783178}}},"y":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":3,"docs":{"22":{"tf":1.0},"34":{"tf":1.0},"48":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"33":{"tf":1.0},"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"10":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"4":{"2":{"df":0,"docs":{},"i":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}},"d":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"122":{"tf":1.0},"123":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}}}}}}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"97":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":1,"docs":{"84":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":2.0},"84":{"tf":2.0}}}}}}}}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"97":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":8,"docs":{"117":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":2.6457513110645907}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"86":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.0}}}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"102":{"tf":1.0},"105":{"tf":1.4142135623730951}}}}}}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":13,"docs":{"106":{"tf":2.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.7320508075688772}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"107":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":1,"docs":{"108":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"100":{"tf":2.23606797749979},"101":{"tf":2.449489742783178},"102":{"tf":2.449489742783178},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"48":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":2.23606797749979},"99":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"105":{"tf":2.0},"84":{"tf":2.0},"86":{"tf":2.0}}}}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":4,"docs":{"106":{"tf":2.449489742783178},"107":{"tf":2.6457513110645907},"123":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":28,"docs":{"0":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"44":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":2.449489742783178},"57":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"59":{"tf":2.23606797749979},"60":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"62":{"tf":2.23606797749979},"63":{"tf":2.449489742783178},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":8,"docs":{"105":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"55":{"tf":2.8284271247461903},"59":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":3,"docs":{"44":{"tf":1.0},"56":{"tf":1.0},"76":{"tf":1.7320508075688772}}}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"109":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":7,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"116":{"tf":1.0},"34":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":3,"docs":{"18":{"tf":2.23606797749979},"25":{"tf":1.0},"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"107":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"4":{"tf":1.0},"65":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"109":{"tf":1.0},"54":{"tf":1.0},"76":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"116":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":14,"docs":{"109":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.0},"4":{"tf":1.4142135623730951},"44":{"tf":1.0},"65":{"tf":2.0},"66":{"tf":2.449489742783178},"67":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"77":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"0":{"df":2,"docs":{"111":{"tf":1.0},"23":{"tf":1.0}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"22":{"tf":1.0},"34":{"tf":1.0},"48":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"111":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951}}}}}},"df":14,"docs":{"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"16":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":5,"docs":{"123":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":26,"docs":{"106":{"tf":2.0},"107":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"122":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"16":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":2.449489742783178},"68":{"tf":2.6457513110645907},"69":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"86":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"124":{"tf":1.0},"3":{"tf":1.0},"84":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"18":{"tf":1.0},"29":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"h":{"df":2,"docs":{"112":{"tf":1.0},"24":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":10,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"18":{"tf":2.8284271247461903},"29":{"tf":1.7320508075688772},"30":{"tf":3.3166247903554},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":1.0},"91":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":27,"docs":{"10":{"tf":1.7320508075688772},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"115":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":2.6457513110645907},"28":{"tf":2.0},"4":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.0},"68":{"tf":2.6457513110645907},"69":{"tf":1.0},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"72":{"tf":1.7320508075688772},"91":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"j":{"df":0,"docs":{},"l":{"3":{"df":7,"docs":{"112":{"tf":1.4142135623730951},"22":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"120":{"tf":1.0},"18":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":11,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"125":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.0},"64":{"tf":2.0},"93":{"tf":1.0},"94":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"120":{"tf":2.6457513110645907},"2":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":42,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":2.0},"112":{"tf":1.0},"114":{"tf":2.23606797749979},"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178},"118":{"tf":1.0},"120":{"tf":1.7320508075688772},"124":{"tf":2.23606797749979},"125":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":2.449489742783178},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.6457513110645907},"85":{"tf":1.0},"86":{"tf":2.0},"87":{"tf":1.0},"88":{"tf":2.0},"89":{"tf":2.0},"90":{"tf":2.0},"91":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"66":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":2.23606797749979}}}}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}},"df":11,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":2.23606797749979},"120":{"tf":1.0},"84":{"tf":1.7320508075688772},"86":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"107":{"tf":1.0},"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"109":{"tf":1.0},"113":{"tf":1.0},"124":{"tf":1.4142135623730951},"22":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}},"n":{"df":1,"docs":{"67":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"106":{"tf":2.23606797749979},"107":{"tf":2.23606797749979},"108":{"tf":1.0},"46":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}}},"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"122":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"f":{"df":1,"docs":{"55":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"16":{"tf":1.0},"21":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"109":{"tf":1.0},"120":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"16":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":19,"docs":{"10":{"tf":1.0},"106":{"tf":2.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"79":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"h":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"v":{"0":{".":{"3":{"8":{".":{"0":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"7":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"e":{"df":3,"docs":{"58":{"tf":2.449489742783178},"59":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"w":{"df":4,"docs":{"123":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0}},"n":{"df":2,"docs":{"114":{"tf":1.0},"7":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":7,"docs":{"56":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772},"63":{"tf":1.0},"76":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"109":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"3":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":12,"docs":{"109":{"tf":1.4142135623730951},"11":{"tf":1.0},"114":{"tf":1.0},"122":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.4142135623730951},"44":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}},"i":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":5,"docs":{"124":{"tf":1.0},"15":{"tf":1.0},"33":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"112":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"118":{"tf":2.449489742783178},"120":{"tf":1.7320508075688772},"125":{"tf":1.0},"2":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.0},"121":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"120":{"tf":1.0},"3":{"tf":1.0},"92":{"tf":1.0}}}},"v":{"df":1,"docs":{"3":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"16":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"110":{"tf":1.0},"112":{"tf":1.0},"30":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":5,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":6,"docs":{"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":5,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"36":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"83":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":2.0},"107":{"tf":1.7320508075688772},"18":{"tf":2.23606797749979},"19":{"tf":1.0},"26":{"tf":1.0},"5":{"tf":1.7320508075688772},"6":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":7,"docs":{"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"26":{"tf":1.0},"83":{"tf":1.0}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"i":{"c":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"120":{"tf":1.0},"125":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"x":{")":{")":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}}},"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":42,"docs":{"101":{"tf":2.449489742783178},"102":{"tf":2.6457513110645907},"105":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"116":{"tf":1.0},"125":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":2.23606797749979},"23":{"tf":1.0},"33":{"tf":1.7320508075688772},"35":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":2.0},"54":{"tf":1.0},"55":{"tf":4.123105625617661},"56":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.7320508075688772},"68":{"tf":2.6457513110645907},"69":{"tf":1.4142135623730951},"72":{"tf":2.23606797749979},"73":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"122":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"117":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}},"t":{"df":4,"docs":{"111":{"tf":1.0},"23":{"tf":1.0},"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"11":{"tf":1.4142135623730951},"114":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"26":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"78":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"125":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"118":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"34":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"d":{"b":{"df":2,"docs":{"122":{"tf":2.0},"123":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"65":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":9,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"122":{"tf":1.0},"15":{"tf":1.0},"66":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"e":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"c":{"_":{"c":{"d":{"df":0,"docs":{},"k":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"112":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"j":{"df":0,"docs":{},"l":{"3":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"6":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"df":2,"docs":{"80":{"tf":1.0},"81":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"114":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"s":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"112":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"68":{"tf":1.0},"80":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"df":2,"docs":{"68":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"o":{"d":{"b":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"122":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":53,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.4142135623730951},"107":{"tf":1.0},"109":{"tf":1.7320508075688772},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":2.0},"119":{"tf":1.0},"120":{"tf":2.23606797749979},"121":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":2.6457513110645907},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":2.23606797749979},"22":{"tf":2.449489742783178},"26":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":2.6457513110645907},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"92":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"109":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"115":{"tf":1.0},"31":{"tf":1.0},"55":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"92":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":7,"docs":{"10":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"34":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":6,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0},"84":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":4,"docs":{"11":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":2.449489742783178},"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"124":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"120":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"120":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"118":{"tf":1.0},"125":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"72":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"69":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":3,"docs":{"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":11,"docs":{"112":{"tf":2.8284271247461903},"16":{"tf":2.449489742783178},"24":{"tf":2.8284271247461903},"63":{"tf":1.0},"66":{"tf":2.23606797749979},"68":{"tf":2.449489742783178},"69":{"tf":3.605551275463989},"73":{"tf":2.0},"77":{"tf":1.4142135623730951},"80":{"tf":2.449489742783178},"81":{"tf":2.449489742783178}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"115":{"tf":1.0},"2":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"11":{"tf":1.0},"29":{"tf":1.0}}},"k":{"df":1,"docs":{"3":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"110":{"tf":1.0},"122":{"tf":1.0},"36":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"124":{"tf":1.0},"3":{"tf":1.0},"65":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"122":{"tf":1.0},"125":{"tf":1.0},"65":{"tf":1.0},"83":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"117":{"tf":1.0},"29":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"120":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"l":{"df":12,"docs":{"105":{"tf":2.0},"106":{"tf":2.0},"107":{"tf":2.0},"108":{"tf":2.8284271247461903},"14":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.0},"86":{"tf":2.0},"88":{"tf":2.0},"89":{"tf":2.0},"90":{"tf":2.0},"97":{"tf":2.23606797749979}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"1":{".":{"2":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"111":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"d":{"df":0,"docs":{},"o":{"df":6,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"13":{"tf":1.0},"55":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"103":{"tf":1.0},"104":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}},"l":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"34":{"tf":1.0},"44":{"tf":1.0}}}},"p":{"df":1,"docs":{"84":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"125":{"tf":1.0},"55":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"p":{"df":2,"docs":{"107":{"tf":1.0},"118":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":1.0}}}},"i":{"df":1,"docs":{"5":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":9,"docs":{"12":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"96":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":11,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"16":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}}},"y":{"a":{"a":{"a":{"df":7,"docs":{"112":{"tf":1.7320508075688772},"22":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":59,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.0},"108":{"tf":1.4142135623730951},"109":{"tf":1.0},"11":{"tf":1.0},"116":{"tf":2.449489742783178},"123":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":3.0},"45":{"tf":1.4142135623730951},"46":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":3.1622776601683795},"56":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"66":{"tf":3.3166247903554},"68":{"tf":3.1622776601683795},"69":{"tf":2.8284271247461903},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":2.449489742783178},"85":{"tf":2.23606797749979},"86":{"tf":2.8284271247461903},"87":{"tf":2.23606797749979},"88":{"tf":2.6457513110645907},"89":{"tf":2.6457513110645907},"90":{"tf":2.6457513110645907},"91":{"tf":2.6457513110645907},"94":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"u":{"4":{"df":0,"docs":{},"i":{"7":{"df":0,"docs":{},"z":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"8":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":2,"docs":{"33":{"tf":1.0},"40":{"tf":1.0}}},"k":{"5":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"37":{"tf":1.0},"77":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"114":{"tf":1.0},"121":{"tf":1.0},"3":{"tf":1.0},"91":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"124":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":1,"docs":{"119":{"tf":1.0}},"n":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":4,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"29":{"tf":1.7320508075688772},"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"120":{"tf":1.0},"23":{"tf":2.449489742783178},"29":{"tf":3.1622776601683795},"30":{"tf":2.0},"5":{"tf":1.4142135623730951},"7":{"tf":2.449489742783178}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"120":{"tf":1.0},"125":{"tf":1.0},"36":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"109":{"tf":1.0},"110":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":17,"docs":{"109":{"tf":2.0},"110":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"23":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":2.23606797749979},"92":{"tf":1.0}},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}}}}}}}}}}}},"df":0,"docs":{}},"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"114":{"tf":1.0},"123":{"tf":1.0},"18":{"tf":1.0},"55":{"tf":1.0},"68":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"113":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}},"s":{".":{".":{".":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":43,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":2.23606797749979},"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"114":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":2.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"33":{"tf":2.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":2.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"1":{"df":1,"docs":{"118":{"tf":1.0}}},"2":{"df":1,"docs":{"118":{"tf":1.0}}},"3":{"df":1,"docs":{"118":{"tf":1.0}}},":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}},"s":{":":{":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"116":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":33,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"116":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"44":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.449489742783178},"86":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"91":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":15,"docs":{"102":{"tf":2.449489742783178},"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"108":{"tf":2.0},"116":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"14":{"tf":1.0},"21":{"tf":1.0},"35":{"tf":2.0},"42":{"tf":2.0},"44":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":13,"docs":{"114":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"69":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"112":{"tf":1.0},"16":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"56":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"4":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"u":{"8":{"df":2,"docs":{"46":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"122":{"tf":1.4142135623730951},"123":{"tf":1.0}}}}},"df":2,"docs":{"122":{"tf":2.23606797749979},"123":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"109":{"tf":1.7320508075688772},"118":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"3":{"tf":1.4142135623730951},"40":{"tf":1.0},"69":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"2":{"tf":2.23606797749979},"3":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":16,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.4142135623730951},"114":{"tf":1.0},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":7,"docs":{"11":{"tf":1.0},"118":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":2.23606797749979}}}},"y":{"df":15,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"110":{"tf":1.0},"2":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"11":{"tf":1.0},"66":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"r":{"df":5,"docs":{"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"v":{"df":4,"docs":{"44":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":2.0}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"92":{"tf":1.0}},"i":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"124":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":10,"docs":{"10":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":1.0},"124":{"tf":1.0},"21":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":22,"docs":{"0":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.7320508075688772},"120":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"75":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":8,"docs":{"120":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":16,"docs":{"112":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":2.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"115":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"65":{"tf":1.0}}}}}}}}},"x":{".":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{"b":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"120":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":9,"docs":{"115":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"r":{"df":1,"docs":{"10":{"tf":1.0}}},"v":{"df":5,"docs":{"18":{"tf":1.0},"28":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"120":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"124":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}}}}}}},"z":{"df":1,"docs":{"12":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"101":{"tf":2.449489742783178}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"0":{".":{"0":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"0":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"2":{"df":3,"docs":{"10":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"'":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"'":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"2":{"2":{":":{"4":{"5":{":":{"4":{"4":{".":{"0":{"0":{"1":{"df":0,"docs":{},"z":{"df":1,"docs":{"97":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"7":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"97":{"tf":2.23606797749979}}},"df":7,"docs":{"106":{"tf":2.6457513110645907},"107":{"tf":2.449489742783178},"108":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"1":{"0":{"0":{"0":{"df":1,"docs":{"120":{"tf":1.0}}},"df":2,"docs":{"120":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"1":{"df":2,"docs":{"46":{"tf":2.449489742783178},"95":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"46":{"tf":2.0}}},"8":{"]":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"46":{"tf":3.3166247903554},"95":{"tf":2.23606797749979}}},"df":8,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":2.0},"107":{"tf":1.4142135623730951},"120":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"1":{"1":{"]":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"4":{"df":1,"docs":{"7":{"tf":1.0}}},"df":5,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":2.23606797749979},"4":{"tf":1.0},"46":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"2":{"0":{"1":{"6":{"df":1,"docs":{"3":{"tf":1.0}}},"8":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":1,"docs":{"97":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":1,"docs":{"100":{"tf":1.0}}},"5":{"df":1,"docs":{"100":{"tf":1.0}}},"c":{"3":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"4":{"tf":1.0}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"z":{"df":0,"docs":{},"t":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"7":{"df":0,"docs":{},"i":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"3":{"0":{"df":1,"docs":{"100":{"tf":1.0}}},"df":3,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"46":{"tf":1.0}}},"4":{"5":{"df":1,"docs":{"100":{"tf":1.0}}},"df":4,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"125":{"tf":1.0}},"j":{"df":0,"docs":{},"h":{"df":0,"docs":{},"f":{"3":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}}}}},"5":{".":{"8":{"df":1,"docs":{"98":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":5,"docs":{"101":{"tf":2.23606797749979},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"106":{"tf":2.449489742783178},"107":{"tf":2.449489742783178}}},"6":{"a":{"a":{"a":{"a":{"df":3,"docs":{"19":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.4142135623730951}},"j":{"df":0,"docs":{},"h":{"df":0,"docs":{},"f":{"3":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}}},"7":{"0":{"df":1,"docs":{"100":{"tf":1.0}}},"5":{"df":0,"docs":{},"s":{"5":{"df":0,"docs":{},"h":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"3":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"106":{"tf":1.0},"107":{"tf":1.4142135623730951}}},"8":{"df":2,"docs":{"106":{"tf":1.0},"107":{"tf":1.4142135623730951}}},"9":{"df":2,"docs":{"106":{"tf":1.0},"107":{"tf":1.7320508075688772}}},"_":{"df":1,"docs":{"123":{"tf":2.0}}},"a":{"a":{"a":{"a":{"a":{"df":12,"docs":{"112":{"tf":2.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{},"q":{"df":4,"docs":{"112":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"5":{"tf":1.0}}}},"b":{"a":{"df":7,"docs":{"112":{"tf":1.7320508075688772},"22":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{},"q":{"df":3,"docs":{"19":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":11,"docs":{"114":{"tf":1.0},"118":{"tf":1.0},"18":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.4142135623730951},"124":{"tf":1.0},"48":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"109":{"tf":1.4142135623730951},"121":{"tf":1.0},"65":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":5,"docs":{"112":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"43":{"tf":1.0},"69":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"3":{"tf":1.0}}}}}}},"df":4,"docs":{"118":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"112":{"tf":1.0},"12":{"tf":1.0},"69":{"tf":1.0},"83":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"124":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":5,"docs":{"100":{"tf":2.23606797749979},"103":{"tf":2.23606797749979},"104":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"109":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":2.0},"39":{"tf":1.4142135623730951},"40":{"tf":2.6457513110645907},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":24,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":2.23606797749979},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":1.0},"125":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"h":{"a":{"/":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"107":{"tf":1.0},"11":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"31":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"106":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"120":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"28":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"18":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"31":{"tf":1.0},"65":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":10,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.4142135623730951},"55":{"tf":1.0},"65":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}},"df":1,"docs":{"75":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"56":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"109":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"107":{"tf":1.0},"46":{"tf":2.449489742783178},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"c":{"df":6,"docs":{"108":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":11,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"124":{"tf":3.4641016151377544}}}}}}},"df":0,"docs":{}}}},"df":21,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":2.0},"122":{"tf":1.0},"123":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"124":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"78":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"109":{"tf":1.7320508075688772},"37":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{":":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":15,"docs":{"105":{"tf":1.4142135623730951},"109":{"tf":3.872983346207417},"110":{"tf":2.449489742783178},"111":{"tf":2.0},"112":{"tf":3.0},"125":{"tf":1.4142135623730951},"14":{"tf":1.0},"2":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"55":{"tf":1.0},"63":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"114":{"tf":1.0},"115":{"tf":2.23606797749979},"116":{"tf":1.7320508075688772},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"30":{"tf":1.4142135623730951},"45":{"tf":1.0},"66":{"tf":1.0},"91":{"tf":1.0}}}},"df":3,"docs":{"115":{"tf":1.0},"118":{"tf":1.0},"125":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":12,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"116":{"tf":1.0},"125":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":11,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0}}}},"r":{"df":1,"docs":{"116":{"tf":1.0}}},"y":{"df":3,"docs":{"124":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"46":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"18":{"tf":2.23606797749979},"5":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{"df":2,"docs":{"61":{"tf":2.449489742783178},"62":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}},"h":{"df":2,"docs":{"30":{"tf":1.0},"7":{"tf":1.0}}},"i":{"c":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"122":{"tf":1.0},"124":{"tf":1.0},"4":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"124":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"109":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"91":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"122":{"tf":1.4142135623730951},"123":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"110":{"tf":1.0},"3":{"tf":1.0}}}},"t":{"a":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"0":{"tf":1.0},"44":{"tf":1.4142135623730951},"56":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"25":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":2.449489742783178},"29":{"tf":1.0},"30":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":7,"docs":{"125":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":3.4641016151377544},"64":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"95":{"tf":2.449489742783178}}},"c":{"df":0,"docs":{},"k":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":2,"docs":{"109":{"tf":1.0},"55":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"123":{"tf":1.0},"55":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":10,"docs":{"105":{"tf":2.449489742783178},"123":{"tf":1.7320508075688772},"14":{"tf":1.7320508075688772},"44":{"tf":2.23606797749979},"55":{"tf":1.7320508075688772},"84":{"tf":2.449489742783178},"86":{"tf":2.0},"88":{"tf":2.0},"89":{"tf":2.23606797749979},"90":{"tf":2.0}},"s":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":2.0}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"107":{"tf":2.0}}}}}}},"r":{"d":{"df":1,"docs":{"108":{"tf":2.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"54":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"47":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":13,"docs":{"125":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":2.0},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.4142135623730951},"91":{"tf":1.0},"96":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"76":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"2":{"tf":1.0},"23":{"tf":2.0},"29":{"tf":2.0},"30":{"tf":3.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"124":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"i":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"8":{"0":{"0":{"0":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":8,"docs":{"112":{"tf":1.7320508075688772},"22":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"l":{"df":23,"docs":{"10":{"tf":1.4142135623730951},"107":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":48,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"109":{"tf":2.23606797749979},"11":{"tf":3.0},"110":{"tf":2.8284271247461903},"112":{"tf":2.0},"113":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":2.0},"119":{"tf":2.449489742783178},"12":{"tf":1.4142135623730951},"120":{"tf":3.872983346207417},"125":{"tf":1.4142135623730951},"13":{"tf":2.0},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"23":{"tf":3.0},"24":{"tf":2.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":2.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":2.0},"43":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"67":{"tf":2.449489742783178},"68":{"tf":2.23606797749979},"69":{"tf":2.0},"70":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":2.23606797749979},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"(":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"40":{"tf":1.0}}},"df":0,"docs":{}},"s":{"/":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"d":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":5,"docs":{"66":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":7,"docs":{"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":4,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"69":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"/":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"56":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":2.0},"13":{"tf":1.0}}}}}}},"df":4,"docs":{"11":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"114":{"tf":1.0},"33":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"107":{"tf":1.0}}}}},"d":{"df":3,"docs":{"30":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0}},"k":{"df":3,"docs":{"13":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"70":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"119":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":13,"docs":{"11":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"114":{"tf":2.0},"115":{"tf":1.7320508075688772},"116":{"tf":2.449489742783178},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"10":{"tf":1.0},"109":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"3":{"df":0,"docs":{},"g":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"107":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"o":{":":{":":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"df":1,"docs":{"7":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"109":{"tf":1.0},"110":{"tf":1.7320508075688772},"112":{"tf":1.0},"16":{"tf":1.4142135623730951},"22":{"tf":2.0},"31":{"tf":2.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":16,"docs":{"109":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"33":{"tf":1.0},"40":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"122":{"tf":1.0},"123":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"54":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"3":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"31":{"tf":1.0},"70":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"18":{"tf":2.23606797749979},"21":{"tf":1.7320508075688772},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"28":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"x":{"df":3,"docs":{"120":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"40":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"j":{"df":6,"docs":{"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"67":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"109":{"tf":1.0},"122":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"65":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"109":{"tf":1.4142135623730951},"110":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"57":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"df":9,"docs":{"22":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"46":{"tf":2.449489742783178},"48":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":17,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"66":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"46":{"tf":4.242640687119285},"95":{"tf":2.8284271247461903}},"s":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"109":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"66":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"46":{"tf":2.0}}}}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"68":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"122":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":28,"docs":{"10":{"tf":1.7320508075688772},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.4142135623730951},"13":{"tf":2.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"35":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.7320508075688772},"73":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":2.6457513110645907}},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"118":{"tf":1.7320508075688772},"21":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"35":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"1":{"df":1,"docs":{"118":{"tf":1.0}}},"2":{"df":1,"docs":{"118":{"tf":1.0}}},"3":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}}}}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"120":{"tf":1.0},"77":{"tf":1.0}}}}},"u":{"d":{"df":6,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"121":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"115":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.0},"92":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":27,"docs":{"109":{"tf":2.449489742783178},"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":1.4142135623730951},"123":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"125":{"tf":2.23606797749979},"23":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"55":{"tf":1.0},"64":{"tf":2.0},"65":{"tf":2.23606797749979},"66":{"tf":2.23606797749979},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":2.0},"79":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"d":{"6":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"f":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}}}},"7":{"b":{"df":0,"docs":{},"h":{"df":0,"docs":{},"p":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":20,"docs":{"0":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"114":{"tf":1.0},"116":{"tf":1.0},"121":{"tf":1.7320508075688772},"122":{"tf":1.4142135623730951},"123":{"tf":1.4142135623730951},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}},"df":19,"docs":{"0":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":2.0},"121":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"3":{"tf":2.0},"44":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{},"e":{"(":{"'":{"2":{"0":{"2":{"1":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":11,"docs":{"105":{"tf":1.0},"125":{"tf":1.0},"14":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"48":{"tf":2.6457513110645907},"55":{"tf":1.4142135623730951},"64":{"tf":1.0},"72":{"tf":2.449489742783178},"73":{"tf":1.0},"97":{"tf":2.6457513110645907}},"o":{"df":0,"docs":{},"f":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"125":{"tf":1.0},"3":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":6,"docs":{"118":{"tf":1.0},"36":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":22,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"115":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.0},"64":{"tf":1.0},"74":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"122":{"tf":1.0},"26":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":2.6457513110645907}},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"13":{"tf":1.0},"23":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":25,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"125":{"tf":1.0},"17":{"tf":2.0},"18":{"tf":3.3166247903554},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":2.449489742783178},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":3.0},"31":{"tf":1.0},"5":{"tf":2.0},"67":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":2.0}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}}},"s":{"c":{"df":3,"docs":{"108":{"tf":2.6457513110645907},"84":{"tf":1.0},"86":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"b":{"df":4,"docs":{"109":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":6,"docs":{"10":{"tf":1.0},"109":{"tf":1.4142135623730951},"121":{"tf":1.0},"124":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"109":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"36":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"/":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"33":{"tf":1.0},"37":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"x":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"0":{".":{"7":{".":{"2":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":8,"docs":{"10":{"tf":1.0},"18":{"tf":2.6457513110645907},"21":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":3.872983346207417},"5":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"3":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"118":{"tf":1.0},"119":{"tf":1.0},"3":{"tf":1.0},"92":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"g":{"df":3,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":17,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"44":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"67":{"tf":1.0},"74":{"tf":2.449489742783178},"75":{"tf":2.23606797749979},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"112":{"tf":1.0},"122":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"31":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.449489742783178},"12":{"tf":2.23606797749979},"13":{"tf":2.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"107":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"o":{"c":{"df":1,"docs":{"84":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"122":{"tf":1.0},"123":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"22":{"tf":1.0},"63":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"119":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"28":{"tf":1.0},"3":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"92":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":14,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"11":{"tf":1.0},"120":{"tf":1.0},"125":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"44":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"109":{"tf":1.0},"115":{"tf":1.0},"26":{"tf":1.0}}}}}}},"c":{"2":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"109":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"13":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"120":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":3,"docs":{"107":{"tf":1.0},"2":{"tf":1.4142135623730951},"68":{"tf":1.0}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"70":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"44":{"tf":1.0},"54":{"tf":2.6457513110645907},"55":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0}}}}},"q":{"df":12,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"84":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"107":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"85":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"(":{"_":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"66":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"107":{"tf":1.0},"54":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"109":{"tf":1.4142135623730951},"4":{"tf":1.0},"55":{"tf":1.0}}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"116":{"tf":1.0},"119":{"tf":1.0}},"t":{"df":0,"docs":{},"u":{"df":5,"docs":{"109":{"tf":1.0},"115":{"tf":1.0},"120":{"tf":1.0},"28":{"tf":1.0},"44":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":45,"docs":{"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.7320508075688772},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"113":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"14":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"4":{"tf":2.449489742783178},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":15,"docs":{"109":{"tf":1.0},"118":{"tf":1.4142135623730951},"124":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"123":{"tf":2.23606797749979},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"120":{"tf":1.0},"69":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"109":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"79":{"tf":1.0},"82":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"79":{"tf":1.0},"83":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"79":{"tf":1.0},"80":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"s":{"df":3,"docs":{"122":{"tf":1.0},"36":{"tf":1.0},"92":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.4142135623730951}}}}}}}},"f":{"3":{"2":{"df":2,"docs":{"49":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}},"s":{"df":5,"docs":{"109":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":1,"docs":{"55":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"118":{"tf":1.0},"124":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{},"w":{"df":2,"docs":{"10":{"tf":1.0},"122":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"123":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.0},"123":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"i":{"d":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":21,"docs":{"103":{"tf":1.7320508075688772},"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"108":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"123":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"124":{"tf":1.0},"30":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"e":{"df":19,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"12":{"tf":1.4142135623730951},"120":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":2.23606797749979},"29":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":2.6457513110645907},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"116":{"tf":1.0},"125":{"tf":1.0},"3":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}}},"d":{"df":4,"docs":{"121":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"23":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"120":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"125":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":2.0},"64":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"98":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"w":{"df":2,"docs":{"80":{"tf":1.0},"81":{"tf":1.0}}}}},"n":{"df":15,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.4142135623730951},"116":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"23":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"u":{"df":5,"docs":{"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}},"s":{"df":6,"docs":{"120":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":31,"docs":{"105":{"tf":1.0},"108":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":2.0},"75":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":3,"docs":{"58":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}}}},"q":{"a":{"a":{"a":{"df":4,"docs":{"112":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":15,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"113":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}},"n":{"c":{"df":3,"docs":{"112":{"tf":1.0},"24":{"tf":1.0},"69":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":34,"docs":{"109":{"tf":2.23606797749979},"110":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.7320508075688772},"123":{"tf":1.0},"124":{"tf":2.449489742783178},"125":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772},"82":{"tf":2.23606797749979},"83":{"tf":2.23606797749979},"91":{"tf":1.0}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"108":{"tf":1.0},"120":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}}},"g":{"a":{"df":1,"docs":{"55":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}},"b":{"df":2,"docs":{"120":{"tf":1.7320508075688772},"125":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":48,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"115":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":2.23606797749979},"36":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":2.6457513110645907},"85":{"tf":1.7320508075688772},"86":{"tf":2.0},"87":{"tf":1.7320508075688772},"88":{"tf":2.0},"89":{"tf":2.0},"90":{"tf":2.0},"91":{"tf":2.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}},"t":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":4,"docs":{"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"22":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}}}}}}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"120":{"tf":1.0}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"120":{"tf":1.4142135623730951},"2":{"tf":1.0}}}},"df":6,"docs":{"123":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}},"l":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"107":{"tf":1.0},"119":{"tf":1.0}}}},"o":{"d":{"df":3,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"q":{"df":0,"docs":{},"l":{"df":3,"docs":{"22":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0}}}},"r":{"a":{"b":{"df":2,"docs":{"116":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"h":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":1.0}},"e":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":9,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"122":{"tf":1.0},"15":{"tf":1.0},"66":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"109":{"tf":1.0},"81":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"109":{"tf":1.0},"81":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"109":{"tf":1.0},"81":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":10,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"124":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"21":{"tf":1.0},"24":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.4142135623730951}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"124":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"21":{"tf":1.0},"24":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.0}}},"y":{"(":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"112":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"(":{"\"":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"23":{"tf":1.0}}},"y":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"111":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":50,"docs":{"0":{"tf":2.0},"10":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"11":{"tf":2.0},"110":{"tf":2.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"12":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":2.449489742783178},"14":{"tf":1.4142135623730951},"18":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.23606797749979},"23":{"tf":2.449489742783178},"24":{"tf":1.0},"29":{"tf":2.449489742783178},"3":{"tf":3.0},"30":{"tf":3.3166247903554},"31":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":2.0},"67":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"107":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"28":{"tf":1.0}},"n":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}},"t":{"df":7,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"84":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"df":9,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"48":{"tf":1.0},"84":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.0}},"l":{"df":4,"docs":{"109":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"123":{"tf":2.0},"15":{"tf":1.0},"28":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"55":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"x":{"a":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"98":{"tf":2.23606797749979}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"'":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"'":{"'":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"p":{"df":3,"docs":{"10":{"tf":1.7320508075688772},"116":{"tf":1.0},"37":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":11,"docs":{"109":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0},"54":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"df":10,"docs":{"108":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"124":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}},"h":{"3":{"7":{"a":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}}},"j":{"3":{"7":{"a":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"37":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"120":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}}},"q":{"df":0,"docs":{},"e":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"r":{"7":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":3,"docs":{"19":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"h":{"df":2,"docs":{"20":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0}}}}}}},"df":1,"docs":{"7":{"tf":1.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"/":{"c":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"d":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"2":{"4":{"9":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"d":{"df":0,"docs":{},"k":{".":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"i":{"3":{"2":{"df":2,"docs":{"51":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}},"c":{"_":{"c":{"d":{"df":0,"docs":{},"k":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"y":{"6":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"111":{"tf":1.0},"23":{"tf":1.0}},"s":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"111":{"tf":1.0},"23":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"111":{"tf":1.0},"23":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"111":{"tf":1.0},"23":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":9,"docs":{"0":{"tf":1.7320508075688772},"13":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"26":{"tf":2.23606797749979},"27":{"tf":1.0},"29":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}},"d":{"(":{"df":0,"docs":{},"i":{"d":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":1.0}}}}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":67,"docs":{"100":{"tf":2.23606797749979},"101":{"tf":2.449489742783178},"102":{"tf":2.449489742783178},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":2.8284271247461903},"106":{"tf":4.898979485566356},"107":{"tf":5.196152422706632},"108":{"tf":3.4641016151377544},"111":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":2.0},"118":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"14":{"tf":2.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":2.6457513110645907},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":3.1622776601683795},"58":{"tf":2.6457513110645907},"59":{"tf":2.0},"61":{"tf":2.6457513110645907},"62":{"tf":2.0},"63":{"tf":2.0},"64":{"tf":1.0},"66":{"tf":2.6457513110645907},"67":{"tf":1.0},"68":{"tf":3.3166247903554},"69":{"tf":2.6457513110645907},"72":{"tf":2.449489742783178},"73":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":2.449489742783178},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":5.830951894845301},"86":{"tf":3.1622776601683795},"88":{"tf":3.1622776601683795},"89":{"tf":3.3166247903554},"90":{"tf":3.605551275463989},"91":{"tf":1.4142135623730951},"95":{"tf":2.0},"96":{"tf":1.0},"97":{"tf":2.23606797749979},"98":{"tf":2.23606797749979},"99":{"tf":4.47213595499958}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"109":{"tf":2.449489742783178},"33":{"tf":1.7320508075688772},"37":{"tf":2.0},"43":{"tf":2.0}}}}},"l":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"(":{"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":2.0}}}}}}},"df":1,"docs":{"40":{"tf":1.4142135623730951}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"120":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":17,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"116":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":22,"docs":{"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"119":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":2.0},"70":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"92":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":17,"docs":{"10":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"15":{"tf":1.7320508075688772},"22":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":2.0},"40":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"120":{"tf":1.0},"124":{"tf":1.4142135623730951},"23":{"tf":1.0},"44":{"tf":1.7320508075688772},"64":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":3,"docs":{"107":{"tf":1.7320508075688772},"120":{"tf":1.0},"55":{"tf":1.0}}}},"i":{"c":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"c":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":12,"docs":{"116":{"tf":1.0},"117":{"tf":1.0},"123":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"9":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}}}},"df":4,"docs":{"82":{"tf":2.0},"83":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":2.6457513110645907}},"i":{"df":4,"docs":{"116":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"84":{"tf":1.0},"91":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"125":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":25,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"125":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"52":{"tf":1.0},"84":{"tf":3.3166247903554},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"10":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":2.0},"39":{"tf":2.0},"5":{"tf":1.4142135623730951},"7":{"tf":2.6457513110645907}}},"n":{"c":{"df":1,"docs":{"109":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":4,"docs":{"10":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"3":{"2":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":15,"docs":{"100":{"tf":2.6457513110645907},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"125":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":2.0},"55":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"84":{"tf":2.0},"86":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"124":{"tf":2.0},"34":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"3":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":14,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"109":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"2":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":2.0},"37":{"tf":1.0},"43":{"tf":1.0},"67":{"tf":1.0},"92":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":2,"docs":{"15":{"tf":1.0},"72":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":5,"docs":{"107":{"tf":1.0},"114":{"tf":1.0},"28":{"tf":1.0},"55":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}},"t":{"'":{"df":10,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"118":{"tf":1.0},"3":{"tf":1.0},"73":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"109":{"tf":1.0},"118":{"tf":1.0},"69":{"tf":1.0},"92":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":6,"docs":{"16":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"s":{"df":8,"docs":{"109":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":2.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}}}}}}}}}}},"df":9,"docs":{"101":{"tf":1.4142135623730951},"125":{"tf":1.0},"16":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":2.8284271247461903},"64":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}}},"k":{"3":{"4":{"df":0,"docs":{},"k":{"df":0,"docs":{},"j":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"11":{"tf":1.0},"83":{"tf":1.0}}}},"y":{"df":3,"docs":{"109":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"107":{"tf":1.0},"118":{"tf":1.0},"44":{"tf":1.0},"92":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"16":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":5,"docs":{"120":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.23606797749979},"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"j":{"df":6,"docs":{"102":{"tf":2.23606797749979},"106":{"tf":1.4142135623730951},"107":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"21":{"tf":1.0},"65":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"33":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"122":{"tf":1.0},"123":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"118":{"tf":1.4142135623730951},"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}},"t":{"'":{"df":5,"docs":{"116":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"125":{"tf":1.4142135623730951},"16":{"tf":1.0},"38":{"tf":1.0}}}}}},"i":{"b":{"df":1,"docs":{"13":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"109":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"38":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}},"t":{"df":1,"docs":{"120":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"df":11,"docs":{"106":{"tf":3.0},"107":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"125":{"tf":2.0},"46":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"86":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}},"k":{"df":2,"docs":{"17":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"115":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":11,"docs":{"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":2,"docs":{"4":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":1,"docs":{"46":{"tf":1.7320508075688772}},"i":{"c":{"df":5,"docs":{"112":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":17,"docs":{"10":{"tf":1.4142135623730951},"110":{"tf":1.0},"116":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"113":{"tf":1.0},"115":{"tf":1.0}}}},"t":{"df":5,"docs":{"10":{"tf":1.0},"124":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"69":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"s":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"v":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":8,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"48":{"tf":1.0},"84":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"df":8,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"84":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}},"o":{"df":1,"docs":{"12":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"112":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"120":{"tf":1.0},"123":{"tf":1.0},"65":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":14,"docs":{"10":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.4142135623730951},"12":{"tf":1.0},"123":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.4142135623730951},"55":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":17,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"33":{"tf":1.0},"44":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"63":{"tf":2.8284271247461903},"65":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":9,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.7320508075688772},"16":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"40":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{".":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":9,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0}}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"122":{"tf":1.0},"123":{"tf":2.0},"66":{"tf":2.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"y":{"6":{"4":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"66":{"tf":2.0},"68":{"tf":2.449489742783178},"69":{"tf":2.8284271247461903},"77":{"tf":1.4142135623730951}},"e":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}},">":{"(":{"1":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"i":{"d":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"t":{"a":{"df":2,"docs":{"101":{"tf":2.449489742783178},"52":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"113":{"tf":1.7320508075688772},"114":{"tf":2.0},"115":{"tf":3.1622776601683795},"116":{"tf":2.8284271247461903},"125":{"tf":1.4142135623730951},"2":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"124":{"tf":1.0},"65":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"j":{"df":1,"docs":{"102":{"tf":1.0}}},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{":":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"112":{"tf":1.0},"24":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{":":{"b":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"s":{":":{":":{"b":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"61":{"tf":1.7320508075688772},"62":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"e":{"df":14,"docs":{"106":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"124":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"1":{"tf":1.7320508075688772},"2":{"tf":1.0},"3":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"_":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"110":{"tf":1.7320508075688772},"112":{"tf":1.7320508075688772},"24":{"tf":2.0},"4":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":3.0},"70":{"tf":1.0},"73":{"tf":1.7320508075688772}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"115":{"tf":1.0},"121":{"tf":1.0},"28":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"119":{"tf":1.7320508075688772},"120":{"tf":1.7320508075688772},"2":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":2.449489742783178},"4":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.4142135623730951}}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":37,"docs":{"0":{"tf":1.0},"106":{"tf":1.7320508075688772},"107":{"tf":1.7320508075688772},"108":{"tf":1.7320508075688772},"109":{"tf":2.449489742783178},"118":{"tf":2.23606797749979},"119":{"tf":2.23606797749979},"120":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":2.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"42":{"tf":2.0},"46":{"tf":2.0},"48":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":2.6457513110645907},"88":{"tf":2.23606797749979},"89":{"tf":2.23606797749979},"90":{"tf":2.23606797749979},"91":{"tf":2.6457513110645907}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":2,"docs":{"35":{"tf":1.0},"46":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"33":{"tf":1.0},"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"122":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"36":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"109":{"tf":1.0},"69":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":22,"docs":{"10":{"tf":1.4142135623730951},"109":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"124":{"tf":1.0},"16":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"72":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"w":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":2.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.0},"66":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"109":{"tf":1.0},"118":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"j":{"df":3,"docs":{"31":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}},"e":{"df":3,"docs":{"122":{"tf":2.0},"66":{"tf":1.7320508075688772},"68":{"tf":2.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"i":{"c":{"df":2,"docs":{"68":{"tf":1.7320508075688772},"69":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":14,"docs":{"112":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"92":{"tf":1.0}}}},"p":{"df":0,"docs":{},"m":{"df":5,"docs":{"30":{"tf":3.3166247903554},"32":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"x":{"df":3,"docs":{"5":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"114":{"tf":1.0},"3":{"tf":1.7320508075688772},"46":{"tf":2.6457513110645907},"55":{"tf":1.0},"75":{"tf":1.0}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"123":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"(":{"_":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"114":{"tf":1.4142135623730951},"116":{"tf":1.0},"122":{"tf":1.4142135623730951},"123":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":32,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":1.0},"116":{"tf":1.7320508075688772},"123":{"tf":1.0},"125":{"tf":1.0},"16":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"50":{"tf":1.0},"55":{"tf":2.449489742783178},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":2.23606797749979},"86":{"tf":2.0},"87":{"tf":2.23606797749979},"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"91":{"tf":2.23606797749979}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":2.0},"123":{"tf":2.449489742783178}}}}}}}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"df":8,"docs":{"106":{"tf":1.0},"107":{"tf":3.1622776601683795},"46":{"tf":1.0},"84":{"tf":1.7320508075688772},"86":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}}}}}}},"k":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"122":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":1,"docs":{"66":{"tf":1.0}}},"n":{"c":{"df":8,"docs":{"0":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"125":{"tf":1.0},"13":{"tf":1.0},"29":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0}}},"df":20,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.6457513110645907},"58":{"tf":1.7320508075688772},"60":{"tf":2.0},"61":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"91":{"tf":1.7320508075688772}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"107":{"tf":1.0},"18":{"tf":1.4142135623730951},"30":{"tf":1.0},"65":{"tf":1.0}}},"r":{"df":10,"docs":{"0":{"tf":1.0},"109":{"tf":1.4142135623730951},"112":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.0},"2":{"tf":1.0},"65":{"tf":1.0}}}},"t":{"df":1,"docs":{"12":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"25":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":2.23606797749979},"29":{"tf":2.449489742783178},"30":{"tf":2.6457513110645907}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.7320508075688772},"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}},"df":4,"docs":{"33":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"69":{"tf":1.0}}}}}}},"q":{"4":{"df":0,"docs":{},"n":{"b":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":7,"docs":{"107":{"tf":1.0},"108":{"tf":2.8284271247461903},"84":{"tf":1.7320508075688772},"86":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}}}}}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"t":{"df":9,"docs":{"10":{"tf":1.0},"114":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":2,"docs":{"0":{"tf":1.0},"26":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":5,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":4,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"33":{"tf":1.0},"40":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"123":{"tf":2.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"107":{"tf":1.0},"109":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":2.0},"43":{"tf":1.0},"66":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"s":{"df":2,"docs":{"16":{"tf":1.0},"48":{"tf":1.0}}},"t":{"df":8,"docs":{"3":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"33":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"25":{"tf":1.0},"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"55":{"tf":1.0},"56":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":5,"docs":{"109":{"tf":2.23606797749979},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"93":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"122":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"55":{"tf":2.0}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"109":{"tf":1.0},"118":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"109":{"tf":1.0},"115":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"56":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"107":{"tf":1.0},"28":{"tf":1.0},"70":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"92":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"108":{"tf":1.4142135623730951},"115":{"tf":1.0},"120":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":4,"docs":{"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"91":{"tf":1.0}},"e":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":4,"docs":{"123":{"tf":1.0},"30":{"tf":1.0},"55":{"tf":1.0},"83":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"2":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"44":{"tf":1.0},"65":{"tf":1.0},"84":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"40":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"113":{"tf":1.0},"114":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"109":{"tf":1.0},"110":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"120":{"tf":1.0},"3":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"116":{"tf":1.0},"30":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":18,"docs":{"10":{"tf":2.6457513110645907},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"120":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":2.449489742783178},"6":{"tf":2.0},"8":{"tf":1.7320508075688772},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"120":{"tf":1.0},"3":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":6,"docs":{"106":{"tf":1.7320508075688772},"107":{"tf":1.4142135623730951},"29":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"120":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"109":{"tf":1.0}},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"i":{"d":{"df":9,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"3":{"tf":1.0},"31":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"24":{"tf":1.0},"69":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"14":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.0}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"92":{"tf":1.0}}}},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":55,"docs":{"0":{"tf":1.4142135623730951},"100":{"tf":2.23606797749979},"101":{"tf":2.449489742783178},"102":{"tf":2.449489742783178},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":2.23606797749979},"107":{"tf":2.0},"108":{"tf":2.0},"109":{"tf":1.7320508075688772},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"120":{"tf":1.7320508075688772},"124":{"tf":1.7320508075688772},"125":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":2.449489742783178},"19":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":2.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"77":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":2.6457513110645907},"86":{"tf":2.8284271247461903},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":2.0},"96":{"tf":1.0},"97":{"tf":2.23606797749979},"98":{"tf":2.23606797749979},"99":{"tf":2.449489742783178}}},"y":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":3,"docs":{"22":{"tf":1.0},"34":{"tf":1.0},"48":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"33":{"tf":1.0},"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"10":{"tf":1.7320508075688772},"5":{"tf":2.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"4":{"2":{"df":0,"docs":{},"i":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}},"d":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"122":{"tf":1.0},"123":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}}}}}}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"97":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":1,"docs":{"84":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":2.0},"84":{"tf":2.0}}}}}}}}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"97":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":8,"docs":{"117":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":3.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"86":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.0}}}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"102":{"tf":1.0},"105":{"tf":1.4142135623730951}}}}}}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":13,"docs":{"106":{"tf":2.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.7320508075688772}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"107":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":1,"docs":{"108":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"100":{"tf":2.23606797749979},"101":{"tf":2.449489742783178},"102":{"tf":2.449489742783178},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"48":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":2.23606797749979},"99":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"105":{"tf":2.0},"84":{"tf":2.0},"86":{"tf":2.0}}}}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":4,"docs":{"106":{"tf":2.449489742783178},"107":{"tf":2.6457513110645907},"123":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":28,"docs":{"0":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"44":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":2.8284271247461903},"57":{"tf":2.0},"58":{"tf":2.0},"59":{"tf":2.449489742783178},"60":{"tf":2.0},"61":{"tf":2.0},"62":{"tf":2.449489742783178},"63":{"tf":2.8284271247461903},"76":{"tf":2.0},"78":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":8,"docs":{"105":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"55":{"tf":2.8284271247461903},"59":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":3,"docs":{"44":{"tf":1.0},"56":{"tf":1.0},"76":{"tf":1.7320508075688772}}}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"109":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":7,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"116":{"tf":1.0},"34":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":3,"docs":{"18":{"tf":2.23606797749979},"25":{"tf":1.0},"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"107":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"4":{"tf":1.0},"65":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"109":{"tf":1.0},"54":{"tf":1.0},"76":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"116":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":18,"docs":{"109":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.0},"4":{"tf":1.4142135623730951},"44":{"tf":1.0},"65":{"tf":2.449489742783178},"66":{"tf":2.8284271247461903},"67":{"tf":2.23606797749979},"68":{"tf":1.0},"69":{"tf":2.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"0":{"df":2,"docs":{"111":{"tf":1.0},"23":{"tf":1.0}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"22":{"tf":1.0},"34":{"tf":1.0},"48":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"111":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951}}}}}},"df":14,"docs":{"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"16":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":5,"docs":{"123":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":26,"docs":{"106":{"tf":2.0},"107":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"122":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"16":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":2.449489742783178},"68":{"tf":2.6457513110645907},"69":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"86":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"124":{"tf":1.0},"3":{"tf":1.0},"84":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772},"18":{"tf":1.0},"29":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"h":{"df":2,"docs":{"112":{"tf":1.0},"24":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":10,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"18":{"tf":2.8284271247461903},"29":{"tf":1.7320508075688772},"30":{"tf":3.3166247903554},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":1.0},"91":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":27,"docs":{"10":{"tf":1.7320508075688772},"110":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":2.8284271247461903},"28":{"tf":2.0},"4":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.0},"68":{"tf":2.8284271247461903},"69":{"tf":1.0},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"72":{"tf":2.0},"91":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"j":{"df":0,"docs":{},"l":{"3":{"df":7,"docs":{"112":{"tf":1.4142135623730951},"22":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"120":{"tf":1.0},"18":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":19,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"125":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"45":{"tf":2.23606797749979},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"64":{"tf":2.449489742783178},"93":{"tf":1.0},"94":{"tf":2.0}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"120":{"tf":3.0},"2":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":83,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.4142135623730951},"109":{"tf":2.0},"112":{"tf":1.0},"114":{"tf":2.23606797749979},"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178},"118":{"tf":1.0},"120":{"tf":1.7320508075688772},"124":{"tf":2.23606797749979},"125":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"44":{"tf":2.6457513110645907},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":2.6457513110645907},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":3.0},"85":{"tf":1.4142135623730951},"86":{"tf":2.23606797749979},"87":{"tf":1.4142135623730951},"88":{"tf":2.23606797749979},"89":{"tf":2.23606797749979},"90":{"tf":2.23606797749979},"91":{"tf":2.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"66":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":2.23606797749979}}}}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}},"df":19,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":1.7320508075688772},"105":{"tf":2.6457513110645907},"120":{"tf":1.0},"84":{"tf":1.7320508075688772},"86":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":2.23606797749979},"94":{"tf":2.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"107":{"tf":1.0},"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"109":{"tf":1.0},"113":{"tf":1.0},"124":{"tf":1.4142135623730951},"22":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}},"n":{"df":1,"docs":{"67":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"106":{"tf":2.23606797749979},"107":{"tf":2.23606797749979},"108":{"tf":1.0},"46":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}}},"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"122":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"f":{"df":1,"docs":{"55":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"16":{"tf":1.0},"21":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"109":{"tf":1.0},"120":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"16":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":19,"docs":{"10":{"tf":1.0},"106":{"tf":2.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"79":{"tf":2.449489742783178},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"h":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"v":{"0":{".":{"3":{"8":{".":{"0":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"7":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"e":{"df":3,"docs":{"58":{"tf":2.449489742783178},"59":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"w":{"df":4,"docs":{"123":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0}},"n":{"df":2,"docs":{"114":{"tf":1.0},"7":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":7,"docs":{"56":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":2.0},"61":{"tf":1.7320508075688772},"62":{"tf":2.0},"63":{"tf":1.0},"76":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"109":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"3":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":12,"docs":{"109":{"tf":1.4142135623730951},"11":{"tf":1.0},"114":{"tf":1.4142135623730951},"122":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.4142135623730951},"44":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}},"i":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":5,"docs":{"124":{"tf":1.0},"15":{"tf":1.0},"33":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"112":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"118":{"tf":2.6457513110645907},"120":{"tf":1.7320508075688772},"125":{"tf":1.0},"2":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.0},"121":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"120":{"tf":1.0},"3":{"tf":1.0},"92":{"tf":1.0}}}},"v":{"df":1,"docs":{"3":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"16":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"110":{"tf":1.0},"112":{"tf":1.0},"30":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":5,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":6,"docs":{"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":5,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"36":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"83":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":14,"docs":{"0":{"tf":1.0},"10":{"tf":2.0},"107":{"tf":1.7320508075688772},"18":{"tf":2.23606797749979},"19":{"tf":1.0},"26":{"tf":1.0},"5":{"tf":2.23606797749979},"6":{"tf":1.7320508075688772},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":7,"docs":{"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"26":{"tf":1.0},"83":{"tf":1.0}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"i":{"c":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"120":{"tf":1.0},"125":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"x":{")":{")":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}}},"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":42,"docs":{"101":{"tf":2.449489742783178},"102":{"tf":2.8284271247461903},"105":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.7320508075688772},"116":{"tf":1.0},"125":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":2.23606797749979},"23":{"tf":1.0},"33":{"tf":1.7320508075688772},"35":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":2.23606797749979},"54":{"tf":1.0},"55":{"tf":4.123105625617661},"56":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.7320508075688772},"68":{"tf":2.6457513110645907},"69":{"tf":1.4142135623730951},"72":{"tf":2.23606797749979},"73":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"122":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"117":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}},"t":{"df":4,"docs":{"111":{"tf":1.0},"23":{"tf":1.0},"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"11":{"tf":1.4142135623730951},"114":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"26":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"78":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"125":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"118":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"34":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"d":{"b":{"df":2,"docs":{"122":{"tf":2.23606797749979},"123":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"65":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":9,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"122":{"tf":1.0},"15":{"tf":1.0},"66":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"e":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"c":{"_":{"c":{"d":{"df":0,"docs":{},"k":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"112":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"j":{"df":0,"docs":{},"l":{"3":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"6":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"df":2,"docs":{"80":{"tf":1.0},"81":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"114":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"s":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"112":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"68":{"tf":1.0},"80":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"df":2,"docs":{"68":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"o":{"d":{"b":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"122":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":58,"docs":{"0":{"tf":2.23606797749979},"10":{"tf":1.4142135623730951},"107":{"tf":1.0},"109":{"tf":1.7320508075688772},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":2.0},"119":{"tf":1.0},"120":{"tf":2.23606797749979},"121":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":2.6457513110645907},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":2.23606797749979},"22":{"tf":2.6457513110645907},"26":{"tf":1.4142135623730951},"31":{"tf":2.0},"32":{"tf":1.7320508075688772},"33":{"tf":2.8284271247461903},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":2.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":2.23606797749979},"8":{"tf":2.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"92":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"109":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"115":{"tf":1.0},"31":{"tf":1.0},"55":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"92":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":7,"docs":{"10":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"34":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":6,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0},"84":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":4,"docs":{"11":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":2.449489742783178},"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"124":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"120":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"120":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"118":{"tf":1.0},"125":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"72":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"69":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":3,"docs":{"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":11,"docs":{"112":{"tf":2.8284271247461903},"16":{"tf":2.449489742783178},"24":{"tf":2.8284271247461903},"63":{"tf":1.0},"66":{"tf":2.23606797749979},"68":{"tf":2.449489742783178},"69":{"tf":3.605551275463989},"73":{"tf":2.0},"77":{"tf":1.4142135623730951},"80":{"tf":2.449489742783178},"81":{"tf":2.449489742783178}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"115":{"tf":1.0},"2":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"11":{"tf":1.0},"29":{"tf":1.0}}},"k":{"df":1,"docs":{"3":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"110":{"tf":1.0},"122":{"tf":1.0},"36":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"124":{"tf":1.0},"3":{"tf":1.0},"65":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"122":{"tf":1.0},"125":{"tf":1.0},"65":{"tf":1.0},"83":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"117":{"tf":1.0},"29":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"120":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"l":{"df":12,"docs":{"105":{"tf":2.0},"106":{"tf":2.0},"107":{"tf":2.0},"108":{"tf":2.8284271247461903},"14":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.0},"86":{"tf":2.0},"88":{"tf":2.0},"89":{"tf":2.0},"90":{"tf":2.0},"97":{"tf":2.23606797749979}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"1":{".":{"2":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"111":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"d":{"df":0,"docs":{},"o":{"df":6,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"13":{"tf":1.0},"55":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"103":{"tf":1.0},"104":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}},"l":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"34":{"tf":1.0},"44":{"tf":1.0}}}},"p":{"df":1,"docs":{"84":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"117":{"tf":2.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"125":{"tf":1.0},"55":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"p":{"df":2,"docs":{"107":{"tf":1.0},"118":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":1.0}}}},"i":{"df":1,"docs":{"5":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":9,"docs":{"12":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"96":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":11,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"16":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"65":{"tf":1.0},"76":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}}},"y":{"a":{"a":{"a":{"df":7,"docs":{"112":{"tf":1.7320508075688772},"22":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":59,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.0},"108":{"tf":1.4142135623730951},"109":{"tf":1.0},"11":{"tf":1.0},"116":{"tf":2.449489742783178},"123":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":3.0},"45":{"tf":1.4142135623730951},"46":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":3.1622776601683795},"56":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"66":{"tf":3.3166247903554},"68":{"tf":3.1622776601683795},"69":{"tf":2.8284271247461903},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":2.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":2.449489742783178},"85":{"tf":2.23606797749979},"86":{"tf":2.8284271247461903},"87":{"tf":2.23606797749979},"88":{"tf":2.6457513110645907},"89":{"tf":2.6457513110645907},"90":{"tf":2.6457513110645907},"91":{"tf":2.6457513110645907},"94":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"u":{"4":{"df":0,"docs":{},"i":{"7":{"df":0,"docs":{},"z":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"8":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":2,"docs":{"33":{"tf":1.0},"40":{"tf":1.0}}},"k":{"5":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"37":{"tf":1.0},"77":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"114":{"tf":1.0},"121":{"tf":1.0},"3":{"tf":1.0},"91":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"124":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":1,"docs":{"119":{"tf":1.0}},"n":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":4,"docs":{"11":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"29":{"tf":1.7320508075688772},"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"120":{"tf":1.0},"23":{"tf":2.449489742783178},"29":{"tf":3.1622776601683795},"30":{"tf":2.0},"5":{"tf":1.4142135623730951},"7":{"tf":2.449489742783178}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"120":{"tf":1.0},"125":{"tf":1.0},"36":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"109":{"tf":1.0},"110":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":17,"docs":{"109":{"tf":2.0},"110":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"23":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":2.6457513110645907},"92":{"tf":1.0}},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}}}}}}}}}}}},"df":0,"docs":{}},"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"114":{"tf":1.0},"123":{"tf":1.0},"18":{"tf":1.0},"55":{"tf":1.0},"68":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"113":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}},"s":{".":{".":{".":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":43,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":2.23606797749979},"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"114":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":2.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"33":{"tf":2.23606797749979},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":2.23606797749979},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"1":{"df":1,"docs":{"118":{"tf":1.0}}},"2":{"df":1,"docs":{"118":{"tf":1.0}}},"3":{"df":1,"docs":{"118":{"tf":1.0}}},":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}},"s":{":":{":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"116":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":33,"docs":{"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"116":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"44":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.449489742783178},"86":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"91":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":15,"docs":{"102":{"tf":2.449489742783178},"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"108":{"tf":2.0},"116":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"14":{"tf":1.0},"21":{"tf":1.0},"35":{"tf":2.0},"42":{"tf":2.0},"44":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":13,"docs":{"114":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"69":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"112":{"tf":1.0},"16":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"56":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"4":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"u":{"8":{"df":2,"docs":{"46":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"122":{"tf":1.4142135623730951},"123":{"tf":1.0}}}}},"df":2,"docs":{"122":{"tf":2.23606797749979},"123":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"109":{"tf":1.7320508075688772},"118":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"3":{"tf":1.4142135623730951},"40":{"tf":1.0},"69":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.7320508075688772},"2":{"tf":2.6457513110645907},"3":{"tf":1.7320508075688772}}}},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":16,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.4142135623730951},"114":{"tf":1.0},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"23":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":8,"docs":{"11":{"tf":1.0},"118":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":2.23606797749979},"29":{"tf":2.449489742783178},"30":{"tf":1.0}}}},"y":{"df":15,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"110":{"tf":1.0},"2":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"11":{"tf":1.0},"66":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"r":{"df":5,"docs":{"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"v":{"df":4,"docs":{"44":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":2.0}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"92":{"tf":1.0}},"i":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"124":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":10,"docs":{"10":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":1.0},"124":{"tf":1.0},"21":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":22,"docs":{"0":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.7320508075688772},"120":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":8,"docs":{"120":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":16,"docs":{"112":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":2.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"115":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"65":{"tf":1.0}}}}}}}}},"x":{".":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{"b":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":3,"docs":{"109":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"120":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":9,"docs":{"115":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"r":{"df":1,"docs":{"10":{"tf":1.0}}},"v":{"df":5,"docs":{"18":{"tf":1.0},"28":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"120":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"124":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}}}}}}},"z":{"df":1,"docs":{"12":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"101":{"tf":2.449489742783178}}}}}}}},"title":{"root":{"a":{"d":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"124":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"115":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"46":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"47":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"110":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"36":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"77":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"31":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":5,"docs":{"121":{"tf":1.0},"124":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"74":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":2,"docs":{"48":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0},"9":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"74":{"tf":1.0},"75":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.0}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"8":{"tf":1.0},"84":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"d":{"df":2,"docs":{"50":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"32":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":2,"docs":{"100":{"tf":1.0},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"124":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"101":{"tf":1.0},"52":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":1.0},"125":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"21":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"116":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"1":{"tf":1.0},"3":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":4,"docs":{"112":{"tf":1.0},"24":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"119":{"tf":1.0},"120":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"118":{"tf":1.0},"119":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"42":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"107":{"tf":1.0}}}}}}},"n":{"df":4,"docs":{"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"108":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}}}},"o":{"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"34":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"85":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"105":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"111":{"tf":1.0},"23":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"45":{"tf":1.0},"64":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":3,"docs":{"14":{"tf":1.0},"44":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"105":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"102":{"tf":1.0},"53":{"tf":1.0}}}}}}},"u":{"b":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"d":{"b":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":6,"docs":{"0":{"tf":1.0},"22":{"tf":1.0},"31":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":2,"docs":{"59":{"tf":1.0},"62":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":2,"docs":{"33":{"tf":1.0},"40":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":3,"docs":{"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});