Object.assign(window.search, {"doc_urls":["sudograph.html#sudograph","quickest-of-quick-starts.html#quickest-of-quick-starts","quick-start.html#quick-start","quick-start.html#prerequisites","quick-start.html#sudograph-generate","quick-start.html#local-deployment","quick-start.html#production-deployment","graphql-database-canister.html#graphql-database-canister","graphql-database-canister.html#rust-wasm-binary-optimization","graphql-database-canister.html#manual-optimization","graphql-database-canister.html#automatic-optimization","sudograph-client.html#sudograph-client","schema.html#schema","schema-scalars.html#scalars","schema-scalars.html#boolean","schema-scalars.html#date","schema-scalars.html#float","schema-scalars.html#id","schema-scalars.html#int","schema-scalars.html#string","schema-objects.html#objects","schema-relations.html#relations","schema-relations.html#one-to-one-relations","schema-relations.html#one-sided","schema-relations.html#two-sided","schema-relations.html#one-to-many-relations","schema-relations.html#one-sided","schema-relations.html#two-sided","schema-relations.html#many-to-many-relations","schema-custom-scalars.html#custom-scalars","schema-custom-resolvers.html#custom-resolvers","schema-sudograph-settings.html#sudograph-settings","generated-schema.html#generated-schema","query.html#query","read.html#read","mutation.html#mutation","create.html#create","update.html#update","delete.html#delete","subscription.html#subscription","filtering.html#filtering","paging.html#paging","ordering.html#ordering","examples.html#examples","migrations.html#migrations","transactions.html#transactions","transactions.html#single-canister-mutations","transactions.html#multi-canister-mutations","vision.html#vision","motivation.html#motivation","limitations.html#limitations","multi-canister-scaling.html#multi-canister-scaling"],"index":{"documentStore":{"docInfo":{"0":{"body":54,"breadcrumbs":2,"title":1},"1":{"body":58,"breadcrumbs":6,"title":3},"10":{"body":138,"breadcrumbs":5,"title":2},"11":{"body":12,"breadcrumbs":4,"title":2},"12":{"body":104,"breadcrumbs":2,"title":1},"13":{"body":16,"breadcrumbs":3,"title":1},"14":{"body":11,"breadcrumbs":3,"title":1},"15":{"body":14,"breadcrumbs":3,"title":1},"16":{"body":11,"breadcrumbs":3,"title":1},"17":{"body":17,"breadcrumbs":3,"title":1},"18":{"body":11,"breadcrumbs":3,"title":1},"19":{"body":11,"breadcrumbs":3,"title":1},"2":{"body":0,"breadcrumbs":4,"title":2},"20":{"body":146,"breadcrumbs":3,"title":1},"21":{"body":12,"breadcrumbs":3,"title":1},"22":{"body":9,"breadcrumbs":5,"title":3},"23":{"body":45,"breadcrumbs":4,"title":2},"24":{"body":37,"breadcrumbs":4,"title":2},"25":{"body":9,"breadcrumbs":5,"title":3},"26":{"body":54,"breadcrumbs":4,"title":2},"27":{"body":43,"breadcrumbs":4,"title":2},"28":{"body":43,"breadcrumbs":5,"title":3},"29":{"body":15,"breadcrumbs":5,"title":2},"3":{"body":86,"breadcrumbs":3,"title":1},"30":{"body":137,"breadcrumbs":5,"title":2},"31":{"body":26,"breadcrumbs":5,"title":2},"32":{"body":41,"breadcrumbs":4,"title":2},"33":{"body":33,"breadcrumbs":4,"title":1},"34":{"body":33,"breadcrumbs":5,"title":1},"35":{"body":33,"breadcrumbs":4,"title":1},"36":{"body":33,"breadcrumbs":5,"title":1},"37":{"body":33,"breadcrumbs":5,"title":1},"38":{"body":33,"breadcrumbs":5,"title":1},"39":{"body":1,"breadcrumbs":4,"title":1},"4":{"body":18,"breadcrumbs":4,"title":2},"40":{"body":33,"breadcrumbs":4,"title":1},"41":{"body":1,"breadcrumbs":4,"title":1},"42":{"body":1,"breadcrumbs":4,"title":1},"43":{"body":33,"breadcrumbs":2,"title":1},"44":{"body":77,"breadcrumbs":2,"title":1},"45":{"body":9,"breadcrumbs":2,"title":1},"46":{"body":100,"breadcrumbs":4,"title":3},"47":{"body":40,"breadcrumbs":4,"title":3},"48":{"body":3,"breadcrumbs":2,"title":1},"49":{"body":3,"breadcrumbs":2,"title":1},"5":{"body":155,"breadcrumbs":4,"title":2},"50":{"body":54,"breadcrumbs":2,"title":1},"51":{"body":97,"breadcrumbs":6,"title":3},"6":{"body":31,"breadcrumbs":4,"title":2},"7":{"body":364,"breadcrumbs":6,"title":3},"8":{"body":47,"breadcrumbs":7,"title":4},"9":{"body":100,"breadcrumbs":5,"title":2}},"docs":{"0":{"body":"Sudograph is a GraphQL database for the Internet Computer (IC). Its goal is to become the simplest way to develop applications for the IC. Developers start by defining a GraphQL schema using the GraphQL SDL . Once the schema is defined, it can be included within a canister and deployed to the IC. An entire relational database is generated from the schema, with GraphQL queries and mutations enabling a variety of CRUD operations, including advanced querying over relational data. Sudograph should be considered somewhere between alpha and beta software.","breadcrumbs":"Sudograph » Sudograph","id":"0","title":"Sudograph"},"1":{"body":"If you've already got Node.js, npm, Rust, the wasm32-unknown-unknown Rust compilation target, and dfx 0.7.0 installed then just run the following commands: mkdir my-new-project\ncd my-new-project\nnpx sudograph\ndfx start --background\ndfx deploy Once deployed, you can visit the following canisters from a Chromium browser: playground: http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 frontend: http://rrkah-fqaaa-aaaaa-aaaaq-cai.localhost:8000 If the above did not work, try the full installation steps in the actual quick start.","breadcrumbs":"Quickest of quick starts » Quickest of quick starts","id":"1","title":"Quickest of quick starts"},"10":{"body":"It can be tedious to have to run the above command manually after each dfx deploy. If you wish to figure out how to use cargo scripts of some kind you can do that. You could also use make or bash or some other build process or scripting system. Another way is to adopt npm scripts. Your package.json could look something like this: { \"scripts\": { \"build\": \"cd canisters/playground && npm install && npm run build && cd ../frontend && npm install && npm run build\", \"dfx-deploy\": \"npm run dfx-build-graphql && npm run dfx-optimize-graphql && dfx deploy\", \"dfx-deploy-graphql\": \"npm run dfx-build-graphql && npm run dfx-optimize-graphql && dfx deploy graphql\", \"dfx-build-graphql\": \"cargo build --target wasm32-unknown-unknown --package graphql --release\", \"dfx-optimize-graphql\": \"./target/bin/ic-cdk-optimizer ./target/wasm32-unknown-unknown/release/graphql.wasm -o ./target/wasm32-unknown-unknown/release/graphql-optimised.wasm\" }\n} Then instead of running dfx deploy or dfx deploy graphql you would run npm run dfx-deploy or npm run dfx-deploy-graphql. In the future it would be nice for the dfx.json to allow for some sort of build scripts, which would make this process less messy. There is an open forum post about this here: https://forum.dfinity.org/t/dfx-json-build-scripts/4922","breadcrumbs":"GraphQL database canister » Automatic optimization","id":"10","title":"Automatic optimization"},"11":{"body":"This is not yet well-documented. You can look at the examples to see how to use it in a JavaScript frontend. npm install sudograph and go from there.","breadcrumbs":"Sudograph Client » Sudograph Client","id":"11","title":"Sudograph Client"},"12":{"body":"The schema is where you define all of the data types of your application, including relations between types. It is also where you will eventually define many other settings, possibly including authentication, authorization, subnet, and Sudograph-specific settings. An example schema might look like this: type User { id: ID! username: String! blogPosts: [BlogPost!]! @relation(name: \"User:blogPosts and BlogPost:author\")\n} type BlogPost { id: ID! publishedAt: Date title: String! author: User! @relation(name: \"User:blogPosts and BlogPost:author\")\n} We have told Sudograph that we have two object types, User and BlogPost. We've described the fields of each type, using some included scalar types such as ID, Date, and String. We have also described one relation between our two types, a one-to-many relationship from User to BlogPost on the fields User:blogPosts and BlogPost:author. The schema is an incredibly powerful yet simple tool for defining the complex data types of your application. Get to know the possibilities of your schema: Scalars Objects Relations Custom scalars Custom resolvers Sudograph settings","breadcrumbs":"Schema » Schema","id":"12","title":"Schema"},"13":{"body":"Scalar types are not divisible, they have no fields of their own. The scalar types automatically available to you in a Sudograph schema are: Boolean Date Float ID Int String","breadcrumbs":"Schema » Scalars » Scalars","id":"13","title":"Scalars"},"14":{"body":"A Boolean value maps to a Rust bool. type User { id: ID! verified: Boolean!\n}","breadcrumbs":"Schema » Scalars » Boolean","id":"14","title":"Boolean"},"15":{"body":"A Date value maps to a Rust String for storage and a chrono::DateTime for filtering. type User { id: ID! dateOfBirth: Date!\n}","breadcrumbs":"Schema » Scalars » Date","id":"15","title":"Date"},"16":{"body":"A Float value maps to a Rust f32. type User { id: ID! height: Float!\n}","breadcrumbs":"Schema » Scalars » Float","id":"16","title":"Float"},"17":{"body":"An ID value maps to a Rust String. All Sudograph object types must have a field called id of type ID. type User { id: ID!\n}","breadcrumbs":"Schema » Scalars » ID","id":"17","title":"ID"},"18":{"body":"An Int value maps to a Rust i32. type User { id: ID! age: Int!\n}","breadcrumbs":"Schema » Scalars » Int","id":"18","title":"Int"},"19":{"body":"A String value maps to a Rust String. type User { id: ID! username: String!\n}","breadcrumbs":"Schema » Scalars » String","id":"19","title":"String"},"2":{"body":"","breadcrumbs":"Quick start » Quick start","id":"2","title":"Quick start"},"20":{"body":"Object types have fields that may be other object types or scalar types. Object types allow you to define the truly custom data types and relations that make up your application. You could model a user with blog posts like so: type User { id: ID! username: String! blogPosts: [BlogPost!]! @relation(name: \"User:blogPosts and BlogPost:author\")\n} type BlogPost { id: ID! publishedAt: Date title: String! author: User! @relation(name: \"User:blogPosts and BlogPost:author\")\n} You could model a family tree like so: type Person { id: ID! firstName: String! lastName: String! father: Person @relation(name: \"Person:father and Person:children\") mother: Person @relation(name: \"Person:mother and Person:children\") children: [Person!]! @relation(name: \"Person:father and Person:children\") @relation(name: \"Person:mother and Person:children\")\n} TODO the example above will not work yet TODO the self-referencing has some issues and multiple @relation directives per field is not yet supported You could model Ethereum block data like so: type Block { id: ID! number: Int! hash: String! parent: Block transactionsRoot: String! transactionCount: Int! stateRoot: String! gasLimit: String! gasUsed: String! timestamp: Date! transactions: [Transaction!]! @relation(name: \"Block:transactions and Transaction:block\")\n} type Transaction { id: ID! hash: String! index: Int! from: String! to: String! value: String! gasPrice: String! gas: String! inputData: String! block: Block! @relation(name: \"Block:transactions and Transaction:block\") gasUsed: String!\n}","breadcrumbs":"Schema » Objects » Objects","id":"20","title":"Objects"},"21":{"body":"Relations allow you to describe the relationships between object types and their fields. Sudograph has a variety of relation capabilities:","breadcrumbs":"Schema » Relations » Relations","id":"21","title":"Relations"},"22":{"body":"One-to-one relations allow you to connect one object with another object.","breadcrumbs":"Schema » Relations » One-to-one relations","id":"22","title":"One-to-one relations"},"23":{"body":"If you only care about retrieving relation information from one side of the relation, you don't need a @relation directive: type Foot { id: ID! shoe: Shoe\n} type Shoe { id: ID!\n} In the above example, you will be able to select the shoe of a foot, like so: query { readFoot(search: { id: { eq: \"7c3nrr-6jhf3-2gozt-hh37a-d6nvf-lsdwv-d7bhp-uk5nt-r42y\" } }) { id shoe { id } }\n} You will not be able to select the foot of a shoe.","breadcrumbs":"Schema » Relations » One-sided","id":"23","title":"One-sided"},"24":{"body":"If you care about retrieving relation information from both sides of the relation, add a @relation directive. The name argument of the @relation directive can be arbitrary, but it must be the same on both sides of the relation. type Foot { id: ID! shoe: Shoe @relation(name: \"Foot:shoe and Shoe:foot\")\n} type Shoe { id: ID! foot: Foot @relation(name: \"Foot:shoe and Shoe:foot\")\n}","breadcrumbs":"Schema » Relations » Two-sided","id":"24","title":"Two-sided"},"25":{"body":"One-to-many relations allow you to connect one object with multiple other objects.","breadcrumbs":"Schema » Relations » One-to-many relations","id":"25","title":"One-to-many relations"},"26":{"body":"If you only care about retrieving relation information from one side of the relation, you don't need a @relation directive: type Monkey { id: ID! name: String! bananas: [Banana!]!\n} type Banana { id: ID! color: String! size: Int!\n} In the above example, you will be able to select the bananas of a monkey, like so: query { readMonkey(search: { id: { eq: \"7c3nrr-6jhf3-2gozt-hh37a-d6nvf-lsdwv-d7bhp-uk5nt-r42y\" } }) { id name bananas { id color size } }\n} You will not be able to select the monkey of a banana.","breadcrumbs":"Schema » Relations » One-sided","id":"26","title":"One-sided"},"27":{"body":"If you care about retrieving relation information from both sides of the relation, add a @relation directive. The name argument of the @relation directive can be arbitrary, but it must be the same on both sides of the relation. type Monkey { id: ID! name: String! bananas: [Banana!]! @relation(name: \"Monkey:bananas and Banana:monkey\")\n} type Banana { id: ID! color: String! size: Int! monkey: Monkey @relation(name: \"Monkey:bananas and Banana:monkey\")\n}","breadcrumbs":"Schema » Relations » Two-sided","id":"27","title":"Two-sided"},"28":{"body":"Many-to-many relations allow you to connect multiple objects with multiple other objects. Many-to-many relations must have a @relation directive. The name argument of the @relation directive can be arbitrary, but it must be the same on both sides of the relation. type Author { id: ID! documents: [Document!]! @relation(name: \"Author:documents and Document:authors\")\n} type Document { id: ID! text: String! authors: [Author!]! @relation(name: \"Author:documents and Document:authors\")\n}","breadcrumbs":"Schema » Relations » Many-to-many relations","id":"28","title":"Many-to-many relations"},"29":{"body":"Custom scalars (scalars that you define) are not yet supported. You'll have to work with the included scalars: Boolean Date Float ID Int String","breadcrumbs":"Schema » Custom scalars » Custom scalars","id":"29","title":"Custom scalars"},"3":{"body":"You should have the following installed on your system: Node.js npm Rust wasm32-unknown-unknown Rust compilation target dfx 0.7.0 If you already have the above installed, you can skip to Sudograph generate . Run the following commands to install Node.js and npm. nvm is highly recommended and its use is shown below: curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.38.0/install.sh | bash # restart your terminal nvm install 14 Run the following command to install Rust and the wasm32-unknown-unknown target: curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh rustup target add wasm32-unknown-unknown Run the following command to install dfx 0.7.0: # Sudograph has been tested against version 0.7.0, so it is safest to install that specific version for now\nDFX_VERSION=0.7.0 sh -ci \"$(curl -fsSL https://sdk.dfinity.org/install.sh)\"","breadcrumbs":"Quick start » Prerequisites","id":"3","title":"Prerequisites"},"30":{"body":"Custom resolvers where the resolver function is defined within the same Rust canister as the graphql_database macro are possible now, but not well-documented. See the intermediate example for a very rough overview of how to achieve this. Custom resolvers where the resolver function is defined in a separate canister (be it written in Rust, Motoko, AssemblyScript, or any other language) are also supported. For now you will need to write a custom resolver in Rust that does a cross-canister call to the resolver in the separate canister. This is not well-documented but is possible. In the future, the plan is for those types of custom resolvers to be defined only in the schema so that no Rust code is required. It will look like this: # schema.graphql type Query { myCustomQueryResolver(param1: Int!): Boolean! @canister(id: \"renrk-eyaaa-aaaaa-aaada-cai\")\n} type Mutation { myCustomMutationResolver(param1: Float!): String! @canister(id: \"rdmx6-jaaaa-aaaaa-aaadq-cai\")\n} Defining the above Query and Mutation object types in your schema would generate two custom resolver functions in the Rust canister where the graphql_database macro is used. These resolver functions would perform cross-canister calls to a canister with the id defined in the @canister directive. You would then need to define myCustomQueryResolver with the appropriate parameters and return type in the renrk-eyaaa-aaaaa-aaada-cai canister, and myCustomMutationResolver with the appropriate parameters and return type in the rdmx6-jaaaa-aaaaa-aaadq-cai canister.","breadcrumbs":"Schema » Custom resolvers » Custom resolvers","id":"30","title":"Custom resolvers"},"31":{"body":"There will be many settings that Sudograph will allow the developer to customize. Currently however, none of these settings are possible to change. But here is how it might eventually look to change settings: type SudographSettings { exportGeneratedGraphQLQueryFunction: false exportGenerateGraphQLMutationFunction: true exportGeneratedInitFunction: true exportGeneratedPostUpgradeFunction: false\n}","breadcrumbs":"Schema » Sudograph settings » Sudograph settings","id":"31","title":"Sudograph settings"},"32":{"body":"Sudograph takes your schema and generates a much more powerful schema. This section is not yet well-documented, but assuming you've generated an example project with npx sudograph and deployed your canisters, then navigate to the playground at http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 in a Chromium browser and click the Docs button in the top right corner. That documentation explains everything that you can do with your newly generated schema.","breadcrumbs":"Generated schema » Generated Schema","id":"32","title":"Generated Schema"},"33":{"body":"This section is not yet well-documented, but assuming you've generated an example project with npx sudograph and deployed your canisters, then navigate to the playground at http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 in a Chromium browser and click the Docs button in the top right corner. That documentation explains everything that you can do with your newly generated schema.","breadcrumbs":"Generated schema » Query » Query","id":"33","title":"Query"},"34":{"body":"This section is not yet well-documented, but assuming you've generated an example project with npx sudograph and deployed your canisters, then navigate to the playground at http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 in a Chromium browser and click the Docs button in the top right corner. That documentation explains everything that you can do with your newly generated schema.","breadcrumbs":"Generated schema » Query » read » read","id":"34","title":"read"},"35":{"body":"This section is not yet well-documented, but assuming you've generated an example project with npx sudograph and deployed your canisters, then navigate to the playground at http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 in a Chromium browser and click the Docs button in the top right corner. That documentation explains everything that you can do with your newly generated schema.","breadcrumbs":"Generated schema » Mutation » Mutation","id":"35","title":"Mutation"},"36":{"body":"This section is not yet well-documented, but assuming you've generated an example project with npx sudograph and deployed your canisters, then navigate to the playground at http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 in a Chromium browser and click the Docs button in the top right corner. That documentation explains everything that you can do with your newly generated schema.","breadcrumbs":"Generated schema » Mutation » create » create","id":"36","title":"create"},"37":{"body":"This section is not yet well-documented, but assuming you've generated an example project with npx sudograph and deployed your canisters, then navigate to the playground at http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 in a Chromium browser and click the Docs button in the top right corner. That documentation explains everything that you can do with your newly generated schema.","breadcrumbs":"Generated schema » Mutation » update » update","id":"37","title":"update"},"38":{"body":"This section is not yet well-documented, but assuming you've generated an example project with npx sudograph and deployed your canisters, then navigate to the playground at http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 in a Chromium browser and click the Docs button in the top right corner. That documentation explains everything that you can do with your newly generated schema.","breadcrumbs":"Generated schema » Mutation » delete » delete","id":"38","title":"delete"},"39":{"body":"This is not yet implemented","breadcrumbs":"Generated schema » Subscription » Subscription","id":"39","title":"Subscription"},"4":{"body":"Start by making a new directory for your project. You then simply run the sudograph generate command: mkdir my-new-project cd my-new-project npx sudograph","breadcrumbs":"Quick start » Sudograph generate","id":"4","title":"Sudograph generate"},"40":{"body":"This section is not yet well-documented, but assuming you've generated an example project with npx sudograph and deployed your canisters, then navigate to the playground at http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 in a Chromium browser and click the Docs button in the top right corner. That documentation explains everything that you can do with your newly generated schema.","breadcrumbs":"Generated schema » Filtering » Filtering","id":"40","title":"Filtering"},"41":{"body":"Not yet implemented","breadcrumbs":"Generated schema » Paging » Paging","id":"41","title":"Paging"},"42":{"body":"Not yet implemented","breadcrumbs":"Generated schema » Ordering » Ordering","id":"42","title":"Ordering"},"43":{"body":"This section is not yet well-documented, but assuming you've generated an example project with npx sudograph and deployed your canisters, then navigate to the playground at http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 in a Chromium browser and click the Docs button in the top right corner. That documentation explains everything that you can do with your newly generated schema.","breadcrumbs":"Examples » Examples","id":"43","title":"Examples"},"44":{"body":"Automated migrations are not currently supported. If you wish to update a Sudograph canister that has already been deployed, you will lose all of your saved data unless you implement your own migrations. You can implement your own migrations by implementing and exporting pre_upgrade and post_upgrade canister functions. You can save your state to stable memory in the pre_upgrade function, and restore that state in the post_upgrade function. See here and here for more information. The plan is to eventually automate migrations as much as possible. If you change your schema and wish to update it on a live canister, Sudograph will generate migrations written in Rust to accomplish the migration for you. If a migration cannot be performed automatically, Sudograph will allow you to easily define your own migration code in Rust. That's the rough plan for now. But until then, you're on your own. Good luck soldier.","breadcrumbs":"Migrations » Migrations","id":"44","title":"Migrations"},"45":{"body":"Sudograph does not have a strong guarantee of atomicity (transactions) at this time. Read on for more information.","breadcrumbs":"Transactions » Transactions","id":"45","title":"Transactions"},"46":{"body":"Within a single update call, transactions are automatically handled by the Internet Computer itself! If there are any errors (technically Wasm traps) all state changes are undone and thus not persisted. This is a very nice feature of single canister development. If you don't know already you need to know that the schema that Sudograph generates for you is limited to a single canister by default. If you need to scale across canisters, you will need to write custom code. Unfortunately, Sudograph does not currently guarantee that all errors will lead to traps that undo all state changes. It should not be too difficult to add, but currently you do not have a guarantee that all mutations within a single update call will be executed atomically. Once Sudograph ensures all errors will lead to traps, you will be able to ensure atomicity by executing many mutations within a single update call like this: mutation { createUser1: createUser(input: { username: \"user1\" }) { id } createUser2: createUser(input: { username: \"user2\" }) { id } createUser3: createUser(input: { username: \"user3\" }) { id }\n} All of the mutations above will either all succeed or all fail.","breadcrumbs":"Transactions » Single canister mutations","id":"46","title":"Single canister mutations"},"47":{"body":"Even if you batch many mutations into one update call, if any of your mutations are custom and call into other canisters, the atomic guarantees are gone. This will be more difficult for Sudograph to implement because the Internet Computer does not provide atomicity when doing multi-canister updates. If you need transactions across multiple canisters, you will need to write custom code that undoes state changes across all canisters in a chain of mutations.","breadcrumbs":"Transactions » Multi-canister mutations","id":"47","title":"Multi-canister mutations"},"48":{"body":"Not yet well-documented, sheesh!","breadcrumbs":"Vision » Vision","id":"48","title":"Vision"},"49":{"body":"Not yet well-documented, sheesh!","breadcrumbs":"Motivation » Motivation","id":"49","title":"Motivation"},"5":{"body":"Start up an IC replica and deploy: # Open a terminal and run the following command to start a local IC replica\ndfx start # Alternatively to the above command, you can run the replica in the background\ndfx start --background # If you are running the replica in the background, you can run this command within the same terminal as the dfx start --background command\n# If you are not running the replica in the background, then open another terminal and run this command from the root directory of your project\ndfx deploy Make sure to run dfx deploy for your first deploy. For quicker deployments after the first, you can run dfx deploy graphql if you've only changed your schema or the Rust code within the graphql canister. dfx deploy graphql will only deploy the graphql canister, which contains the generated database. playground canister Start executing GraphQL queries and mutations against your database by going to the following URL in a Chromium browser: http://r7inp-6aaaa-aaaaa-aaabq-cai.localhost:8000 . frontend canister View a simple frontend application that communicates with the graphql canister by going to the following URL in a Chromium browser: http://rrkah-fqaaa-aaaaa-aaaaq-cai.localhost:8000 . graphql canister You can execute queries against the graphql canister from the command line if you wish: # send a query to the graphql canister\ndfx canister call graphql graphql_query '(\"query { readUser { id } }\", \"{}\")' # send a mutation to the graphql canister\ndfx canister call graphql graphql_mutation '(\"mutation { createUser(input: { username: \\\"lastmjs\\\" }) { id } }\", \"{}\")'","breadcrumbs":"Quick start » Local deployment","id":"5","title":"Local deployment"},"50":{"body":"No paging or ordering of records No custom scalars, only Int, Float, String, ID, Boolean, and Date are available Filtering is limited to the top level selection set Limited to a single canister ~4GB of storage Very inneficient querying, be careful once you get into the 100,000s or 1,000,000s of records No automatic migrations, once you deploy the schema is final unless you implement your own migrations No authorization at the schema level, deal with it through your own custom authorization at the canister function level No automated tests No subscriptions No transactions","breadcrumbs":"Limitations » Limitations","id":"50","title":"Limitations"},"51":{"body":"Sudograph will not scale a single schema across multiple canisters automatically. The goal is to eventually provide this functionality, but the timeline and feasibility of this goal are unknown. Currently each schema that you deploy into a canister is limited to ~4GB of data. This should be sufficient for prototyping and small amounts of storage and usage. There are also multiple scaling techniques that could be used to scale out, for example by storing large files (video, audio, images, documents) in a separate set of canisters that has automatic scaling built-in, and storing references to that data in your Sudograph canister. One of the main problems Sudograph will have scaling across multiple canisters is ensuring efficient and complex querying. Indexes and filters will need to work across multiple canisters. One reason Sudograph is waiting to implement scaling, is to lock down an amazing single canister development experience first. This should be sufficient for many new developers and young projects. wasm64 multiple memories infinite virtual memory","breadcrumbs":"Multi-canister scaling » Multi-canister scaling","id":"51","title":"Multi-canister scaling"},"6":{"body":"Before deploying to production you should understand that Sudograph is alpha/beta software. There are missing features and potential bugs. There is also no way to easily migrate data (if you change your schema, you'll need to delete your state and start over). But if you must deploy to production, here is the command: dfx deploy --network ic","breadcrumbs":"Quick start » Production deployment","id":"6","title":"Production deployment"},"7":{"body":"Sudograph provides one main entrypoint for creating your GraphQL database, and that is the graphql_database Rust procedural macro. Using the power of Rust procedural macros, graphql_database will take your GraphQL schema file and generate all code required to turn the types defined in your schema into a functioning CRUD database. To use graphql_database, first create a new Rust canister. If you're new to developing for the Internet Computer, you might want to check the documentation to get familiar with canister development. Add a new canister to your dfx.json. You can name the canister whatever you'd like, but to keep things simple the canister defined below is named graphql. The contents of your dfx.json should look like the following. If you have other canisters already defined, just add the graphql canister: { \"canisters\": { \"graphql\": { \"type\": \"custom\", \"build\": \"cargo build --target wasm32-unknown-unknown --package graphql --release\", \"candid\": \"canisters/graphql/src/graphql.did\", \"wasm\": \"target/wasm32-unknown-unknown/release/graphql.wasm\" } }\n} The canister defined above assumes a directory structure where dfx.json is in the root of your project, and there is a directory called canisters to contain each canister. You can change up the directory structure if you'd like, just change all of the paths appropriately. Create a new directory within canisters called graphql, and add a Cargo.toml file. It should look something like the following: [package]\nname = \"graphql\"\nversion = \"0.0.0\"\nedition = \"2018\" [lib]\npath = \"src/graphql.rs\"\ncrate-type = [\"cdylib\"] [dependencies]\nsudograph = \"0.2.0\" Within the canisters/graphql directory, now create a src directory. The canisters/graphql/src directory will contain the entrypoint to your graphql canister, graphql.rs, along with your schema.graphql file and your graphql.did file. The graphql.rs file should look like this: use sudograph::graphql_database; graphql_database!(\"canisters/graphql/src/schema.graphql\"); This simply imports the graphql_database procedural macro from sudograph and then invokes it with the path to your schema.graphql file. You must also create a custom candid file graphql.did: service : { \"graphql_query\": (text, text) -> (text) query; \"graphql_mutation\": (text, text) -> (text);\n} The generated canister code will have created the two functions defined in graphql.did, but for now you'll need to create the candid file manually. Hopefully in the future it can be generated for you or abstracted away somehow. graphql_query and graphql_mutation both take two parameters. The first parameter is the query or mutation string. The second parameter is a JSON string containing any variables for the query or mutation. Currently the second parameter is required, so just send an empty JSON object strin \"{}\" if no variables are required for the query or mutation. graphql_query and graphql_mutation both return the result of the query or mutation as a JSON string. Whatever client is consuming the query or mutation will then need to parse the JSON string to turn it into a language-level object. The Sudograph Client will do this for you in a JavaScript frontend. Finally create your schema.graphql file: type User { id: ID! username: String! blogPosts: [BlogPost!]! @relation(name: \"User:blogPosts and BlogPost:author\")\n} type BlogPost { id: ID! publishedAt: Date title: String! author: User! @relation(name: \"User:blogPosts and BlogPost:author\")\n} You now have everything you need to deploy a simple graphql canister. Boot up a node with dfx start and then deploy with dfx deploy. It's important to note that Sudograph currently only works within a single canister. You can deploy as many Sudograph canisters as you'd like, with as many schemas as you'd like, but the generated querying and mutations will only know about data that has been created within the same canister. Querying between canisters would require you to write your own custom code. Sudograph will hopefully address scaling in the future so that you only ever have to deal with thinking about one schema per application.","breadcrumbs":"GraphQL database canister » GraphQL database canister","id":"7","title":"GraphQL database canister"},"8":{"body":"At some point your compiled Rust Wasm binary will grow too large and will be rejected by the canister on deploy. This could happen because the Rust source code that you've written has grown too large, or because your schema has grown too large. A large schema will lead to a large amount of generated Rust code. To temporarily overcome this issue (only so much can be done during optimization, eventually the binary will be too big and the Internet Computer will need to address that), you can optimize your Rust Wasm binary.","breadcrumbs":"GraphQL database canister » Rust Wasm binary optimization","id":"8","title":"Rust Wasm binary optimization"},"9":{"body":"To do this manually, in the root of your directory run the following command once to install the optimizer: cargo install ic-cdk-optimizer --root target You should also change your dfx.json file from: { \"canisters\": { \"graphql\": { \"type\": \"custom\", \"build\": \"cargo build --target wasm32-unknown-unknown --package graphql --release\", \"candid\": \"canisters/graphql/src/graphql.did\", \"wasm\": \"target/wasm32-unknown-unknown/release/graphql.wasm\" } }\n} to: { \"canisters\": { \"graphql\": { \"type\": \"custom\", \"build\": \"cargo build --target wasm32-unknown-unknown --package graphql --release\", \"candid\": \"canisters/graphql/src/graphql.did\", \"wasm\": \"target/wasm32-unknown-unknown/release/graphql-optimized.wasm\" } }\n} The only thing that changed was the wasm property of the graphql canister object, and it changed from \"wasm\": \"target/wasm32-unknown-unknown/release/graphql.wasm\" to \"wasm\": \"target/wasm32-unknown-unknown/release/graphql-optimized.wasm\". Each time you run dfx deploy or dfx deploy graphql, you will need to run the following command after: ./target/bin/ic-cdk-optimizer ./target/wasm32-unknown-unknown/release/graphql.wasm -o ./target/wasm32-unknown-unknown/release/graphql-optimized.wasm","breadcrumbs":"GraphQL database canister » Manual optimization","id":"9","title":"Manual optimization"}},"length":52,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"0":{".":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"0":{"df":2,"docs":{"1":{"tf":1.0},"3":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{",":{"0":{"0":{"0":{",":{"0":{"0":{"0":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{",":{"0":{"0":{"0":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"1":{"8":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"z":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}}}},"4":{"df":0,"docs":{},"g":{"b":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}}},"6":{"a":{"a":{"a":{"a":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"j":{"df":0,"docs":{},"h":{"df":0,"docs":{},"f":{"3":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"7":{"c":{"3":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"a":{"a":{"a":{"a":{"df":12,"docs":{"1":{"tf":1.4142135623730951},"30":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{},"q":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}}},"b":{"df":0,"docs":{},"q":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}}},"d":{"a":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{},"q":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":10,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":5,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"46":{"tf":1.0},"7":{"tf":1.7320508075688772}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"18":{"tf":1.0}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":8,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"h":{"a":{"/":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":5,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"51":{"tf":1.0},"8":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"10":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":10,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"7":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{":":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":5,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"28":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951}}}},"df":2,"docs":{"44":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":2.23606797749979}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}}}},"df":2,"docs":{"26":{"tf":2.449489742783178},"27":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"3":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"a":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":2.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"20":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"20":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"12":{"tf":2.23606797749979},"20":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772}}}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"24":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"6":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"10":{"tf":3.1622776601683795},"7":{"tf":1.4142135623730951},"9":{"tf":2.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"i":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"8":{"0":{"0":{"0":{"df":11,"docs":{"1":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"30":{"tf":2.0}}},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"17":{"tf":1.0},"30":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"7":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":21,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"30":{"tf":3.1622776601683795},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":2.0},"47":{"tf":2.23606797749979},"5":{"tf":3.3166247903554},"50":{"tf":1.4142135623730951},"51":{"tf":2.8284271247461903},"7":{"tf":4.47213595499958},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"d":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"50":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":3,"docs":{"10":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"d":{"df":3,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"4":{"tf":1.0}},"k":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":8,"docs":{"31":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"o":{":":{":":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"df":1,"docs":{"3":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":7,"docs":{"30":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":2.449489742783178},"6":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"12":{"tf":1.0},"51":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"7":{"tf":3.0}},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}}}}},"1":{"df":1,"docs":{"46":{"tf":1.0}}},"2":{"df":1,"docs":{"46":{"tf":1.0}}},"3":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"u":{"d":{"df":2,"docs":{"0":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":10,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":2.449489742783178},"31":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}}}}}},"d":{"6":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"f":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}}},"7":{"b":{"df":0,"docs":{},"h":{"df":0,"docs":{},"p":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":7,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":7,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"29":{"tf":1.0},"50":{"tf":1.0},"7":{"tf":1.0}},"o":{"df":0,"docs":{},"f":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"20":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":2.449489742783178},"44":{"tf":1.0},"7":{"tf":2.23606797749979}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"6":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":20,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":3.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":3.0},"50":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":2.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"21":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"31":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}}},"f":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"0":{".":{"7":{".":{"0":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":7,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":3.872983346207417},"3":{"tf":1.4142135623730951},"5":{"tf":3.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"47":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.6457513110645907},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"o":{"c":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":16,"docs":{"11":{"tf":1.0},"28":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"df":1,"docs":{"47":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"23":{"tf":1.0},"26":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"6":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}}}}}},"q":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}},"t":{"df":0,"docs":{},"u":{"df":5,"docs":{"12":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0},"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":10,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":16,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}},"y":{"a":{"a":{"a":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"3":{"2":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":1,"docs":{"20":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"51":{"tf":1.0},"7":{"tf":3.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"15":{"tf":1.0},"40":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.4142135623730951},"51":{"tf":1.0},"7":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"13":{"tf":1.0},"16":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"3":{"tf":2.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"q":{"a":{"a":{"a":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"30":{"tf":2.0},"44":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"g":{"a":{"df":1,"docs":{"20":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":18,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":2.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.0}}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"51":{"tf":1.4142135623730951}}}},"df":2,"docs":{"11":{"tf":1.0},"5":{"tf":1.4142135623730951}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}}},"o":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":2.0}},"e":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}}}}},"df":5,"docs":{"0":{"tf":2.0},"10":{"tf":3.3166247903554},"5":{"tf":3.4641016151377544},"7":{"tf":3.3166247903554},"9":{"tf":2.449489742783178}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"h":{"3":{"7":{"a":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"r":{"7":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"3":{"tf":1.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{".":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"x":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"d":{"df":0,"docs":{},"k":{".":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"3":{"2":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":4,"docs":{"0":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}},"d":{"df":20,"docs":{"12":{"tf":2.23606797749979},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":2.449489742783178},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":3.1622776601683795},"23":{"tf":2.6457513110645907},"24":{"tf":2.0},"26":{"tf":2.6457513110645907},"27":{"tf":2.0},"28":{"tf":2.0},"29":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"7":{"tf":2.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"29":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"20":{"tf":1.0},"51":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":6,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"3":{"tf":2.6457513110645907},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":8,"docs":{"13":{"tf":1.0},"18":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":2,"docs":{"20":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"'":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"j":{"a":{"a":{"a":{"a":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":2.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"12":{"tf":1.0},"46":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"30":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"51":{"tf":1.0},"8":{"tf":2.23606797749979}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"j":{"df":1,"docs":{"5":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"46":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}}},"i":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}}},"s":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"v":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"51":{"tf":1.0},"7":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"20":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":8,"docs":{"12":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"28":{"tf":2.449489742783178},"31":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"p":{"df":6,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"51":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"44":{"tf":3.0},"50":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{":":{"b":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"32":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"49":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"32":{"tf":1.0},"44":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"47":{"tf":1.4142135623730951},"51":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"20":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"47":{"tf":1.0},"51":{"tf":2.23606797749979}}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.0},"46":{"tf":2.23606797749979},"47":{"tf":2.0},"5":{"tf":1.7320508075688772},"7":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"y":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"1":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"1":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}}}}}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":10,"docs":{"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"51":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"w":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"51":{"tf":1.0},"7":{"tf":2.0}},"l":{"df":0,"docs":{},"i":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"j":{"df":2,"docs":{"1":{"tf":1.0},"3":{"tf":1.4142135623730951}}}},"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}},"w":{"df":4,"docs":{"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"44":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"m":{"df":4,"docs":{"1":{"tf":1.0},"10":{"tf":3.3166247903554},"11":{"tf":1.0},"3":{"tf":1.4142135623730951}}},"x":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":10,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"20":{"tf":2.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"7":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":3,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}},"n":{"c":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":8,"docs":{"12":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"23":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":2.23606797749979},"8":{"tf":1.7320508075688772},"9":{"tf":2.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"42":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"51":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":2,"docs":{"0":{"tf":1.0},"6":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"41":{"tf":1.0},"50":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":2.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"s":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"30":{"tf":1.0},"44":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{":":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":2.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"20":{"tf":2.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.0},"44":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"10":{"tf":1.0},"20":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":14,"docs":{"1":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"3":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"47":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":9,"docs":{"0":{"tf":1.4142135623730951},"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.0},"5":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":2.8284271247461903}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"r":{"4":{"2":{"df":0,"docs":{},"i":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"x":{"6":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"34":{"tf":1.0},"45":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":2.23606797749979},"25":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"27":{"tf":2.23606797749979},"28":{"tf":2.449489742783178}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":6,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":2.8284271247461903},"24":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"12":{"tf":1.0},"21":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":1,"docs":{"5":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.0},"7":{"tf":2.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"12":{"tf":1.0},"30":{"tf":3.1622776601683795}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"30":{"tf":1.0},"44":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":3.3166247903554},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":2.8284271247461903},"9":{"tf":1.7320508075688772}}},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":2.23606797749979},"44":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":2.23606797749979}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"20":{"tf":1.0},"29":{"tf":2.0},"50":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"46":{"tf":1.0},"51":{"tf":2.6457513110645907},"7":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":2,"docs":{"30":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":21,"docs":{"0":{"tf":1.7320508075688772},"12":{"tf":2.23606797749979},"13":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":2.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":2.23606797749979}},"s":{"/":{"4":{"9":{"2":{"2":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":1.0},"30":{"tf":1.0},"44":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"50":{"tf":1.0}}}},"df":0,"docs":{}},"f":{"df":1,"docs":{"20":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"51":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":4,"docs":{"12":{"tf":1.7320508075688772},"31":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0}}}},"h":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"v":{"0":{".":{"3":{"8":{".":{"0":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"3":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"e":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"23":{"tf":2.449489742783178},"24":{"tf":1.7320508075688772}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":5,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"i":{"df":2,"docs":{"4":{"tf":1.0},"7":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"46":{"tf":2.449489742783178},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"12":{"tf":1.0},"3":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"2":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":2.449489742783178},"6":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"6":{"tf":1.0}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"15":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}},"g":{"df":13,"docs":{"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":2.0},"20":{"tf":4.123105625617661},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.0},"7":{"tf":2.449489742783178}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"45":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"50":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"12":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":26,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"51":{"tf":2.0},"6":{"tf":1.0},"7":{"tf":2.6457513110645907}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"44":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"10":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":2.449489742783178}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":5,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"3":{"tf":1.7320508075688772},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"50":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"7":{"tf":2.449489742783178}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}},"k":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"46":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"45":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"1":{".":{"2":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"p":{"df":10,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}},"i":{"df":1,"docs":{"1":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"o":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"24":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":19,"docs":{"12":{"tf":3.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":3.1622776601683795},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":2.449489742783178},"31":{"tf":1.0},"7":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"k":{"5":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":2,"docs":{"46":{"tf":1.0},"47":{"tf":1.0}},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":2.0},"3":{"tf":2.449489742783178},"51":{"tf":1.0},"7":{"tf":1.7320508075688772},"9":{"tf":3.1622776601683795}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"44":{"tf":1.0},"50":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"37":{"tf":1.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"20":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"1":{"df":1,"docs":{"46":{"tf":1.0}}},"2":{"df":1,"docs":{"46":{"tf":1.0}}},"3":{"df":1,"docs":{"46":{"tf":1.0}}},":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}},"df":9,"docs":{"12":{"tf":2.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":6,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":7,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"21":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"30":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":5,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"3":{"tf":1.7320508075688772},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"46":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":2.23606797749979}}}},"y":{"df":3,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":13,"docs":{"11":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"10":{"tf":1.0},"44":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"0":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"7":{"tf":2.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":5,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"30":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"7":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"44":{"tf":1.0},"8":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":1,"docs":{"7":{"tf":2.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"29":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":2,"docs":{"44":{"tf":1.0},"7":{"tf":1.0}}},"v":{"df":12,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"0":{".":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"0":{"df":2,"docs":{"1":{"tf":1.0},"3":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{",":{"0":{"0":{"0":{",":{"0":{"0":{"0":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{",":{"0":{"0":{"0":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"1":{"8":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"z":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}}}},"4":{"df":0,"docs":{},"g":{"b":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}}},"6":{"a":{"a":{"a":{"a":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"j":{"df":0,"docs":{},"h":{"df":0,"docs":{},"f":{"3":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"7":{"c":{"3":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"a":{"a":{"a":{"a":{"df":12,"docs":{"1":{"tf":1.4142135623730951},"30":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{},"q":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}}},"b":{"df":0,"docs":{},"q":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}}},"d":{"a":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{},"q":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":10,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":5,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"46":{"tf":1.0},"7":{"tf":1.7320508075688772}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"18":{"tf":1.0}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":8,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"h":{"a":{"/":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":5,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"51":{"tf":1.0},"8":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"10":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":10,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"7":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{":":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":5,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"28":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951}}}},"df":2,"docs":{"44":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":2.23606797749979}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}}}},"df":2,"docs":{"26":{"tf":2.449489742783178},"27":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"3":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"a":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"20":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"20":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"12":{"tf":2.23606797749979},"20":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772}}}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"13":{"tf":1.0},"14":{"tf":2.0},"29":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"24":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"6":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"10":{"tf":3.1622776601683795},"7":{"tf":1.4142135623730951},"9":{"tf":2.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"i":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"8":{"0":{"0":{"0":{"df":11,"docs":{"1":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"30":{"tf":2.0}}},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"17":{"tf":1.0},"30":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"n":{"d":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"7":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":22,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"30":{"tf":3.1622776601683795},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":2.23606797749979},"47":{"tf":2.449489742783178},"5":{"tf":3.3166247903554},"50":{"tf":1.4142135623730951},"51":{"tf":3.1622776601683795},"7":{"tf":4.69041575982343},"8":{"tf":1.4142135623730951},"9":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"d":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"50":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":3,"docs":{"10":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"d":{"df":3,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"4":{"tf":1.0}},"k":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":8,"docs":{"31":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"o":{":":{":":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"df":1,"docs":{"3":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":7,"docs":{"30":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":2.449489742783178},"6":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"12":{"tf":1.0},"51":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"7":{"tf":3.0}},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}}}}},"1":{"df":1,"docs":{"46":{"tf":1.0}}},"2":{"df":1,"docs":{"46":{"tf":1.0}}},"3":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"u":{"d":{"df":2,"docs":{"0":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":10,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":2.8284271247461903},"31":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}}}}}}}},"d":{"6":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"f":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}}},"7":{"b":{"df":0,"docs":{},"h":{"df":0,"docs":{},"p":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":7,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":7,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":2.0},"20":{"tf":1.4142135623730951},"29":{"tf":1.0},"50":{"tf":1.0},"7":{"tf":1.0}},"o":{"df":0,"docs":{},"f":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"20":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":2.449489742783178},"44":{"tf":1.0},"7":{"tf":2.23606797749979}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.7320508075688772},"6":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":20,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":3.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":3.1622776601683795},"50":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":2.23606797749979},"7":{"tf":2.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"21":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"31":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}}},"f":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"0":{".":{"7":{".":{"0":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":7,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":3.872983346207417},"3":{"tf":1.4142135623730951},"5":{"tf":3.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"47":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.6457513110645907},"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"o":{"c":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":16,"docs":{"11":{"tf":1.0},"28":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"df":1,"docs":{"47":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"23":{"tf":1.0},"26":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"6":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}}}}}},"q":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}},"t":{"df":0,"docs":{},"u":{"df":5,"docs":{"12":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0},"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":10,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":16,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":2.0},"51":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}},"y":{"a":{"a":{"a":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"3":{"2":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":1,"docs":{"20":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"51":{"tf":1.0},"7":{"tf":3.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"15":{"tf":1.0},"40":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.4142135623730951},"51":{"tf":1.0},"7":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"13":{"tf":1.0},"16":{"tf":2.0},"29":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"3":{"tf":2.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"q":{"a":{"a":{"a":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"30":{"tf":2.0},"44":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"g":{"a":{"df":1,"docs":{"20":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":21,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"35":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"37":{"tf":1.7320508075688772},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.0}}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"51":{"tf":1.4142135623730951}}}},"df":2,"docs":{"11":{"tf":1.0},"5":{"tf":1.4142135623730951}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}}},"o":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":2.0}},"e":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}}}}},"df":6,"docs":{"0":{"tf":2.0},"10":{"tf":3.4641016151377544},"5":{"tf":3.4641016151377544},"7":{"tf":3.605551275463989},"8":{"tf":1.0},"9":{"tf":2.6457513110645907}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"h":{"3":{"7":{"a":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"r":{"7":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"3":{"tf":1.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{".":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"x":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"d":{"df":0,"docs":{},"k":{".":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"3":{"2":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":4,"docs":{"0":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}},"d":{"df":20,"docs":{"12":{"tf":2.23606797749979},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":2.6457513110645907},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":3.1622776601683795},"23":{"tf":2.6457513110645907},"24":{"tf":2.0},"26":{"tf":2.6457513110645907},"27":{"tf":2.0},"28":{"tf":2.0},"29":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"7":{"tf":2.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"29":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"20":{"tf":1.0},"51":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":6,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"3":{"tf":2.6457513110645907},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":8,"docs":{"13":{"tf":1.0},"18":{"tf":2.0},"20":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":2,"docs":{"20":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"'":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"j":{"a":{"a":{"a":{"a":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":2.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"12":{"tf":1.0},"46":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"30":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"51":{"tf":1.0},"8":{"tf":2.23606797749979}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"j":{"df":1,"docs":{"5":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"46":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}}},"i":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"50":{"tf":2.23606797749979},"51":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}}}},"s":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"v":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"51":{"tf":1.0},"7":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"20":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":8,"docs":{"12":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"28":{"tf":2.8284271247461903},"31":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"df":6,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"51":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"44":{"tf":3.3166247903554},"50":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{":":{"b":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"32":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"32":{"tf":1.0},"44":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"47":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"20":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"47":{"tf":1.0},"51":{"tf":2.23606797749979}}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":10,"docs":{"0":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":2.449489742783178},"47":{"tf":2.23606797749979},"5":{"tf":1.7320508075688772},"7":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"y":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"1":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"1":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}}}}}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":10,"docs":{"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"51":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"w":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"51":{"tf":1.0},"7":{"tf":2.0}},"l":{"df":0,"docs":{},"i":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"j":{"df":2,"docs":{"1":{"tf":1.0},"3":{"tf":1.4142135623730951}}}},"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}},"w":{"df":4,"docs":{"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"44":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"m":{"df":4,"docs":{"1":{"tf":1.0},"10":{"tf":3.3166247903554},"11":{"tf":1.0},"3":{"tf":1.4142135623730951}}},"x":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":10,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"20":{"tf":2.449489742783178},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"7":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":3,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}},"n":{"c":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":8,"docs":{"12":{"tf":1.4142135623730951},"22":{"tf":2.6457513110645907},"23":{"tf":1.7320508075688772},"25":{"tf":2.0},"26":{"tf":1.7320508075688772},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":2.449489742783178},"8":{"tf":2.0},"9":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"42":{"tf":1.7320508075688772},"50":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"51":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":2,"docs":{"0":{"tf":1.0},"6":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"41":{"tf":1.7320508075688772},"50":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":2.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"s":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"30":{"tf":1.0},"44":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{":":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":2.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"20":{"tf":2.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.0},"44":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":11,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"10":{"tf":1.0},"20":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}}}}}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":14,"docs":{"1":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"3":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"47":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":10,"docs":{"0":{"tf":1.4142135623730951},"23":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"5":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":2.8284271247461903}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"1":{"tf":2.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"r":{"4":{"2":{"df":0,"docs":{},"i":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"x":{"6":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"34":{"tf":1.7320508075688772},"45":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"22":{"tf":2.0},"23":{"tf":2.0},"24":{"tf":2.449489742783178},"25":{"tf":2.0},"26":{"tf":2.0},"27":{"tf":2.449489742783178},"28":{"tf":2.8284271247461903}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":6,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":2.8284271247461903},"24":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"12":{"tf":1.0},"21":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":1,"docs":{"5":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.0},"7":{"tf":2.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"12":{"tf":1.0},"30":{"tf":3.4641016151377544}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"30":{"tf":1.0},"44":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":3.3166247903554},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":2.8284271247461903},"9":{"tf":1.7320508075688772}}},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":2.23606797749979},"44":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":2.449489742783178}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":11,"docs":{"12":{"tf":1.7320508075688772},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":2.449489742783178},"50":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"46":{"tf":1.0},"51":{"tf":3.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":2,"docs":{"30":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":41,"docs":{"0":{"tf":1.7320508075688772},"12":{"tf":2.6457513110645907},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":2.23606797749979}},"s":{"/":{"4":{"9":{"2":{"2":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":1.0},"30":{"tf":1.0},"44":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"50":{"tf":1.0}}}},"df":0,"docs":{}},"f":{"df":1,"docs":{"20":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"51":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":4,"docs":{"12":{"tf":1.7320508075688772},"31":{"tf":2.449489742783178},"50":{"tf":1.0},"51":{"tf":1.0}}}},"h":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"v":{"0":{".":{"3":{"8":{".":{"0":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"3":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"e":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"23":{"tf":2.449489742783178},"24":{"tf":1.7320508075688772}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":5,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":2.0},"26":{"tf":1.7320508075688772},"27":{"tf":2.0},"28":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"i":{"df":2,"docs":{"4":{"tf":1.0},"7":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"46":{"tf":2.6457513110645907},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"12":{"tf":1.0},"3":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":2.23606797749979},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":2.6457513110645907},"6":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"6":{"tf":1.0}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"15":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}},"g":{"df":13,"docs":{"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":2.23606797749979},"20":{"tf":4.123105625617661},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.0},"7":{"tf":2.449489742783178}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"45":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.7320508075688772},"50":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"12":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":26,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":2.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":2.0},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"51":{"tf":2.0},"6":{"tf":1.0},"7":{"tf":2.6457513110645907}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"44":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"10":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"32":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":2.449489742783178}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":5,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"3":{"tf":1.7320508075688772},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"50":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"7":{"tf":2.449489742783178}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}},"k":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"46":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"45":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"1":{".":{"2":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"p":{"df":10,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.7320508075688772},"45":{"tf":2.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"50":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}},"i":{"df":1,"docs":{"1":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"o":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"30":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":19,"docs":{"12":{"tf":3.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":3.1622776601683795},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":2.449489742783178},"31":{"tf":1.0},"7":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"k":{"5":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":2,"docs":{"46":{"tf":1.0},"47":{"tf":1.0}},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":2.0},"3":{"tf":2.449489742783178},"51":{"tf":1.0},"7":{"tf":1.7320508075688772},"9":{"tf":3.1622776601683795}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"44":{"tf":1.0},"50":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"37":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"20":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"1":{"df":1,"docs":{"46":{"tf":1.0}}},"2":{"df":1,"docs":{"46":{"tf":1.0}}},"3":{"df":1,"docs":{"46":{"tf":1.0}}},":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}},"df":9,"docs":{"12":{"tf":2.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":6,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":7,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"21":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"30":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.7320508075688772}}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":5,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"3":{"tf":1.7320508075688772},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"46":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.0},"9":{"tf":2.23606797749979}}}},"y":{"df":3,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":13,"docs":{"11":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"10":{"tf":1.0},"44":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"0":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"7":{"tf":2.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":5,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"30":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"7":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"44":{"tf":1.0},"8":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":1,"docs":{"7":{"tf":2.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"29":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":2,"docs":{"44":{"tf":1.0},"7":{"tf":1.0}}},"v":{"df":12,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}}},"title":{"root":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"32":{"tf":1.0},"4":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"25":{"tf":1.0},"28":{"tf":1.4142135623730951}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"47":{"tf":1.0},"51":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"35":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":2,"docs":{"12":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"u":{"b":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":2,"docs":{"24":{"tf":1.0},"27":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});