// This code has been automatically generated on 2021-06-14
// using the project https://github.com/Pendulum-Chain/substrate-stellar-xdr-generator
// Do not edit this code by hand!

#[allow(unused_imports)]
use crate::compound_types::{
    LimitedString, LimitedVarArray, LimitedVarOpaque, UnlimitedString, UnlimitedVarArray,
    UnlimitedVarOpaque,
};
#[allow(unused_imports)]
use crate::streams::{ReadStream, ReadStreamError, WriteStream, WriteStreamError};
#[allow(unused_imports)]
use crate::xdr_codec::XdrCodec;
#[allow(unused_imports)]
use sp_std::{boxed::Box, prelude::*};

#[allow(dead_code)]
pub const MASK_ACCOUNT_FLAGS: i32 = 7;
#[allow(dead_code)]
pub const MASK_ACCOUNT_FLAGS_V17: i32 = 15;
#[allow(dead_code)]
pub const MAX_SIGNERS: i32 = 20;
#[allow(dead_code)]
pub const MASK_TRUSTLINE_FLAGS: i32 = 1;
#[allow(dead_code)]
pub const MASK_TRUSTLINE_FLAGS_V13: i32 = 3;
#[allow(dead_code)]
pub const MASK_TRUSTLINE_FLAGS_V17: i32 = 7;
#[allow(dead_code)]
pub const MASK_OFFERENTRY_FLAGS: i32 = 1;
#[allow(dead_code)]
pub const MASK_CLAIMABLE_BALANCE_FLAGS: i32 = 1;
#[allow(dead_code)]
pub const MAX_OPS_PER_TX: i32 = 100;

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum EnvelopeType {
    EnvelopeTypeTxV0 = 0,
    EnvelopeTypeScp = 1,
    EnvelopeTypeTx = 2,
    EnvelopeTypeAuth = 3,
    EnvelopeTypeScpvalue = 4,
    EnvelopeTypeTxFeeBump = 5,
    EnvelopeTypeOpId = 6,
}
impl XdrCodec for EnvelopeType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(EnvelopeType::EnvelopeTypeTxV0),
            1 => Ok(EnvelopeType::EnvelopeTypeScp),
            2 => Ok(EnvelopeType::EnvelopeTypeTx),
            3 => Ok(EnvelopeType::EnvelopeTypeAuth),
            4 => Ok(EnvelopeType::EnvelopeTypeScpvalue),
            5 => Ok(EnvelopeType::EnvelopeTypeTxFeeBump),
            6 => Ok(EnvelopeType::EnvelopeTypeOpId),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum TransactionMeta {
    V0(UnlimitedVarArray<OperationMeta>),
    V1(TransactionMetaV1),
    V2(TransactionMetaV2),
    Default(i32),
}
impl XdrCodec for TransactionMeta {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            TransactionMeta::V0(value) => {
                (0 as i32).to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TransactionMeta::V1(value) => {
                (1 as i32).to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TransactionMeta::V2(value) => {
                (2 as i32).to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TransactionMeta::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(TransactionMeta::V0(
                UnlimitedVarArray::<OperationMeta>::from_xdr_buffered(read_stream)?,
            )),
            1 => Ok(TransactionMeta::V1(TransactionMetaV1::from_xdr_buffered(
                read_stream,
            )?)),
            2 => Ok(TransactionMeta::V2(TransactionMetaV2::from_xdr_buffered(
                read_stream,
            )?)),
            code => Ok(TransactionMeta::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct TransactionMetaV2 {
    pub tx_changes_before: LedgerEntryChanges,
    pub operations: UnlimitedVarArray<OperationMeta>,
    pub tx_changes_after: LedgerEntryChanges,
}
impl XdrCodec for TransactionMetaV2 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.tx_changes_before.to_xdr_buffered(write_stream)?;
        self.operations.to_xdr_buffered(write_stream)?;
        self.tx_changes_after.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(TransactionMetaV2 {
            tx_changes_before: LedgerEntryChanges::from_xdr_buffered(read_stream)?,
            operations: UnlimitedVarArray::<OperationMeta>::from_xdr_buffered(read_stream)?,
            tx_changes_after: LedgerEntryChanges::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
pub type LedgerEntryChanges = UnlimitedVarArray<LedgerEntryChange>;

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum LedgerEntryChange {
    LedgerEntryCreated(LedgerEntry),
    LedgerEntryUpdated(LedgerEntry),
    LedgerEntryRemoved(LedgerKey),
    LedgerEntryState(LedgerEntry),
}
impl XdrCodec for LedgerEntryChange {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            LedgerEntryChange::LedgerEntryCreated(value) => {
                LedgerEntryChangeType::LedgerEntryCreated.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerEntryChange::LedgerEntryUpdated(value) => {
                LedgerEntryChangeType::LedgerEntryUpdated.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerEntryChange::LedgerEntryRemoved(value) => {
                LedgerEntryChangeType::LedgerEntryRemoved.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerEntryChange::LedgerEntryState(value) => {
                LedgerEntryChangeType::LedgerEntryState.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match LedgerEntryChangeType::from_xdr_buffered(read_stream)? {
            LedgerEntryChangeType::LedgerEntryCreated => Ok(LedgerEntryChange::LedgerEntryCreated(
                LedgerEntry::from_xdr_buffered(read_stream)?,
            )),
            LedgerEntryChangeType::LedgerEntryUpdated => Ok(LedgerEntryChange::LedgerEntryUpdated(
                LedgerEntry::from_xdr_buffered(read_stream)?,
            )),
            LedgerEntryChangeType::LedgerEntryRemoved => Ok(LedgerEntryChange::LedgerEntryRemoved(
                LedgerKey::from_xdr_buffered(read_stream)?,
            )),
            LedgerEntryChangeType::LedgerEntryState => Ok(LedgerEntryChange::LedgerEntryState(
                LedgerEntry::from_xdr_buffered(read_stream)?,
            )),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum LedgerEntryChangeType {
    LedgerEntryCreated = 0,
    LedgerEntryUpdated = 1,
    LedgerEntryRemoved = 2,
    LedgerEntryState = 3,
}
impl XdrCodec for LedgerEntryChangeType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(LedgerEntryChangeType::LedgerEntryCreated),
            1 => Ok(LedgerEntryChangeType::LedgerEntryUpdated),
            2 => Ok(LedgerEntryChangeType::LedgerEntryRemoved),
            3 => Ok(LedgerEntryChangeType::LedgerEntryState),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum LedgerKey {
    Account(LedgerKeyAccount),
    Trustline(LedgerKeyTrustLine),
    Offer(LedgerKeyOffer),
    Data(LedgerKeyData),
    ClaimableBalance(LedgerKeyClaimableBalance),
}
impl XdrCodec for LedgerKey {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            LedgerKey::Account(value) => {
                LedgerEntryType::Account.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerKey::Trustline(value) => {
                LedgerEntryType::Trustline.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerKey::Offer(value) => {
                LedgerEntryType::Offer.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerKey::Data(value) => {
                LedgerEntryType::Data.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerKey::ClaimableBalance(value) => {
                LedgerEntryType::ClaimableBalance.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match LedgerEntryType::from_xdr_buffered(read_stream)? {
            LedgerEntryType::Account => Ok(LedgerKey::Account(
                LedgerKeyAccount::from_xdr_buffered(read_stream)?,
            )),
            LedgerEntryType::Trustline => Ok(LedgerKey::Trustline(
                LedgerKeyTrustLine::from_xdr_buffered(read_stream)?,
            )),
            LedgerEntryType::Offer => Ok(LedgerKey::Offer(LedgerKeyOffer::from_xdr_buffered(
                read_stream,
            )?)),
            LedgerEntryType::Data => Ok(LedgerKey::Data(LedgerKeyData::from_xdr_buffered(
                read_stream,
            )?)),
            LedgerEntryType::ClaimableBalance => Ok(LedgerKey::ClaimableBalance(
                LedgerKeyClaimableBalance::from_xdr_buffered(read_stream)?,
            )),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum LedgerEntryType {
    Account = 0,
    Trustline = 1,
    Offer = 2,
    Data = 3,
    ClaimableBalance = 4,
}
impl XdrCodec for LedgerEntryType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(LedgerEntryType::Account),
            1 => Ok(LedgerEntryType::Trustline),
            2 => Ok(LedgerEntryType::Offer),
            3 => Ok(LedgerEntryType::Data),
            4 => Ok(LedgerEntryType::ClaimableBalance),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct LedgerKeyClaimableBalance {
    pub balance_id: ClaimableBalanceId,
}
impl XdrCodec for LedgerKeyClaimableBalance {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.balance_id.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(LedgerKeyClaimableBalance {
            balance_id: ClaimableBalanceId::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ClaimableBalanceId {
    ClaimableBalanceIdTypeV0(Hash),
}
impl XdrCodec for ClaimableBalanceId {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ClaimableBalanceId::ClaimableBalanceIdTypeV0(value) => {
                ClaimableBalanceIdType::ClaimableBalanceIdTypeV0.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ClaimableBalanceIdType::from_xdr_buffered(read_stream)? {
            ClaimableBalanceIdType::ClaimableBalanceIdTypeV0 => Ok(
                ClaimableBalanceId::ClaimableBalanceIdTypeV0(Hash::from_xdr_buffered(read_stream)?),
            ),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ClaimableBalanceIdType {
    ClaimableBalanceIdTypeV0 = 0,
}
impl XdrCodec for ClaimableBalanceIdType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ClaimableBalanceIdType::ClaimableBalanceIdTypeV0),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
pub type Hash = [u8; 32];

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct LedgerKeyData {
    pub account_id: AccountId,
    pub data_name: String64,
}
impl XdrCodec for LedgerKeyData {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.account_id.to_xdr_buffered(write_stream)?;
        self.data_name.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(LedgerKeyData {
            account_id: AccountId::from_xdr_buffered(read_stream)?,
            data_name: String64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
pub type String64 = LimitedString<64>;

#[allow(dead_code)]
pub type AccountId = PublicKey;

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum PublicKey {
    PublicKeyTypeEd25519(Uint256),
}
impl XdrCodec for PublicKey {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            PublicKey::PublicKeyTypeEd25519(value) => {
                PublicKeyType::PublicKeyTypeEd25519.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match PublicKeyType::from_xdr_buffered(read_stream)? {
            PublicKeyType::PublicKeyTypeEd25519 => Ok(PublicKey::PublicKeyTypeEd25519(
                Uint256::from_xdr_buffered(read_stream)?,
            )),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum PublicKeyType {
    PublicKeyTypeEd25519 = 0,
}
impl XdrCodec for PublicKeyType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(PublicKeyType::PublicKeyTypeEd25519),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
pub type Uint256 = [u8; 32];

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct LedgerKeyOffer {
    pub seller_id: AccountId,
    pub offer_id: Int64,
}
impl XdrCodec for LedgerKeyOffer {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.seller_id.to_xdr_buffered(write_stream)?;
        self.offer_id.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(LedgerKeyOffer {
            seller_id: AccountId::from_xdr_buffered(read_stream)?,
            offer_id: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
pub type Int64 = i64;

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct LedgerKeyTrustLine {
    pub account_id: AccountId,
    pub asset: Asset,
}
impl XdrCodec for LedgerKeyTrustLine {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.account_id.to_xdr_buffered(write_stream)?;
        self.asset.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(LedgerKeyTrustLine {
            account_id: AccountId::from_xdr_buffered(read_stream)?,
            asset: Asset::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum Asset {
    AssetTypeNative,
    AssetTypeCreditAlphanum4(AssetAlphaNum4),
    AssetTypeCreditAlphanum12(AssetAlphaNum12),
}
impl XdrCodec for Asset {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            Asset::AssetTypeNative => AssetType::AssetTypeNative.to_xdr_buffered(write_stream)?,
            Asset::AssetTypeCreditAlphanum4(value) => {
                AssetType::AssetTypeCreditAlphanum4.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            Asset::AssetTypeCreditAlphanum12(value) => {
                AssetType::AssetTypeCreditAlphanum12.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match AssetType::from_xdr_buffered(read_stream)? {
            AssetType::AssetTypeNative => Ok(Asset::AssetTypeNative),
            AssetType::AssetTypeCreditAlphanum4 => Ok(Asset::AssetTypeCreditAlphanum4(
                AssetAlphaNum4::from_xdr_buffered(read_stream)?,
            )),
            AssetType::AssetTypeCreditAlphanum12 => Ok(Asset::AssetTypeCreditAlphanum12(
                AssetAlphaNum12::from_xdr_buffered(read_stream)?,
            )),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum AssetType {
    AssetTypeNative = 0,
    AssetTypeCreditAlphanum4 = 1,
    AssetTypeCreditAlphanum12 = 2,
}
impl XdrCodec for AssetType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(AssetType::AssetTypeNative),
            1 => Ok(AssetType::AssetTypeCreditAlphanum4),
            2 => Ok(AssetType::AssetTypeCreditAlphanum12),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct AssetAlphaNum12 {
    pub asset_code: AssetCode12,
    pub issuer: AccountId,
}
impl XdrCodec for AssetAlphaNum12 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.asset_code.to_xdr_buffered(write_stream)?;
        self.issuer.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(AssetAlphaNum12 {
            asset_code: AssetCode12::from_xdr_buffered(read_stream)?,
            issuer: AccountId::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
pub type AssetCode12 = [u8; 12];

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct AssetAlphaNum4 {
    pub asset_code: AssetCode4,
    pub issuer: AccountId,
}
impl XdrCodec for AssetAlphaNum4 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.asset_code.to_xdr_buffered(write_stream)?;
        self.issuer.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(AssetAlphaNum4 {
            asset_code: AssetCode4::from_xdr_buffered(read_stream)?,
            issuer: AccountId::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
pub type AssetCode4 = [u8; 4];

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct LedgerKeyAccount {
    pub account_id: AccountId,
}
impl XdrCodec for LedgerKeyAccount {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.account_id.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(LedgerKeyAccount {
            account_id: AccountId::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct LedgerEntry {
    pub last_modified_ledger_seq: Uint32,
    pub data: LedgerEntryData,
    pub ext: LedgerEntryExt,
}
impl XdrCodec for LedgerEntry {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.last_modified_ledger_seq
            .to_xdr_buffered(write_stream)?;
        self.data.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(LedgerEntry {
            last_modified_ledger_seq: Uint32::from_xdr_buffered(read_stream)?,
            data: LedgerEntryData::from_xdr_buffered(read_stream)?,
            ext: LedgerEntryExt::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum LedgerEntryExt {
    V0,
    V1(LedgerEntryExtensionV1),
    Default(i32),
}
impl XdrCodec for LedgerEntryExt {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            LedgerEntryExt::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            LedgerEntryExt::V1(value) => {
                (1 as i32).to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerEntryExt::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(LedgerEntryExt::V0),
            1 => Ok(LedgerEntryExt::V1(
                LedgerEntryExtensionV1::from_xdr_buffered(read_stream)?,
            )),
            code => Ok(LedgerEntryExt::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct LedgerEntryExtensionV1 {
    pub sponsoring_id: SponsorshipDescriptor,
    pub ext: LedgerEntryExtensionV1Ext,
}
impl XdrCodec for LedgerEntryExtensionV1 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.sponsoring_id.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(LedgerEntryExtensionV1 {
            sponsoring_id: SponsorshipDescriptor::from_xdr_buffered(read_stream)?,
            ext: LedgerEntryExtensionV1Ext::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum LedgerEntryExtensionV1Ext {
    V0,
    Default(i32),
}
impl XdrCodec for LedgerEntryExtensionV1Ext {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            LedgerEntryExtensionV1Ext::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            LedgerEntryExtensionV1Ext::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(LedgerEntryExtensionV1Ext::V0),
            code => Ok(LedgerEntryExtensionV1Ext::Default(code)),
        }
    }
}

#[allow(dead_code)]
pub type SponsorshipDescriptor = Option<AccountId>;

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum LedgerEntryData {
    Account(AccountEntry),
    Trustline(TrustLineEntry),
    Offer(OfferEntry),
    Data(DataEntry),
    ClaimableBalance(ClaimableBalanceEntry),
}
impl XdrCodec for LedgerEntryData {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            LedgerEntryData::Account(value) => {
                LedgerEntryType::Account.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerEntryData::Trustline(value) => {
                LedgerEntryType::Trustline.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerEntryData::Offer(value) => {
                LedgerEntryType::Offer.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerEntryData::Data(value) => {
                LedgerEntryType::Data.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            LedgerEntryData::ClaimableBalance(value) => {
                LedgerEntryType::ClaimableBalance.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match LedgerEntryType::from_xdr_buffered(read_stream)? {
            LedgerEntryType::Account => Ok(LedgerEntryData::Account(
                AccountEntry::from_xdr_buffered(read_stream)?,
            )),
            LedgerEntryType::Trustline => Ok(LedgerEntryData::Trustline(
                TrustLineEntry::from_xdr_buffered(read_stream)?,
            )),
            LedgerEntryType::Offer => Ok(LedgerEntryData::Offer(OfferEntry::from_xdr_buffered(
                read_stream,
            )?)),
            LedgerEntryType::Data => Ok(LedgerEntryData::Data(DataEntry::from_xdr_buffered(
                read_stream,
            )?)),
            LedgerEntryType::ClaimableBalance => Ok(LedgerEntryData::ClaimableBalance(
                ClaimableBalanceEntry::from_xdr_buffered(read_stream)?,
            )),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ClaimableBalanceEntry {
    pub balance_id: ClaimableBalanceId,
    pub claimants: LimitedVarArray<Claimant, 10>,
    pub asset: Asset,
    pub amount: Int64,
    pub ext: ClaimableBalanceEntryExt,
}
impl XdrCodec for ClaimableBalanceEntry {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.balance_id.to_xdr_buffered(write_stream)?;
        self.claimants.to_xdr_buffered(write_stream)?;
        self.asset.to_xdr_buffered(write_stream)?;
        self.amount.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ClaimableBalanceEntry {
            balance_id: ClaimableBalanceId::from_xdr_buffered(read_stream)?,
            claimants: LimitedVarArray::<Claimant, 10>::from_xdr_buffered(read_stream)?,
            asset: Asset::from_xdr_buffered(read_stream)?,
            amount: Int64::from_xdr_buffered(read_stream)?,
            ext: ClaimableBalanceEntryExt::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ClaimableBalanceEntryExt {
    V0,
    V1(ClaimableBalanceEntryExtensionV1),
    Default(i32),
}
impl XdrCodec for ClaimableBalanceEntryExt {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ClaimableBalanceEntryExt::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            ClaimableBalanceEntryExt::V1(value) => {
                (1 as i32).to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            ClaimableBalanceEntryExt::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(ClaimableBalanceEntryExt::V0),
            1 => Ok(ClaimableBalanceEntryExt::V1(
                ClaimableBalanceEntryExtensionV1::from_xdr_buffered(read_stream)?,
            )),
            code => Ok(ClaimableBalanceEntryExt::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ClaimableBalanceEntryExtensionV1 {
    pub ext: ClaimableBalanceEntryExtensionV1Ext,
    pub flags: Uint32,
}
impl XdrCodec for ClaimableBalanceEntryExtensionV1 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.ext.to_xdr_buffered(write_stream)?;
        self.flags.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ClaimableBalanceEntryExtensionV1 {
            ext: ClaimableBalanceEntryExtensionV1Ext::from_xdr_buffered(read_stream)?,
            flags: Uint32::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ClaimableBalanceEntryExtensionV1Ext {
    V0,
    Default(i32),
}
impl XdrCodec for ClaimableBalanceEntryExtensionV1Ext {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ClaimableBalanceEntryExtensionV1Ext::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            ClaimableBalanceEntryExtensionV1Ext::Default(code) => {
                code.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(ClaimableBalanceEntryExtensionV1Ext::V0),
            code => Ok(ClaimableBalanceEntryExtensionV1Ext::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum Claimant {
    ClaimantTypeV0(ClaimantV0),
}
impl XdrCodec for Claimant {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            Claimant::ClaimantTypeV0(value) => {
                ClaimantType::ClaimantTypeV0.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ClaimantType::from_xdr_buffered(read_stream)? {
            ClaimantType::ClaimantTypeV0 => Ok(Claimant::ClaimantTypeV0(
                ClaimantV0::from_xdr_buffered(read_stream)?,
            )),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ClaimantType {
    ClaimantTypeV0 = 0,
}
impl XdrCodec for ClaimantType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ClaimantType::ClaimantTypeV0),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ClaimantV0 {
    pub destination: AccountId,
    pub predicate: ClaimPredicate,
}
impl XdrCodec for ClaimantV0 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.destination.to_xdr_buffered(write_stream)?;
        self.predicate.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ClaimantV0 {
            destination: AccountId::from_xdr_buffered(read_stream)?,
            predicate: ClaimPredicate::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ClaimPredicate {
    ClaimPredicateUnconditional,
    ClaimPredicateAnd(LimitedVarArray<ClaimPredicate, 2>),
    ClaimPredicateOr(LimitedVarArray<ClaimPredicate, 2>),
    ClaimPredicateNot(Option<Box<ClaimPredicate>>),
    ClaimPredicateBeforeAbsoluteTime(Int64),
    ClaimPredicateBeforeRelativeTime(Int64),
}
impl XdrCodec for ClaimPredicate {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ClaimPredicate::ClaimPredicateUnconditional => {
                ClaimPredicateType::ClaimPredicateUnconditional.to_xdr_buffered(write_stream)?
            }
            ClaimPredicate::ClaimPredicateAnd(value) => {
                ClaimPredicateType::ClaimPredicateAnd.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            ClaimPredicate::ClaimPredicateOr(value) => {
                ClaimPredicateType::ClaimPredicateOr.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            ClaimPredicate::ClaimPredicateNot(value) => {
                ClaimPredicateType::ClaimPredicateNot.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            ClaimPredicate::ClaimPredicateBeforeAbsoluteTime(value) => {
                ClaimPredicateType::ClaimPredicateBeforeAbsoluteTime
                    .to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            ClaimPredicate::ClaimPredicateBeforeRelativeTime(value) => {
                ClaimPredicateType::ClaimPredicateBeforeRelativeTime
                    .to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ClaimPredicateType::from_xdr_buffered(read_stream)? {
            ClaimPredicateType::ClaimPredicateUnconditional => {
                Ok(ClaimPredicate::ClaimPredicateUnconditional)
            }
            ClaimPredicateType::ClaimPredicateAnd => {
                Ok(ClaimPredicate::ClaimPredicateAnd(LimitedVarArray::<
                    ClaimPredicate,
                    2,
                >::from_xdr_buffered(
                    read_stream
                )?))
            }
            ClaimPredicateType::ClaimPredicateOr => {
                Ok(ClaimPredicate::ClaimPredicateOr(LimitedVarArray::<
                    ClaimPredicate,
                    2,
                >::from_xdr_buffered(
                    read_stream
                )?))
            }
            ClaimPredicateType::ClaimPredicateNot => {
                Ok(ClaimPredicate::ClaimPredicateNot(Option::<
                    Box<ClaimPredicate>,
                >::from_xdr_buffered(
                    read_stream
                )?))
            }
            ClaimPredicateType::ClaimPredicateBeforeAbsoluteTime => {
                Ok(ClaimPredicate::ClaimPredicateBeforeAbsoluteTime(
                    Int64::from_xdr_buffered(read_stream)?,
                ))
            }
            ClaimPredicateType::ClaimPredicateBeforeRelativeTime => {
                Ok(ClaimPredicate::ClaimPredicateBeforeRelativeTime(
                    Int64::from_xdr_buffered(read_stream)?,
                ))
            }
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ClaimPredicateType {
    ClaimPredicateUnconditional = 0,
    ClaimPredicateAnd = 1,
    ClaimPredicateOr = 2,
    ClaimPredicateNot = 3,
    ClaimPredicateBeforeAbsoluteTime = 4,
    ClaimPredicateBeforeRelativeTime = 5,
}
impl XdrCodec for ClaimPredicateType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ClaimPredicateType::ClaimPredicateUnconditional),
            1 => Ok(ClaimPredicateType::ClaimPredicateAnd),
            2 => Ok(ClaimPredicateType::ClaimPredicateOr),
            3 => Ok(ClaimPredicateType::ClaimPredicateNot),
            4 => Ok(ClaimPredicateType::ClaimPredicateBeforeAbsoluteTime),
            5 => Ok(ClaimPredicateType::ClaimPredicateBeforeRelativeTime),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct DataEntry {
    pub account_id: AccountId,
    pub data_name: String64,
    pub data_value: DataValue,
    pub ext: DataEntryExt,
}
impl XdrCodec for DataEntry {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.account_id.to_xdr_buffered(write_stream)?;
        self.data_name.to_xdr_buffered(write_stream)?;
        self.data_value.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(DataEntry {
            account_id: AccountId::from_xdr_buffered(read_stream)?,
            data_name: String64::from_xdr_buffered(read_stream)?,
            data_value: DataValue::from_xdr_buffered(read_stream)?,
            ext: DataEntryExt::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum DataEntryExt {
    V0,
    Default(i32),
}
impl XdrCodec for DataEntryExt {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            DataEntryExt::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            DataEntryExt::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(DataEntryExt::V0),
            code => Ok(DataEntryExt::Default(code)),
        }
    }
}

#[allow(dead_code)]
pub type DataValue = LimitedVarOpaque<64>;

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct OfferEntry {
    pub seller_id: AccountId,
    pub offer_id: Int64,
    pub selling: Asset,
    pub buying: Asset,
    pub amount: Int64,
    pub price: Price,
    pub flags: Uint32,
    pub ext: OfferEntryExt,
}
impl XdrCodec for OfferEntry {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.seller_id.to_xdr_buffered(write_stream)?;
        self.offer_id.to_xdr_buffered(write_stream)?;
        self.selling.to_xdr_buffered(write_stream)?;
        self.buying.to_xdr_buffered(write_stream)?;
        self.amount.to_xdr_buffered(write_stream)?;
        self.price.to_xdr_buffered(write_stream)?;
        self.flags.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(OfferEntry {
            seller_id: AccountId::from_xdr_buffered(read_stream)?,
            offer_id: Int64::from_xdr_buffered(read_stream)?,
            selling: Asset::from_xdr_buffered(read_stream)?,
            buying: Asset::from_xdr_buffered(read_stream)?,
            amount: Int64::from_xdr_buffered(read_stream)?,
            price: Price::from_xdr_buffered(read_stream)?,
            flags: Uint32::from_xdr_buffered(read_stream)?,
            ext: OfferEntryExt::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum OfferEntryExt {
    V0,
    Default(i32),
}
impl XdrCodec for OfferEntryExt {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            OfferEntryExt::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            OfferEntryExt::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(OfferEntryExt::V0),
            code => Ok(OfferEntryExt::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct Price {
    pub n: Int32,
    pub d: Int32,
}
impl XdrCodec for Price {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.n.to_xdr_buffered(write_stream)?;
        self.d.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(Price {
            n: Int32::from_xdr_buffered(read_stream)?,
            d: Int32::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
pub type Int32 = i32;

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct TrustLineEntry {
    pub account_id: AccountId,
    pub asset: Asset,
    pub balance: Int64,
    pub limit: Int64,
    pub flags: Uint32,
    pub ext: TrustLineEntryExt,
}
impl XdrCodec for TrustLineEntry {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.account_id.to_xdr_buffered(write_stream)?;
        self.asset.to_xdr_buffered(write_stream)?;
        self.balance.to_xdr_buffered(write_stream)?;
        self.limit.to_xdr_buffered(write_stream)?;
        self.flags.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(TrustLineEntry {
            account_id: AccountId::from_xdr_buffered(read_stream)?,
            asset: Asset::from_xdr_buffered(read_stream)?,
            balance: Int64::from_xdr_buffered(read_stream)?,
            limit: Int64::from_xdr_buffered(read_stream)?,
            flags: Uint32::from_xdr_buffered(read_stream)?,
            ext: TrustLineEntryExt::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum TrustLineEntryExt {
    V0,
    V1(TrustLineEntryV1),
    Default(i32),
}
impl XdrCodec for TrustLineEntryExt {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            TrustLineEntryExt::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            TrustLineEntryExt::V1(value) => {
                (1 as i32).to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TrustLineEntryExt::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(TrustLineEntryExt::V0),
            1 => Ok(TrustLineEntryExt::V1(TrustLineEntryV1::from_xdr_buffered(
                read_stream,
            )?)),
            code => Ok(TrustLineEntryExt::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct TrustLineEntryV1 {
    pub liabilities: Liabilities,
    pub ext: TrustLineEntryV1Ext,
}
impl XdrCodec for TrustLineEntryV1 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.liabilities.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(TrustLineEntryV1 {
            liabilities: Liabilities::from_xdr_buffered(read_stream)?,
            ext: TrustLineEntryV1Ext::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum TrustLineEntryV1Ext {
    V0,
    Default(i32),
}
impl XdrCodec for TrustLineEntryV1Ext {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            TrustLineEntryV1Ext::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            TrustLineEntryV1Ext::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(TrustLineEntryV1Ext::V0),
            code => Ok(TrustLineEntryV1Ext::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct Liabilities {
    pub buying: Int64,
    pub selling: Int64,
}
impl XdrCodec for Liabilities {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.buying.to_xdr_buffered(write_stream)?;
        self.selling.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(Liabilities {
            buying: Int64::from_xdr_buffered(read_stream)?,
            selling: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct AccountEntry {
    pub account_id: AccountId,
    pub balance: Int64,
    pub seq_num: SequenceNumber,
    pub num_sub_entries: Uint32,
    pub inflation_dest: Option<AccountId>,
    pub flags: Uint32,
    pub home_domain: String32,
    pub thresholds: Thresholds,
    pub signers: LimitedVarArray<Signer, MAX_SIGNERS>,
    pub ext: AccountEntryExt,
}
impl XdrCodec for AccountEntry {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.account_id.to_xdr_buffered(write_stream)?;
        self.balance.to_xdr_buffered(write_stream)?;
        self.seq_num.to_xdr_buffered(write_stream)?;
        self.num_sub_entries.to_xdr_buffered(write_stream)?;
        self.inflation_dest.to_xdr_buffered(write_stream)?;
        self.flags.to_xdr_buffered(write_stream)?;
        self.home_domain.to_xdr_buffered(write_stream)?;
        self.thresholds.to_xdr_buffered(write_stream)?;
        self.signers.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(AccountEntry {
            account_id: AccountId::from_xdr_buffered(read_stream)?,
            balance: Int64::from_xdr_buffered(read_stream)?,
            seq_num: SequenceNumber::from_xdr_buffered(read_stream)?,
            num_sub_entries: Uint32::from_xdr_buffered(read_stream)?,
            inflation_dest: Option::<AccountId>::from_xdr_buffered(read_stream)?,
            flags: Uint32::from_xdr_buffered(read_stream)?,
            home_domain: String32::from_xdr_buffered(read_stream)?,
            thresholds: Thresholds::from_xdr_buffered(read_stream)?,
            signers: LimitedVarArray::<Signer, MAX_SIGNERS>::from_xdr_buffered(read_stream)?,
            ext: AccountEntryExt::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum AccountEntryExt {
    V0,
    V1(AccountEntryExtensionV1),
    Default(i32),
}
impl XdrCodec for AccountEntryExt {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            AccountEntryExt::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            AccountEntryExt::V1(value) => {
                (1 as i32).to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            AccountEntryExt::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(AccountEntryExt::V0),
            1 => Ok(AccountEntryExt::V1(
                AccountEntryExtensionV1::from_xdr_buffered(read_stream)?,
            )),
            code => Ok(AccountEntryExt::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct AccountEntryExtensionV1 {
    pub liabilities: Liabilities,
    pub ext: AccountEntryExtensionV1Ext,
}
impl XdrCodec for AccountEntryExtensionV1 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.liabilities.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(AccountEntryExtensionV1 {
            liabilities: Liabilities::from_xdr_buffered(read_stream)?,
            ext: AccountEntryExtensionV1Ext::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum AccountEntryExtensionV1Ext {
    V0,
    V2(AccountEntryExtensionV2),
    Default(i32),
}
impl XdrCodec for AccountEntryExtensionV1Ext {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            AccountEntryExtensionV1Ext::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            AccountEntryExtensionV1Ext::V2(value) => {
                (2 as i32).to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            AccountEntryExtensionV1Ext::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(AccountEntryExtensionV1Ext::V0),
            2 => Ok(AccountEntryExtensionV1Ext::V2(
                AccountEntryExtensionV2::from_xdr_buffered(read_stream)?,
            )),
            code => Ok(AccountEntryExtensionV1Ext::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct AccountEntryExtensionV2 {
    pub num_sponsored: Uint32,
    pub num_sponsoring: Uint32,
    pub signer_sponsoring_i_ds: LimitedVarArray<SponsorshipDescriptor, MAX_SIGNERS>,
    pub ext: AccountEntryExtensionV2Ext,
}
impl XdrCodec for AccountEntryExtensionV2 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.num_sponsored.to_xdr_buffered(write_stream)?;
        self.num_sponsoring.to_xdr_buffered(write_stream)?;
        self.signer_sponsoring_i_ds.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(AccountEntryExtensionV2 {
            num_sponsored: Uint32::from_xdr_buffered(read_stream)?,
            num_sponsoring: Uint32::from_xdr_buffered(read_stream)?,
            signer_sponsoring_i_ds:
                LimitedVarArray::<SponsorshipDescriptor, MAX_SIGNERS>::from_xdr_buffered(
                    read_stream,
                )?,
            ext: AccountEntryExtensionV2Ext::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum AccountEntryExtensionV2Ext {
    V0,
    Default(i32),
}
impl XdrCodec for AccountEntryExtensionV2Ext {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            AccountEntryExtensionV2Ext::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            AccountEntryExtensionV2Ext::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(AccountEntryExtensionV2Ext::V0),
            code => Ok(AccountEntryExtensionV2Ext::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct Signer {
    pub key: SignerKey,
    pub weight: Uint32,
}
impl XdrCodec for Signer {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.key.to_xdr_buffered(write_stream)?;
        self.weight.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(Signer {
            key: SignerKey::from_xdr_buffered(read_stream)?,
            weight: Uint32::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum SignerKey {
    SignerKeyTypeEd25519(Uint256),
    SignerKeyTypePreAuthTx(Uint256),
    SignerKeyTypeHashX(Uint256),
}
impl XdrCodec for SignerKey {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            SignerKey::SignerKeyTypeEd25519(value) => {
                SignerKeyType::SignerKeyTypeEd25519.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            SignerKey::SignerKeyTypePreAuthTx(value) => {
                SignerKeyType::SignerKeyTypePreAuthTx.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            SignerKey::SignerKeyTypeHashX(value) => {
                SignerKeyType::SignerKeyTypeHashX.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match SignerKeyType::from_xdr_buffered(read_stream)? {
            SignerKeyType::SignerKeyTypeEd25519 => Ok(SignerKey::SignerKeyTypeEd25519(
                Uint256::from_xdr_buffered(read_stream)?,
            )),
            SignerKeyType::SignerKeyTypePreAuthTx => Ok(SignerKey::SignerKeyTypePreAuthTx(
                Uint256::from_xdr_buffered(read_stream)?,
            )),
            SignerKeyType::SignerKeyTypeHashX => Ok(SignerKey::SignerKeyTypeHashX(
                Uint256::from_xdr_buffered(read_stream)?,
            )),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum SignerKeyType {
    SignerKeyTypeEd25519 = 0,
    SignerKeyTypePreAuthTx = 1,
    SignerKeyTypeHashX = 2,
}
impl XdrCodec for SignerKeyType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(SignerKeyType::SignerKeyTypeEd25519),
            1 => Ok(SignerKeyType::SignerKeyTypePreAuthTx),
            2 => Ok(SignerKeyType::SignerKeyTypeHashX),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
pub type Thresholds = [u8; 4];

#[allow(dead_code)]
pub type String32 = LimitedString<32>;

#[allow(dead_code)]
pub type SequenceNumber = Int64;

#[allow(dead_code)]
pub type Uint32 = u32;

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct TransactionMetaV1 {
    pub tx_changes: LedgerEntryChanges,
    pub operations: UnlimitedVarArray<OperationMeta>,
}
impl XdrCodec for TransactionMetaV1 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.tx_changes.to_xdr_buffered(write_stream)?;
        self.operations.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(TransactionMetaV1 {
            tx_changes: LedgerEntryChanges::from_xdr_buffered(read_stream)?,
            operations: UnlimitedVarArray::<OperationMeta>::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct OperationMeta {
    pub changes: LedgerEntryChanges,
}
impl XdrCodec for OperationMeta {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.changes.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(OperationMeta {
            changes: LedgerEntryChanges::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct TransactionResult {
    pub fee_charged: Int64,
    pub result: TransactionResultResult,
    pub ext: TransactionResultExt,
}
impl XdrCodec for TransactionResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.fee_charged.to_xdr_buffered(write_stream)?;
        self.result.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(TransactionResult {
            fee_charged: Int64::from_xdr_buffered(read_stream)?,
            result: TransactionResultResult::from_xdr_buffered(read_stream)?,
            ext: TransactionResultExt::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum TransactionResultExt {
    V0,
    Default(i32),
}
impl XdrCodec for TransactionResultExt {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            TransactionResultExt::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            TransactionResultExt::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(TransactionResultExt::V0),
            code => Ok(TransactionResultExt::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum TransactionResultResult {
    TxFeeBumpInnerSuccess(InnerTransactionResultPair),
    TxFeeBumpInnerFailed(InnerTransactionResultPair),
    TxSuccess(UnlimitedVarArray<OperationResult>),
    TxFailed(UnlimitedVarArray<OperationResult>),
    Default(TransactionResultCode),
}
impl XdrCodec for TransactionResultResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            TransactionResultResult::TxFeeBumpInnerSuccess(value) => {
                TransactionResultCode::TxFeeBumpInnerSuccess.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TransactionResultResult::TxFeeBumpInnerFailed(value) => {
                TransactionResultCode::TxFeeBumpInnerFailed.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TransactionResultResult::TxSuccess(value) => {
                TransactionResultCode::TxSuccess.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TransactionResultResult::TxFailed(value) => {
                TransactionResultCode::TxFailed.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TransactionResultResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match TransactionResultCode::from_xdr_buffered(read_stream)? {
            TransactionResultCode::TxFeeBumpInnerSuccess => {
                Ok(TransactionResultResult::TxFeeBumpInnerSuccess(
                    InnerTransactionResultPair::from_xdr_buffered(read_stream)?,
                ))
            }
            TransactionResultCode::TxFeeBumpInnerFailed => {
                Ok(TransactionResultResult::TxFeeBumpInnerFailed(
                    InnerTransactionResultPair::from_xdr_buffered(read_stream)?,
                ))
            }
            TransactionResultCode::TxSuccess => {
                Ok(TransactionResultResult::TxSuccess(UnlimitedVarArray::<
                    OperationResult,
                >::from_xdr_buffered(
                    read_stream
                )?))
            }
            TransactionResultCode::TxFailed => {
                Ok(TransactionResultResult::TxFailed(UnlimitedVarArray::<
                    OperationResult,
                >::from_xdr_buffered(
                    read_stream
                )?))
            }
            code => Ok(TransactionResultResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum TransactionResultCode {
    TxFeeBumpInnerSuccess = 1,
    TxSuccess = 0,
    TxFailed = -1,
    TxTooEarly = -2,
    TxTooLate = -3,
    TxMissingOperation = -4,
    TxBadSeq = -5,
    TxBadAuth = -6,
    TxInsufficientBalance = -7,
    TxNoAccount = -8,
    TxInsufficientFee = -9,
    TxBadAuthExtra = -10,
    TxInternalError = -11,
    TxNotSupported = -12,
    TxFeeBumpInnerFailed = -13,
    TxBadSponsorship = -14,
}
impl XdrCodec for TransactionResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            1 => Ok(TransactionResultCode::TxFeeBumpInnerSuccess),
            0 => Ok(TransactionResultCode::TxSuccess),
            -1 => Ok(TransactionResultCode::TxFailed),
            -2 => Ok(TransactionResultCode::TxTooEarly),
            -3 => Ok(TransactionResultCode::TxTooLate),
            -4 => Ok(TransactionResultCode::TxMissingOperation),
            -5 => Ok(TransactionResultCode::TxBadSeq),
            -6 => Ok(TransactionResultCode::TxBadAuth),
            -7 => Ok(TransactionResultCode::TxInsufficientBalance),
            -8 => Ok(TransactionResultCode::TxNoAccount),
            -9 => Ok(TransactionResultCode::TxInsufficientFee),
            -10 => Ok(TransactionResultCode::TxBadAuthExtra),
            -11 => Ok(TransactionResultCode::TxInternalError),
            -12 => Ok(TransactionResultCode::TxNotSupported),
            -13 => Ok(TransactionResultCode::TxFeeBumpInnerFailed),
            -14 => Ok(TransactionResultCode::TxBadSponsorship),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum OperationResult {
    OpInner(OperationResultTr),
    Default(OperationResultCode),
}
impl XdrCodec for OperationResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            OperationResult::OpInner(value) => {
                OperationResultCode::OpInner.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match OperationResultCode::from_xdr_buffered(read_stream)? {
            OperationResultCode::OpInner => Ok(OperationResult::OpInner(
                OperationResultTr::from_xdr_buffered(read_stream)?,
            )),
            code => Ok(OperationResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum OperationResultCode {
    OpInner = 0,
    OpBadAuth = -1,
    OpNoAccount = -2,
    OpNotSupported = -3,
    OpTooManySubentries = -4,
    OpExceededWorkLimit = -5,
    OpTooManySponsoring = -6,
}
impl XdrCodec for OperationResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(OperationResultCode::OpInner),
            -1 => Ok(OperationResultCode::OpBadAuth),
            -2 => Ok(OperationResultCode::OpNoAccount),
            -3 => Ok(OperationResultCode::OpNotSupported),
            -4 => Ok(OperationResultCode::OpTooManySubentries),
            -5 => Ok(OperationResultCode::OpExceededWorkLimit),
            -6 => Ok(OperationResultCode::OpTooManySponsoring),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum OperationResultTr {
    CreateAccount(CreateAccountResult),
    Payment(PaymentResult),
    PathPaymentStrictReceive(PathPaymentStrictReceiveResult),
    ManageSellOffer(ManageSellOfferResult),
    CreatePassiveSellOffer(ManageSellOfferResult),
    SetOptions(SetOptionsResult),
    ChangeTrust(ChangeTrustResult),
    AllowTrust(AllowTrustResult),
    AccountMerge(AccountMergeResult),
    Inflation(InflationResult),
    ManageData(ManageDataResult),
    BumpSequence(BumpSequenceResult),
    ManageBuyOffer(ManageBuyOfferResult),
    PathPaymentStrictSend(PathPaymentStrictSendResult),
    CreateClaimableBalance(CreateClaimableBalanceResult),
    ClaimClaimableBalance(ClaimClaimableBalanceResult),
    BeginSponsoringFutureReserves(BeginSponsoringFutureReservesResult),
    EndSponsoringFutureReserves(EndSponsoringFutureReservesResult),
    RevokeSponsorship(RevokeSponsorshipResult),
    Clawback(ClawbackResult),
    ClawbackClaimableBalance(ClawbackClaimableBalanceResult),
    SetTrustLineFlags(SetTrustLineFlagsResult),
}
impl XdrCodec for OperationResultTr {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            OperationResultTr::CreateAccount(value) => {
                OperationType::CreateAccount.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::Payment(value) => {
                OperationType::Payment.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::PathPaymentStrictReceive(value) => {
                OperationType::PathPaymentStrictReceive.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::ManageSellOffer(value) => {
                OperationType::ManageSellOffer.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::CreatePassiveSellOffer(value) => {
                OperationType::CreatePassiveSellOffer.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::SetOptions(value) => {
                OperationType::SetOptions.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::ChangeTrust(value) => {
                OperationType::ChangeTrust.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::AllowTrust(value) => {
                OperationType::AllowTrust.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::AccountMerge(value) => {
                OperationType::AccountMerge.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::Inflation(value) => {
                OperationType::Inflation.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::ManageData(value) => {
                OperationType::ManageData.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::BumpSequence(value) => {
                OperationType::BumpSequence.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::ManageBuyOffer(value) => {
                OperationType::ManageBuyOffer.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::PathPaymentStrictSend(value) => {
                OperationType::PathPaymentStrictSend.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::CreateClaimableBalance(value) => {
                OperationType::CreateClaimableBalance.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::ClaimClaimableBalance(value) => {
                OperationType::ClaimClaimableBalance.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::BeginSponsoringFutureReserves(value) => {
                OperationType::BeginSponsoringFutureReserves.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::EndSponsoringFutureReserves(value) => {
                OperationType::EndSponsoringFutureReserves.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::RevokeSponsorship(value) => {
                OperationType::RevokeSponsorship.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::Clawback(value) => {
                OperationType::Clawback.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::ClawbackClaimableBalance(value) => {
                OperationType::ClawbackClaimableBalance.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationResultTr::SetTrustLineFlags(value) => {
                OperationType::SetTrustLineFlags.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match OperationType::from_xdr_buffered(read_stream)? {
            OperationType::CreateAccount => Ok(OperationResultTr::CreateAccount(
                CreateAccountResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::Payment => Ok(OperationResultTr::Payment(
                PaymentResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::PathPaymentStrictReceive => {
                Ok(OperationResultTr::PathPaymentStrictReceive(
                    PathPaymentStrictReceiveResult::from_xdr_buffered(read_stream)?,
                ))
            }
            OperationType::ManageSellOffer => Ok(OperationResultTr::ManageSellOffer(
                ManageSellOfferResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::CreatePassiveSellOffer => Ok(OperationResultTr::CreatePassiveSellOffer(
                ManageSellOfferResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::SetOptions => Ok(OperationResultTr::SetOptions(
                SetOptionsResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::ChangeTrust => Ok(OperationResultTr::ChangeTrust(
                ChangeTrustResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::AllowTrust => Ok(OperationResultTr::AllowTrust(
                AllowTrustResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::AccountMerge => Ok(OperationResultTr::AccountMerge(
                AccountMergeResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::Inflation => Ok(OperationResultTr::Inflation(
                InflationResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::ManageData => Ok(OperationResultTr::ManageData(
                ManageDataResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::BumpSequence => Ok(OperationResultTr::BumpSequence(
                BumpSequenceResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::ManageBuyOffer => Ok(OperationResultTr::ManageBuyOffer(
                ManageBuyOfferResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::PathPaymentStrictSend => Ok(OperationResultTr::PathPaymentStrictSend(
                PathPaymentStrictSendResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::CreateClaimableBalance => Ok(OperationResultTr::CreateClaimableBalance(
                CreateClaimableBalanceResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::ClaimClaimableBalance => Ok(OperationResultTr::ClaimClaimableBalance(
                ClaimClaimableBalanceResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::BeginSponsoringFutureReserves => {
                Ok(OperationResultTr::BeginSponsoringFutureReserves(
                    BeginSponsoringFutureReservesResult::from_xdr_buffered(read_stream)?,
                ))
            }
            OperationType::EndSponsoringFutureReserves => {
                Ok(OperationResultTr::EndSponsoringFutureReserves(
                    EndSponsoringFutureReservesResult::from_xdr_buffered(read_stream)?,
                ))
            }
            OperationType::RevokeSponsorship => Ok(OperationResultTr::RevokeSponsorship(
                RevokeSponsorshipResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::Clawback => Ok(OperationResultTr::Clawback(
                ClawbackResult::from_xdr_buffered(read_stream)?,
            )),
            OperationType::ClawbackClaimableBalance => {
                Ok(OperationResultTr::ClawbackClaimableBalance(
                    ClawbackClaimableBalanceResult::from_xdr_buffered(read_stream)?,
                ))
            }
            OperationType::SetTrustLineFlags => Ok(OperationResultTr::SetTrustLineFlags(
                SetTrustLineFlagsResult::from_xdr_buffered(read_stream)?,
            )),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum OperationType {
    CreateAccount = 0,
    Payment = 1,
    PathPaymentStrictReceive = 2,
    ManageSellOffer = 3,
    CreatePassiveSellOffer = 4,
    SetOptions = 5,
    ChangeTrust = 6,
    AllowTrust = 7,
    AccountMerge = 8,
    Inflation = 9,
    ManageData = 10,
    BumpSequence = 11,
    ManageBuyOffer = 12,
    PathPaymentStrictSend = 13,
    CreateClaimableBalance = 14,
    ClaimClaimableBalance = 15,
    BeginSponsoringFutureReserves = 16,
    EndSponsoringFutureReserves = 17,
    RevokeSponsorship = 18,
    Clawback = 19,
    ClawbackClaimableBalance = 20,
    SetTrustLineFlags = 21,
}
impl XdrCodec for OperationType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(OperationType::CreateAccount),
            1 => Ok(OperationType::Payment),
            2 => Ok(OperationType::PathPaymentStrictReceive),
            3 => Ok(OperationType::ManageSellOffer),
            4 => Ok(OperationType::CreatePassiveSellOffer),
            5 => Ok(OperationType::SetOptions),
            6 => Ok(OperationType::ChangeTrust),
            7 => Ok(OperationType::AllowTrust),
            8 => Ok(OperationType::AccountMerge),
            9 => Ok(OperationType::Inflation),
            10 => Ok(OperationType::ManageData),
            11 => Ok(OperationType::BumpSequence),
            12 => Ok(OperationType::ManageBuyOffer),
            13 => Ok(OperationType::PathPaymentStrictSend),
            14 => Ok(OperationType::CreateClaimableBalance),
            15 => Ok(OperationType::ClaimClaimableBalance),
            16 => Ok(OperationType::BeginSponsoringFutureReserves),
            17 => Ok(OperationType::EndSponsoringFutureReserves),
            18 => Ok(OperationType::RevokeSponsorship),
            19 => Ok(OperationType::Clawback),
            20 => Ok(OperationType::ClawbackClaimableBalance),
            21 => Ok(OperationType::SetTrustLineFlags),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum SetTrustLineFlagsResult {
    SetTrustLineFlagsSuccess,
    Default(SetTrustLineFlagsResultCode),
}
impl XdrCodec for SetTrustLineFlagsResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            SetTrustLineFlagsResult::SetTrustLineFlagsSuccess => {
                SetTrustLineFlagsResultCode::SetTrustLineFlagsSuccess
                    .to_xdr_buffered(write_stream)?
            }
            SetTrustLineFlagsResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match SetTrustLineFlagsResultCode::from_xdr_buffered(read_stream)? {
            SetTrustLineFlagsResultCode::SetTrustLineFlagsSuccess => {
                Ok(SetTrustLineFlagsResult::SetTrustLineFlagsSuccess)
            }
            code => Ok(SetTrustLineFlagsResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum SetTrustLineFlagsResultCode {
    SetTrustLineFlagsSuccess = 0,
    SetTrustLineFlagsMalformed = -1,
    SetTrustLineFlagsNoTrustLine = -2,
    SetTrustLineFlagsCantRevoke = -3,
    SetTrustLineFlagsInvalidState = -4,
}
impl XdrCodec for SetTrustLineFlagsResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(SetTrustLineFlagsResultCode::SetTrustLineFlagsSuccess),
            -1 => Ok(SetTrustLineFlagsResultCode::SetTrustLineFlagsMalformed),
            -2 => Ok(SetTrustLineFlagsResultCode::SetTrustLineFlagsNoTrustLine),
            -3 => Ok(SetTrustLineFlagsResultCode::SetTrustLineFlagsCantRevoke),
            -4 => Ok(SetTrustLineFlagsResultCode::SetTrustLineFlagsInvalidState),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ClawbackClaimableBalanceResult {
    ClawbackClaimableBalanceSuccess,
    Default(ClawbackClaimableBalanceResultCode),
}
impl XdrCodec for ClawbackClaimableBalanceResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ClawbackClaimableBalanceResult::ClawbackClaimableBalanceSuccess => {
                ClawbackClaimableBalanceResultCode::ClawbackClaimableBalanceSuccess
                    .to_xdr_buffered(write_stream)?
            }
            ClawbackClaimableBalanceResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ClawbackClaimableBalanceResultCode::from_xdr_buffered(read_stream)? {
            ClawbackClaimableBalanceResultCode::ClawbackClaimableBalanceSuccess => {
                Ok(ClawbackClaimableBalanceResult::ClawbackClaimableBalanceSuccess)
            }
            code => Ok(ClawbackClaimableBalanceResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ClawbackClaimableBalanceResultCode {
    ClawbackClaimableBalanceSuccess = 0,
    ClawbackClaimableBalanceDoesNotExist = -1,
    ClawbackClaimableBalanceNotIssuer = -2,
    ClawbackClaimableBalanceNotClawbackEnabled = -3,
}
impl XdrCodec for ClawbackClaimableBalanceResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ClawbackClaimableBalanceResultCode::ClawbackClaimableBalanceSuccess),
            -1 => Ok(ClawbackClaimableBalanceResultCode::ClawbackClaimableBalanceDoesNotExist),
            -2 => Ok(ClawbackClaimableBalanceResultCode::ClawbackClaimableBalanceNotIssuer),
            -3 => {
                Ok(ClawbackClaimableBalanceResultCode::ClawbackClaimableBalanceNotClawbackEnabled)
            }
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ClawbackResult {
    ClawbackSuccess,
    Default(ClawbackResultCode),
}
impl XdrCodec for ClawbackResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ClawbackResult::ClawbackSuccess => {
                ClawbackResultCode::ClawbackSuccess.to_xdr_buffered(write_stream)?
            }
            ClawbackResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ClawbackResultCode::from_xdr_buffered(read_stream)? {
            ClawbackResultCode::ClawbackSuccess => Ok(ClawbackResult::ClawbackSuccess),
            code => Ok(ClawbackResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ClawbackResultCode {
    ClawbackSuccess = 0,
    ClawbackMalformed = -1,
    ClawbackNotClawbackEnabled = -2,
    ClawbackNoTrust = -3,
    ClawbackUnderfunded = -4,
}
impl XdrCodec for ClawbackResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ClawbackResultCode::ClawbackSuccess),
            -1 => Ok(ClawbackResultCode::ClawbackMalformed),
            -2 => Ok(ClawbackResultCode::ClawbackNotClawbackEnabled),
            -3 => Ok(ClawbackResultCode::ClawbackNoTrust),
            -4 => Ok(ClawbackResultCode::ClawbackUnderfunded),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum RevokeSponsorshipResult {
    RevokeSponsorshipSuccess,
    Default(RevokeSponsorshipResultCode),
}
impl XdrCodec for RevokeSponsorshipResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            RevokeSponsorshipResult::RevokeSponsorshipSuccess => {
                RevokeSponsorshipResultCode::RevokeSponsorshipSuccess
                    .to_xdr_buffered(write_stream)?
            }
            RevokeSponsorshipResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match RevokeSponsorshipResultCode::from_xdr_buffered(read_stream)? {
            RevokeSponsorshipResultCode::RevokeSponsorshipSuccess => {
                Ok(RevokeSponsorshipResult::RevokeSponsorshipSuccess)
            }
            code => Ok(RevokeSponsorshipResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum RevokeSponsorshipResultCode {
    RevokeSponsorshipSuccess = 0,
    RevokeSponsorshipDoesNotExist = -1,
    RevokeSponsorshipNotSponsor = -2,
    RevokeSponsorshipLowReserve = -3,
    RevokeSponsorshipOnlyTransferable = -4,
}
impl XdrCodec for RevokeSponsorshipResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(RevokeSponsorshipResultCode::RevokeSponsorshipSuccess),
            -1 => Ok(RevokeSponsorshipResultCode::RevokeSponsorshipDoesNotExist),
            -2 => Ok(RevokeSponsorshipResultCode::RevokeSponsorshipNotSponsor),
            -3 => Ok(RevokeSponsorshipResultCode::RevokeSponsorshipLowReserve),
            -4 => Ok(RevokeSponsorshipResultCode::RevokeSponsorshipOnlyTransferable),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum EndSponsoringFutureReservesResult {
    EndSponsoringFutureReservesSuccess,
    Default(EndSponsoringFutureReservesResultCode),
}
impl XdrCodec for EndSponsoringFutureReservesResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            EndSponsoringFutureReservesResult::EndSponsoringFutureReservesSuccess => {
                EndSponsoringFutureReservesResultCode::EndSponsoringFutureReservesSuccess
                    .to_xdr_buffered(write_stream)?
            }
            EndSponsoringFutureReservesResult::Default(code) => {
                code.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match EndSponsoringFutureReservesResultCode::from_xdr_buffered(read_stream)? {
            EndSponsoringFutureReservesResultCode::EndSponsoringFutureReservesSuccess => {
                Ok(EndSponsoringFutureReservesResult::EndSponsoringFutureReservesSuccess)
            }
            code => Ok(EndSponsoringFutureReservesResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum EndSponsoringFutureReservesResultCode {
    EndSponsoringFutureReservesSuccess = 0,
    EndSponsoringFutureReservesNotSponsored = -1,
}
impl XdrCodec for EndSponsoringFutureReservesResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(EndSponsoringFutureReservesResultCode::EndSponsoringFutureReservesSuccess),
            -1 => {
                Ok(EndSponsoringFutureReservesResultCode::EndSponsoringFutureReservesNotSponsored)
            }
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum BeginSponsoringFutureReservesResult {
    BeginSponsoringFutureReservesSuccess,
    Default(BeginSponsoringFutureReservesResultCode),
}
impl XdrCodec for BeginSponsoringFutureReservesResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            BeginSponsoringFutureReservesResult::BeginSponsoringFutureReservesSuccess => {
                BeginSponsoringFutureReservesResultCode::BeginSponsoringFutureReservesSuccess
                    .to_xdr_buffered(write_stream)?
            }
            BeginSponsoringFutureReservesResult::Default(code) => {
                code.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match BeginSponsoringFutureReservesResultCode::from_xdr_buffered(read_stream)? {
            BeginSponsoringFutureReservesResultCode::BeginSponsoringFutureReservesSuccess => {
                Ok(BeginSponsoringFutureReservesResult::BeginSponsoringFutureReservesSuccess)
            }
            code => Ok(BeginSponsoringFutureReservesResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum BeginSponsoringFutureReservesResultCode {
    BeginSponsoringFutureReservesSuccess = 0,
    BeginSponsoringFutureReservesMalformed = -1,
    BeginSponsoringFutureReservesAlreadySponsored = -2,
    BeginSponsoringFutureReservesRecursive = -3,
}
impl XdrCodec for BeginSponsoringFutureReservesResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(BeginSponsoringFutureReservesResultCode::BeginSponsoringFutureReservesSuccess),
            -1 => Ok(BeginSponsoringFutureReservesResultCode::BeginSponsoringFutureReservesMalformed),
            -2 => Ok(BeginSponsoringFutureReservesResultCode::BeginSponsoringFutureReservesAlreadySponsored),
            -3 => Ok(BeginSponsoringFutureReservesResultCode::BeginSponsoringFutureReservesRecursive),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {at_position: read_stream.get_position()})
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ClaimClaimableBalanceResult {
    ClaimClaimableBalanceSuccess,
    Default(ClaimClaimableBalanceResultCode),
}
impl XdrCodec for ClaimClaimableBalanceResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ClaimClaimableBalanceResult::ClaimClaimableBalanceSuccess => {
                ClaimClaimableBalanceResultCode::ClaimClaimableBalanceSuccess
                    .to_xdr_buffered(write_stream)?
            }
            ClaimClaimableBalanceResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ClaimClaimableBalanceResultCode::from_xdr_buffered(read_stream)? {
            ClaimClaimableBalanceResultCode::ClaimClaimableBalanceSuccess => {
                Ok(ClaimClaimableBalanceResult::ClaimClaimableBalanceSuccess)
            }
            code => Ok(ClaimClaimableBalanceResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ClaimClaimableBalanceResultCode {
    ClaimClaimableBalanceSuccess = 0,
    ClaimClaimableBalanceDoesNotExist = -1,
    ClaimClaimableBalanceCannotClaim = -2,
    ClaimClaimableBalanceLineFull = -3,
    ClaimClaimableBalanceNoTrust = -4,
    ClaimClaimableBalanceNotAuthorized = -5,
}
impl XdrCodec for ClaimClaimableBalanceResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ClaimClaimableBalanceResultCode::ClaimClaimableBalanceSuccess),
            -1 => Ok(ClaimClaimableBalanceResultCode::ClaimClaimableBalanceDoesNotExist),
            -2 => Ok(ClaimClaimableBalanceResultCode::ClaimClaimableBalanceCannotClaim),
            -3 => Ok(ClaimClaimableBalanceResultCode::ClaimClaimableBalanceLineFull),
            -4 => Ok(ClaimClaimableBalanceResultCode::ClaimClaimableBalanceNoTrust),
            -5 => Ok(ClaimClaimableBalanceResultCode::ClaimClaimableBalanceNotAuthorized),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum CreateClaimableBalanceResult {
    CreateClaimableBalanceSuccess(ClaimableBalanceId),
    Default(CreateClaimableBalanceResultCode),
}
impl XdrCodec for CreateClaimableBalanceResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            CreateClaimableBalanceResult::CreateClaimableBalanceSuccess(value) => {
                CreateClaimableBalanceResultCode::CreateClaimableBalanceSuccess
                    .to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            CreateClaimableBalanceResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match CreateClaimableBalanceResultCode::from_xdr_buffered(read_stream)? {
            CreateClaimableBalanceResultCode::CreateClaimableBalanceSuccess => {
                Ok(CreateClaimableBalanceResult::CreateClaimableBalanceSuccess(
                    ClaimableBalanceId::from_xdr_buffered(read_stream)?,
                ))
            }
            code => Ok(CreateClaimableBalanceResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum CreateClaimableBalanceResultCode {
    CreateClaimableBalanceSuccess = 0,
    CreateClaimableBalanceMalformed = -1,
    CreateClaimableBalanceLowReserve = -2,
    CreateClaimableBalanceNoTrust = -3,
    CreateClaimableBalanceNotAuthorized = -4,
    CreateClaimableBalanceUnderfunded = -5,
}
impl XdrCodec for CreateClaimableBalanceResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(CreateClaimableBalanceResultCode::CreateClaimableBalanceSuccess),
            -1 => Ok(CreateClaimableBalanceResultCode::CreateClaimableBalanceMalformed),
            -2 => Ok(CreateClaimableBalanceResultCode::CreateClaimableBalanceLowReserve),
            -3 => Ok(CreateClaimableBalanceResultCode::CreateClaimableBalanceNoTrust),
            -4 => Ok(CreateClaimableBalanceResultCode::CreateClaimableBalanceNotAuthorized),
            -5 => Ok(CreateClaimableBalanceResultCode::CreateClaimableBalanceUnderfunded),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum PathPaymentStrictSendResult {
    PathPaymentStrictSendSuccess(PathPaymentStrictSendResultSuccess),
    PathPaymentStrictSendNoIssuer(Asset),
    Default(PathPaymentStrictSendResultCode),
}
impl XdrCodec for PathPaymentStrictSendResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            PathPaymentStrictSendResult::PathPaymentStrictSendSuccess(value) => {
                PathPaymentStrictSendResultCode::PathPaymentStrictSendSuccess
                    .to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            PathPaymentStrictSendResult::PathPaymentStrictSendNoIssuer(value) => {
                PathPaymentStrictSendResultCode::PathPaymentStrictSendNoIssuer
                    .to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            PathPaymentStrictSendResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match PathPaymentStrictSendResultCode::from_xdr_buffered(read_stream)? {
            PathPaymentStrictSendResultCode::PathPaymentStrictSendSuccess => {
                Ok(PathPaymentStrictSendResult::PathPaymentStrictSendSuccess(
                    PathPaymentStrictSendResultSuccess::from_xdr_buffered(read_stream)?,
                ))
            }
            PathPaymentStrictSendResultCode::PathPaymentStrictSendNoIssuer => {
                Ok(PathPaymentStrictSendResult::PathPaymentStrictSendNoIssuer(
                    Asset::from_xdr_buffered(read_stream)?,
                ))
            }
            code => Ok(PathPaymentStrictSendResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum PathPaymentStrictSendResultCode {
    PathPaymentStrictSendSuccess = 0,
    PathPaymentStrictSendMalformed = -1,
    PathPaymentStrictSendUnderfunded = -2,
    PathPaymentStrictSendSrcNoTrust = -3,
    PathPaymentStrictSendSrcNotAuthorized = -4,
    PathPaymentStrictSendNoDestination = -5,
    PathPaymentStrictSendNoTrust = -6,
    PathPaymentStrictSendNotAuthorized = -7,
    PathPaymentStrictSendLineFull = -8,
    PathPaymentStrictSendNoIssuer = -9,
    PathPaymentStrictSendTooFewOffers = -10,
    PathPaymentStrictSendOfferCrossSelf = -11,
    PathPaymentStrictSendUnderDestmin = -12,
}
impl XdrCodec for PathPaymentStrictSendResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendSuccess),
            -1 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendMalformed),
            -2 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendUnderfunded),
            -3 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendSrcNoTrust),
            -4 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendSrcNotAuthorized),
            -5 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendNoDestination),
            -6 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendNoTrust),
            -7 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendNotAuthorized),
            -8 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendLineFull),
            -9 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendNoIssuer),
            -10 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendTooFewOffers),
            -11 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendOfferCrossSelf),
            -12 => Ok(PathPaymentStrictSendResultCode::PathPaymentStrictSendUnderDestmin),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct PathPaymentStrictSendResultSuccess {
    pub offers: UnlimitedVarArray<ClaimOfferAtom>,
    pub last: SimplePaymentResult,
}
impl XdrCodec for PathPaymentStrictSendResultSuccess {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.offers.to_xdr_buffered(write_stream)?;
        self.last.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(PathPaymentStrictSendResultSuccess {
            offers: UnlimitedVarArray::<ClaimOfferAtom>::from_xdr_buffered(read_stream)?,
            last: SimplePaymentResult::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct SimplePaymentResult {
    pub destination: AccountId,
    pub asset: Asset,
    pub amount: Int64,
}
impl XdrCodec for SimplePaymentResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.destination.to_xdr_buffered(write_stream)?;
        self.asset.to_xdr_buffered(write_stream)?;
        self.amount.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(SimplePaymentResult {
            destination: AccountId::from_xdr_buffered(read_stream)?,
            asset: Asset::from_xdr_buffered(read_stream)?,
            amount: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ClaimOfferAtom {
    pub seller_id: AccountId,
    pub offer_id: Int64,
    pub asset_sold: Asset,
    pub amount_sold: Int64,
    pub asset_bought: Asset,
    pub amount_bought: Int64,
}
impl XdrCodec for ClaimOfferAtom {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.seller_id.to_xdr_buffered(write_stream)?;
        self.offer_id.to_xdr_buffered(write_stream)?;
        self.asset_sold.to_xdr_buffered(write_stream)?;
        self.amount_sold.to_xdr_buffered(write_stream)?;
        self.asset_bought.to_xdr_buffered(write_stream)?;
        self.amount_bought.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ClaimOfferAtom {
            seller_id: AccountId::from_xdr_buffered(read_stream)?,
            offer_id: Int64::from_xdr_buffered(read_stream)?,
            asset_sold: Asset::from_xdr_buffered(read_stream)?,
            amount_sold: Int64::from_xdr_buffered(read_stream)?,
            asset_bought: Asset::from_xdr_buffered(read_stream)?,
            amount_bought: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ManageBuyOfferResult {
    ManageBuyOfferSuccess(ManageOfferSuccessResult),
    Default(ManageBuyOfferResultCode),
}
impl XdrCodec for ManageBuyOfferResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ManageBuyOfferResult::ManageBuyOfferSuccess(value) => {
                ManageBuyOfferResultCode::ManageBuyOfferSuccess.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            ManageBuyOfferResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ManageBuyOfferResultCode::from_xdr_buffered(read_stream)? {
            ManageBuyOfferResultCode::ManageBuyOfferSuccess => {
                Ok(ManageBuyOfferResult::ManageBuyOfferSuccess(
                    ManageOfferSuccessResult::from_xdr_buffered(read_stream)?,
                ))
            }
            code => Ok(ManageBuyOfferResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ManageBuyOfferResultCode {
    ManageBuyOfferSuccess = 0,
    ManageBuyOfferMalformed = -1,
    ManageBuyOfferSellNoTrust = -2,
    ManageBuyOfferBuyNoTrust = -3,
    ManageBuyOfferSellNotAuthorized = -4,
    ManageBuyOfferBuyNotAuthorized = -5,
    ManageBuyOfferLineFull = -6,
    ManageBuyOfferUnderfunded = -7,
    ManageBuyOfferCrossSelf = -8,
    ManageBuyOfferSellNoIssuer = -9,
    ManageBuyOfferBuyNoIssuer = -10,
    ManageBuyOfferNotFound = -11,
    ManageBuyOfferLowReserve = -12,
}
impl XdrCodec for ManageBuyOfferResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ManageBuyOfferResultCode::ManageBuyOfferSuccess),
            -1 => Ok(ManageBuyOfferResultCode::ManageBuyOfferMalformed),
            -2 => Ok(ManageBuyOfferResultCode::ManageBuyOfferSellNoTrust),
            -3 => Ok(ManageBuyOfferResultCode::ManageBuyOfferBuyNoTrust),
            -4 => Ok(ManageBuyOfferResultCode::ManageBuyOfferSellNotAuthorized),
            -5 => Ok(ManageBuyOfferResultCode::ManageBuyOfferBuyNotAuthorized),
            -6 => Ok(ManageBuyOfferResultCode::ManageBuyOfferLineFull),
            -7 => Ok(ManageBuyOfferResultCode::ManageBuyOfferUnderfunded),
            -8 => Ok(ManageBuyOfferResultCode::ManageBuyOfferCrossSelf),
            -9 => Ok(ManageBuyOfferResultCode::ManageBuyOfferSellNoIssuer),
            -10 => Ok(ManageBuyOfferResultCode::ManageBuyOfferBuyNoIssuer),
            -11 => Ok(ManageBuyOfferResultCode::ManageBuyOfferNotFound),
            -12 => Ok(ManageBuyOfferResultCode::ManageBuyOfferLowReserve),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ManageOfferSuccessResult {
    pub offers_claimed: UnlimitedVarArray<ClaimOfferAtom>,
    pub offer: ManageOfferSuccessResultOffer,
}
impl XdrCodec for ManageOfferSuccessResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.offers_claimed.to_xdr_buffered(write_stream)?;
        self.offer.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ManageOfferSuccessResult {
            offers_claimed: UnlimitedVarArray::<ClaimOfferAtom>::from_xdr_buffered(read_stream)?,
            offer: ManageOfferSuccessResultOffer::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ManageOfferSuccessResultOffer {
    ManageOfferCreated(OfferEntry),
    ManageOfferUpdated(OfferEntry),
    Default(ManageOfferEffect),
}
impl XdrCodec for ManageOfferSuccessResultOffer {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ManageOfferSuccessResultOffer::ManageOfferCreated(value) => {
                ManageOfferEffect::ManageOfferCreated.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            ManageOfferSuccessResultOffer::ManageOfferUpdated(value) => {
                ManageOfferEffect::ManageOfferUpdated.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            ManageOfferSuccessResultOffer::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ManageOfferEffect::from_xdr_buffered(read_stream)? {
            ManageOfferEffect::ManageOfferCreated => {
                Ok(ManageOfferSuccessResultOffer::ManageOfferCreated(
                    OfferEntry::from_xdr_buffered(read_stream)?,
                ))
            }
            ManageOfferEffect::ManageOfferUpdated => {
                Ok(ManageOfferSuccessResultOffer::ManageOfferUpdated(
                    OfferEntry::from_xdr_buffered(read_stream)?,
                ))
            }
            code => Ok(ManageOfferSuccessResultOffer::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ManageOfferEffect {
    ManageOfferCreated = 0,
    ManageOfferUpdated = 1,
    ManageOfferDeleted = 2,
}
impl XdrCodec for ManageOfferEffect {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ManageOfferEffect::ManageOfferCreated),
            1 => Ok(ManageOfferEffect::ManageOfferUpdated),
            2 => Ok(ManageOfferEffect::ManageOfferDeleted),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum BumpSequenceResult {
    BumpSequenceSuccess,
    Default(BumpSequenceResultCode),
}
impl XdrCodec for BumpSequenceResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            BumpSequenceResult::BumpSequenceSuccess => {
                BumpSequenceResultCode::BumpSequenceSuccess.to_xdr_buffered(write_stream)?
            }
            BumpSequenceResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match BumpSequenceResultCode::from_xdr_buffered(read_stream)? {
            BumpSequenceResultCode::BumpSequenceSuccess => {
                Ok(BumpSequenceResult::BumpSequenceSuccess)
            }
            code => Ok(BumpSequenceResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum BumpSequenceResultCode {
    BumpSequenceSuccess = 0,
    BumpSequenceBadSeq = -1,
}
impl XdrCodec for BumpSequenceResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(BumpSequenceResultCode::BumpSequenceSuccess),
            -1 => Ok(BumpSequenceResultCode::BumpSequenceBadSeq),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ManageDataResult {
    ManageDataSuccess,
    Default(ManageDataResultCode),
}
impl XdrCodec for ManageDataResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ManageDataResult::ManageDataSuccess => {
                ManageDataResultCode::ManageDataSuccess.to_xdr_buffered(write_stream)?
            }
            ManageDataResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ManageDataResultCode::from_xdr_buffered(read_stream)? {
            ManageDataResultCode::ManageDataSuccess => Ok(ManageDataResult::ManageDataSuccess),
            code => Ok(ManageDataResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ManageDataResultCode {
    ManageDataSuccess = 0,
    ManageDataNotSupportedYet = -1,
    ManageDataNameNotFound = -2,
    ManageDataLowReserve = -3,
    ManageDataInvalidName = -4,
}
impl XdrCodec for ManageDataResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ManageDataResultCode::ManageDataSuccess),
            -1 => Ok(ManageDataResultCode::ManageDataNotSupportedYet),
            -2 => Ok(ManageDataResultCode::ManageDataNameNotFound),
            -3 => Ok(ManageDataResultCode::ManageDataLowReserve),
            -4 => Ok(ManageDataResultCode::ManageDataInvalidName),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum InflationResult {
    InflationSuccess(UnlimitedVarArray<InflationPayout>),
    Default(InflationResultCode),
}
impl XdrCodec for InflationResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            InflationResult::InflationSuccess(value) => {
                InflationResultCode::InflationSuccess.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            InflationResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match InflationResultCode::from_xdr_buffered(read_stream)? {
            InflationResultCode::InflationSuccess => {
                Ok(InflationResult::InflationSuccess(UnlimitedVarArray::<
                    InflationPayout,
                >::from_xdr_buffered(
                    read_stream
                )?))
            }
            code => Ok(InflationResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum InflationResultCode {
    InflationSuccess = 0,
    InflationNotTime = -1,
}
impl XdrCodec for InflationResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(InflationResultCode::InflationSuccess),
            -1 => Ok(InflationResultCode::InflationNotTime),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct InflationPayout {
    pub destination: AccountId,
    pub amount: Int64,
}
impl XdrCodec for InflationPayout {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.destination.to_xdr_buffered(write_stream)?;
        self.amount.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(InflationPayout {
            destination: AccountId::from_xdr_buffered(read_stream)?,
            amount: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum AccountMergeResult {
    AccountMergeSuccess(Int64),
    Default(AccountMergeResultCode),
}
impl XdrCodec for AccountMergeResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            AccountMergeResult::AccountMergeSuccess(value) => {
                AccountMergeResultCode::AccountMergeSuccess.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            AccountMergeResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match AccountMergeResultCode::from_xdr_buffered(read_stream)? {
            AccountMergeResultCode::AccountMergeSuccess => Ok(
                AccountMergeResult::AccountMergeSuccess(Int64::from_xdr_buffered(read_stream)?),
            ),
            code => Ok(AccountMergeResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum AccountMergeResultCode {
    AccountMergeSuccess = 0,
    AccountMergeMalformed = -1,
    AccountMergeNoAccount = -2,
    AccountMergeImmutableSet = -3,
    AccountMergeHasSubEntries = -4,
    AccountMergeSeqnumTooFar = -5,
    AccountMergeDestFull = -6,
    AccountMergeIsSponsor = -7,
}
impl XdrCodec for AccountMergeResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(AccountMergeResultCode::AccountMergeSuccess),
            -1 => Ok(AccountMergeResultCode::AccountMergeMalformed),
            -2 => Ok(AccountMergeResultCode::AccountMergeNoAccount),
            -3 => Ok(AccountMergeResultCode::AccountMergeImmutableSet),
            -4 => Ok(AccountMergeResultCode::AccountMergeHasSubEntries),
            -5 => Ok(AccountMergeResultCode::AccountMergeSeqnumTooFar),
            -6 => Ok(AccountMergeResultCode::AccountMergeDestFull),
            -7 => Ok(AccountMergeResultCode::AccountMergeIsSponsor),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum AllowTrustResult {
    AllowTrustSuccess,
    Default(AllowTrustResultCode),
}
impl XdrCodec for AllowTrustResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            AllowTrustResult::AllowTrustSuccess => {
                AllowTrustResultCode::AllowTrustSuccess.to_xdr_buffered(write_stream)?
            }
            AllowTrustResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match AllowTrustResultCode::from_xdr_buffered(read_stream)? {
            AllowTrustResultCode::AllowTrustSuccess => Ok(AllowTrustResult::AllowTrustSuccess),
            code => Ok(AllowTrustResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum AllowTrustResultCode {
    AllowTrustSuccess = 0,
    AllowTrustMalformed = -1,
    AllowTrustNoTrustLine = -2,
    AllowTrustTrustNotRequired = -3,
    AllowTrustCantRevoke = -4,
    AllowTrustSelfNotAllowed = -5,
}
impl XdrCodec for AllowTrustResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(AllowTrustResultCode::AllowTrustSuccess),
            -1 => Ok(AllowTrustResultCode::AllowTrustMalformed),
            -2 => Ok(AllowTrustResultCode::AllowTrustNoTrustLine),
            -3 => Ok(AllowTrustResultCode::AllowTrustTrustNotRequired),
            -4 => Ok(AllowTrustResultCode::AllowTrustCantRevoke),
            -5 => Ok(AllowTrustResultCode::AllowTrustSelfNotAllowed),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ChangeTrustResult {
    ChangeTrustSuccess,
    Default(ChangeTrustResultCode),
}
impl XdrCodec for ChangeTrustResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ChangeTrustResult::ChangeTrustSuccess => {
                ChangeTrustResultCode::ChangeTrustSuccess.to_xdr_buffered(write_stream)?
            }
            ChangeTrustResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ChangeTrustResultCode::from_xdr_buffered(read_stream)? {
            ChangeTrustResultCode::ChangeTrustSuccess => Ok(ChangeTrustResult::ChangeTrustSuccess),
            code => Ok(ChangeTrustResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ChangeTrustResultCode {
    ChangeTrustSuccess = 0,
    ChangeTrustMalformed = -1,
    ChangeTrustNoIssuer = -2,
    ChangeTrustInvalidLimit = -3,
    ChangeTrustLowReserve = -4,
    ChangeTrustSelfNotAllowed = -5,
}
impl XdrCodec for ChangeTrustResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ChangeTrustResultCode::ChangeTrustSuccess),
            -1 => Ok(ChangeTrustResultCode::ChangeTrustMalformed),
            -2 => Ok(ChangeTrustResultCode::ChangeTrustNoIssuer),
            -3 => Ok(ChangeTrustResultCode::ChangeTrustInvalidLimit),
            -4 => Ok(ChangeTrustResultCode::ChangeTrustLowReserve),
            -5 => Ok(ChangeTrustResultCode::ChangeTrustSelfNotAllowed),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum SetOptionsResult {
    SetOptionsSuccess,
    Default(SetOptionsResultCode),
}
impl XdrCodec for SetOptionsResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            SetOptionsResult::SetOptionsSuccess => {
                SetOptionsResultCode::SetOptionsSuccess.to_xdr_buffered(write_stream)?
            }
            SetOptionsResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match SetOptionsResultCode::from_xdr_buffered(read_stream)? {
            SetOptionsResultCode::SetOptionsSuccess => Ok(SetOptionsResult::SetOptionsSuccess),
            code => Ok(SetOptionsResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum SetOptionsResultCode {
    SetOptionsSuccess = 0,
    SetOptionsLowReserve = -1,
    SetOptionsTooManySigners = -2,
    SetOptionsBadFlags = -3,
    SetOptionsInvalidInflation = -4,
    SetOptionsCantChange = -5,
    SetOptionsUnknownFlag = -6,
    SetOptionsThresholdOutOfRange = -7,
    SetOptionsBadSigner = -8,
    SetOptionsInvalidHomeDomain = -9,
    SetOptionsAuthRevocableRequired = -10,
}
impl XdrCodec for SetOptionsResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(SetOptionsResultCode::SetOptionsSuccess),
            -1 => Ok(SetOptionsResultCode::SetOptionsLowReserve),
            -2 => Ok(SetOptionsResultCode::SetOptionsTooManySigners),
            -3 => Ok(SetOptionsResultCode::SetOptionsBadFlags),
            -4 => Ok(SetOptionsResultCode::SetOptionsInvalidInflation),
            -5 => Ok(SetOptionsResultCode::SetOptionsCantChange),
            -6 => Ok(SetOptionsResultCode::SetOptionsUnknownFlag),
            -7 => Ok(SetOptionsResultCode::SetOptionsThresholdOutOfRange),
            -8 => Ok(SetOptionsResultCode::SetOptionsBadSigner),
            -9 => Ok(SetOptionsResultCode::SetOptionsInvalidHomeDomain),
            -10 => Ok(SetOptionsResultCode::SetOptionsAuthRevocableRequired),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum ManageSellOfferResult {
    ManageSellOfferSuccess(ManageOfferSuccessResult),
    Default(ManageSellOfferResultCode),
}
impl XdrCodec for ManageSellOfferResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            ManageSellOfferResult::ManageSellOfferSuccess(value) => {
                ManageSellOfferResultCode::ManageSellOfferSuccess.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            ManageSellOfferResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match ManageSellOfferResultCode::from_xdr_buffered(read_stream)? {
            ManageSellOfferResultCode::ManageSellOfferSuccess => {
                Ok(ManageSellOfferResult::ManageSellOfferSuccess(
                    ManageOfferSuccessResult::from_xdr_buffered(read_stream)?,
                ))
            }
            code => Ok(ManageSellOfferResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum ManageSellOfferResultCode {
    ManageSellOfferSuccess = 0,
    ManageSellOfferMalformed = -1,
    ManageSellOfferSellNoTrust = -2,
    ManageSellOfferBuyNoTrust = -3,
    ManageSellOfferSellNotAuthorized = -4,
    ManageSellOfferBuyNotAuthorized = -5,
    ManageSellOfferLineFull = -6,
    ManageSellOfferUnderfunded = -7,
    ManageSellOfferCrossSelf = -8,
    ManageSellOfferSellNoIssuer = -9,
    ManageSellOfferBuyNoIssuer = -10,
    ManageSellOfferNotFound = -11,
    ManageSellOfferLowReserve = -12,
}
impl XdrCodec for ManageSellOfferResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(ManageSellOfferResultCode::ManageSellOfferSuccess),
            -1 => Ok(ManageSellOfferResultCode::ManageSellOfferMalformed),
            -2 => Ok(ManageSellOfferResultCode::ManageSellOfferSellNoTrust),
            -3 => Ok(ManageSellOfferResultCode::ManageSellOfferBuyNoTrust),
            -4 => Ok(ManageSellOfferResultCode::ManageSellOfferSellNotAuthorized),
            -5 => Ok(ManageSellOfferResultCode::ManageSellOfferBuyNotAuthorized),
            -6 => Ok(ManageSellOfferResultCode::ManageSellOfferLineFull),
            -7 => Ok(ManageSellOfferResultCode::ManageSellOfferUnderfunded),
            -8 => Ok(ManageSellOfferResultCode::ManageSellOfferCrossSelf),
            -9 => Ok(ManageSellOfferResultCode::ManageSellOfferSellNoIssuer),
            -10 => Ok(ManageSellOfferResultCode::ManageSellOfferBuyNoIssuer),
            -11 => Ok(ManageSellOfferResultCode::ManageSellOfferNotFound),
            -12 => Ok(ManageSellOfferResultCode::ManageSellOfferLowReserve),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum PathPaymentStrictReceiveResult {
    PathPaymentStrictReceiveSuccess(PathPaymentStrictReceiveResultSuccess),
    PathPaymentStrictReceiveNoIssuer(Asset),
    Default(PathPaymentStrictReceiveResultCode),
}
impl XdrCodec for PathPaymentStrictReceiveResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            PathPaymentStrictReceiveResult::PathPaymentStrictReceiveSuccess(value) => {
                PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveSuccess
                    .to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            PathPaymentStrictReceiveResult::PathPaymentStrictReceiveNoIssuer(value) => {
                PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveNoIssuer
                    .to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            PathPaymentStrictReceiveResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match PathPaymentStrictReceiveResultCode::from_xdr_buffered(read_stream)? {
            PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveSuccess => Ok(
                PathPaymentStrictReceiveResult::PathPaymentStrictReceiveSuccess(
                    PathPaymentStrictReceiveResultSuccess::from_xdr_buffered(read_stream)?,
                ),
            ),
            PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveNoIssuer => Ok(
                PathPaymentStrictReceiveResult::PathPaymentStrictReceiveNoIssuer(
                    Asset::from_xdr_buffered(read_stream)?,
                ),
            ),
            code => Ok(PathPaymentStrictReceiveResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum PathPaymentStrictReceiveResultCode {
    PathPaymentStrictReceiveSuccess = 0,
    PathPaymentStrictReceiveMalformed = -1,
    PathPaymentStrictReceiveUnderfunded = -2,
    PathPaymentStrictReceiveSrcNoTrust = -3,
    PathPaymentStrictReceiveSrcNotAuthorized = -4,
    PathPaymentStrictReceiveNoDestination = -5,
    PathPaymentStrictReceiveNoTrust = -6,
    PathPaymentStrictReceiveNotAuthorized = -7,
    PathPaymentStrictReceiveLineFull = -8,
    PathPaymentStrictReceiveNoIssuer = -9,
    PathPaymentStrictReceiveTooFewOffers = -10,
    PathPaymentStrictReceiveOfferCrossSelf = -11,
    PathPaymentStrictReceiveOverSendmax = -12,
}
impl XdrCodec for PathPaymentStrictReceiveResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveSuccess),
            -1 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveMalformed),
            -2 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveUnderfunded),
            -3 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveSrcNoTrust),
            -4 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveSrcNotAuthorized),
            -5 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveNoDestination),
            -6 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveNoTrust),
            -7 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveNotAuthorized),
            -8 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveLineFull),
            -9 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveNoIssuer),
            -10 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveTooFewOffers),
            -11 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveOfferCrossSelf),
            -12 => Ok(PathPaymentStrictReceiveResultCode::PathPaymentStrictReceiveOverSendmax),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct PathPaymentStrictReceiveResultSuccess {
    pub offers: UnlimitedVarArray<ClaimOfferAtom>,
    pub last: SimplePaymentResult,
}
impl XdrCodec for PathPaymentStrictReceiveResultSuccess {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.offers.to_xdr_buffered(write_stream)?;
        self.last.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(PathPaymentStrictReceiveResultSuccess {
            offers: UnlimitedVarArray::<ClaimOfferAtom>::from_xdr_buffered(read_stream)?,
            last: SimplePaymentResult::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum PaymentResult {
    PaymentSuccess,
    Default(PaymentResultCode),
}
impl XdrCodec for PaymentResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            PaymentResult::PaymentSuccess => {
                PaymentResultCode::PaymentSuccess.to_xdr_buffered(write_stream)?
            }
            PaymentResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match PaymentResultCode::from_xdr_buffered(read_stream)? {
            PaymentResultCode::PaymentSuccess => Ok(PaymentResult::PaymentSuccess),
            code => Ok(PaymentResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum PaymentResultCode {
    PaymentSuccess = 0,
    PaymentMalformed = -1,
    PaymentUnderfunded = -2,
    PaymentSrcNoTrust = -3,
    PaymentSrcNotAuthorized = -4,
    PaymentNoDestination = -5,
    PaymentNoTrust = -6,
    PaymentNotAuthorized = -7,
    PaymentLineFull = -8,
    PaymentNoIssuer = -9,
}
impl XdrCodec for PaymentResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(PaymentResultCode::PaymentSuccess),
            -1 => Ok(PaymentResultCode::PaymentMalformed),
            -2 => Ok(PaymentResultCode::PaymentUnderfunded),
            -3 => Ok(PaymentResultCode::PaymentSrcNoTrust),
            -4 => Ok(PaymentResultCode::PaymentSrcNotAuthorized),
            -5 => Ok(PaymentResultCode::PaymentNoDestination),
            -6 => Ok(PaymentResultCode::PaymentNoTrust),
            -7 => Ok(PaymentResultCode::PaymentNotAuthorized),
            -8 => Ok(PaymentResultCode::PaymentLineFull),
            -9 => Ok(PaymentResultCode::PaymentNoIssuer),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum CreateAccountResult {
    CreateAccountSuccess,
    Default(CreateAccountResultCode),
}
impl XdrCodec for CreateAccountResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            CreateAccountResult::CreateAccountSuccess => {
                CreateAccountResultCode::CreateAccountSuccess.to_xdr_buffered(write_stream)?
            }
            CreateAccountResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match CreateAccountResultCode::from_xdr_buffered(read_stream)? {
            CreateAccountResultCode::CreateAccountSuccess => {
                Ok(CreateAccountResult::CreateAccountSuccess)
            }
            code => Ok(CreateAccountResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum CreateAccountResultCode {
    CreateAccountSuccess = 0,
    CreateAccountMalformed = -1,
    CreateAccountUnderfunded = -2,
    CreateAccountLowReserve = -3,
    CreateAccountAlreadyExist = -4,
}
impl XdrCodec for CreateAccountResultCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(CreateAccountResultCode::CreateAccountSuccess),
            -1 => Ok(CreateAccountResultCode::CreateAccountMalformed),
            -2 => Ok(CreateAccountResultCode::CreateAccountUnderfunded),
            -3 => Ok(CreateAccountResultCode::CreateAccountLowReserve),
            -4 => Ok(CreateAccountResultCode::CreateAccountAlreadyExist),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct InnerTransactionResultPair {
    pub transaction_hash: Hash,
    pub result: InnerTransactionResult,
}
impl XdrCodec for InnerTransactionResultPair {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.transaction_hash.to_xdr_buffered(write_stream)?;
        self.result.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(InnerTransactionResultPair {
            transaction_hash: Hash::from_xdr_buffered(read_stream)?,
            result: InnerTransactionResult::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct InnerTransactionResult {
    pub fee_charged: Int64,
    pub result: InnerTransactionResultResult,
    pub ext: InnerTransactionResultExt,
}
impl XdrCodec for InnerTransactionResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.fee_charged.to_xdr_buffered(write_stream)?;
        self.result.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(InnerTransactionResult {
            fee_charged: Int64::from_xdr_buffered(read_stream)?,
            result: InnerTransactionResultResult::from_xdr_buffered(read_stream)?,
            ext: InnerTransactionResultExt::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum InnerTransactionResultExt {
    V0,
    Default(i32),
}
impl XdrCodec for InnerTransactionResultExt {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            InnerTransactionResultExt::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            InnerTransactionResultExt::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(InnerTransactionResultExt::V0),
            code => Ok(InnerTransactionResultExt::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum InnerTransactionResultResult {
    TxSuccess(UnlimitedVarArray<OperationResult>),
    TxFailed(UnlimitedVarArray<OperationResult>),
    TxTooEarly,
    TxTooLate,
    TxMissingOperation,
    TxBadSeq,
    TxBadAuth,
    TxInsufficientBalance,
    TxNoAccount,
    TxInsufficientFee,
    TxBadAuthExtra,
    TxInternalError,
    TxNotSupported,
    TxBadSponsorship,
    Default(TransactionResultCode),
}
impl XdrCodec for InnerTransactionResultResult {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            InnerTransactionResultResult::TxSuccess(value) => {
                TransactionResultCode::TxSuccess.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxFailed(value) => {
                TransactionResultCode::TxFailed.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxTooEarly => {
                TransactionResultCode::TxTooEarly.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxTooLate => {
                TransactionResultCode::TxTooLate.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxMissingOperation => {
                TransactionResultCode::TxMissingOperation.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxBadSeq => {
                TransactionResultCode::TxBadSeq.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxBadAuth => {
                TransactionResultCode::TxBadAuth.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxInsufficientBalance => {
                TransactionResultCode::TxInsufficientBalance.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxNoAccount => {
                TransactionResultCode::TxNoAccount.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxInsufficientFee => {
                TransactionResultCode::TxInsufficientFee.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxBadAuthExtra => {
                TransactionResultCode::TxBadAuthExtra.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxInternalError => {
                TransactionResultCode::TxInternalError.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxNotSupported => {
                TransactionResultCode::TxNotSupported.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::TxBadSponsorship => {
                TransactionResultCode::TxBadSponsorship.to_xdr_buffered(write_stream)?
            }
            InnerTransactionResultResult::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match TransactionResultCode::from_xdr_buffered(read_stream)? {
            TransactionResultCode::TxSuccess => Ok(InnerTransactionResultResult::TxSuccess(
                UnlimitedVarArray::<OperationResult>::from_xdr_buffered(read_stream)?,
            )),
            TransactionResultCode::TxFailed => {
                Ok(InnerTransactionResultResult::TxFailed(UnlimitedVarArray::<
                    OperationResult,
                >::from_xdr_buffered(
                    read_stream
                )?))
            }
            TransactionResultCode::TxTooEarly => Ok(InnerTransactionResultResult::TxTooEarly),
            TransactionResultCode::TxTooLate => Ok(InnerTransactionResultResult::TxTooLate),
            TransactionResultCode::TxMissingOperation => {
                Ok(InnerTransactionResultResult::TxMissingOperation)
            }
            TransactionResultCode::TxBadSeq => Ok(InnerTransactionResultResult::TxBadSeq),
            TransactionResultCode::TxBadAuth => Ok(InnerTransactionResultResult::TxBadAuth),
            TransactionResultCode::TxInsufficientBalance => {
                Ok(InnerTransactionResultResult::TxInsufficientBalance)
            }
            TransactionResultCode::TxNoAccount => Ok(InnerTransactionResultResult::TxNoAccount),
            TransactionResultCode::TxInsufficientFee => {
                Ok(InnerTransactionResultResult::TxInsufficientFee)
            }
            TransactionResultCode::TxBadAuthExtra => {
                Ok(InnerTransactionResultResult::TxBadAuthExtra)
            }
            TransactionResultCode::TxInternalError => {
                Ok(InnerTransactionResultResult::TxInternalError)
            }
            TransactionResultCode::TxNotSupported => {
                Ok(InnerTransactionResultResult::TxNotSupported)
            }
            TransactionResultCode::TxBadSponsorship => {
                Ok(InnerTransactionResultResult::TxBadSponsorship)
            }
            code => Ok(InnerTransactionResultResult::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum TransactionEnvelope {
    EnvelopeTypeTxV0(TransactionV0Envelope),
    EnvelopeTypeTx(TransactionV1Envelope),
    EnvelopeTypeTxFeeBump(FeeBumpTransactionEnvelope),
    Default(EnvelopeType),
}
impl XdrCodec for TransactionEnvelope {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            TransactionEnvelope::EnvelopeTypeTxV0(value) => {
                EnvelopeType::EnvelopeTypeTxV0.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TransactionEnvelope::EnvelopeTypeTx(value) => {
                EnvelopeType::EnvelopeTypeTx.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TransactionEnvelope::EnvelopeTypeTxFeeBump(value) => {
                EnvelopeType::EnvelopeTypeTxFeeBump.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            TransactionEnvelope::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match EnvelopeType::from_xdr_buffered(read_stream)? {
            EnvelopeType::EnvelopeTypeTxV0 => Ok(TransactionEnvelope::EnvelopeTypeTxV0(
                TransactionV0Envelope::from_xdr_buffered(read_stream)?,
            )),
            EnvelopeType::EnvelopeTypeTx => Ok(TransactionEnvelope::EnvelopeTypeTx(
                TransactionV1Envelope::from_xdr_buffered(read_stream)?,
            )),
            EnvelopeType::EnvelopeTypeTxFeeBump => Ok(TransactionEnvelope::EnvelopeTypeTxFeeBump(
                FeeBumpTransactionEnvelope::from_xdr_buffered(read_stream)?,
            )),
            code => Ok(TransactionEnvelope::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct FeeBumpTransactionEnvelope {
    pub tx: FeeBumpTransaction,
    pub signatures: LimitedVarArray<DecoratedSignature, 20>,
}
impl XdrCodec for FeeBumpTransactionEnvelope {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.tx.to_xdr_buffered(write_stream)?;
        self.signatures.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(FeeBumpTransactionEnvelope {
            tx: FeeBumpTransaction::from_xdr_buffered(read_stream)?,
            signatures: LimitedVarArray::<DecoratedSignature, 20>::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct DecoratedSignature {
    pub hint: SignatureHint,
    pub signature: Signature,
}
impl XdrCodec for DecoratedSignature {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.hint.to_xdr_buffered(write_stream)?;
        self.signature.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(DecoratedSignature {
            hint: SignatureHint::from_xdr_buffered(read_stream)?,
            signature: Signature::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
pub type Signature = LimitedVarOpaque<64>;

#[allow(dead_code)]
pub type SignatureHint = [u8; 4];

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct FeeBumpTransaction {
    pub fee_source: MuxedAccount,
    pub fee: Int64,
    pub inner_tx: FeeBumpTransactionInnerTx,
    pub ext: FeeBumpTransactionExt,
}
impl XdrCodec for FeeBumpTransaction {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.fee_source.to_xdr_buffered(write_stream)?;
        self.fee.to_xdr_buffered(write_stream)?;
        self.inner_tx.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(FeeBumpTransaction {
            fee_source: MuxedAccount::from_xdr_buffered(read_stream)?,
            fee: Int64::from_xdr_buffered(read_stream)?,
            inner_tx: FeeBumpTransactionInnerTx::from_xdr_buffered(read_stream)?,
            ext: FeeBumpTransactionExt::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum FeeBumpTransactionExt {
    V0,
    Default(i32),
}
impl XdrCodec for FeeBumpTransactionExt {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            FeeBumpTransactionExt::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            FeeBumpTransactionExt::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(FeeBumpTransactionExt::V0),
            code => Ok(FeeBumpTransactionExt::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum FeeBumpTransactionInnerTx {
    EnvelopeTypeTx(TransactionV1Envelope),
    Default(EnvelopeType),
}
impl XdrCodec for FeeBumpTransactionInnerTx {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            FeeBumpTransactionInnerTx::EnvelopeTypeTx(value) => {
                EnvelopeType::EnvelopeTypeTx.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            FeeBumpTransactionInnerTx::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match EnvelopeType::from_xdr_buffered(read_stream)? {
            EnvelopeType::EnvelopeTypeTx => Ok(FeeBumpTransactionInnerTx::EnvelopeTypeTx(
                TransactionV1Envelope::from_xdr_buffered(read_stream)?,
            )),
            code => Ok(FeeBumpTransactionInnerTx::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum MuxedAccount {
    KeyTypeEd25519(Uint256),
    KeyTypeMuxedEd25519(MuxedAccountMed25519),
    Default(CryptoKeyType),
}
impl XdrCodec for MuxedAccount {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            MuxedAccount::KeyTypeEd25519(value) => {
                CryptoKeyType::KeyTypeEd25519.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            MuxedAccount::KeyTypeMuxedEd25519(value) => {
                CryptoKeyType::KeyTypeMuxedEd25519.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            MuxedAccount::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match CryptoKeyType::from_xdr_buffered(read_stream)? {
            CryptoKeyType::KeyTypeEd25519 => Ok(MuxedAccount::KeyTypeEd25519(
                Uint256::from_xdr_buffered(read_stream)?,
            )),
            CryptoKeyType::KeyTypeMuxedEd25519 => Ok(MuxedAccount::KeyTypeMuxedEd25519(
                MuxedAccountMed25519::from_xdr_buffered(read_stream)?,
            )),
            code => Ok(MuxedAccount::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum CryptoKeyType {
    KeyTypeEd25519 = 0,
    KeyTypePreAuthTx = 1,
    KeyTypeHashX = 2,
    KeyTypeMuxedEd25519 = 256,
}
impl XdrCodec for CryptoKeyType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(CryptoKeyType::KeyTypeEd25519),
            1 => Ok(CryptoKeyType::KeyTypePreAuthTx),
            2 => Ok(CryptoKeyType::KeyTypeHashX),
            256 => Ok(CryptoKeyType::KeyTypeMuxedEd25519),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct MuxedAccountMed25519 {
    pub id: Uint64,
    pub ed25519: Uint256,
}
impl XdrCodec for MuxedAccountMed25519 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.id.to_xdr_buffered(write_stream)?;
        self.ed25519.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(MuxedAccountMed25519 {
            id: Uint64::from_xdr_buffered(read_stream)?,
            ed25519: Uint256::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
pub type Uint64 = u64;

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct TransactionV1Envelope {
    pub tx: Transaction,
    pub signatures: LimitedVarArray<DecoratedSignature, 20>,
}
impl XdrCodec for TransactionV1Envelope {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.tx.to_xdr_buffered(write_stream)?;
        self.signatures.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(TransactionV1Envelope {
            tx: Transaction::from_xdr_buffered(read_stream)?,
            signatures: LimitedVarArray::<DecoratedSignature, 20>::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct Transaction {
    pub source_account: MuxedAccount,
    pub fee: Uint32,
    pub seq_num: SequenceNumber,
    pub time_bounds: Option<TimeBounds>,
    pub memo: Memo,
    pub operations: LimitedVarArray<Operation, MAX_OPS_PER_TX>,
    pub ext: TransactionExt,
}
impl XdrCodec for Transaction {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.source_account.to_xdr_buffered(write_stream)?;
        self.fee.to_xdr_buffered(write_stream)?;
        self.seq_num.to_xdr_buffered(write_stream)?;
        self.time_bounds.to_xdr_buffered(write_stream)?;
        self.memo.to_xdr_buffered(write_stream)?;
        self.operations.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(Transaction {
            source_account: MuxedAccount::from_xdr_buffered(read_stream)?,
            fee: Uint32::from_xdr_buffered(read_stream)?,
            seq_num: SequenceNumber::from_xdr_buffered(read_stream)?,
            time_bounds: Option::<TimeBounds>::from_xdr_buffered(read_stream)?,
            memo: Memo::from_xdr_buffered(read_stream)?,
            operations: LimitedVarArray::<Operation, MAX_OPS_PER_TX>::from_xdr_buffered(
                read_stream,
            )?,
            ext: TransactionExt::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum TransactionExt {
    V0,
    Default(i32),
}
impl XdrCodec for TransactionExt {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            TransactionExt::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            TransactionExt::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(TransactionExt::V0),
            code => Ok(TransactionExt::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct Operation {
    pub source_account: Option<MuxedAccount>,
    pub body: OperationBody,
}
impl XdrCodec for Operation {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.source_account.to_xdr_buffered(write_stream)?;
        self.body.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(Operation {
            source_account: Option::<MuxedAccount>::from_xdr_buffered(read_stream)?,
            body: OperationBody::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum OperationBody {
    CreateAccount(CreateAccountOp),
    Payment(PaymentOp),
    PathPaymentStrictReceive(PathPaymentStrictReceiveOp),
    ManageSellOffer(ManageSellOfferOp),
    CreatePassiveSellOffer(CreatePassiveSellOfferOp),
    SetOptions(SetOptionsOp),
    ChangeTrust(ChangeTrustOp),
    AllowTrust(AllowTrustOp),
    AccountMerge(MuxedAccount),
    Inflation,
    ManageData(ManageDataOp),
    BumpSequence(BumpSequenceOp),
    ManageBuyOffer(ManageBuyOfferOp),
    PathPaymentStrictSend(PathPaymentStrictSendOp),
    CreateClaimableBalance(CreateClaimableBalanceOp),
    ClaimClaimableBalance(ClaimClaimableBalanceOp),
    BeginSponsoringFutureReserves(BeginSponsoringFutureReservesOp),
    EndSponsoringFutureReserves,
    RevokeSponsorship(RevokeSponsorshipOp),
    Clawback(ClawbackOp),
    ClawbackClaimableBalance(ClawbackClaimableBalanceOp),
    SetTrustLineFlags(SetTrustLineFlagsOp),
}
impl XdrCodec for OperationBody {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            OperationBody::CreateAccount(value) => {
                OperationType::CreateAccount.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::Payment(value) => {
                OperationType::Payment.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::PathPaymentStrictReceive(value) => {
                OperationType::PathPaymentStrictReceive.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::ManageSellOffer(value) => {
                OperationType::ManageSellOffer.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::CreatePassiveSellOffer(value) => {
                OperationType::CreatePassiveSellOffer.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::SetOptions(value) => {
                OperationType::SetOptions.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::ChangeTrust(value) => {
                OperationType::ChangeTrust.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::AllowTrust(value) => {
                OperationType::AllowTrust.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::AccountMerge(value) => {
                OperationType::AccountMerge.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::Inflation => OperationType::Inflation.to_xdr_buffered(write_stream)?,
            OperationBody::ManageData(value) => {
                OperationType::ManageData.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::BumpSequence(value) => {
                OperationType::BumpSequence.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::ManageBuyOffer(value) => {
                OperationType::ManageBuyOffer.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::PathPaymentStrictSend(value) => {
                OperationType::PathPaymentStrictSend.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::CreateClaimableBalance(value) => {
                OperationType::CreateClaimableBalance.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::ClaimClaimableBalance(value) => {
                OperationType::ClaimClaimableBalance.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::BeginSponsoringFutureReserves(value) => {
                OperationType::BeginSponsoringFutureReserves.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::EndSponsoringFutureReserves => {
                OperationType::EndSponsoringFutureReserves.to_xdr_buffered(write_stream)?
            }
            OperationBody::RevokeSponsorship(value) => {
                OperationType::RevokeSponsorship.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::Clawback(value) => {
                OperationType::Clawback.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::ClawbackClaimableBalance(value) => {
                OperationType::ClawbackClaimableBalance.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            OperationBody::SetTrustLineFlags(value) => {
                OperationType::SetTrustLineFlags.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match OperationType::from_xdr_buffered(read_stream)? {
            OperationType::CreateAccount => Ok(OperationBody::CreateAccount(
                CreateAccountOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::Payment => Ok(OperationBody::Payment(PaymentOp::from_xdr_buffered(
                read_stream,
            )?)),
            OperationType::PathPaymentStrictReceive => Ok(OperationBody::PathPaymentStrictReceive(
                PathPaymentStrictReceiveOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::ManageSellOffer => Ok(OperationBody::ManageSellOffer(
                ManageSellOfferOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::CreatePassiveSellOffer => Ok(OperationBody::CreatePassiveSellOffer(
                CreatePassiveSellOfferOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::SetOptions => Ok(OperationBody::SetOptions(
                SetOptionsOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::ChangeTrust => Ok(OperationBody::ChangeTrust(
                ChangeTrustOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::AllowTrust => Ok(OperationBody::AllowTrust(
                AllowTrustOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::AccountMerge => Ok(OperationBody::AccountMerge(
                MuxedAccount::from_xdr_buffered(read_stream)?,
            )),
            OperationType::Inflation => Ok(OperationBody::Inflation),
            OperationType::ManageData => Ok(OperationBody::ManageData(
                ManageDataOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::BumpSequence => Ok(OperationBody::BumpSequence(
                BumpSequenceOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::ManageBuyOffer => Ok(OperationBody::ManageBuyOffer(
                ManageBuyOfferOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::PathPaymentStrictSend => Ok(OperationBody::PathPaymentStrictSend(
                PathPaymentStrictSendOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::CreateClaimableBalance => Ok(OperationBody::CreateClaimableBalance(
                CreateClaimableBalanceOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::ClaimClaimableBalance => Ok(OperationBody::ClaimClaimableBalance(
                ClaimClaimableBalanceOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::BeginSponsoringFutureReserves => {
                Ok(OperationBody::BeginSponsoringFutureReserves(
                    BeginSponsoringFutureReservesOp::from_xdr_buffered(read_stream)?,
                ))
            }
            OperationType::EndSponsoringFutureReserves => {
                Ok(OperationBody::EndSponsoringFutureReserves)
            }
            OperationType::RevokeSponsorship => Ok(OperationBody::RevokeSponsorship(
                RevokeSponsorshipOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::Clawback => Ok(OperationBody::Clawback(ClawbackOp::from_xdr_buffered(
                read_stream,
            )?)),
            OperationType::ClawbackClaimableBalance => Ok(OperationBody::ClawbackClaimableBalance(
                ClawbackClaimableBalanceOp::from_xdr_buffered(read_stream)?,
            )),
            OperationType::SetTrustLineFlags => Ok(OperationBody::SetTrustLineFlags(
                SetTrustLineFlagsOp::from_xdr_buffered(read_stream)?,
            )),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct SetTrustLineFlagsOp {
    pub trustor: AccountId,
    pub asset: Asset,
    pub clear_flags: Uint32,
    pub set_flags: Uint32,
}
impl XdrCodec for SetTrustLineFlagsOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.trustor.to_xdr_buffered(write_stream)?;
        self.asset.to_xdr_buffered(write_stream)?;
        self.clear_flags.to_xdr_buffered(write_stream)?;
        self.set_flags.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(SetTrustLineFlagsOp {
            trustor: AccountId::from_xdr_buffered(read_stream)?,
            asset: Asset::from_xdr_buffered(read_stream)?,
            clear_flags: Uint32::from_xdr_buffered(read_stream)?,
            set_flags: Uint32::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ClawbackClaimableBalanceOp {
    pub balance_id: ClaimableBalanceId,
}
impl XdrCodec for ClawbackClaimableBalanceOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.balance_id.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ClawbackClaimableBalanceOp {
            balance_id: ClaimableBalanceId::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ClawbackOp {
    pub asset: Asset,
    pub from: MuxedAccount,
    pub amount: Int64,
}
impl XdrCodec for ClawbackOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.asset.to_xdr_buffered(write_stream)?;
        self.from.to_xdr_buffered(write_stream)?;
        self.amount.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ClawbackOp {
            asset: Asset::from_xdr_buffered(read_stream)?,
            from: MuxedAccount::from_xdr_buffered(read_stream)?,
            amount: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum RevokeSponsorshipOp {
    RevokeSponsorshipLedgerEntry(LedgerKey),
    RevokeSponsorshipSigner(RevokeSponsorshipOpSigner),
}
impl XdrCodec for RevokeSponsorshipOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            RevokeSponsorshipOp::RevokeSponsorshipLedgerEntry(value) => {
                RevokeSponsorshipType::RevokeSponsorshipLedgerEntry
                    .to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            RevokeSponsorshipOp::RevokeSponsorshipSigner(value) => {
                RevokeSponsorshipType::RevokeSponsorshipSigner.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match RevokeSponsorshipType::from_xdr_buffered(read_stream)? {
            RevokeSponsorshipType::RevokeSponsorshipLedgerEntry => {
                Ok(RevokeSponsorshipOp::RevokeSponsorshipLedgerEntry(
                    LedgerKey::from_xdr_buffered(read_stream)?,
                ))
            }
            RevokeSponsorshipType::RevokeSponsorshipSigner => {
                Ok(RevokeSponsorshipOp::RevokeSponsorshipSigner(
                    RevokeSponsorshipOpSigner::from_xdr_buffered(read_stream)?,
                ))
            }
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum RevokeSponsorshipType {
    RevokeSponsorshipLedgerEntry = 0,
    RevokeSponsorshipSigner = 1,
}
impl XdrCodec for RevokeSponsorshipType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(RevokeSponsorshipType::RevokeSponsorshipLedgerEntry),
            1 => Ok(RevokeSponsorshipType::RevokeSponsorshipSigner),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct RevokeSponsorshipOpSigner {
    pub account_id: AccountId,
    pub signer_key: SignerKey,
}
impl XdrCodec for RevokeSponsorshipOpSigner {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.account_id.to_xdr_buffered(write_stream)?;
        self.signer_key.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(RevokeSponsorshipOpSigner {
            account_id: AccountId::from_xdr_buffered(read_stream)?,
            signer_key: SignerKey::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct BeginSponsoringFutureReservesOp {
    pub sponsored_id: AccountId,
}
impl XdrCodec for BeginSponsoringFutureReservesOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.sponsored_id.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(BeginSponsoringFutureReservesOp {
            sponsored_id: AccountId::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ClaimClaimableBalanceOp {
    pub balance_id: ClaimableBalanceId,
}
impl XdrCodec for ClaimClaimableBalanceOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.balance_id.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ClaimClaimableBalanceOp {
            balance_id: ClaimableBalanceId::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct CreateClaimableBalanceOp {
    pub asset: Asset,
    pub amount: Int64,
    pub claimants: LimitedVarArray<Claimant, 10>,
}
impl XdrCodec for CreateClaimableBalanceOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.asset.to_xdr_buffered(write_stream)?;
        self.amount.to_xdr_buffered(write_stream)?;
        self.claimants.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(CreateClaimableBalanceOp {
            asset: Asset::from_xdr_buffered(read_stream)?,
            amount: Int64::from_xdr_buffered(read_stream)?,
            claimants: LimitedVarArray::<Claimant, 10>::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct PathPaymentStrictSendOp {
    pub send_asset: Asset,
    pub send_amount: Int64,
    pub destination: MuxedAccount,
    pub dest_asset: Asset,
    pub dest_min: Int64,
    pub path: LimitedVarArray<Asset, 5>,
}
impl XdrCodec for PathPaymentStrictSendOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.send_asset.to_xdr_buffered(write_stream)?;
        self.send_amount.to_xdr_buffered(write_stream)?;
        self.destination.to_xdr_buffered(write_stream)?;
        self.dest_asset.to_xdr_buffered(write_stream)?;
        self.dest_min.to_xdr_buffered(write_stream)?;
        self.path.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(PathPaymentStrictSendOp {
            send_asset: Asset::from_xdr_buffered(read_stream)?,
            send_amount: Int64::from_xdr_buffered(read_stream)?,
            destination: MuxedAccount::from_xdr_buffered(read_stream)?,
            dest_asset: Asset::from_xdr_buffered(read_stream)?,
            dest_min: Int64::from_xdr_buffered(read_stream)?,
            path: LimitedVarArray::<Asset, 5>::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ManageBuyOfferOp {
    pub selling: Asset,
    pub buying: Asset,
    pub buy_amount: Int64,
    pub price: Price,
    pub offer_id: Int64,
}
impl XdrCodec for ManageBuyOfferOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.selling.to_xdr_buffered(write_stream)?;
        self.buying.to_xdr_buffered(write_stream)?;
        self.buy_amount.to_xdr_buffered(write_stream)?;
        self.price.to_xdr_buffered(write_stream)?;
        self.offer_id.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ManageBuyOfferOp {
            selling: Asset::from_xdr_buffered(read_stream)?,
            buying: Asset::from_xdr_buffered(read_stream)?,
            buy_amount: Int64::from_xdr_buffered(read_stream)?,
            price: Price::from_xdr_buffered(read_stream)?,
            offer_id: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct BumpSequenceOp {
    pub bump_to: SequenceNumber,
}
impl XdrCodec for BumpSequenceOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.bump_to.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(BumpSequenceOp {
            bump_to: SequenceNumber::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ManageDataOp {
    pub data_name: String64,
    pub data_value: Option<DataValue>,
}
impl XdrCodec for ManageDataOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.data_name.to_xdr_buffered(write_stream)?;
        self.data_value.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ManageDataOp {
            data_name: String64::from_xdr_buffered(read_stream)?,
            data_value: Option::<DataValue>::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct AllowTrustOp {
    pub trustor: AccountId,
    pub asset: AssetCode,
    pub authorize: Uint32,
}
impl XdrCodec for AllowTrustOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.trustor.to_xdr_buffered(write_stream)?;
        self.asset.to_xdr_buffered(write_stream)?;
        self.authorize.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(AllowTrustOp {
            trustor: AccountId::from_xdr_buffered(read_stream)?,
            asset: AssetCode::from_xdr_buffered(read_stream)?,
            authorize: Uint32::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum AssetCode {
    AssetTypeCreditAlphanum4(AssetCode4),
    AssetTypeCreditAlphanum12(AssetCode12),
    Default(AssetType),
}
impl XdrCodec for AssetCode {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            AssetCode::AssetTypeCreditAlphanum4(value) => {
                AssetType::AssetTypeCreditAlphanum4.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            AssetCode::AssetTypeCreditAlphanum12(value) => {
                AssetType::AssetTypeCreditAlphanum12.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            AssetCode::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match AssetType::from_xdr_buffered(read_stream)? {
            AssetType::AssetTypeCreditAlphanum4 => Ok(AssetCode::AssetTypeCreditAlphanum4(
                AssetCode4::from_xdr_buffered(read_stream)?,
            )),
            AssetType::AssetTypeCreditAlphanum12 => Ok(AssetCode::AssetTypeCreditAlphanum12(
                AssetCode12::from_xdr_buffered(read_stream)?,
            )),
            code => Ok(AssetCode::Default(code)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ChangeTrustOp {
    pub line: Asset,
    pub limit: Int64,
}
impl XdrCodec for ChangeTrustOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.line.to_xdr_buffered(write_stream)?;
        self.limit.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ChangeTrustOp {
            line: Asset::from_xdr_buffered(read_stream)?,
            limit: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct SetOptionsOp {
    pub inflation_dest: Option<AccountId>,
    pub clear_flags: Option<Uint32>,
    pub set_flags: Option<Uint32>,
    pub master_weight: Option<Uint32>,
    pub low_threshold: Option<Uint32>,
    pub med_threshold: Option<Uint32>,
    pub high_threshold: Option<Uint32>,
    pub home_domain: Option<String32>,
    pub signer: Option<Signer>,
}
impl XdrCodec for SetOptionsOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.inflation_dest.to_xdr_buffered(write_stream)?;
        self.clear_flags.to_xdr_buffered(write_stream)?;
        self.set_flags.to_xdr_buffered(write_stream)?;
        self.master_weight.to_xdr_buffered(write_stream)?;
        self.low_threshold.to_xdr_buffered(write_stream)?;
        self.med_threshold.to_xdr_buffered(write_stream)?;
        self.high_threshold.to_xdr_buffered(write_stream)?;
        self.home_domain.to_xdr_buffered(write_stream)?;
        self.signer.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(SetOptionsOp {
            inflation_dest: Option::<AccountId>::from_xdr_buffered(read_stream)?,
            clear_flags: Option::<Uint32>::from_xdr_buffered(read_stream)?,
            set_flags: Option::<Uint32>::from_xdr_buffered(read_stream)?,
            master_weight: Option::<Uint32>::from_xdr_buffered(read_stream)?,
            low_threshold: Option::<Uint32>::from_xdr_buffered(read_stream)?,
            med_threshold: Option::<Uint32>::from_xdr_buffered(read_stream)?,
            high_threshold: Option::<Uint32>::from_xdr_buffered(read_stream)?,
            home_domain: Option::<String32>::from_xdr_buffered(read_stream)?,
            signer: Option::<Signer>::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct CreatePassiveSellOfferOp {
    pub selling: Asset,
    pub buying: Asset,
    pub amount: Int64,
    pub price: Price,
}
impl XdrCodec for CreatePassiveSellOfferOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.selling.to_xdr_buffered(write_stream)?;
        self.buying.to_xdr_buffered(write_stream)?;
        self.amount.to_xdr_buffered(write_stream)?;
        self.price.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(CreatePassiveSellOfferOp {
            selling: Asset::from_xdr_buffered(read_stream)?,
            buying: Asset::from_xdr_buffered(read_stream)?,
            amount: Int64::from_xdr_buffered(read_stream)?,
            price: Price::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct ManageSellOfferOp {
    pub selling: Asset,
    pub buying: Asset,
    pub amount: Int64,
    pub price: Price,
    pub offer_id: Int64,
}
impl XdrCodec for ManageSellOfferOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.selling.to_xdr_buffered(write_stream)?;
        self.buying.to_xdr_buffered(write_stream)?;
        self.amount.to_xdr_buffered(write_stream)?;
        self.price.to_xdr_buffered(write_stream)?;
        self.offer_id.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(ManageSellOfferOp {
            selling: Asset::from_xdr_buffered(read_stream)?,
            buying: Asset::from_xdr_buffered(read_stream)?,
            amount: Int64::from_xdr_buffered(read_stream)?,
            price: Price::from_xdr_buffered(read_stream)?,
            offer_id: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct PathPaymentStrictReceiveOp {
    pub send_asset: Asset,
    pub send_max: Int64,
    pub destination: MuxedAccount,
    pub dest_asset: Asset,
    pub dest_amount: Int64,
    pub path: LimitedVarArray<Asset, 5>,
}
impl XdrCodec for PathPaymentStrictReceiveOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.send_asset.to_xdr_buffered(write_stream)?;
        self.send_max.to_xdr_buffered(write_stream)?;
        self.destination.to_xdr_buffered(write_stream)?;
        self.dest_asset.to_xdr_buffered(write_stream)?;
        self.dest_amount.to_xdr_buffered(write_stream)?;
        self.path.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(PathPaymentStrictReceiveOp {
            send_asset: Asset::from_xdr_buffered(read_stream)?,
            send_max: Int64::from_xdr_buffered(read_stream)?,
            destination: MuxedAccount::from_xdr_buffered(read_stream)?,
            dest_asset: Asset::from_xdr_buffered(read_stream)?,
            dest_amount: Int64::from_xdr_buffered(read_stream)?,
            path: LimitedVarArray::<Asset, 5>::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct PaymentOp {
    pub destination: MuxedAccount,
    pub asset: Asset,
    pub amount: Int64,
}
impl XdrCodec for PaymentOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.destination.to_xdr_buffered(write_stream)?;
        self.asset.to_xdr_buffered(write_stream)?;
        self.amount.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(PaymentOp {
            destination: MuxedAccount::from_xdr_buffered(read_stream)?,
            asset: Asset::from_xdr_buffered(read_stream)?,
            amount: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct CreateAccountOp {
    pub destination: AccountId,
    pub starting_balance: Int64,
}
impl XdrCodec for CreateAccountOp {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.destination.to_xdr_buffered(write_stream)?;
        self.starting_balance.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(CreateAccountOp {
            destination: AccountId::from_xdr_buffered(read_stream)?,
            starting_balance: Int64::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum Memo {
    MemoNone,
    MemoText(LimitedString<28>),
    MemoId(Uint64),
    MemoHash(Hash),
    MemoReturn(Hash),
}
impl XdrCodec for Memo {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            Memo::MemoNone => MemoType::MemoNone.to_xdr_buffered(write_stream)?,
            Memo::MemoText(value) => {
                MemoType::MemoText.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            Memo::MemoId(value) => {
                MemoType::MemoId.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            Memo::MemoHash(value) => {
                MemoType::MemoHash.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
            Memo::MemoReturn(value) => {
                MemoType::MemoReturn.to_xdr_buffered(write_stream)?;
                value.to_xdr_buffered(write_stream)?
            }
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match MemoType::from_xdr_buffered(read_stream)? {
            MemoType::MemoNone => Ok(Memo::MemoNone),
            MemoType::MemoText => Ok(Memo::MemoText(LimitedString::<28>::from_xdr_buffered(
                read_stream,
            )?)),
            MemoType::MemoId => Ok(Memo::MemoId(Uint64::from_xdr_buffered(read_stream)?)),
            MemoType::MemoHash => Ok(Memo::MemoHash(Hash::from_xdr_buffered(read_stream)?)),
            MemoType::MemoReturn => Ok(Memo::MemoReturn(Hash::from_xdr_buffered(read_stream)?)),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Copy, Clone, Eq, PartialEq)]
pub enum MemoType {
    MemoNone = 0,
    MemoText = 1,
    MemoId = 2,
    MemoHash = 3,
    MemoReturn = 4,
}
impl XdrCodec for MemoType {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        let value = *self as i32;
        value.to_xdr_buffered(write_stream)
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        let enum_value = i32::from_xdr_buffered(read_stream)?;
        match enum_value {
            0 => Ok(MemoType::MemoNone),
            1 => Ok(MemoType::MemoText),
            2 => Ok(MemoType::MemoId),
            3 => Ok(MemoType::MemoHash),
            4 => Ok(MemoType::MemoReturn),
            _ => Err(ReadStreamError::InvalidEnumDiscriminator {
                at_position: read_stream.get_position(),
            }),
        }
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct TimeBounds {
    pub min_time: TimePoint,
    pub max_time: TimePoint,
}
impl XdrCodec for TimeBounds {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.min_time.to_xdr_buffered(write_stream)?;
        self.max_time.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(TimeBounds {
            min_time: TimePoint::from_xdr_buffered(read_stream)?,
            max_time: TimePoint::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
pub type TimePoint = Uint64;

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct TransactionV0Envelope {
    pub tx: TransactionV0,
    pub signatures: LimitedVarArray<DecoratedSignature, 20>,
}
impl XdrCodec for TransactionV0Envelope {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.tx.to_xdr_buffered(write_stream)?;
        self.signatures.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(TransactionV0Envelope {
            tx: TransactionV0::from_xdr_buffered(read_stream)?,
            signatures: LimitedVarArray::<DecoratedSignature, 20>::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub struct TransactionV0 {
    pub source_account_ed25519: Uint256,
    pub fee: Uint32,
    pub seq_num: SequenceNumber,
    pub time_bounds: Option<TimeBounds>,
    pub memo: Memo,
    pub operations: LimitedVarArray<Operation, MAX_OPS_PER_TX>,
    pub ext: TransactionV0Ext,
}
impl XdrCodec for TransactionV0 {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        self.source_account_ed25519.to_xdr_buffered(write_stream)?;
        self.fee.to_xdr_buffered(write_stream)?;
        self.seq_num.to_xdr_buffered(write_stream)?;
        self.time_bounds.to_xdr_buffered(write_stream)?;
        self.memo.to_xdr_buffered(write_stream)?;
        self.operations.to_xdr_buffered(write_stream)?;
        self.ext.to_xdr_buffered(write_stream)?;
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        Ok(TransactionV0 {
            source_account_ed25519: Uint256::from_xdr_buffered(read_stream)?,
            fee: Uint32::from_xdr_buffered(read_stream)?,
            seq_num: SequenceNumber::from_xdr_buffered(read_stream)?,
            time_bounds: Option::<TimeBounds>::from_xdr_buffered(read_stream)?,
            memo: Memo::from_xdr_buffered(read_stream)?,
            operations: LimitedVarArray::<Operation, MAX_OPS_PER_TX>::from_xdr_buffered(
                read_stream,
            )?,
            ext: TransactionV0Ext::from_xdr_buffered(read_stream)?,
        })
    }
}

#[allow(dead_code)]
#[derive(Debug, Clone, Eq, PartialEq)]
pub enum TransactionV0Ext {
    V0,
    Default(i32),
}
impl XdrCodec for TransactionV0Ext {
    fn to_xdr_buffered(&self, write_stream: &mut WriteStream) -> Result<(), WriteStreamError> {
        match self {
            TransactionV0Ext::V0 => (0 as i32).to_xdr_buffered(write_stream)?,
            TransactionV0Ext::Default(code) => code.to_xdr_buffered(write_stream)?,
        }
        Ok(())
    }

    fn from_xdr_buffered(read_stream: &mut ReadStream) -> Result<Self, ReadStreamError> {
        match i32::from_xdr_buffered(read_stream)? {
            0 => Ok(TransactionV0Ext::V0),
            code => Ok(TransactionV0Ext::Default(code)),
        }
    }
}
