# Rust API client for subspace_openapi_client

# Introduction

The Subspace API is based on REST, has resource-oriented URLs, returns JSON-encoded responses, and returns standardHTTP response codes.

The base URL for the API is `https://api.subspace.com/`

# Naming Convention

**EARLY ACCESS NOTE:** There is no “stable” version yet.  Once there is, the version name **stable** will be used to access the latest stable API version.
  * Example: `https://api.subspace.com/stable`
* Version name currently in use is: *v1*
  * Example: `https://api.subspace.com/v1`

# Authentication

## API Tokens

Subspace authenticates your API requests using JWT Bearer tokens.  The provided client library requires this JWT to be set before it can be used, by setting the local access token in the local configuration.  

Bearer tokens are granted by requesting one (as noted below) and presenting your publishable (client_id) and secret (client_secret) tokens.   

Subspace provides two types of API tokens: publishable (client_id) and secret (client_secret).  These are available in the Subspace console.
  * **Publishable** API tokens (client_id) are meant solely to identify your account with Subspace, they aren’t secret. They can be published in places like your website JavaScript code, or in an iPhone or Android app.
  * **Secret** API tokens (client_secret) should be kept confidential and only stored on your own servers. Your account’s secret API token will allow you to acquire a valid JWT token authorized to perform any API request to Subspace.

## Getting a JWT Bearer Token

Subspace uses auth0 for JWT token management.  You can acquire a JWT token by utilizing `https://id.subspace.com` and following the instructions in the curl example below.

## Protecting Your API Tokens

  * **JWT tokens have a expiration time of 24 hours.**  Once expired, you will have to use your Subspace private API and public token to request a new one.
  * The Subspace private token can be rotated from within the Subspace console.  Rotation may take up to 10 minutes for all systems to update state to invalidate the older token and enable the new one.
* **Keep your secret token safe.** Your secret token can make any API call on behalf of your account, including changes that may impact billing such as enabling pay-as-you-go charges. Do not store your secret token in your version control system. Do not use your secret token outside your web server, such as a browser, mobile app, or distributed file.
  * **You may use the Subspace console to acquire an API token.**
 * **You may use the Subspace console to disable pay-as-you-go.** This may prevent unexpected charges due to unauthorized or abnormal usage.

**Acquiring a valid JWT**

Command line example:
```
curl --request POST 
         --url 'https://id.subspace.com/oauth/token' 
         --header 'content-type: application/json' 
         --data '{ \"client_id\": "YOURCLIENTID", "client_secret": "YOURCLIENTSECRET", "audience": "https://api.subspace.com/", "grant_type": "client_credentials" }'
```


## Tips for using the API

Using the library from inside your program
```
use subspace_openapi_client::apis::*;
```

Configuration:

Set the JWT token, and pass in &my_config on all API calls.
```
    let mut my_config = subspace_openapi_client::apis::configuration::Configuration::new();
    my_config.oauth_access_token = Some("YOUR_JWT_TOKEN".to_string());
    // Example call:
    let list_accelerators = subspace_openapi_client::apis::accelerator_service_api::accelerator_service_list(&my_config,None,None,None).await;
```

dependencies.reqwest in Cargo.toml may need to have its features list updated to append "default-tls" or "rustls-tls" to enable your preferred TLS library for HTTPS connections.



## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.RustClientCodegen
For more information, please visit [https://subspace.com](https://subspace.com)

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    subspace_openapi_client = { path = "./rust-client" }
```

## Documentation for API Endpoints

All URIs are relative to *https://api.subspace.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AcceleratorServiceApi* | [**accelerator_service_create**](docs/AcceleratorServiceApi.md#accelerator_service_create) | **POST** /v1/accelerators | CreateAccelerator
*AcceleratorServiceApi* | [**accelerator_service_delete**](docs/AcceleratorServiceApi.md#accelerator_service_delete) | **DELETE** /v1/accelerators/{id} | DeleteAccelerator
*AcceleratorServiceApi* | [**accelerator_service_get**](docs/AcceleratorServiceApi.md#accelerator_service_get) | **GET** /v1/accelerators/{id} | GetAccelerator
*AcceleratorServiceApi* | [**accelerator_service_list**](docs/AcceleratorServiceApi.md#accelerator_service_list) | **GET** /v1/accelerators | ListAccelerators
*AcceleratorServiceApi* | [**accelerator_service_update**](docs/AcceleratorServiceApi.md#accelerator_service_update) | **PUT** /v1/accelerators/{id} | UpdateAccelerator
*SipTeleportServiceApi* | [**sip_teleport_service_create**](docs/SipTeleportServiceApi.md#sip_teleport_service_create) | **POST** /v1/sip-teleports | CreateSipTeleport
*SipTeleportServiceApi* | [**sip_teleport_service_delete**](docs/SipTeleportServiceApi.md#sip_teleport_service_delete) | **DELETE** /v1/sip-teleports/{id} | DeleteSipTeleport
*SipTeleportServiceApi* | [**sip_teleport_service_get**](docs/SipTeleportServiceApi.md#sip_teleport_service_get) | **GET** /v1/sip-teleports/{id} | GetSipTeleport
*SipTeleportServiceApi* | [**sip_teleport_service_list**](docs/SipTeleportServiceApi.md#sip_teleport_service_list) | **GET** /v1/sip-teleports | ListSipTeleports
*SipTeleportServiceApi* | [**sip_teleport_service_update**](docs/SipTeleportServiceApi.md#sip_teleport_service_update) | **PUT** /v1/sip-teleports/{id} | UpdateSipTeleport


## Documentation For Models

 - [Body](docs/Body.md)
 - [Body1](docs/Body1.md)
 - [ProtobufAny](docs/ProtobufAny.md)
 - [RpcStatus](docs/RpcStatus.md)
 - [V1Accelerator](docs/V1Accelerator.md)
 - [V1ListAcceleratorsResponse](docs/V1ListAcceleratorsResponse.md)
 - [V1ListSipTeleportResponse](docs/V1ListSipTeleportResponse.md)
 - [V1NextPage](docs/V1NextPage.md)
 - [V1Protocol](docs/V1Protocol.md)
 - [V1SipTeleportResponse](docs/V1SipTeleportResponse.md)
 - [V1SipTeleportStatus](docs/V1SipTeleportStatus.md)
 - [V1TeleportAddresses](docs/V1TeleportAddresses.md)
 - [V1TransportType](docs/V1TransportType.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

sales@subspace.com

