import dpss


def test_find_subset():
    assert dpss.find_subset([1, 2, 3, 4, 5], 6, 3) == [
        [1, 5], [2, 4], [1, 2, 3]]


def test_find_subset_fast_only_positive():
    assert dpss.find_subset_fast_only_positive([1, 2, 3, 4, 5], 10, 4) == [
        [1, 4, 5], [2, 3, 5], [1, 2, 3, 4]]


def test_sequence_matcher():
    assert dpss.sequence_matcher(
        [1980, 2980, 3500, 4000, 1050],
        [1950, 2900, 30, 80, 3300, 200, 3980, 1050, 20], 5, 5) == \
[[([1050], [1050]), ([1980], [30, 1950]), ([2980], [80, 2900]), ([3500], [200, 3300]), ([4000], [20, 3980])],
[([1050], [1050]), ([1980], [30, 1950]), ([2980], [80, 2900]), ([3500, 4000], [20, 200, 3300, 3980])],
[([1050], [1050]), ([1980], [30, 1950]), ([3500], [200, 3300]), ([2980, 4000], [20, 80, 2900, 3980])],
[([1050], [1050]), ([1980], [30, 1950]), ([4000], [20, 3980]), ([2980, 3500], [80, 200, 2900, 3300])],
[([1050], [1050]), ([2980], [80, 2900]), ([3500], [200, 3300]), ([1980, 4000], [20, 30, 1950, 3980])],
[([1050], [1050]), ([2980], [80, 2900]), ([4000], [20, 3980]), ([1980, 3500], [30, 200, 1950, 3300])],
[([1050], [1050]), ([3500], [200, 3300]), ([4000], [20, 3980]), ([1980, 2980], [30, 80, 1950, 2900])],
[([1980], [30, 1950]), ([2980], [80, 2900]), ([1050, 3500, 4000], [20, 200, 1050, 3300, 3980])],
[([1980], [30, 1950]), ([2980], [80, 2900]), ([3500], [200, 3300]), ([1050, 4000], [20, 1050, 3980])],
[([1980], [30, 1950]), ([2980], [80, 2900]), ([4000], [20, 3980]), ([1050, 3500], [200, 1050, 3300])],
[([1980], [30, 1950]), ([3500], [200, 3300]), ([1050, 2980, 4000], [20, 80, 1050, 2900, 3980])],
[([1980], [30, 1950]), ([3500], [200, 3300]), ([4000], [20, 3980]), ([1050, 2980], [80, 1050, 2900])],
[([1980], [30, 1950]), ([4000], [20, 3980]), ([1050, 2980, 3500], [80, 200, 1050, 2900, 3300])],
[([2980], [80, 2900]), ([3500], [200, 3300]), ([1050, 1980, 4000], [20, 30, 1050, 1950, 3980])],
[([2980], [80, 2900]), ([3500], [200, 3300]), ([4000], [20, 3980]), ([1050, 1980], [30, 1050, 1950])],
[([2980], [80, 2900]), ([4000], [20, 3980]), ([1050, 1980, 3500], [30, 200, 1050, 1950, 3300])],
[([2980, 4000], [20, 80, 2900, 3980]), ([1050, 1980, 3500], [30, 200, 1050, 1950, 3300])],
[([3500], [200, 3300]), ([1050, 1980], [20, 30, 80, 2900]), ([2980, 4000], [1050, 1950, 3980])],
[([3500], [200, 3300]), ([1050, 2980], [20, 30, 3980]), ([1980, 4000], [80, 1050, 1950, 2900])],
[([3500], [200, 3300]), ([1050, 2980], [80, 1050, 2900]), ([1980, 4000], [20, 30, 1950, 3980])],
[([3500], [200, 3300]), ([4000], [20, 30, 1050, 2900]), ([1050, 1980, 2980], [80, 1950, 3980])],
[([3500], [200, 3300]), ([4000], [20, 3980]), ([1050, 1980, 2980], [30, 80, 1050, 1950, 2900])],
[([4000], [20, 30, 1050, 2900]), ([1050, 1980, 2980, 3500], [80, 200, 1950, 3300, 3980])]]
