use std::path::{Component, Path, PathBuf};

use log::trace;
use pandoc::{InputFormat, InputKind, OutputFormat, OutputKind, Pandoc, PandocOption};

/// Get the base directory given the name of the markdown file.
///
/// All relative filename, such as bindings files, are resolved
/// against the base directory.
pub fn get_basedir_from(filename: &Path) -> PathBuf {
    match filename.parent() {
        None => {
            let p = Component::CurDir;
            let p: &Path = p.as_ref();
            p.to_path_buf()
        }
        Some(x) => x.to_path_buf(),
    }
}

/// Add 'citeproc' to a Pandoc instance.
///
/// This attempts to determine if `--citeproc` or `--filter pandoc-citeproc`
/// is needed, and then does that specific thing.
pub fn add_citeproc(pandoc: &mut Pandoc) {
    let mut guesser = Pandoc::new();
    guesser.set_input(InputKind::Pipe("".to_string()));
    guesser.set_input_format(InputFormat::Markdown, vec![]);
    guesser.set_output_format(OutputFormat::Markdown, vec![]);
    guesser.set_output(OutputKind::Pipe);
    guesser.add_option(PandocOption::Citeproc);
    if guesser.execute().is_ok() {
        trace!("Discovered --citeproc");
        pandoc.add_option(PandocOption::Citeproc);
    } else {
        trace!("Discovered --filter pandoc-citeproc");
        pandoc.add_option(PandocOption::Filter("pandoc-citeproc".into()));
    }
}
