# Big decisions made by the Subplot project

In the [2021-09-11 meeting][] we decided to start keeping a decision
log: a log of big decisions, often architectural ones. This file is
that log. Decisions should be discussed before being made so that
there is a strong consensus for them. Decisions can be changed or
overturned if they turn out to no longer be good. Overturning is a
decision.

[2021-09-11 meeting]: https://subplot.liw.fi/blog/2021/09/11/meeting/

Each decision should have its own heading. Newest decision should come
first. Updated or overturned decisions should have their section
updated to note their status, without moving them.

## Minimum Supported Rust Version

Date: 2021-10-09

What: We decided that Subplot would support an MSRV of 1.48.0 in
order that it can be maximally useful to the Sequoia-PGP project.
If and when we gain other large client projects, we will endeavour
to support an MSRV which makes them all happy. We will walk the
MSRV forward as and when our client projects move forward.

Who: Daniel, Lars

## Do not clear/override all environment variables

Date: 2021-10-08

What: We decided that the environment being "clean" is more the
resposibility of the caller of the test suite than of the test
suite itself. As such, we have decided to only set SHELL, HOME,
and TMPDIR. Importantly we do not override PATH etc. so that
things will work on NixOS etc.

Who: Daniel, Lars.

## Start decision log

Date: 2021-09-11

What: We decided to start keeping a decision log for big, often
architectural decisions affecting the project as a whole.

Who: Daniel, Lars.
