---
title: Release notes for Subplot
...

This file summarises the changes between released versions of Subplot and its
associated libraries, especially with regards to changes visible to
the user of the Subplot software.

# Version 0.3.0, released 2021-10-20

This is still an ALPHA quality release, and includes breaking changes.

## Breaking changes

You definitely need to pay attention to these changes.

* Subplot is moving to libraries and subplots being able to support
  multiple step implementation languages at once. In this release,
  bindings can indicate different functions for each language. Note
  that a binding only needs to support one language. The new binding
  format is:

```yaml
- given: foo
  impl:
    python:
      function: foo
      cleanup: foo_cleanup
    rust:
      function: somelib::foo
      cleanup: somelib::foo_cleanup
```

* The Subplot code generator now uses the `pulldown-cmark` crate for
  parsing Markdown input. The reason for this change is to not have to
  have Pandoc installed in a CI or other environment that only
  generates and runs test programs.

  The document generator still uses Pandoc for this, but it, too, will
  migrate to `pulldown-cmark` so that all parsing is done in the same
  way.

  The parsing crate should support the same Markdown variants as
  Pandoc does, more or less.

  Unfortunately, the YAML document metadata block is less forgiving
  now. The new metadata parser doesn't accept everything Pandoc does,
  and there will be a need to change input documents. The next release
  of Subplot is likely to introduce further changes, and we will
  document the new metadata format then.

* The generated test programs no longer clear the environment
  variables before running scenarios. This is partly to allow Subplot
  to be more easily ported to operating systems other than Debian
  (such as NixOS, but also Windows and macOS), but also because
  clearing the environment variables is not a good way to make sure
  the tests run in a known environment. Subplot now makes it the
  responsibility of the person running the test program to control
  where it is run: what software is installed, what services are
  available, etc.

* Subplot code generation now refuses documents that have no
  scenarios. Document generation still accepts them so that Subplot
  can be used to produce typeset documents and web pages.

## General

The changes in this section should not break any existing Subplot
documents. They affect all uses of Subplot, regardless of step
implementation language and whether Subplot code or document
generation is used.

* After a bug fix, Subplot now handles better the input files being
  elsewhere than the current directory. If the Markdown input file is
  in `foo/bar/yo.md`, the files referred to from the input file are
  looked up relative to `foo/bar` instead of the current working
  directory.

* Subplot now has initial support for logging to make it easier to
  find out what it's doing, when it's doing something surprising. The
  environment variables `SUBPLOT_LOG`, `SUBPLOT_LOG_FILE`, and
  `SUBPLOT_LOG_FORMAT` (`oneline`, `json`, or `pretty`). What Subplot
  logs is still rudimentary but will be improved over time. We'd
  welcome suggestions.

* The Subplot Debian package now builds in the resource into the
  Subplot binary.

* Document titles can now use markup to indicate `literal` text.

* Subplot now automatically handles versions of Pandoc that don't have
  a separate `pandoc-citeproc` binary, and want the `--citeproc`
  option instead.

* Subplot now works with version 1.48.0 of the Rust language and
  toolchain, in order to make it possible for the Sequoia-PGP project
  to use Subplot.

## Python support

* The generated Python test program now supports the `--run-all`
  (`-k`) option to run all scenarios even if one or more fail.

## Rust support

* Subplot now provides the `subplot-build` crate, for using Subplot
  code generation from another project's `build.rs` script.

* We are in the process of elevating Rust into a supported language,
  so that it will be on par with Python. This release does not get
  there, but starts the process.

## Bash support

* We've not made much effort to improve the Bash support (modulo the
  environment cleanup). Compared to Python and Rust it is not a
  well-support language in Subplot. Lars and Daniel do not feel it is
  a target worth spending much of their free time one, but would
  welcome help with that.


# Version 0.2.2, released 2021-08-07

This is release is meant for use by people other than Subplot's own
developers. It is of ALPHA quality, in that what is implemented is
meant to work, but we reserve the right to make backwards incompatible,
breaking changes in future releases.

## General

* When a scenario step matches more than one binding, the error
  message now lists all the matching bindings to make it easier for
  the user to fix the problem. (By Lars Wirzenius)

* The documentation now explains core concepts relevant to Subplot,
  and suggests an initial workflow for a project using Subplot. (By
  Lars Wirzenius)

## Python support

* The `lib/daemon` Subplot library now uses custom Python code instead
  of the netcat tool. This removes a dependency, and also avoids the
  problem of there being at least two more or less incompatible
  versions of netcat in common use. (By Alexander Batischev)

* The `lib/daemon` library now has a way to pass environment variables
  to the daemon. (By Alexander Batischev)

## Bash support

* The documentation now makes it clearer that the `files_get`
  function returns the contents of the embedded file and not a
  filename. (By Richard Maw)

* Some spelling and other language mistakes have been fixed in the
  documentation for Bash support. (By Richard Maw)

* The `dict` helper functions can now read embedded files. (By Richard
  Maw)

* The generated Bash test program now supports the `--env` option to
  let the user pass in environment variables when invoking the test
  program. (By Richard Maw)

* Assertion functions now return an error rather then terminating the
  test program. This lets cleanups run. (By Richard Maw)

# Version 0.2.1, released 2021-07-11

This is the first release meant for use by people other than Subplot's
own developers.

* The locations of the `dot` and `plantuml` programs and for the Java
  byte code interpreter can now be configured when Subplot is invoked,
  which is useful when they're not installed in the locations where
  Debian puts them. Those programs are used by Subplot to render
  diagrams.

* The `./check` script now outputs the last one hundred lines or so of
  the log file produced by the generated test program, if that program
  fails. This makes it easier to debug failures under CI.

* Additionally, there have been some minor tweaks only visible to
  those developing Subplot itself.

# Version 0.2.0, released 2021-06-12

This is the first public release of Subplot. No APIs or other surfaces are to be
considered stable at this time. While the `subplotlib` and `subplotlib-derive`
crates have been published, they do not form part of this release.

The only _template_ which is considered in any sense "supported" in this release
is the `python` template.
