---
title: Release notes for Subplot
...

This file summarises the changes between released versions of Subplot and its
associated libraries.

# Version 0.2.2, released 2021-08-07

This is release is meant for use by people other than Subplot's own
developers. It is of ALPHA quality, in that what is implemented is
meant to work, but we reserve the right to make backwards incompatible,
breaking changes in future releases.

## General

* When a scenario step matches more than one binding, the error
  message now lists all the matching bindings to make it easier for
  the user to fix the problem. (By Lars Wirzenius)

* The documentation now explains core concepts relevant to Subplot,
  and suggests an initial workflow for a project using Subplot. (By
  Lars Wirzenius)

## Python support

* The `lib/daemon` Subplot library now uses custom Python code instead
  of the netcat tool. This removes a dependency, and also avoids the
  problem of there being at least two more or less incompatible
  versions of netcat in common use. (By Alexander Batischev)

* The `lib/daemon` library now has a way to pass environment variables
  to the daemon. (By Alexander Batischev)

## Bash support

* The documentation now makes it clearer that the `files_get`
  function returns the contents of the embedded file and not a
  filename. (By Richard Maw)
  
* Some spelling and other language mistakes have been fixed in the
  documentation for Bash support. (By Richard Maw)

* The `dict` helper functions can now read embedded files. (By Richard
  Maw)

* The generated Bash test program now supports the `--env` option to
  let the user pass in environment variables when invoking the test
  program. (By Richard Maw)
  
* Assertion functions now return an error rather then terminating the
  test program. This lets cleanups run. (By Richard Maw)

# Version 0.2.1, released 2021-07-11

This is the first release meant for use by people other than Subplot's
own developers.

* The locations of the `dot` and `plantuml` programs and for the Java
  byte code interpreter can now be configured when Subplot is invoked,
  which is useful when they're not installed in the locations where
  Debian puts them. Those programs are used by Subplot to render
  diagrams.

* The `./check` script now outputs the last one hundred lines or so of
  the log file produced by the generated test program, if that program
  fails. This makes it easier to debug failures under CI.

* Additionally, there have been some minor tweaks only visible to
  those developing Subplot itself.

# Version 0.2.0, released 2021-06-12

This is the first public release of Subplot. No APIs or other surfaces are to be
considered stable at this time. While the `subplotlib` and `subplotlib-derive`
crates have been published, they do not form part of this release.

The only _template_ which is considered in any sense "supported" in this release
is the `python` template.
