use num_bigint::{BigInt};

/// A general `suan` object containing all possible numeric types involved in the calculation
pub enum Subject {
    /// Small integer
    Int(i64),
    /// Arbitrary-precision integer
    BInt(BigInt),
    /// Small real number
    Real(f64),
    /// Arbitrary-precision real number
    BReal(),
    /// Rational number
    Frac(),
    /// Arbitrary-precision Fractional number
    BFrac(),
    /// Small integer in modulo ring
    IntMod(),
    /// Arbitrary-precision integer in modulo ring
    BIntMod(),
}