`suan` is a calculator supporting advanced mathematics.

- `suam factors`: integer factorization
- `suam divisor`: get a factor of an integer
- `suam is_prime`: primality test
- `suam primes`: generate primes below a limit
- `suam nprimes`: generate n primes

This crate can also be used to compile as a Python MP library, aiming to be the PARI/GP on Python?

Support types:
| PARI type | Symbol | Description | Rust |
|-----------|--------|-------------|------|
| t_INT | Z | Integers (with arbitrary precision) | `num-bigint` / `rug` |
| t_REAL | R | Real numbers (with arbitrary precision) | `rug` |
| t_INTMOD | Z/nZ | Intmods (integers modulo n) | N/A |
| t_FRAC | Q | Rational numbers (in irreducible form) | `num-rational` / `rug` |
| t_FFELT | Fq | Finite field element | N/A (`ff`?) |
| t_COMPLEX | T[i] | Complex numbers | `num-complex` / `rug` |
| t_PADIC | Qp | p-adic numbers | N/A |
| t_QUAD | Q[w] | Quadratic Numbers (where [Z[w]:Z] = 2) | `num-irrational` |
| t_POLMOD | T[X]/(P) | Polmods (polynomials modulo P ∈ T[X]) | N/A |
| t_POL | T[X] | Polynomials | N/A |
| t_SER | T((X)) | Power series (finite Laurent series) | N/A |
| t_RFRAC | T(X) | Rational functions (in irreducible form) | N/A |

References:
- [Pari/GP](https://pari.math.u-bordeaux.fr/)
- [Pari/GP cheatsheet](https://math.mit.edu/~brubaker/PARI/PARIrefcard.pdf)
- [mpmath](https://mpmath.org/)
- [FLINT](http://flintlib.org/doc/)
