// implement a common error type, and implement conversion to python types if enabled pyo3 feature

/// A enum representation all possible errors for operations on `Subject`.
pub enum SuErr {
    /// Variant is unsupported for specific operation
    UnsupportedVariant,

    /// The desired precision exceeds the maximum precision to be supported
    ExceedMaxPrecision,
}

#[cfg(feature = "pyo3")]
mod pysupport {
    use super::*;
    use pyo3::exceptions::{PyOverflowError, PyTypeError};
    use pyo3::PyErr;

    impl From<SuErr> for PyErr {
        fn from(e: SuErr) -> Self {
            match e {
                SuErr::UnsupportedVariant => {
                    PyTypeError::new_err("this variant is not supported on this operation")
                }
                SuErr::ExceedMaxPrecision => {
                    PyOverflowError::new_err("the precision exceeded limit during the operation")
                }
            }
        }
    }
}
