# struct-field-names-as-array

Provides the `FieldNamesAsArray` procedural macro.

The procedural macro adds the ``FIELD_NAMES_AS_ARRAY`` constant to
the struct.
The `FIELD_NAMES_AS_ARRAY` is an array containing the field names
of the struct (as the name suggests).
The visibility of the `FIELD_NAMES_AS_ARRAY` is the same as the
corresponding struct.

**NOTE:** the macro can only be derived by named structs.

## Example

```rust
use struct_field_names_as_array::FieldNamesAsArray;

#[derive(FieldNamesAsArray)]
struct Foo {
  bar: String,
  baz: String,
  bat: String,
}

assert_eq!(Foo::FIELD_NAMES_AS_ARRAY, ["bar", "baz", "bat"]);
```
