#![recursion_limit = "256"]

extern crate proc_macro;

mod read;
mod types;
mod utils;
mod write;

use proc_macro::TokenStream;
use quote::quote;
use syn::{parse_macro_input, DeriveInput};
use types::Element;

#[proc_macro_derive(XmlRead, attributes(xml))]
pub fn derive_xml_read(input: TokenStream) -> TokenStream {
    let input = parse_macro_input!(input as DeriveInput);

    let name = &input.ident;
    let generics = &input.generics;

    let params = &generics.params;

    let where_clause = &generics.where_clause;

    let input_lifetime = utils::gen_input_lifetime(&generics);

    let mut params_with_input_lifetime = generics.params.clone();

    params_with_input_lifetime.insert(0, input_lifetime.into());

    let impl_read = read::impl_read(Element::parse(input.clone()));

    let gen = quote! {
        impl <#params_with_input_lifetime> strong_xml::XmlRead<'__input> for #name <#params>
            #where_clause
        {
            fn from_reader(
                mut reader: &mut strong_xml::XmlReader<'__input>
            ) -> strong_xml::XmlResult<Self> {
                use strong_xml::xmlparser::{ElementEnd, Token, Tokenizer};
                use strong_xml::XmlError;
                #impl_read
            }
        }
    };

    gen.into()
}

#[proc_macro_derive(XmlWrite, attributes(xml))]
pub fn derive_xml_write(input: TokenStream) -> TokenStream {
    let input = parse_macro_input!(input as DeriveInput);

    let name = &input.ident;
    let generics = &input.generics;

    let params = &generics.params;

    let where_clause = &generics.where_clause;

    let impl_write = write::impl_write(Element::parse(input.clone()));

    let gen = quote! {
        impl <#params> strong_xml::XmlWrite for #name <#params>
            #where_clause
        {
            fn to_writer<W: std::io::Write>(
                &self,
                mut writer: &mut strong_xml::XmlWriter<W>
            ) -> strong_xml::XmlResult<()> {
                #impl_write

                Ok(())
            }
        }
    };

    gen.into()
}
