mod iter_replace;
mod iter_placehold;

use iter_replace::iter_replace;
use iter_placehold::iter_placehold;
use regex::Regex;
use siesta::*;

pub fn strfn(text: String) -> Vec<(String, bool)> {
    let rule = format!("{}|{}|{}", "'\\\\.'", "'[^\\\\]'", "\"[^\"]+\"");
    let _re = Regex::new(&rule[..]).unwrap();

    let (text, al) = iter_replace(&text, "\\\\\"", "__");
    let indexes = _re.find_iter(&text[..]);
    let text = iter_placehold(&text, &al, "\\\"");

    let mut result: Vec<(String, bool)> = Vec::new();
    let mut last = 0;
    for index in indexes {
        let (start, end) = (index.start(), index.end());
        result.push((s!(
            &text[last..start]
        ), false));

        result.push((s!(
            &text[start..end]
        ), true));
        last = end;
    } result.push((s!(&text[last..text.len()]), false));

    result
}
