use regex::Regex;
use siesta::*;

pub fn iter_replace(mtext: &String, reptext: &str, totext: &str) -> (String, Vec<(usize, usize)>)
{
    let _i = Regex::new(reptext).unwrap();
    let indexes = _i.find_iter(&mtext);

    let mut io: Vec<(usize, usize)> = Vec::new();
    let mut text = s!("");

    let mut last = 0;
    for index in indexes {
        let (start, end) = (index.start(), index.end());
        io.push((start as usize, end as usize));
        text += &mtext[last..start];
        text += totext;
        last = end;
    }
    text += &mtext[last..(mtext.len())];

    (text, io)
}
