use solana_program::{account_info::AccountInfo, entrypoint::ProgramResult, pubkey::Pubkey};

#[derive(Clone, Debug)]
pub struct WithdrawAccounts<'a> {
    /// Account invoking transaction.
    pub authority: AccountInfo<'a>, // [writable, signer]
    /// Recipient's wallet address
    pub recipient: AccountInfo<'a>, // []
    /// The associated token account address of a stream `recipient`
    pub recipient_tokens: AccountInfo<'a>, // [writable]
    /// The account holding the stream parameters
    pub metadata: AccountInfo<'a>, // [writable]
    /// The escrow account holding the stream funds
    pub escrow_tokens: AccountInfo<'a>, // [writable]
    /// Streamflow treasury account
    pub streamflow_treasury: AccountInfo<'a>, // [writable]
    /// Streamflow treasury's associated token account
    pub streamflow_treasury_tokens: AccountInfo<'a>, // [writable]
    /// Partner treasury account
    pub partner: AccountInfo<'a>, // []
    /// Partner's associated token account
    pub partner_tokens: AccountInfo<'a>, // [writable]
    /// The SPL token mint account
    pub mint: AccountInfo<'a>, // []
    /// The SPL token program
    pub token_program: AccountInfo<'a>, // []
}

pub trait WithdrawStream {
    fn withdraw(pid: &Pubkey, acc: WithdrawAccounts, amount: u64) -> ProgramResult;
}
