#!/usr/bin/env python3
from codegen import *

contents = """// Metadata and instruction serialization
const borsh = require("borsh");
const spl = require("@solana/spl-token");

class Assignable {
    constructor(properties) {
        Object.keys(properties).map((key) => {
            this[key] = properties[key];
        });
    }
}
"""


def main():
    global contents
    types = parse_types("src/state.rs")

    for typ in types:
        if isinstance(types[typ], tuple):
            # TODO: consts
            continue

        if not isinstance(types[typ], list):
            raise Exception("Unimplemented")

        contents += f"\n\nclass {typ}Struct extends Assignable {{}}\n"
        contents += f"const {typ} = new Map([[{typ}Struct, {{\n"
        contents += "    kind: 'struct',\n"
        contents += "    fields: [\n"

        for i in types[typ]:
            if i[1] in types:
                for inner in types[i[1]]:
                    contents += "        "
                    contents += lookup_type_borsh(inner[0], inner[1], types)
            else:
                contents += "        "
                contents += lookup_type_borsh(i[0], i[1], types)

        contents += "    ]\n"
        contents += "}]]);"

    print(contents)


if __name__ == "__main__":
    main()
