#!/usr/bin/env python3
import json
import sys
from collections import OrderedDict
from codegen import *

instruction_files = [
    "src/instruction/create.rs",
    "src/instruction/withdraw.rs",
    "src/instruction/cancel.rs",
    "src/instruction/transfer.rs",
    "src/instruction/topup.rs",
]


def main():
    types = parse_types("src/state.rs")

    idl = OrderedDict()
    idl["name"] = "timelock"
    idl["version"] = "0.4.0"

    instructions = []

    for path in instruction_files:
        accounts = parse_accounts_struct(path)
        signature = parse_function_signatures(path)

        ix = OrderedDict()

        # We consider every one of these files to have one function.
        # If there are more, this is the place to fix it.
        ix["name"] = to_camel_case(signature[0][0])
        ix["accounts"] = accounts
        # Our function signatures also have the program_id as arg0,
        # and accounts as arg[1], so we start from index 2.
        if len(signature[0][1]) > 2:
            ix["args"] = expand_args_idl(signature[0][1][2:], types)
        else:
            ix["args"] = []

        instructions.append(ix)

    idl["instructions"] = instructions

    jsonstr = json.dumps(idl, indent=2)
    sys.stdout.write("export default ")
    for line in jsonstr.split("\n"):
        if line.strip() == '"u8",':
            # Edge case
            print(line)
        else:
            print(line.replace('"', '', 2))


if __name__ == "__main__":
    main()
