pub const COMMANDS: &'static [(&'static str, &'static str)] = &[
    ("device list", "- lists all streamdeck devices"),
    ("device add", "<serial> - adds specified device to managed"),
    ("device remove", "<serial> - removes specified device from managed"),
    ("-select", "<serial> - selects device to be used with device related operations, to unselect, enter 'select' alone"),
    ("config reload all", "- reloads all device configs, all unsaved changes will lost"),
    ("config reload", "[<serial>] - reloads device config for specific/selected device, all unsaved changes will lost"),
    ("config save all", "- saves all device configs"),
    ("config save", "[<serial>] - saves device config for specific/selected device"),
    ("config import", "[<serial>] <path> - imports device config from a file for specific/selected device"),
    ("config export", "[<serial>] <path> - exports device config into a file for specific/selected device"),
    ("brightness", "[<serial>] <0-100> - sets brightness for device"),
    ("back", "[<serial>] [drop] - navigates back, even if there's no button for that, if drop is included, goes to root screen"),
    ("press", "[<serial>] <key index> - simulates a press on a button"),
    ("module list", "- lists all loaded modules"),
    ("module info", "<name> - prints information about module"),
    ("module params add", "<name> <parameter path> - adds a new element into parameter array"),
    ("module params remove", "<name> <parameter path> <element index> - removes element from parameter array"),
    ("module params set", "<name> <parameter path> <value> - sets value to module's parameter"),
    ("module params upload", "<name> <parameter path> <value> <file path> - reads binary file and sets that as value to module's parameter"),
    ("module params list", "<name> - lists parameters of the module along with values and paths"),
    ("font list", "- lists names of fonts loaded by daemon"),
    ("component list", "- lists available components from modules"),
    ("component info", "<name> - prints information about component"),
    ("image list", "[<serial>] [preview size] - lists all images used by a device, optionally sizes images according to provided size"),
    ("image add", "[<serial>] <file path> - adds image to device config"),
    ("image remove", "[<serial>] <identifier> - removes image from device config"),
    ("stack", "[<serial>] - prints current stack"),
    ("button list", "[<serial>] - lists all buttons defined on current screen"),
    ("button info", "[<serial>] <key index> - provides more detailed information about a button"),
    ("button new", "[<serial>] <key index> - creates an empty button on current screen"),
    ("button from", "[<serial>] <key index> <component name> - creates a button based on component's template"),
    ("button copy", "[<serial>] <key index> - saves button to internal clipboard"),
    ("button paste", "[<serial>] <key index> - creates a new button from internal clipboard"),
    ("button remove", "[<serial>] <key index> - removes a button on current screen"),
    ("button component add", "[<serial>] <key index> <component name> - adds component on a button"),
    ("button component remove", "[<serial>] <key index> <component name> - removes component from a button"),
    ("button component params add", "[<serial>] <key index> <component name> <parameter path> - adds a new element into parameter array"),
    ("button component params remove", "[<serial>] <key index> <component name> <parameter path> <element index> - removes element from parameter array"),
    ("button component params set", "[<serial>] <key index> <component name> <parameter path> <value> - sets value to component's parameter"),
    ("button component params upload", "[<serial>] <key index> <component name> <parameter path> <file path> - reads binary file and sets that as value to component's parameter"),
    ("button component params list", "[<serial>] <key index> <component name> - lists parameters of the component along with values and paths"),
];