pub trait TWrite {
    /// Write one byte to stream.
    fn write_byte(&mut self, byte: u8);

    /// Write bytes to stream.
    fn write(&mut self, buffer: &[u8]) -> usize;
}

pub trait TRead<E> {
    /// Peek one byte from stream, position don't shift.
    fn peek_byte(&self) -> Result<u8, E>;

    /// Peek bytes from stream, position don't shift.
    fn peek(&self, buffer: &mut [u8]) -> Result<usize, E>;

    /// Read one byte from stream, position  shifted.
    fn read_byte(&mut self) -> Result<u8, E>;

    /// Read bytes from stream, position shifted.
    fn read(&mut self, buffer: &mut [u8]) -> Result<usize, E>;

    /// Skip "count" bytes in stream, position shifted.
    fn skip(&mut self, count: usize) -> usize;

    /// Skip all bytes in stream, position shifted.
    fn skip_all(&mut self) -> usize;

    /// View of available bytes in stream.
    fn view(&self) -> &[u8];

    /// Return available to read bytes.
    fn available(&self) -> usize;
}