//! Simple inmemory stream.
//!
//! Created for use as a buffer. Supports write, peek, read, skip operations.
//!
//! # Examples
//!
//! ### Write, read stream.
//! ```
//! use stream_inmemory::{Stream, TWrite, TRead};
//! let arr = [1, 2, 3, 4, 5, 6, 7, 8, 9];
//! let mut stream = Stream::new();
//! stream.write(&arr[2..6]);
//! assert_eq!(stream.available(), 4);
//! let mut dest = [0; 10];
//! stream.read(&mut dest);
//! stream.truncate_readied();
//! assert_eq!(dest, [3, 4, 5, 6, 0, 0, 0, 0, 0, 0]);
//! assert_eq!(stream.available(), 0);
//! ```
//!

mod traits;
mod stream;

#[cfg(test)]
mod tests;

pub use stream::{Stream, StreamError};
pub use traits::{TRead, TWrite};