use crate::{Stream, StreamError};

#[test]
fn it_works() {
    let arr = [1, 2, 3, 4, 5, 6, 7, 8, 9];
    let mut stream = Stream::new();
    stream.write(&arr[2..6]);
    assert_eq!(stream.available(), 4);
    let mut dest = [0; 10];
    stream.read(&mut dest);
    assert_eq!(dest, [3, 4, 5, 6, 0, 0, 0, 0, 0, 0]);
    assert_eq!(stream.available(), 0);
    assert_eq!(2 + 2, 4);
}
