use crate::Miner;
use async_std::sync::{Arc, Mutex};
use std::collections::HashMap;

#[derive(Debug, Clone)]
pub struct MinerList {
    pub miners: Arc<Mutex<HashMap<u32, Miner>>>,
}

impl MinerList {
    pub fn new() -> Self {
        MinerList {
            miners: Arc::new(Mutex::new(HashMap::new())),
        }
    }

    pub async fn add_miner(&self, session_id: u16, miner: Miner) {
        self.miners.lock().await.insert(session_id as u32, miner);
    }

    //@todo we could return the miner from this function, but I'm not sure we see a need for that
    //right now, but think on it.
    pub async fn remove_miner(&self, session_id: u16) {
        self.miners.lock().await.remove(&(session_id as u32));
    }

    pub async fn get_miner_by_id(&self, session_id: u16) -> Option<Miner> {
        self.miners.lock().await.get(&(session_id as u32)).cloned()
    }

    pub async fn update_miner_by_session_id(&self, session_id: u16, miner: Miner) {
        self.miners.lock().await.insert(session_id as u32, miner);
    }
}

impl Default for MinerList {
    fn default() -> Self {
        Self::new()
    }
}
