#[cfg(not(feature = "websockets"))]
mod tcp;

#[cfg(feature = "websockets")]
mod websockets;

mod api;
mod ban_manager;
mod builder;
mod connection;
mod error;
mod global;
mod miner_list;
mod request;
mod result;
mod route;
mod router;
mod server;
mod types;

pub use crate::ban_manager::BanManager;
pub use crate::builder::StratumServerBuilder;
pub use crate::connection::Connection;
pub use crate::error::Error;
pub use crate::global::Global;
pub use crate::miner_list::MinerList;
pub use crate::request::StratumRequest;
pub use crate::result::StratumResult;
pub use crate::server::StratumServer;
pub use crate::types::{ExMessageGeneric, MessageTypes, MessageValue, ReadyIndicator, ID};

pub type Result<T> = std::result::Result<T, Error>;
