use crate::types::MessageValue;
use extended_primitives::Buffer;

pub struct StratumRequest<State> {
    pub(crate) state: State,
    // pub(crate) values: serde_json::map::Map<String, serde_json::Value>,
    pub(crate) values: MessageValue,
}

impl<State> StratumRequest<State> {
    pub fn is_stratum_request(&self) -> bool {
        match self.values {
            MessageValue::StratumV1(_) => true,
            MessageValue::ExMessage(_) => false,
        }
    }

    pub fn is_ex_message_request(&self) -> bool {
        match self.values {
            MessageValue::StratumV1(_) => false,
            MessageValue::ExMessage(_) => true,
        }
    }

    ///  Access application scoped state.
    pub fn state(&self) -> &State {
        &self.state
    }

    //@todo maybe just kill these.
    pub fn get_stratum_v1_value(&self, name: &str) -> Option<&serde_json::Value> {
        match &self.values {
            MessageValue::StratumV1(value) => value.get(name),
            MessageValue::ExMessage(_) => None,
        }
    }

    //@todo maybe don't clone this let's double check on that.
    pub fn get_ex_message_value(&self, name: &str) -> Option<Buffer> {
        match &self.values {
            MessageValue::StratumV1(value) => None,
            MessageValue::ExMessage(value) => Some(value.clone()),
        }
    }

    // //@todo this should actually return either I think.
    // pub fn get(&self, name: &str) -> Option<&serde_json::Value> {
    //     match self.values {
    //         MessageValue::StratumV1(value) => value.get(name),
    //         MessageValue::ExMessage(_) => None,
    //     }
    // }

    pub fn get_json<T: serde::de::DeserializeOwned>(
        &self,
        name: &str,
    ) -> Result<T, serde_json::Error> {
        match &self.values {
            //@todo switch up these names for clarity too many value
            MessageValue::StratumV1(value) => {
                let value = value
                    .get(name)
                    .ok_or_else(|| serde::de::Error::custom(format!("expected {}", name)))?
                    .clone();

                Ok(serde_json::from_value(value)?)
            }
            MessageValue::ExMessage(_) => Err(serde::de::Error::custom(format!(
                "wrong message type request"
            ))),
        }
    }
}
