mod aabb;
mod interpolation;
mod transform;
mod trigonometry;

pub use self::aabb::*;
pub use self::interpolation::*;
pub use self::transform::*;
pub use self::trigonometry::*;

/// Converts perceptual (db) into linear ([0, 1]).
pub fn perceptual(db: f32) -> f32 {
    const LUT: [f32; 256] = [
        1.0, 1.0027113, 1.00543, 1.008156, 1.0108894, 1.01363, 1.0163783, 1.0191339, 1.0218971, 1.0246677,
        1.0274459, 1.0302317, 1.0330249, 1.0358257, 1.0386341, 1.0414501, 1.0442737, 1.0471052, 1.0499442,
        1.0527908, 1.0556451, 1.0585073, 1.0613772, 1.0642549, 1.0671405, 1.0700337, 1.0729349, 1.0758438,
        1.0787607, 1.0816857, 1.0846184, 1.0875591, 1.0905077, 1.0934645, 1.0964291, 1.0994017, 1.1023827,
        1.1053715, 1.1083684, 1.1113734, 1.1143868, 1.1174082, 1.1204377, 1.1234756, 1.1265216, 1.129576,
        1.1326386, 1.1357094, 1.1387887, 1.1418762, 1.1449722, 1.1480765, 1.1511892, 1.1543103, 1.1574401,
        1.1605783, 1.1637249, 1.16688, 1.1700438, 1.1732162, 1.176397, 1.1795865, 1.1827847, 1.1859916,
        1.1892071, 1.1924313, 1.1956644, 1.1989061, 1.2021568, 1.2054161, 1.2086843, 1.2119614, 1.2152473,
        1.2185422, 1.2218461, 1.2251588, 1.2284805, 1.2318113, 1.235151, 1.2384999, 1.2418578, 1.2452247,
        1.248601, 1.2519863, 1.2553807, 1.2587843, 1.2621974, 1.2656195, 1.2690508, 1.2724917, 1.2759418,
        1.2794012, 1.28287, 1.2863482, 1.2898359, 1.293333, 1.2968396, 1.3003557, 1.3038813, 1.3074164,
        1.3109612, 1.3145156, 1.3180796, 1.3216532, 1.3252366, 1.3288296, 1.3324325, 1.3360451, 1.3396674,
        1.3432997, 1.3469418, 1.3505938, 1.3542556, 1.3579272, 1.361609, 1.3653008, 1.3690023, 1.3727143,
        1.3764359, 1.3801678, 1.3839098, 1.3876619, 1.3914243, 1.395197, 1.3989797, 1.4027727, 1.406576,
        1.4103897, 1.4142135, 1.4180478, 1.4218926, 1.4257478, 1.4296134, 1.4334893, 1.437376, 1.4412732,
        1.4451808, 1.4490991, 1.4530281, 1.4569675, 1.4609178, 1.4648787, 1.4688505, 1.472833, 1.4768261,
        1.4808302, 1.484845, 1.488871, 1.4929078, 1.4969554, 1.5010141, 1.5050838, 1.5091645, 1.5132562,
        1.517359, 1.5214729, 1.5255982, 1.5297345, 1.533882, 1.5380408, 1.5422108, 1.5463922, 1.5505849,
        1.554789, 1.5590044, 1.5632313, 1.5674696, 1.5717194, 1.5759809, 1.5802537, 1.5845382, 1.5888345,
        1.5931423, 1.5974616, 1.6017927, 1.6061357, 1.6104903, 1.6148568, 1.6192352, 1.6236253, 1.6280276,
        1.6324414, 1.6368674, 1.6413056, 1.6457556, 1.6502175, 1.6546918, 1.6591781, 1.6636765, 1.6681874,
        1.6727102, 1.6772454, 1.6817929, 1.6863526, 1.6909249, 1.6955093, 1.7001064, 1.7047157, 1.7093376,
        1.7139723, 1.7186192, 1.7232789, 1.7279512, 1.7326363, 1.7373339, 1.7420442, 1.7467673, 1.7515033,
        1.756252, 1.7610139, 1.7657884, 1.770576, 1.7753766, 1.78019, 1.7850167, 1.7898563, 1.794709,
        1.7995751, 1.8044541, 1.8093464, 1.814252, 1.8191712, 1.8241032, 1.829049, 1.8340081, 1.8389806,
        1.8439665, 1.848966, 1.8539791, 1.8590058, 1.864046, 1.8691001, 1.8741676, 1.8792491, 1.8843442,
        1.8894532, 1.894576, 1.8997127, 1.9048632, 1.9100279, 1.9152066, 1.9203992, 1.925606, 1.9308267,
        1.9360617, 1.9413109, 1.9465744, 1.9518521, 1.9571441, 1.9624505, 1.9677712, 1.9731065, 1.9784559,
        1.9838201, 1.9891988, 1.994592,
    ];
    let db = db * 0.16609640474f32;
    let r = (db.abs() * 256.0) as usize;
    let w = (1 << (r >> 8)) as f32;
    let w = w * LUT[r & 255];
    if db < 0.0 {
        1.0 / w
    } else {
        w
    }
}

/// Linearly interpolates between a and b by t.
pub fn lerp(a: f32, b: f32, t: f32) -> f32 {
    a + t * (b - a)
}
